/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.transform.TransformerException;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.export.DisplaySettingsPane;
import mpi.eudico.client.annotator.export.ExportQtSmilDialog;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.client.util.Transcription2QtSubtitle;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ExportQtSubtitleDialog
extends AbstractExtTierExportDialog
implements ListSelectionListener,
ChangeListener {
    private JCheckBox minimalDurCB;
    private JTextField minimalDurTF;
    private JCheckBox correctTimesCB;
    private JCheckBox mergeTiersCB;
    private JCheckBox recalculateTimesCB;
    private JButton fontSettingsButton;
    private HashMap fontSettingHashMap;
    private boolean smilExport;

    public ExportQtSubtitleDialog(Frame parent, boolean modal, Transcription transcription, Selection selection) {
        this(parent, modal, transcription, selection, false);
    }

    public ExportQtSubtitleDialog(Frame parent, boolean modal, Transcription transcription, Selection selection, boolean smilExport) {
        super(parent, modal, transcription, selection);
        this.smilExport = smilExport;
        this.makeLayout();
        this.extractTiers();
        this.postInit();
        this.restrictCheckBox.requestFocus();
    }

    protected void extractTiers() {
        if (this.model != null) {
            for (int i = this.model.getRowCount() - 1; i >= 0; --i) {
                this.model.removeRow(i);
            }
            if (this.transcription != null) {
                Vector v = this.transcription.getTiers();
                for (int i = 0; i < v.size(); ++i) {
                    TierImpl t = (TierImpl)v.get(i);
                    if (i == 0) {
                        this.model.addRow(new Object[]{Boolean.TRUE, t.getName()});
                        continue;
                    }
                    this.model.addRow(new Object[]{Boolean.FALSE, t.getName()});
                }
                Object useTyp = Preferences.get("ExportQtSubtitleDialog.selectedTiers", this.transcription);
                if (useTyp != null) {
                    this.loadTierPreferences((ArrayList)useTyp);
                }
                if (this.model.getRowCount() > 0) {
                    this.tierTable.setRowSelectionInterval(0, 0);
                }
            }
        }
    }

    protected void makeLayout() {
        super.makeLayout();
        this.model.setColumnIdentifiers(new String[]{"export", "tier"});
        this.tierTable.getColumn("export").setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.tierTable.getColumn("export").setCellRenderer(new CheckBoxTableCellRenderer());
        this.tierTable.getColumn("export").setMaxWidth(30);
        this.tierTable.setShowVerticalLines(false);
        this.tierTable.setTableHeader(null);
        this.tierTable.getSelectionModel().addListSelectionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.restrictCheckBox, gridBagConstraints);
        this.recalculateTimesCB = new JCheckBox();
        this.recalculateTimesCB.setEnabled(false);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 22, 4, 6);
        this.optionsPanel.add((Component)this.recalculateTimesCB, gridBagConstraints);
        this.correctTimesCB = new JCheckBox();
        this.correctTimesCB.setSelected(true);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.correctTimesCB, gridBagConstraints);
        this.minimalDurCB = new JCheckBox();
        this.minimalDurCB.setSelected(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.minimalDurCB, gridBagConstraints);
        this.minimalDurTF = new JTextField(6);
        this.minimalDurTF.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.minimalDurTF, gridBagConstraints);
        this.mergeTiersCB = new JCheckBox();
        this.mergeTiersCB.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.mergeTiersCB, gridBagConstraints);
        this.fontSettingsButton = new JButton();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.fontSettingsButton, gridBagConstraints);
        this.fontSettingsButton.addActionListener(this);
        this.minimalDurCB.addChangeListener(this);
        this.restrictCheckBox.addChangeListener(this);
        this.setPreferredSetting();
        this.updateLocale();
    }

    protected boolean startExport() throws IOException {
        Vector mediaDescriptors;
        File exportFile;
        List selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        int minimalDur = 0;
        if (this.minimalDurCB.isSelected()) {
            String dur = this.minimalDurTF.getText();
            if (dur == null || dur.length() == 0) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.InvalidNumber"), ElanLocale.getString("Message.Warning"), 2);
                this.minimalDurTF.requestFocus();
                return false;
            }
            try {
                minimalDur = Integer.parseInt(dur);
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.InvalidNumber"), ElanLocale.getString("Message.Warning"), 2);
                this.minimalDurTF.requestFocus();
                return false;
            }
        }
        if (this.smilExport) {
            exportFile = this.promptForFile(ElanLocale.getString("ExportQtSmilDialog.Title "), FileExtension.SMIL_EXT, ElanFileFilter.createFileFilter(13), false);
            if (exportFile == null) {
                return false;
            }
        } else {
            exportFile = this.promptForFile(ElanLocale.getString("ExportQtSubtitleDialog.Title"), FileExtension.TEXT_EXT, ElanFileFilter.createFileFilter(11), false);
        }
        if (exportFile == null) {
            return false;
        }
        long offset = 0L;
        if (this.correctTimesCB.isSelected() && (mediaDescriptors = this.transcription.getMediaDescriptors()).size() > 0) {
            offset = ((MediaDescriptor)mediaDescriptors.get((int)0)).timeOrigin;
        }
        boolean merge = this.mergeTiersCB.isSelected();
        long mediaDur = ELANCommandFactory.getViewerManager(this.transcription).getMasterMediaPlayer().getMediaDuration();
        String[] tierNames = selectedTiers.toArray(new String[0]);
        long b = 0L;
        long e = Long.MAX_VALUE;
        if (this.restrictCheckBox.isSelected()) {
            b = this.selection.getBeginTime();
            e = this.selection.getEndTime();
        }
        String mediaURL = "";
        if (((TranscriptionImpl)this.transcription).getMediaDescriptors().size() > 0) {
            mediaURL = ((MediaDescriptor)((TranscriptionImpl)this.transcription).getMediaDescriptors().get((int)0)).mediaURL;
        }
        if (!merge) {
            Transcription2QtSubtitle.exportTiers(this.transcription, tierNames, exportFile, b, e, offset, minimalDur, mediaDur, this.recalculateTimesCB.isSelected(), this.fontSettingHashMap);
        } else {
            Transcription2QtSubtitle.exportTiersMerged(this.transcription, tierNames, exportFile, b, e, offset, minimalDur, mediaDur, this.recalculateTimesCB.isSelected(), this.fontSettingHashMap);
        }
        if (this.smilExport) {
            String smilFile = exportFile.getAbsolutePath();
            int index = smilFile.lastIndexOf(46);
            if (index > 0) {
                smilFile = smilFile.substring(0, index);
            }
            smilFile = smilFile + "." + FileExtension.SMIL_EXT[1];
            String mediaPath = "";
            if (mediaURL.length() > 0) {
                index = mediaURL.lastIndexOf("/");
                mediaPath = mediaURL.substring(index + 1);
            }
            try {
                if (this.selection != null && this.restrictCheckBox.isSelected()) {
                    ExportQtSmilDialog.export2SMILQt(new File(((TranscriptionImpl)this.transcription).getPathName()), new File(smilFile), tierNames, mediaPath, b + offset, e + offset, this.recalculateTimesCB.isSelected(), merge, this.fontSettingHashMap);
                } else {
                    ExportQtSmilDialog.export2SMILQt(new File(((TranscriptionImpl)this.transcription).getPathName()), new File(smilFile), tierNames, mediaPath, mediaDur, merge, this.fontSettingHashMap);
                }
                return true;
            }
            catch (TransformerException te) {
                throw new IOException("TransformerException: " + te.getMessage());
            }
        }
        return true;
    }

    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportQtSubtitleDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportQtSubtitleDialog.TitleLabel"));
        this.correctTimesCB.setText(ElanLocale.getString("ExportDialog.CorrectTimes"));
        this.minimalDurCB.setText(ElanLocale.getString("ExportDialog.Label.MinimalDur"));
        this.mergeTiersCB.setText(ElanLocale.getString("ExportQtSubtitleDialog.Label.Merge"));
        this.fontSettingsButton.setText(ElanLocale.getString("ExportQtSubtitleDialog.Button.FontSetting"));
        this.recalculateTimesCB.setText(ElanLocale.getString("ExportDialog.RecalculateTimes"));
        if (this.smilExport) {
            this.setTitle(ElanLocale.getString("ExportQtSmilDialog.Title"));
            this.titleLabel.setText(ElanLocale.getString("ExportQtSmilDialog.TitleLabel"));
        }
    }

    public void valueChanged(ListSelectionEvent lse) {
        if (this.model != null && lse.getValueIsAdjusting()) {
            int b = lse.getFirstIndex();
            int e = lse.getLastIndex();
            int col = this.model.findColumn("export");
            for (int i = b; i <= e; ++i) {
                if (!this.tierTable.isRowSelected(i)) continue;
                this.model.setValueAt(Boolean.TRUE, i, col);
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.minimalDurCB) {
            this.minimalDurTF.setEnabled(this.minimalDurCB.isSelected());
        } else if (e.getSource() == this.restrictCheckBox) {
            this.recalculateTimesCB.setEnabled(this.restrictCheckBox.isSelected());
        }
    }

    public void actionPerformed(ActionEvent ae) {
        super.actionPerformed(ae);
        if (ae.getSource() == this.fontSettingsButton) {
            this.setNewFontSetting(DisplaySettingsPane.getNewFontSetting(this, ElanLocale.getString("DisplaySettingsPane.Title")));
        }
    }

    protected void setNewFontSetting(HashMap newSetting) {
        if (newSetting != null) {
            this.fontSettingHashMap = new HashMap();
            this.fontSettingHashMap = newSetting;
        }
    }

    protected void setPreferredSetting() {
        Object useTyp = Preferences.get("ExportQtSubtitleDialog.restrictCheckBox", null);
        if (useTyp != null) {
            this.restrictCheckBox.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportQtSubtitleDialog.minimalDurCB", null)) != null) {
            this.minimalDurCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportQtSubtitleDialog.correctTimesCB", null)) != null) {
            this.correctTimesCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportQtSubtitleDialog.mergeTiersCB", null)) != null) {
            this.mergeTiersCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportQtSubtitleDialog.minimalDurTF", null)) != null) {
            this.minimalDurTF.setText(useTyp.toString());
        }
        if ((useTyp = Preferences.get("ExportQtSubtitleDialog.recalculateTimesCB", null)) != null) {
            this.recalculateTimesCB.setSelected((Boolean)useTyp);
        }
    }

    protected void savePreferences() {
        Preferences.set("ExportQtSubtitleDialog.restrictCheckBox", this.restrictCheckBox.isSelected(), null);
        Preferences.set("ExportQtSubtitleDialog.minimalDurCB", this.minimalDurCB.isSelected(), null);
        Preferences.set("ExportQtSubtitleDialog.correctTimesCB", this.correctTimesCB.isSelected(), null);
        Preferences.set("ExportQtSubtitleDialog.mergeTiersCB", this.mergeTiersCB.isSelected(), null);
        Preferences.set("ExportQtSubtitleDialog.recalculateTimesCB", this.recalculateTimesCB.isSelected(), null);
        if (this.minimalDurTF.getText() != null) {
            Preferences.set("ExportQtSubtitleDialog.minimalDurTF", this.minimalDurTF.getText(), null);
        }
        Preferences.set("ExportQtSubtitleDialog.selectedTiers", this.getSelectedTiers(), this.transcription);
    }
}

