/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.data.Segment;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.recognizer.io.RecTierWriter;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.util.TimeRelation;

public class ExportRecogTiersDialog
extends AbstractExtTierExportDialog
implements ActionListener,
ItemListener,
ListSelectionListener {
    private JCheckBox rootTiersCB;
    private JCheckBox selectionCB;

    public ExportRecogTiersDialog(Frame parent, boolean modal, Transcription transcription, Selection selection) {
        super(parent, modal, transcription, selection);
        this.makeLayout();
        this.extractTiers();
        this.postInit();
    }

    public void actionPerformed(ActionEvent ae) {
        super.actionPerformed(ae);
    }

    public void itemStateChanged(ItemEvent ie) {
        this.extractTiers();
    }

    public void valueChanged(ListSelectionEvent lse) {
        if (this.model != null && lse.getValueIsAdjusting()) {
            int b = lse.getFirstIndex();
            int e = lse.getLastIndex();
            int col = this.model.findColumn("export");
            for (int i = b; i <= e; ++i) {
                if (!this.tierTable.isRowSelected(i)) continue;
                this.model.setValueAt(Boolean.TRUE, i, col);
            }
        }
    }

    protected void extractTiers() {
        if (this.model != null) {
            Object useTyp;
            for (int i = this.model.getRowCount() - 1; i >= 0; --i) {
                this.model.removeRow(i);
            }
            if (this.transcription != null) {
                Vector v = this.transcription.getTiers();
                boolean rootsOnly = this.rootTiersCB.isSelected();
                for (int i = 0; i < v.size(); ++i) {
                    TierImpl t = (TierImpl)v.get(i);
                    if (rootsOnly) {
                        if (t.getParentTier() != null) continue;
                        this.model.addRow(new Object[]{Boolean.TRUE, t.getName()});
                        continue;
                    }
                    if (t.getParentTier() == null) {
                        this.model.addRow(new Object[]{Boolean.TRUE, t.getName()});
                        continue;
                    }
                    this.model.addRow(new Object[]{Boolean.FALSE, t.getName()});
                }
            }
            if ((useTyp = Preferences.get("ExportRecogTiersDialog.selectedTiers", this.transcription)) instanceof ArrayList) {
                this.loadTierPreferences((ArrayList)useTyp);
            }
            if (this.model.getRowCount() > 1) {
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(true);
            } else {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    protected void makeLayout() {
        super.makeLayout();
        this.rootTiersCB = new JCheckBox();
        this.selectionCB = new JCheckBox();
        this.rootTiersCB.setSelected(true);
        this.rootTiersCB.addItemListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.tierSelectionPanel.add((Component)this.rootTiersCB, gridBagConstraints);
        this.model.setColumnIdentifiers(new String[]{"export", "tier"});
        this.tierTable.getColumn("export").setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.tierTable.getColumn("export").setCellRenderer(new CheckBoxTableCellRenderer());
        this.tierTable.getColumn("export").setMaxWidth(30);
        this.tierTable.setShowVerticalLines(false);
        this.tierTable.setTableHeader(null);
        this.tierTable.getSelectionModel().addListSelectionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.selectionCB, gridBagConstraints);
        this.setPreferredSetting();
        this.updateLocale();
    }

    protected boolean startExport() throws IOException {
        List selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        String fileName = this.promptForFileName();
        if (fileName == null) {
            return false;
        }
        File tf = new File(fileName);
        try {
            int answer;
            if (tf.exists() && (answer = JOptionPane.showConfirmDialog(this, ElanLocale.getString("Message.Overwrite"), ElanLocale.getString("SaveDialog.Message.Title"), 0, 2)) == 1) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        long begin = 0L;
        long end = Long.MAX_VALUE;
        if (this.selectionCB.isSelected() && this.selection != null && this.selection.getBeginTime() < this.selection.getEndTime()) {
            begin = this.selection.getBeginTime();
            end = this.selection.getEndTime();
        }
        ArrayList<Object> segmentations = new ArrayList<Object>(selectedTiers.size());
        for (int i = 0; i < selectedTiers.size(); ++i) {
            String name = (String)selectedTiers.get(i);
            TierImpl ti = (TierImpl)this.transcription.getTierWithId(name);
            if (ti == null) continue;
            Vector anns = ti.getAnnotations();
            ArrayList<RSelection> segments = new ArrayList<RSelection>(anns.size());
            for (int j = 0; j < anns.size(); ++j) {
                AbstractAnnotation aa = (AbstractAnnotation)anns.get(j);
                if (TimeRelation.overlaps(aa, begin, end)) {
                    segments.add(new Segment(aa.getBeginTimeBoundary(), aa.getEndTimeBoundary(), aa.getValue()));
                }
                if (aa.getBeginTimeBoundary() > end) break;
            }
            Segmentation segmentation = new Segmentation(name, segments, "");
            segmentations.add(segmentation);
        }
        try {
            RecTierWriter xTierWriter = new RecTierWriter();
            xTierWriter.write(tf, segmentations, false);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.SaveFailed") + ioe.getMessage(), ElanLocale.getString("Message.Warning"), 0);
            return false;
        }
        return true;
    }

    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportDialog.RecogTiers.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportDialog.RecogTiers.Title"));
        this.rootTiersCB.setText(ElanLocale.getString("ExportTradTranscript.Label.RootTiers"));
        this.selectionCB.setText(ElanLocale.getString("ExportDialog.Restrict"));
    }

    protected String promptForFileName() {
        String prefPath = null;
        Object val = Preferences.get("Recognizer.Path", null);
        prefPath = val instanceof String ? (String)val : System.getProperty("user.home");
        JFileChooser chooser = null;
        chooser = prefPath != null ? new JFileChooser(prefPath) : new JFileChooser();
        FileFilter ff = ElanFileFilter.createFileFilter(20);
        FileFilter ff2 = ElanFileFilter.createFileFilter(23);
        chooser.addChoosableFileFilter(ff);
        chooser.addChoosableFileFilter(ff2);
        chooser.setFileFilter(ff2);
        if (chooser.showSaveDialog(this) == 0) {
            File f = chooser.getSelectedFile();
            File par = f.getParentFile();
            if (par != null && par.isDirectory()) {
                Preferences.set("Recognizer.Path", par.getAbsolutePath(), null);
            }
            if (chooser.getFileFilter() == ff) {
                String lower = f.getAbsolutePath().toLowerCase();
                boolean valid = false;
                for (int i = 0; i < FileExtension.CSV_EXT.length; ++i) {
                    if (!lower.endsWith(FileExtension.CSV_EXT[i])) continue;
                    valid = true;
                    break;
                }
                if (!valid) {
                    f = new File(f.getAbsolutePath() + "." + FileExtension.CSV_EXT[0]);
                }
            } else if (!f.getAbsolutePath().toLowerCase().endsWith("xml")) {
                f = new File(f.getAbsolutePath() + ".xml");
            }
            return f.getAbsolutePath();
        }
        return null;
    }

    private void setPreferredSetting() {
        Object useTyp = Preferences.get("ExportRecogTiersDialog.rootTiersCB", null);
        if (useTyp != null) {
            this.rootTiersCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportRecogTiersDialog.selectionCB", null)) != null) {
            this.selectionCB.setSelected((Boolean)useTyp);
        }
    }

    private void savePreferences() {
        Preferences.set("ExportRecogTiersDialog.rootTiersCB", this.rootTiersCB.isSelected(), null);
        Preferences.set("ExportRecogTiersDialog.selectionCB", this.selectionCB.isSelected(), null);
        Preferences.set("ExportRecogTiersDialog.selectedTiers", this.getSelectedTiers(), this.transcription);
    }
}

