/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.CommandAction;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.client.util.TierTree;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.ConstraintImpl;
import mpi.eudico.server.corpora.clomimpl.type.IncludedIn;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicAssociation;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicSubdivision;
import mpi.eudico.server.corpora.clomimpl.type.TimeSubdivision;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;

public class ExportSelectionAsEAF
implements ClientLogger {
    private TranscriptionImpl transcription;
    private TranscriptionImpl nextTrans;
    private String path;
    private long beginTime;
    private long endTime;
    private boolean clipMedia;
    private ProgressMonitor monitor;

    public ExportSelectionAsEAF(TranscriptionImpl transcription, long beginTime, long endTime) {
        this.transcription = transcription;
        this.beginTime = beginTime;
        this.endTime = endTime;
        if (transcription != null) {
            this.startExport();
        }
    }

    private void startExport() {
        this.path = this.promptForFileName();
        if (this.path == null) {
            return;
        }
        this.nextTrans = new TranscriptionImpl();
        this.monitor = new ProgressMonitor(null, ElanLocale.getString("SaveDialog.Message.Title"), "", 0, 100);
        this.monitor.setMillisToDecideToPopup(10);
        this.monitor.setMillisToPopup(10);
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ExportSelectionAsEAF.this.startCopy();
            }
        }.start();
    }

    private void startCopy() {
        if (this.transcription == null || this.nextTrans == null) {
            this.progressUpdate(null, 100);
            return;
        }
        this.progressUpdate(null, 10);
        this.copy(this.transcription, this.nextTrans, this.beginTime, this.endTime, this.clipMedia);
        this.progressUpdate(null, 100);
    }

    private String createClipMediaFileName(String fileName, long begin, long end) {
        if (fileName != null) {
            int index = fileName.lastIndexOf(".");
            fileName = index > -1 ? fileName.substring(0, index) + "_" + begin + "_" + end + fileName.substring(index) : fileName + "_" + begin + "_" + end;
        }
        return fileName;
    }

    private void copy(TranscriptionImpl sourceTrans, TranscriptionImpl copyTrans, long begin, long end, boolean clipMedia) {
        TierImpl t1;
        String name;
        DefaultMutableTreeNode node;
        LinguisticType lt2;
        LinguisticType lt1;
        copyTrans.setNotifying(false);
        if (clipMedia) {
            CommandAction ca = ELANCommandFactory.getCommandAction(sourceTrans, "Menu.File.Export.MediaWithScript");
            ca.actionPerformed(null);
        }
        Vector mds = sourceTrans.getMediaDescriptors();
        Vector<MediaDescriptor> cmds = new Vector<MediaDescriptor>(mds.size());
        for (int i = 0; i < mds.size(); ++i) {
            MediaDescriptor md = (MediaDescriptor)mds.get(i);
            if (clipMedia) {
                long offset = md.timeOrigin;
                md.mediaURL = this.createClipMediaFileName(md.mediaURL, begin + offset, end + offset);
                if (md.extractedFrom != null) {
                    md.extractedFrom = this.createClipMediaFileName(md.extractedFrom, begin + offset, end + offset);
                }
                if (md.relativeMediaURL != null) {
                    md.relativeMediaURL = this.createClipMediaFileName(md.relativeMediaURL, begin + offset, end + offset);
                }
            }
            cmds.add((MediaDescriptor)md.clone());
        }
        copyTrans.setMediaDescriptors(cmds);
        Vector lfds = sourceTrans.getLinkedFileDescriptors();
        Vector<LinkedFileDescriptor> clfds = new Vector<LinkedFileDescriptor>(lfds.size());
        for (int i = 0; i < lfds.size(); ++i) {
            LinkedFileDescriptor lfd = (LinkedFileDescriptor)lfds.get(i);
            clfds.add((LinkedFileDescriptor)lfd.clone());
        }
        copyTrans.setLinkedFileDescriptors(clfds);
        this.progressUpdate(null, 20);
        if (this.isCancelled()) {
            return;
        }
        Vector cvs = sourceTrans.getControlledVocabularies();
        Vector<ControlledVocabulary> cvc = new Vector<ControlledVocabulary>(cvs.size());
        for (int i = 0; i < cvs.size(); ++i) {
            ControlledVocabulary cv1 = (ControlledVocabulary)cvs.get(i);
            ControlledVocabulary cv2 = new ControlledVocabulary(cv1.getName(), cv1.getDescription());
            CVEntry[] entries = cv1.getEntries();
            for (int j = 0; j < entries.length; ++j) {
                CVEntry ent1 = entries[j];
                CVEntry ent2 = new CVEntry(ent1.getValue(), ent1.getDescription());
                cv2.addEntry(ent2);
            }
            cvc.add(cv2);
        }
        copyTrans.setControlledVocabularies(cvc);
        this.progressUpdate(null, 30);
        if (this.isCancelled()) {
            return;
        }
        Vector types = sourceTrans.getLinguisticTypes();
        Vector<LinguisticType> typc = new Vector<LinguisticType>(types.size());
        ConstraintImpl con2 = null;
        for (int i = 0; i < types.size(); ++i) {
            lt1 = (LinguisticType)types.get(i);
            lt2 = new LinguisticType(lt1.getLinguisticTypeName());
            lt2.setTimeAlignable(lt1.isTimeAlignable());
            lt2.setGraphicReferences(lt1.hasGraphicReferences());
            lt2.setControlledVocabularyName(lt1.getControlledVocabylaryName());
            Constraint con1 = lt1.getConstraints();
            if (con1 != null) {
                switch (con1.getStereoType()) {
                    case 0: {
                        con2 = new TimeSubdivision();
                        break;
                    }
                    case 3: {
                        con2 = new SymbolicSubdivision();
                        break;
                    }
                    case 4: {
                        con2 = new SymbolicAssociation();
                        break;
                    }
                    case 1: {
                        con2 = new IncludedIn();
                    }
                }
                lt2.addConstraint(con2);
            }
            typc.add(lt2);
        }
        copyTrans.setLinguisticTypes(typc);
        this.progressUpdate(null, 35);
        if (this.isCancelled()) {
            return;
        }
        TierTree tree = new TierTree(sourceTrans);
        DefaultMutableTreeNode root = tree.getTree();
        Enumeration<TreeNode> en = root.breadthFirstEnumeration();
        en.nextElement();
        while (en.hasMoreElements()) {
            TierImpl copyTier = null;
            node = (DefaultMutableTreeNode)en.nextElement();
            name = (String)node.getUserObject();
            t1 = (TierImpl)sourceTrans.getTierWithId(name);
            if (t1 != null) {
                lt1 = t1.getLinguisticType();
                lt2 = copyTrans.getLinguisticTypeByName(lt1.getLinguisticTypeName());
                if (lt2 != null) {
                    if (t1.hasParentTier()) {
                        String parentName = t1.getParentTier().getName();
                        TierImpl t2 = (TierImpl)copyTrans.getTierWithId(parentName);
                        if (t2 != null) {
                            copyTier = new TierImpl(t2, name, t1.getParticipant(), copyTrans, lt2);
                            copyTier.setDefaultLocale(t1.getDefaultLocale());
                            copyTier.setAnnotator(t1.getAnnotator());
                        } else {
                            LOG.warning("The parent tier: " + parentName + " for tier: " + name + " was not found in the destination transcription");
                        }
                    } else {
                        copyTier = new TierImpl(name, t1.getParticipant(), copyTrans, lt2);
                        copyTier.setDefaultLocale(t1.getDefaultLocale());
                        copyTier.setAnnotator(t1.getAnnotator());
                    }
                } else {
                    LOG.warning("Could not add tier: " + name + " because the Linguistic Type was not found in the destination transcription.");
                }
            }
            if (copyTier == null) continue;
            copyTrans.addTier(copyTier);
        }
        this.progressUpdate(null, 40);
        if (this.isCancelled()) {
            return;
        }
        float incr = 40.0f / (float)Math.max(root.getChildCount(), 1);
        for (int i = 0; i < root.getChildCount(); ++i) {
            node = (DefaultMutableTreeNode)root.getChildAt(i);
            name = (String)node.getUserObject();
            t1 = (TierImpl)sourceTrans.getTierWithId(name);
            Vector srcAnnos = t1.getAnnotations();
            for (int j = 0; j < srcAnnos.size(); ++j) {
                AlignableAnnotation ann = (AlignableAnnotation)srcAnnos.get(j);
                if (ann.getEndTimeBoundary() <= begin) continue;
                if (ann.getBeginTimeBoundary() >= end) break;
                DefaultMutableTreeNode record = AnnotationRecreator.createTreeForAnnotation(ann);
                AlignableAnnotation copyAnn = (AlignableAnnotation)AnnotationRecreator.createAnnotationFromTree(copyTrans, record);
                if (copyAnn.getBeginTimeBoundary() < begin) {
                    copyAnn.updateTimeInterval(begin, copyAnn.getEndTimeBoundary());
                }
                if (copyAnn.getEndTimeBoundary() <= end) continue;
                copyAnn.updateTimeInterval(copyAnn.getBeginTimeBoundary(), end);
            }
            this.progressUpdate(null, 40 + (int)((float)i * incr));
            if (!this.isCancelled()) continue;
            return;
        }
        this.progressUpdate(null, 80);
        if (this.isCancelled()) {
            return;
        }
        copyTrans.shiftAllAnnotations(-begin);
        TranscriptionStore store = ACMTranscriptionStore.getCurrentTranscriptionStore();
        try {
            store.storeTranscription(copyTrans, null, new Vector(), this.path, 0);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        LOG.info("Selection saved as new .eaf");
    }

    private String promptForFileName() {
        String exportDir = (String)Preferences.get("LastUsedEAFDir", null);
        if (exportDir == null) {
            exportDir = System.getProperty("user.dir");
        }
        FileAndClipMediaChooser chooser = new FileAndClipMediaChooser();
        chooser.setCurrentDirectory(new File(exportDir));
        chooser.setDialogTitle(ElanLocale.getString("SaveDialog.Title"));
        File exportFile = null;
        FileFilter filter = ElanFileFilter.createFileFilter(3);
        chooser.setFileFilter(filter);
        if (chooser.showSaveDialog(ELANCommandFactory.getRootFrame(this.transcription)) == 0) {
            File curDir = chooser.getCurrentDirectory();
            if (curDir != null) {
                Preferences.set("LastUsedEAFDir", curDir.getAbsolutePath(), null);
            }
            exportFile = chooser.getSelectedFile();
            this.clipMedia = chooser.isClipMedia();
            if (exportFile != null) {
                String name = exportFile.getAbsolutePath();
                String lowerPathName = name.toLowerCase();
                String[] exts = FileExtension.EAF_EXT;
                boolean validExt = false;
                for (int i = 0; i < exts.length; ++i) {
                    if (!lowerPathName.endsWith("." + exts[i])) continue;
                    validExt = true;
                    break;
                }
                if (!validExt) {
                    name = name + "." + exts[0];
                    exportFile = new File(name);
                }
                if (exportFile.exists()) {
                    int answer = JOptionPane.showConfirmDialog(null, ElanLocale.getString("Message.Overwrite"), ElanLocale.getString("SaveDialog.Message.Title"), 0);
                    if (answer == 1) {
                        return this.promptForFileName();
                    }
                    return name;
                }
                return name;
            }
            return null;
        }
        return null;
    }

    private void progressUpdate(String note, int progress) {
        if (this.monitor != null) {
            if (note != null) {
                this.monitor.setNote(note);
            }
            this.monitor.setProgress(progress);
        }
    }

    private boolean isCancelled() {
        if (this.monitor != null) {
            return this.monitor.isCanceled();
        }
        return false;
    }

    public class FileAndClipMediaChooser
    extends JFileChooser {
        private JCheckBox clipMediaCB = new JCheckBox(ElanLocale.getString("ExportSelectionAsEAF.Label.ClipMedia"));

        public FileAndClipMediaChooser() {
            this.addCheckBox();
        }

        public boolean isClipMedia() {
            return this.clipMediaCB.isSelected();
        }

        private void addCheckBox() {
            JComponent component = (JComponent)this.getComponent(this.getComponentCount() - 1);
            JPanel panel = new JPanel(new GridBagLayout());
            JLabel title = new JLabel(ElanLocale.getString("ExportSelectionAsEAF.Label.Title"));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.weightx = 1.0;
            if (SystemReporting.isMacOS()) {
                gbc.insets = new Insets(10, 10, 0, 0);
                panel.add((Component)title, gbc);
                gbc.insets = new Insets(6, 20, 6, 4);
                gbc.gridy = 1;
                gbc.gridwidth = 0;
                panel.add((Component)this.clipMediaCB, gbc);
            } else {
                gbc.insets = new Insets(10, 0, 0, 0);
                panel.add((Component)title, gbc);
                gbc.insets = new Insets(6, 10, 6, 4);
                gbc.gridy = 1;
                gbc.gridwidth = 0;
                panel.add((Component)this.clipMediaCB, gbc);
            }
            component.add((Component)panel, component.getComponentCount() - 1);
        }
    }
}

