/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;

public class ExportTabCustomizePanel
extends JPanel {
    private JTable table;
    private DefaultTableModel model;
    private String[] headers;
    private boolean[] selected;

    public ExportTabCustomizePanel(String[] headers, boolean[] selected) {
        this.headers = headers;
        this.selected = selected;
        this.initComponents();
    }

    public ExportTabCustomizePanel(String[] headers) {
        this.headers = headers;
        this.initComponents();
    }

    public ExportTabCustomizePanel(String[] headers, int[] selectedIndices) {
        this.headers = headers;
        this.selected = new boolean[headers.length];
        for (int i = 0; i < selectedIndices.length; ++i) {
            if (selectedIndices[i] >= this.selected.length) continue;
            this.selected[selectedIndices[i]] = true;
        }
        this.initComponents();
    }

    public String[] getColumnOrder() {
        if (this.table.getTableHeader() != null) {
            Enumeration<TableColumn> colEnum = this.table.getTableHeader().getColumnModel().getColumns();
            ArrayList<String> colNames = new ArrayList<String>(this.table.getTableHeader().getColumnModel().getColumnCount());
            while (colEnum.hasMoreElements()) {
                colNames.add((String)colEnum.nextElement().getHeaderValue());
            }
            return colNames.toArray(new String[0]);
        }
        return null;
    }

    public int[] getSelectedColumnIndices() {
        ArrayList<Integer> colInd = new ArrayList<Integer>(this.headers.length);
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            Boolean value = (Boolean)this.table.getValueAt(0, i);
            if (!value.booleanValue()) continue;
            colInd.add(i);
        }
        int[] sel = new int[colInd.size()];
        for (int i = 0; i < colInd.size(); ++i) {
            sel[i] = (Integer)colInd.get(i);
        }
        return sel;
    }

    public String[] getOrderedSelectedColumns() {
        String[] allCols = this.getColumnOrder();
        if (allCols != null) {
            int[] selCols = this.getSelectedColumnIndices();
            String[] selColNames = new String[selCols.length];
            for (int i = 0; i < selCols.length; ++i) {
                if (selCols[i] >= allCols.length) continue;
                selColNames[i] = allCols[selCols[i]];
            }
            return selColNames;
        }
        return null;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.model = new DefaultTableModel(this.headers, 1);
        for (int i = 0; i < this.headers.length; ++i) {
            if (this.selected != null && i < this.selected.length) {
                this.model.setValueAt(new Boolean(this.selected[i]), 0, i);
                continue;
            }
            this.model.setValueAt(Boolean.FALSE, 0, i);
        }
        this.table = new JTable(this.model);
        JCheckBox cb = new JCheckBox();
        cb.setHorizontalAlignment(0);
        DefaultCellEditor cbEditor = new DefaultCellEditor(cb);
        CheckBoxTableCellRenderer cbRenderer = new CheckBoxTableCellRenderer();
        cbRenderer.setHorizontalAlignment(0);
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            this.table.getColumnModel().getColumn(i).setCellEditor(cbEditor);
            this.table.getColumnModel().getColumn(i).setCellRenderer(cbRenderer);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JScrollPane(this.table), gridBagConstraints);
    }
}

