/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import mpi.eudico.server.corpora.clom.Annotation;

public class TabExportTableModel
implements TableModel {
    public final String BT = "begin";
    public final String ET = "end";
    private List columnIds;
    private List rows;
    private String fileName = null;
    private String absoluteFilePath = null;

    public TabExportTableModel(List annotations, String[] tierNames) {
        this.columnIds = new ArrayList(tierNames.length + 2);
        this.rows = new ArrayList(annotations.size());
        this.columnIds.add("begin");
        this.columnIds.add("end");
        for (int i = 0; i < tierNames.length; ++i) {
            this.columnIds.add(tierNames[i]);
        }
        this.fillRows(annotations);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getAbsoluteFilePath() {
        return this.absoluteFilePath;
    }

    public void setAbsoluteFilePath(String filePath) {
        this.absoluteFilePath = filePath;
    }

    private void fillRows(List annotations) {
        long lastBT = -1L;
        long lastET = -1L;
        for (int i = 0; i < annotations.size(); ++i) {
            Annotation ann = (Annotation)annotations.get(i);
            long bt = ann.getBeginTimeBoundary();
            long et = ann.getEndTimeBoundary();
            if (bt != lastBT || et != lastET) {
                ArrayList<Object> row = new ArrayList<Object>(this.columnIds.size());
                for (int j = 0; j < this.columnIds.size(); ++j) {
                    row.add(j, null);
                }
                row.set(0, new Long(bt));
                row.set(1, new Long(et));
                int col = this.findColumn(ann.getTier().getName());
                if (col > -1) {
                    row.set(col, ann.getValue());
                }
                this.rows.add(row);
            } else {
                int col = this.findColumn(ann.getTier().getName());
                if (col > -1) {
                    this.setValueAt(ann.getValue(), this.rows.size() - 1, col);
                }
            }
            lastBT = bt;
            lastET = et;
        }
    }

    public int findColumn(String columnId) {
        return this.columnIds.indexOf(columnId);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.columnIds.size();
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnIds.size()) {
            throw new ArrayIndexOutOfBoundsException("Index " + columnIndex + " < 0 or > " + (this.columnIds.size() - 1));
        }
        return (String)this.columnIds.get(columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnIds.size()) {
            throw new ArrayIndexOutOfBoundsException("Index " + columnIndex + " < 0 or > " + (this.columnIds.size() - 1));
        }
        if (columnIndex == 0 || columnIndex == 1) {
            return Long.class;
        }
        return String.class;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnIds.size()) {
            throw new ArrayIndexOutOfBoundsException("Index " + columnIndex + " < 0 or > " + (this.columnIds.size() - 1));
        }
        if (rowIndex < 0 || rowIndex >= this.rows.size()) {
            throw new ArrayIndexOutOfBoundsException("Index " + rowIndex + " < 0 or > " + (this.rows.size() - 1));
        }
        List row = (List)this.rows.get(rowIndex);
        return row.get(columnIndex);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnIds.size()) {
            throw new ArrayIndexOutOfBoundsException("Index " + columnIndex + " < 0 or > " + (this.columnIds.size() - 1));
        }
        if (rowIndex < 0 || rowIndex >= this.rows.size()) {
            throw new ArrayIndexOutOfBoundsException("Index " + rowIndex + " < 0 or > " + (this.rows.size() - 1));
        }
        List row = (List)this.rows.get(rowIndex);
        row.set(columnIndex, aValue);
    }

    public void addTableModelListener(TableModelListener l) {
    }

    public void removeTableModelListener(TableModelListener l) {
    }
}

