/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.grid;

import java.util.List;
import mpi.eudico.client.annotator.grid.AbstractGridViewer;
import mpi.eudico.client.annotator.grid.AnnotationTable;
import mpi.eudico.client.annotator.grid.GridEditor;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;

public abstract class AbstractEditableGridViewer
extends AbstractGridViewer
implements ACMEditListener {
    protected GridEditor gridEditor;

    public AbstractEditableGridViewer(AnnotationTable table) {
        super(table);
    }

    protected void initTable() {
        super.initTable();
        this.gridEditor = new GridEditor(this, this.dataModel);
        this.table.setDefaultEditor(Object.class, this.gridEditor);
    }

    public void updateActiveAnnotation() {
        if (this.dataModel.getRowCount() == 0) {
            return;
        }
        this.repaint();
        if (this.getActiveAnnotation() != null) {
            this.doUpdate();
        }
    }

    public void ACMEdited(ACMEditEvent e) {
        if (this.dataModel.getRowCount() == 0) {
            return;
        }
        switch (e.getOperation()) {
            case 7: {
                this.repaint();
                break;
            }
            case 8: {
                this.repaint();
                break;
            }
            default: {
                this.repaint();
            }
        }
    }

    protected void updateDataModel(List annotations) {
        this.gridEditor.cancelCellEditing();
        if (annotations != null) {
            this.dataModel.updateAnnotations(annotations);
        }
    }

    public void updateLocale() {
        this.gridEditor.updateLocale();
        super.updateLocale();
    }

    public void preferencesChanged() {
    }
}

