/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.grid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationCore;
import mpi.eudico.util.TimeFormatter;

public class GridViewerTableModel
extends AbstractTableModel {
    public static final String TIMEPOINT = "ColumnTriangle";
    public static final String COUNT = "ColumnCount";
    public static final String FILENAME = "ColumnFileName";
    public static final String TIERNAME = "ColumnTierName";
    public static final String LEFTCONTEXT = "ColumnLeftContext";
    public static final String ANNOTATION = "ColumnAnnotation";
    public static final String RIGHTCONTEXT = "ColumnRightContext";
    public static final String BEGINTIME = "ColumnBeginTime";
    public static final String ENDTIME = "ColumnEndTime";
    public static final String DURATION = "ColumnDuration";
    public static final String[] fixedColumnNames = new String[]{"ColumnTriangle", "ColumnCount", "ColumnFileName", "ColumnTierName", "ColumnLeftContext", "ColumnAnnotation", "ColumnRightContext", "ColumnBeginTime", "ColumnEndTime", "ColumnDuration"};
    protected static final String HHMMSSsss = "TIMECODE";
    protected static final String MILLISECONDS = "MILLISECONDS";
    protected static final String PAL = "PAL";
    protected static final String NTSC = "NTSC";
    protected List annotations;
    protected List usedColumnNames;
    protected boolean isFiltering = false;
    private final String EMPTY = "";
    private Hashtable childTierHash = new Hashtable();
    private String strTimeFormat = "TIMECODE";
    private final int TC = 0;
    private final int TC_PAL = 1;
    private final int TC_NTSC = 2;
    private final int MS = 3;
    private int time_mode = 0;

    public GridViewerTableModel() {
        this(new ArrayList());
    }

    GridViewerTableModel(List annotations) {
        this.annotations = annotations;
        this.usedColumnNames = new ArrayList();
        this.usedColumnNames.add(TIMEPOINT);
        this.usedColumnNames.add(COUNT);
        this.usedColumnNames.add(ANNOTATION);
        this.usedColumnNames.add(BEGINTIME);
        this.usedColumnNames.add(ENDTIME);
        this.usedColumnNames.add(DURATION);
    }

    public AnnotationCore getAnnotationCore(int row) {
        return (AnnotationCore)this.annotations.get(row);
    }

    public boolean isCellEditable(int row, int column) {
        return this.getValueAt(row, column) instanceof Annotation || !Arrays.asList(fixedColumnNames).contains(this.getColumnName(column));
    }

    public int getColumnCount() {
        return this.usedColumnNames.size();
    }

    public String getColumnName(int nr) {
        if (0 <= nr && nr < this.usedColumnNames.size()) {
            return (String)this.usedColumnNames.get(nr);
        }
        return "";
    }

    public void setFiltering(boolean filtering) {
        this.isFiltering = filtering;
    }

    public boolean isFiltering() {
        return this.isFiltering;
    }

    public int getRowCount() {
        return this.annotations.size();
    }

    public void setTimeFormat(String strTimeFormat) {
        if (strTimeFormat.equals("hh:mm:ss.ms") || strTimeFormat.equals(HHMMSSsss)) {
            this.time_mode = 0;
            this.strTimeFormat = "hh:mm:ss.ms";
        } else if (strTimeFormat.equals(PAL)) {
            this.time_mode = 1;
            this.strTimeFormat = strTimeFormat;
        } else if (strTimeFormat.equals(NTSC)) {
            this.time_mode = 2;
            this.strTimeFormat = strTimeFormat;
        } else if (strTimeFormat.equals("ms") || strTimeFormat.equals(MILLISECONDS)) {
            this.time_mode = 3;
            this.strTimeFormat = "ms";
        }
    }

    public String getTimeFormat() {
        return this.strTimeFormat;
    }

    public void setValueAt(Object annotation, int row, int column) {
        String tierName;
        int size;
        if (annotation instanceof AnnotationCore && (size = this.childTierHash.size()) > 0 && column > 2 && column <= 2 + size && row < this.getRowCount() && this.childTierHash.containsKey(tierName = this.getColumnName(column))) {
            List anns = (List)this.childTierHash.get(tierName);
            anns.set(row, annotation);
        }
    }

    public Object getValueAt(int row, int column) {
        try {
            List v;
            if (column < 0 || column >= this.usedColumnNames.size() || row < 0 || row >= this.annotations.size()) {
                return null;
            }
            String cn = this.getColumnName(column);
            if (cn.equals(TIMEPOINT)) {
                return null;
            }
            if (cn.equals(COUNT)) {
                return "" + (row + 1);
            }
            if (cn.equals(ANNOTATION)) {
                return this.annotations.get(row);
            }
            if (cn.equals(BEGINTIME)) {
                return this.getStringRepresentation(((AnnotationCore)this.annotations.get(row)).getBeginTimeBoundary());
            }
            if (cn.equals(ENDTIME)) {
                return this.getStringRepresentation(((AnnotationCore)this.annotations.get(row)).getEndTimeBoundary());
            }
            if (cn.equals(DURATION)) {
                AnnotationCore ann = (AnnotationCore)this.annotations.get(row);
                return this.getStringRepresentation(ann.getEndTimeBoundary() - ann.getBeginTimeBoundary());
            }
            if (this.childTierHash.containsKey(cn) && row < (v = (List)this.childTierHash.get(cn)).size()) {
                return v.get(row);
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            return null;
        }
        return null;
    }

    public void addAnnotation(AnnotationCore aa) {
        this.annotations.add(aa);
        this.fireTableDataChanged();
    }

    public void addAnnotations(List list) {
        this.annotations.addAll(list);
        this.fireTableDataChanged();
    }

    public void addChildTier(String tierName, List annotations) {
        if (this.childTierHash.containsKey(tierName)) {
            return;
        }
        this.childTierHash.put(tierName, annotations);
        int index = this.findColumn(BEGINTIME);
        this.usedColumnNames.add(index, tierName);
        this.fireTableDataChanged();
    }

    public void updateAnnotations(List annotations) {
        this.annotations = annotations;
        this.removeChildTiers();
        this.fireTableDataChanged();
    }

    private String getStringRepresentation(long l) {
        switch (this.time_mode) {
            case 3: {
                return String.valueOf(l);
            }
            case 1: {
                return TimeFormatter.toTimecodePAL(l);
            }
            case 2: {
                return TimeFormatter.toTimecodeNTSC(l);
            }
        }
        return TimeFormatter.toString(l);
    }

    private void removeChildTiers() {
        int numChildTiers = this.childTierHash.size();
        if (numChildTiers > 0) {
            Enumeration en = this.childTierHash.keys();
            while (en.hasMoreElements()) {
                this.usedColumnNames.remove(en.nextElement());
            }
            this.childTierHash.clear();
        }
    }
}

