/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ELAN;
import mpi.eudico.client.annotator.ElanLocale;

public class AboutPanel
extends JPanel {
    private JTabbedPane tabPane;
    private JPanel aboutTabPanel;
    private JPanel acknowledgeTabPanel;

    public AboutPanel() {
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new GridBagLayout());
        this.tabPane = new JTabbedPane();
        this.aboutTabPanel = new JPanel(new GridBagLayout());
        ImageIcon icon = null;
        try {
            icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/ELAN256.png"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        StringBuffer textBuf = new StringBuffer("<html>");
        textBuf.append("<b>");
        textBuf.append("E L A N - ELAN Linguistic Annotator");
        textBuf.append("<br>");
        textBuf.append("Version: ");
        textBuf.append(ELAN.getVersionString());
        textBuf.append("<br><br>");
        textBuf.append("Copyright \u00a9 2001 - 2011");
        textBuf.append("<br>");
        textBuf.append("Max-Planck-Institute for Psycholinguistics");
        textBuf.append("<br>");
        textBuf.append("Nijmegen, The Netherlands");
        textBuf.append("</b><br><br><br>");
        textBuf.append(ElanLocale.getString("Menu.Help.AboutText.GPL"));
        textBuf.append("<br>");
        textBuf.append("</html>");
        JLabel label = new JLabel(textBuf.toString().replaceAll("\\u000A", "<br>"));
        label.setFont(label.getFont().deriveFont(0));
        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.anchor = 18;
        if (icon != null) {
            this.aboutTabPanel.add((Component)new JLabel(icon), gbc);
        }
        gbc.gridx = 1;
        gbc.anchor = 10;
        this.aboutTabPanel.add((Component)label, gbc);
        this.tabPane.addTab(ElanLocale.getString("Menu.Help.About"), this.aboutTabPanel);
        gbc.gridx = 0;
        this.add((Component)this.tabPane, gbc);
        this.acknowledgeTabPanel = new JPanel(new GridBagLayout());
        JTabbedPane acknowTabPane = new JTabbedPane();
        JScrollPane devScrollPane = new JScrollPane(this.getDeveloperTable());
        devScrollPane.setPreferredSize(new Dimension(200, 80));
        acknowTabPane.addTab(ElanLocale.getString("AboutDialog.Source"), devScrollPane);
        JScrollPane transScrollPane = new JScrollPane(this.getTranslatorsTable());
        transScrollPane.setPreferredSize(new Dimension(200, 80));
        acknowTabPane.addTab(ElanLocale.getString("AboutDialog.Translations"), transScrollPane);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.acknowledgeTabPanel.add((Component)acknowTabPane, gbc);
        this.tabPane.addTab(ElanLocale.getString("AboutDialog.Acknowledgments"), this.acknowledgeTabPanel);
    }

    private JTable getDeveloperTable() {
        DefaultTableModel model = new DefaultTableModel(0, 0);
        model.addColumn(ElanLocale.getString("AboutDialog.Name"));
        model.addColumn(ElanLocale.getString("AboutDialog.Affiliation"));
        model.addRow(new String[]{"Eric Auer", "MPI"});
        model.addRow(new String[]{"Hennie Brugman", "MPI"});
        model.addRow(new String[]{"Greg Gulrajani", "MPI"});
        model.addRow(new String[]{"Alex Klassmann", "MPI"});
        model.addRow(new String[]{"Alex K\u00f6nig", "MPI"});
        model.addRow(new String[]{"Markus Kramer", "MPI"});
        model.addRow(new String[]{"Marc Pippel", "MPI"});
        model.addRow(new String[]{"Albert Russel", "MPI"});
        model.addRow(new String[]{"Han Sloetjes", "MPI"});
        model.addRow(new String[]{"Aarthy Somasundaram", "MPI"});
        model.addRow(new String[]{"Harriet Spenke", "MPI"});
        model.addRow(new String[]{"", ""});
        model.addRow(new String[]{"SIDGrid team", "SIDGrid, Chicago"});
        model.addRow(new String[]{"Ouriel Grynzspan", "CNRS, Paris"});
        model.addRow(new String[]{"Mark Blokpoel", "Radboud University, Nijmegen"});
        model.addRow(new String[]{"Martin Schickbichler", "TU Graz"});
        model.addRow(new String[]{"Tom Myers, Consultant, and the Research Staff", "NSF Project \"Five Languages of Eurasia\""});
        model.addRow(new String[]{"Jeffrey Lemein", "Radboud University, Nijmegen"});
        model.addRow(new String[]{"Micha Hulsbosch", "Radboud University, Nijmegen"});
        model.addRow(new String[]{"Christopher Cox", "University of Alberta"});
        JTable table = new JTable(model);
        table.getTableHeader().setReorderingAllowed(false);
        return table;
    }

    private JTable getTranslatorsTable() {
        DefaultTableModel model = new DefaultTableModel(0, 0);
        model.addColumn(ElanLocale.getString("AboutDialog.Name"));
        model.addColumn(ElanLocale.getString("Menu.Options.Language"));
        model.addRow(new String[]{"Gemma Barbera", "Catalan, Spanish"});
        model.addRow(new String[]{"Florian Gu\u00e9niot", "French"});
        model.addRow(new String[]{"Alexander Koenig", "German"});
        model.addRow(new String[]{"Alex Klassmann", "German"});
        model.addRow(new String[]{"Tarc\u00edsio Leite", "Portuguese"});
        model.addRow(new String[]{"Johanna Mesch", "Swedish"});
        model.addRow(new String[]{"Vlado Plaga", "German"});
        model.addRow(new String[]{"Josep Quer ", "Catalan, Spanish"});
        model.addRow(new String[]{"Andresa Furtado Schmitz", "Portuguese"});
        model.addRow(new String[]{"Yuki Yamada", "Japanese"});
        JTable table = new JTable(model);
        table.getTableHeader().setReorderingAllowed(false);
        return table;
    }
}

