/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.JFontChooser;
import mpi.eudico.client.util.FavoriteColorPanel;

public class AdvancedTierOptionsDialog
extends JDialog
implements ActionListener {
    private HashMap tierProperties;
    private JPanel colorPreviewPanel;
    private JButton colorButton;
    private JButton resetColorButton;
    private JPanel highlightColorPreviewPanel;
    private JButton highlightColorButton;
    private JButton resetHighlightColorButton;
    private JTextField fontTextField;
    private JButton fontButton;
    private JButton resetFontButton;
    private JButton changeButton;
    private JButton cancelButton;

    public AdvancedTierOptionsDialog(Dialog owner, boolean modal, HashMap tierProperties) throws HeadlessException {
        this(owner, "", modal, tierProperties);
    }

    public AdvancedTierOptionsDialog(Dialog owner, String title, boolean modal, HashMap tierProps) throws HeadlessException {
        super(owner, title, modal);
        if (tierProps == null || tierProps.get("TierName") == null) {
            throw new IllegalArgumentException("Insufficient tier properties.");
        }
        this.tierProperties = new HashMap(tierProps.size());
        this.tierProperties.putAll(tierProps);
        this.initComponents();
        this.postInit();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        JPanel prefPanel = new JPanel();
        JLabel titleLabel = new JLabel();
        titleLabel.setText(ElanLocale.getString("EditTierDialog.Label.TierName") + ": " + this.tierProperties.get("TierName"));
        titleLabel.setFont(titleLabel.getFont().deriveFont(16.0f));
        titleLabel.setHorizontalAlignment(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)titleLabel, gbc);
        prefPanel.setBorder(new TitledBorder(ElanLocale.getString("EditTierDialog.Label.TierPreferences")));
        prefPanel.setLayout(new GridBagLayout());
        JLabel colorLabel = new JLabel(ElanLocale.getString("EditTierDialog.Label.TierColor"));
        this.colorPreviewPanel = new JPanel();
        this.colorPreviewPanel.setBorder(new LineBorder(Color.GRAY, 1));
        this.colorPreviewPanel.setBackground(Color.WHITE);
        this.colorButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.colorButton.addActionListener(this);
        this.resetColorButton = new JButton(ElanLocale.getString("Button.Default"));
        this.resetColorButton.addActionListener(this);
        this.colorPreviewPanel.setPreferredSize(new Dimension(this.colorButton.getPreferredSize().height, this.colorButton.getPreferredSize().height));
        this.colorPreviewPanel.setMinimumSize(new Dimension(this.colorButton.getPreferredSize().height, this.colorButton.getPreferredSize().height));
        if (this.tierProperties.get("TierColor") instanceof Color) {
            this.colorPreviewPanel.setBackground((Color)this.tierProperties.get("TierColor"));
        }
        JLabel highlightColorLabel = new JLabel(ElanLocale.getString("EditTierDialog.Label.TierHighlightColor"));
        this.highlightColorPreviewPanel = new JPanel();
        this.highlightColorPreviewPanel.setBorder(new LineBorder(Color.GRAY, 1));
        this.highlightColorPreviewPanel.setBackground(Color.WHITE);
        this.highlightColorButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.highlightColorButton.addActionListener(this);
        this.resetHighlightColorButton = new JButton(ElanLocale.getString("Button.Default"));
        this.resetHighlightColorButton.addActionListener(this);
        this.highlightColorPreviewPanel.setPreferredSize(new Dimension(this.highlightColorButton.getPreferredSize().height, this.highlightColorButton.getPreferredSize().height));
        this.highlightColorPreviewPanel.setMinimumSize(new Dimension(this.highlightColorButton.getPreferredSize().height, this.highlightColorButton.getPreferredSize().height));
        if (this.tierProperties.get("TierHighlightColor") instanceof Color) {
            this.highlightColorPreviewPanel.setBackground((Color)this.tierProperties.get("TierHighlightColor"));
        }
        JLabel fontLabel = new JLabel(ElanLocale.getString("EditTierDialog.Label.TierFont"));
        this.fontTextField = new JTextField(20);
        this.fontTextField.setEditable(false);
        if (this.tierProperties.get("TierFont") instanceof Font) {
            this.fontTextField.setText(((Font)this.tierProperties.get("TierFont")).getName());
        }
        this.fontButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.fontButton.addActionListener(this);
        this.resetFontButton = new JButton(ElanLocale.getString("Button.Default"));
        this.resetFontButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = insets;
        prefPanel.add((Component)colorLabel, gbc);
        gbc.gridx = 1;
        prefPanel.add((Component)this.colorPreviewPanel, gbc);
        gbc.gridx = 3;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        prefPanel.add((Component)this.colorButton, gbc);
        gbc.gridx = 4;
        prefPanel.add((Component)this.resetColorButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        prefPanel.add((Component)highlightColorLabel, gbc);
        gbc.gridx = 1;
        prefPanel.add((Component)this.highlightColorPreviewPanel, gbc);
        gbc.gridx = 3;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        prefPanel.add((Component)this.highlightColorButton, gbc);
        gbc.gridx = 4;
        prefPanel.add((Component)this.resetHighlightColorButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.gridy = 2;
        prefPanel.add((Component)fontLabel, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        prefPanel.add((Component)this.fontTextField, gbc);
        gbc.gridx = 3;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        prefPanel.add((Component)this.fontButton, gbc);
        gbc.gridx = 4;
        prefPanel.add((Component)this.resetFontButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)prefPanel, gbc);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.changeButton = new JButton();
        this.changeButton.setText(ElanLocale.getString("Button.Apply"));
        this.changeButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.changeButton);
        buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.anchor = 15;
        gbc.insets = insets;
        this.getContentPane().add((Component)buttonPanel, gbc);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                AdvancedTierOptionsDialog.this.doClose();
            }
        });
    }

    private void postInit() {
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
    }

    private Color chooseColor(Color oldColor) {
        Color newColor = null;
        final JColorChooser chooser = new JColorChooser(oldColor);
        AbstractColorChooserPanel[] panels = chooser.getChooserPanels();
        AbstractColorChooserPanel[] panels2 = new AbstractColorChooserPanel[panels.length + 1];
        FavoriteColorPanel fcp = new FavoriteColorPanel();
        panels2[0] = fcp;
        for (int i = 0; i < panels.length; ++i) {
            panels2[i + 1] = panels[i];
        }
        chooser.setChooserPanels(panels2);
        Map oldColors = null;
        Object stored = Preferences.get("FavoriteColors", null);
        if (stored instanceof Map) {
            oldColors = (Map)stored;
            Color[] favColors = fcp.getColors();
            for (String key : oldColors.keySet()) {
                Color val = (Color)oldColors.get(key);
                try {
                    int index = Integer.valueOf(key);
                    if (index >= favColors.length) continue;
                    favColors[index] = val;
                }
                catch (NumberFormatException nfe) {}
            }
        }
        AbstractAction aa = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                this.putValue("Default", chooser.getColor());
            }
        };
        JDialog cd = JColorChooser.createDialog(this, ElanLocale.getString("ColorChooser.Title"), true, chooser, aa, null);
        cd.setVisible(true);
        HashMap<String, Color> colMap = new HashMap<String, Color>();
        Color[] colors = fcp.getColors();
        for (int i = 0; i < colors.length; ++i) {
            if (colors[i] == null) continue;
            colMap.put(String.valueOf(i), colors[i]);
        }
        if (colMap.size() > 0 || oldColors != null) {
            Preferences.set("FavoriteColors", colMap, null);
        }
        newColor = (Color)aa.getValue("Default");
        return newColor;
    }

    private void selectTierColor() {
        Color oldColor = (Color)this.tierProperties.get("TierColor");
        Color newColor = this.chooseColor(oldColor);
        if (newColor != null && !newColor.equals(oldColor)) {
            this.colorPreviewPanel.setBackground(newColor);
            this.tierProperties.put("TierColor", newColor);
        }
    }

    private void selectHighlightColor() {
        Color oldColor = (Color)this.tierProperties.get("TierHighlightColor");
        Color newColor = this.chooseColor(oldColor);
        if (newColor != null) {
            this.highlightColorPreviewPanel.setBackground(newColor);
            this.tierProperties.put("TierHighlightColor", newColor);
        }
    }

    private void selectFont() {
        JFontChooser jfc = new JFontChooser();
        Font curFont = (Font)this.tierProperties.get("TierFont");
        Font f = jfc.showDialog(this, true, curFont);
        if (f != null) {
            this.fontTextField.setText(f.getName());
            this.tierProperties.put("TierFont", f);
        }
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.changeButton) {
            this.doClose();
        } else if (e.getSource() == this.cancelButton) {
            this.tierProperties = null;
            this.doClose();
        } else if (e.getSource() == this.colorButton) {
            this.selectTierColor();
        } else if (e.getSource() == this.resetColorButton) {
            this.colorPreviewPanel.setBackground(Color.WHITE);
            this.tierProperties.put("TierColor", Color.WHITE);
        } else if (e.getSource() == this.highlightColorButton) {
            this.selectHighlightColor();
        } else if (e.getSource() == this.resetHighlightColorButton) {
            this.highlightColorPreviewPanel.setBackground(Color.WHITE);
            this.tierProperties.put("TierHighlightColor", Color.WHITE);
        } else if (e.getSource() == this.fontButton) {
            this.selectFont();
        } else if (e.getSource() == this.resetFontButton) {
            this.fontTextField.setText("");
            this.tierProperties.put("TierFont", null);
        }
    }

    public HashMap getTierProperties() {
        return this.tierProperties;
    }
}

