/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.AbstractStatisticsPanel;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.util.TableHeaderToolTipAdapter;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.util.ControlledVocabulary;

public class AnnotationStatisticsPanel
extends AbstractStatisticsPanel
implements ItemListener,
ActionListener,
ClientLogger {
    private JComboBox tierComboBox;
    private Vector rootTiers;
    private String curTier;
    private JLabel tierLabel;
    private JPanel tierSelectionPanel;
    private JCheckBox rootTiersOnlyCB;
    private JCheckBox collapseAdjacentCB;
    private JCheckBox mediaDurObservationCB;
    private String annotations = "Annotations";
    private String occurrences = "Occurrences";
    private String frequency = "Frequency";
    private String averageDuration = "Average Duration";
    private String timeRatio = "Time Ratio";
    private String latency = "Latency";
    private long beginBoundary;
    private long endBoundary;
    private boolean rootsOnly = true;
    private boolean collapseValues = true;
    private boolean useMediaDuration = false;

    public AnnotationStatisticsPanel(Transcription transcription) {
        super(transcription);
        this.readPreferences();
        this.initComponents();
    }

    public AnnotationStatisticsPanel(Transcription transcription, long totalDuration) {
        super(transcription, totalDuration);
        this.readPreferences();
        this.initComponents();
    }

    public JTable getStatisticsTable() {
        return this.statTable;
    }

    void initComponents() {
        this.tierComboBox = new JComboBox();
        this.rootTiers = new Vector();
        if (this.rootsOnly) {
            this.extractRootTiers();
        } else {
            this.extractAllTiers();
        }
        this.tierLabel = new JLabel();
        this.rootTiersOnlyCB = new JCheckBox();
        this.rootTiersOnlyCB.setSelected(this.rootsOnly);
        this.collapseAdjacentCB = new JCheckBox();
        this.collapseAdjacentCB.setSelected(this.collapseValues);
        this.mediaDurObservationCB = new JCheckBox();
        this.mediaDurObservationCB.setSelected(this.useMediaDuration);
        this.tierSelectionPanel = new JPanel(new GridBagLayout());
        this.statPanel = new JPanel();
        this.statTable = new JTable();
        this.statTable.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        this.statTable.setEnabled(false);
        this.setStatTable();
        this.statPane = new JScrollPane(this.statTable);
        Dimension size = new Dimension(500, 100);
        this.statPane.setPreferredSize(size);
        this.updateLocale();
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 12);
        this.tierSelectionPanel.add((Component)this.tierLabel, gridBagConstraints);
        this.tierComboBox.addItemListener(this);
        this.tierComboBox.setMaximumRowCount(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.tierSelectionPanel.add((Component)this.tierComboBox, gridBagConstraints);
        Insets insets2 = new Insets(0, 6, 0, 6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets2;
        this.tierSelectionPanel.add((Component)this.rootTiersOnlyCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets2;
        this.tierSelectionPanel.add((Component)this.collapseAdjacentCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets2;
        this.tierSelectionPanel.add((Component)this.mediaDurObservationCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.tierSelectionPanel, gridBagConstraints);
        this.statPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.statPanel.add((Component)this.statPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 10.0;
        this.add((Component)this.statPanel, gridBagConstraints);
        this.rootTiersOnlyCB.addActionListener(this);
        this.collapseAdjacentCB.addActionListener(this);
        this.mediaDurObservationCB.addActionListener(this);
    }

    public void updateLocale() {
        this.tierSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("Statistics.Panel.Tier")));
        this.tierLabel.setText(ElanLocale.getString("Statistics.Label.Tier"));
        this.rootTiersOnlyCB.setText(ElanLocale.getString("Statistics.Label.RootTiers"));
        this.collapseAdjacentCB.setText(ElanLocale.getString("Statistics.Label.Collapse"));
        this.mediaDurObservationCB.setText(ElanLocale.getString("Statistics.Label.MediaDuration"));
        this.statPanel.setBorder(new TitledBorder(ElanLocale.getString("Statistics.Pane.Table")));
        this.repaint();
    }

    private void updateLocalsForVariables() {
        this.annotations = ElanLocale.getString("Frame.GridFrame.ColumnAnnotation");
        this.occurrences = ElanLocale.getString("Statistics.Occurrences");
        this.frequency = ElanLocale.getString("Statistics.Frequency");
        this.averageDuration = ElanLocale.getString("Statistics.AverageDuration");
        this.timeRatio = ElanLocale.getString("Statistics.TimeRatio");
        this.latency = ElanLocale.getString("Statistics.Latency");
    }

    private void setStatTable() {
        TierImpl tier = (TierImpl)this.transcription.getTierWithId(this.curTier);
        this.setTimeBoundaries();
        DefaultTableModel statTableModel = this.getStatistics(tier);
        this.statTable.setModel(statTableModel);
        this.statTable.getTableHeader().addMouseMotionListener(new TableHeaderToolTipAdapter(this.statTable.getTableHeader()));
    }

    private DefaultTableModel getStatistics(TierImpl tier) {
        Object[][] tableStat;
        DefaultTableModel statTableModel = null;
        Object[] tableHeader = new String[6];
        this.updateLocalsForVariables();
        tableHeader[0] = this.annotations;
        tableHeader[1] = this.occurrences;
        tableHeader[2] = this.frequency;
        tableHeader[3] = this.averageDuration;
        tableHeader[4] = this.timeRatio;
        tableHeader[5] = this.latency;
        TreeSet annValues = this.getAnnotationValues(tier);
        if (null == annValues || annValues.size() == 0) {
            tableStat = new String[0][6];
        } else {
            int i;
            tableStat = new String[annValues.size()][6];
            Iterator itAnnValues = annValues.iterator();
            int r = 0;
            while (itAnnValues.hasNext()) {
                tableStat[r][0] = (String)itAnnValues.next();
                ++r;
            }
            for (i = 0; i < annValues.size(); ++i) {
                tableStat[i][1] = "" + this.getOccurrences(tier, (String)tableStat[i][0]);
            }
            for (i = 0; i < annValues.size(); ++i) {
                tableStat[i][2] = "" + this.getFrequency(tier, (String)tableStat[i][0]);
            }
            for (i = 0; i < annValues.size(); ++i) {
                tableStat[i][3] = "" + this.getAverageDuration(tier, (String)tableStat[i][0]);
            }
            for (i = 0; i < annValues.size(); ++i) {
                tableStat[i][4] = "" + this.getTimeRatio(tier, (String)tableStat[i][0]);
            }
            for (i = 0; i < annValues.size(); ++i) {
                double latency = this.getLatency(tier, (String)tableStat[i][0]);
                tableStat[i][5] = latency == (double)(this.totalDuration - this.beginBoundary) / 1000.0 ? "-" : "" + latency;
            }
        }
        statTableModel = new DefaultTableModel(tableStat, tableHeader);
        return statTableModel;
    }

    private TreeSet getAnnotationValues(TierImpl tier) {
        TreeSet<String> annValues;
        block5: {
            block4: {
                annValues = null;
                if (null == tier || null == tier.getLinguisticType()) {
                    return annValues;
                }
                if (!tier.getLinguisticType().isUsingControlledVocabulary()) break block4;
                String CVname = tier.getLinguisticType().getControlledVocabylaryName();
                ControlledVocabulary CV = this.transcription.getControlledVocabulary(CVname);
                if (CV == null || CV.getEntryValues().length <= 0) break block5;
                String[] cvEntriesVal = CV.getEntryValues();
                annValues = new TreeSet();
                for (int i = 0; i < cvEntriesVal.length; ++i) {
                    if (cvEntriesVal[i] == null || cvEntriesVal[i].length() <= 0) continue;
                    annValues.add(cvEntriesVal[i]);
                }
                break block5;
            }
            Vector annotations = tier.getAnnotations();
            if (annotations != null && annotations.size() > 0) {
                annValues = new TreeSet<String>();
                for (AbstractAnnotation ann : annotations) {
                    if (ann.getValue() == null || ann.getValue().length() <= 0) continue;
                    annValues.add(ann.getValue());
                }
            }
        }
        return annValues;
    }

    private void extractRootTiers() {
        this.tierComboBox.removeItemListener(this);
        this.tierComboBox.removeAllItems();
        if (this.transcription != null) {
            Vector tiers = this.transcription.getTiers();
            Iterator tierIt = tiers.iterator();
            TierImpl tier = null;
            while (tierIt.hasNext()) {
                tier = (TierImpl)tierIt.next();
                if (tier.getLinguisticType().getConstraints() != null) continue;
                this.tierComboBox.addItem(tier.getName());
                this.rootTiers.add(tier);
            }
            if (this.tierComboBox.getModel().getSize() == 0) {
                this.tierComboBox.addItem("-");
            }
        } else {
            this.tierComboBox.addItem("-");
        }
        this.curTier = (String)this.tierComboBox.getSelectedItem();
        this.tierComboBox.addItemListener(this);
    }

    private void extractAllTiers() {
        this.tierComboBox.removeItemListener(this);
        this.tierComboBox.removeAllItems();
        if (this.transcription != null) {
            Vector tiers = this.transcription.getTiers();
            Iterator tierIt = tiers.iterator();
            TierImpl tier = null;
            while (tierIt.hasNext()) {
                tier = (TierImpl)tierIt.next();
                this.tierComboBox.addItem(tier.getName());
                this.rootTiers.add(tier);
            }
            if (this.tierComboBox.getModel().getSize() == 0) {
                this.tierComboBox.addItem("-");
            }
        } else {
            this.tierComboBox.addItem("-");
        }
        this.curTier = (String)this.tierComboBox.getSelectedItem();
        this.tierComboBox.addItemListener(this);
    }

    private long getOccurrences(TierImpl tier, String annValue) {
        long occ = 0L;
        Vector annotations = tier.getAnnotations();
        if (annotations != null) {
            Collections.sort(annotations);
            for (int i = 0; i < annotations.size(); ++i) {
                AbstractAnnotation ann = (AbstractAnnotation)annotations.get(i);
                if (!annValue.equals(ann.getValue())) continue;
                if (!this.collapseValues) {
                    ++occ;
                    continue;
                }
                AbstractAnnotation prevAnn = (AbstractAnnotation)tier.getAnnotationBefore(ann);
                if (null == prevAnn) {
                    ++occ;
                    continue;
                }
                if (prevAnn.getEndTimeBoundary() < ann.getBeginTimeBoundary()) {
                    ++occ;
                    continue;
                }
                if (annValue.equals(prevAnn.getValue())) continue;
                ++occ;
            }
        }
        return occ;
    }

    private void setTimeBoundaries() {
        if (this.useMediaDuration) {
            this.beginBoundary = 0L;
            this.endBoundary = this.totalDuration;
            return;
        }
        this.beginBoundary = this.totalDuration;
        this.endBoundary = 0L;
        for (TierImpl tier : this.rootTiers) {
            Vector annotations = tier.getAnnotations();
            if (annotations == null) continue;
            for (AbstractAnnotation ann : annotations) {
                this.beginBoundary = Math.min(this.beginBoundary, ann.getBeginTimeBoundary());
                this.endBoundary = Math.max(this.endBoundary, ann.getEndTimeBoundary());
            }
        }
        LOG.info("Observation beginning boundary = " + this.beginBoundary + ", observation ending boundary = " + this.endBoundary);
    }

    private double getObservationTime() {
        return (double)(this.endBoundary - this.beginBoundary) / 1000.0;
    }

    private double getFrequency(TierImpl tier, String annValue) {
        double freq = 0.0;
        long occ = this.getOccurrences(tier, annValue);
        if (this.getObservationTime() > 0.0) {
            freq = (double)occ / this.getObservationTime();
        }
        return freq;
    }

    private double getAnnValueDuration(TierImpl tier, String annValue) {
        double valDuration = 0.0;
        Vector annotations = tier.getAnnotations();
        if (annotations != null) {
            for (AbstractAnnotation ann : annotations) {
                if (!annValue.equals(ann.getValue())) continue;
                double annDur = ann.getEndTimeBoundary() - ann.getBeginTimeBoundary();
                valDuration += annDur;
            }
        }
        return valDuration / 1000.0;
    }

    private double getAverageDuration(TierImpl tier, String annValue) {
        double avDuration = 0.0;
        if (this.getOccurrences(tier, annValue) > 0L) {
            avDuration = this.getAnnValueDuration(tier, annValue) / (double)this.getOccurrences(tier, annValue);
        }
        return avDuration;
    }

    private double getTimeRatio(TierImpl tier, String annValue) {
        double timeRatio = 0.0;
        if (this.getObservationTime() > 0.0) {
            timeRatio = this.getAnnValueDuration(tier, annValue) / this.getObservationTime();
        }
        return timeRatio;
    }

    private double getLatency(TierImpl tier, String annValue) {
        double latency = this.totalDuration - this.beginBoundary;
        Vector annotations = tier.getAnnotations();
        if (annotations != null) {
            for (AbstractAnnotation ann : annotations) {
                if (!annValue.equals(ann.getValue())) continue;
                latency = Math.min(latency, (double)(ann.getBeginTimeBoundary() - this.beginBoundary));
            }
        }
        return latency / 1000.0;
    }

    public void itemStateChanged(ItemEvent ie) {
        if (ie.getStateChange() == 1) {
            String newSel = (String)this.tierComboBox.getSelectedItem();
            if (newSel.equals(this.curTier)) {
                return;
            }
            this.curTier = newSel;
            this.setStatTable();
            this.repaint();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.rootTiersOnlyCB) {
            String oldCurTier = this.curTier;
            if (this.rootTiersOnlyCB.isSelected()) {
                this.extractRootTiers();
            } else {
                this.extractAllTiers();
            }
            if (!oldCurTier.equals(this.curTier)) {
                this.tierComboBox.setSelectedItem(oldCurTier);
                this.curTier = (String)this.tierComboBox.getSelectedItem();
                this.setStatTable();
                this.repaint();
            }
        } else if (e.getSource() == this.collapseAdjacentCB) {
            this.collapseValues = this.collapseAdjacentCB.isSelected();
            this.setStatTable();
            this.repaint();
        } else if (e.getSource() == this.mediaDurObservationCB) {
            this.useMediaDuration = this.mediaDurObservationCB.isSelected();
            this.setStatTable();
            this.repaint();
        }
        this.savePreferences();
    }

    private void readPreferences() {
        Boolean flag = (Boolean)Preferences.get("Statistics.Annotation.RootTiersOnly", null);
        if (flag != null) {
            this.rootsOnly = flag;
        }
        if ((flag = (Boolean)Preferences.get("Statistics.Annotation.CollapseContiguous", null)) != null) {
            this.collapseValues = flag;
        }
        if ((flag = (Boolean)Preferences.get("Statistics.Annotation.MediaObservationTime", null)) != null) {
            this.useMediaDuration = flag;
        }
    }

    private void savePreferences() {
        Preferences.set("Statistics.Annotation.RootTiersOnly", new Boolean(this.rootTiersOnlyCB.isSelected()), null, false, false);
        Preferences.set("Statistics.Annotation.CollapseContiguous", new Boolean(this.collapseAdjacentCB.isSelected()), null, false, false);
        Preferences.set("Statistics.Annotation.MediaObservationTime", new Boolean(this.mediaDurObservationCB.isSelected()), null, false, false);
    }
}

