/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.AbstractStatisticsPanel;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.util.TableHeaderToolTipAdapter;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.util.ControlledVocabulary;

public class AnnotationStatisticsPanel2
extends AbstractStatisticsPanel
implements ItemListener,
ActionListener,
ClientLogger {
    private DecimalFormat format = new DecimalFormat("#0.######", new DecimalFormatSymbols(Locale.US));
    private DecimalFormat format2 = new DecimalFormat("#0.###", new DecimalFormatSymbols(Locale.US));
    private int numCols = 8;
    String[] headers;
    private JComboBox tierComboBox;
    private Vector rootTiers;
    private String curTier;
    private JLabel tierLabel;
    private JPanel tierSelectionPanel;
    private JCheckBox rootTiersOnlyCB;
    private boolean rootsOnly = true;

    public AnnotationStatisticsPanel2(Transcription transcription) {
        super(transcription);
        this.initComponents();
    }

    public AnnotationStatisticsPanel2(Transcription transcription, long totalDuration) {
        super(transcription, totalDuration);
        ++this.numCols;
        this.initComponents();
    }

    public JTable getStatisticsTable() {
        return this.statTable;
    }

    void initComponents() {
        this.createHeaders();
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.tierComboBox = new JComboBox();
        this.rootTiers = new Vector();
        if (this.rootsOnly) {
            this.extractRootTiers();
        } else {
            this.extractAllTiers();
        }
        this.tierLabel = new JLabel();
        this.rootTiersOnlyCB = new JCheckBox();
        this.rootTiersOnlyCB.setSelected(this.rootsOnly);
        this.tierSelectionPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 12);
        this.tierSelectionPanel.add((Component)this.tierLabel, gridBagConstraints);
        this.tierComboBox.addItemListener(this);
        this.tierComboBox.setMaximumRowCount(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.tierSelectionPanel.add((Component)this.tierComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 26, 0, 12);
        this.tierSelectionPanel.add((Component)this.rootTiersOnlyCB, gridBagConstraints);
        this.statPanel = new JPanel();
        this.statTable = new JTable();
        this.statTable.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        this.statTable.setEnabled(false);
        this.initTable();
        this.statPane = new JScrollPane(this.statTable);
        Dimension size = new Dimension(500, 100);
        this.statPane.setPreferredSize(size);
        this.updateLocale();
        this.statPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.statPanel.add((Component)this.statPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.tierSelectionPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.statPanel, gridBagConstraints);
        this.rootTiersOnlyCB.addActionListener(this);
    }

    public void updateLocale() {
        this.tierSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("Statistics.Panel.Tier")));
        this.tierLabel.setText(ElanLocale.getString("Statistics.Label.Tier"));
        this.rootTiersOnlyCB.setText(ElanLocale.getString("Statistics.Label.RootTiers"));
        this.statPanel.setBorder(new TitledBorder(ElanLocale.getString("Statistics.Pane.Table")));
    }

    private void createHeaders() {
        this.headers = new String[this.numCols];
        this.headers[0] = ElanLocale.getString("Frame.GridFrame.ColumnAnnotation");
        this.headers[1] = ElanLocale.getString("Statistics.Occurrences");
        this.headers[2] = ElanLocale.getString("Statistics.MinimalDuration");
        this.headers[3] = ElanLocale.getString("Statistics.MaximalDuration");
        this.headers[4] = ElanLocale.getString("Statistics.AverageDuration");
        this.headers[5] = ElanLocale.getString("Statistics.MedianDuration");
        this.headers[6] = ElanLocale.getString("Statistics.TotalDuration");
        this.headers[7] = ElanLocale.getString("Statistics.Latency");
        if (this.numCols == 9) {
            this.headers[7] = ElanLocale.getString("Statistics.TotalDurationPercentage");
            this.headers[8] = ElanLocale.getString("Statistics.Latency");
        }
    }

    private void initTable() {
        if (this.transcription != null) {
            Object[][] data = null;
            if (this.curTier == null) {
                data = new String[0][this.numCols];
            } else {
                TierImpl tier = (TierImpl)this.transcription.getTierWithId(this.curTier);
                if (tier != null) {
                    TreeSet annos = this.getAnnotationValues(tier);
                    int numRows = 0;
                    if (annos != null && annos.size() > 0) {
                        numRows = annos.size();
                        data = new String[numRows][this.numCols];
                        int i = 0;
                        for (String value : annos) {
                            data[i] = this.getRowForValue(tier, value);
                            ++i;
                        }
                    } else {
                        data = new String[numRows][this.numCols];
                    }
                } else {
                    data = new String[0][this.numCols];
                }
            }
            DefaultTableModel model = new DefaultTableModel(data, this.headers);
            this.statTable.setModel(model);
            this.statTable.getTableHeader().addMouseMotionListener(new TableHeaderToolTipAdapter(this.statTable.getTableHeader()));
        }
    }

    private TreeSet getAnnotationValues(TierImpl tier) {
        Vector annotations;
        String CVname;
        ControlledVocabulary CV;
        TreeSet<String> annValues = null;
        if (tier == null || tier.getLinguisticType() == null) {
            return annValues;
        }
        if (tier.getLinguisticType().isUsingControlledVocabulary() && (CV = this.transcription.getControlledVocabulary(CVname = tier.getLinguisticType().getControlledVocabylaryName())) != null && CV.getEntryValues().length > 0) {
            String[] cvEntriesVal = CV.getEntryValues();
            annValues = new TreeSet();
            for (int i = 0; i < cvEntriesVal.length; ++i) {
                if (cvEntriesVal[i] == null || cvEntriesVal[i].length() <= 0) continue;
                annValues.add(cvEntriesVal[i]);
            }
        }
        if ((annotations = tier.getAnnotations()) != null && annotations.size() > 0) {
            if (annValues == null) {
                annValues = new TreeSet<String>();
            }
            for (AbstractAnnotation ann : annotations) {
                if (ann.getValue() == null || ann.getValue().length() <= 0) continue;
                annValues.add(ann.getValue());
            }
        }
        return annValues;
    }

    private String[] getRowForValue(TierImpl tier, String annValue) {
        int i;
        String[] row = new String[this.numCols];
        row[0] = annValue;
        Vector annotations = tier.getAnnotations();
        int numAnn = annotations.size();
        if (numAnn == 0) {
            for (int i2 = 1; i2 < this.numCols; ++i2) {
                row[i2] = "-";
            }
            return row;
        }
        int numOcc = 0;
        AbstractAnnotation ann = null;
        long minDur = Long.MAX_VALUE;
        long maxDur = 0L;
        long totalDur = 0L;
        long medianDur = 0L;
        ArrayList<Long> durList = new ArrayList<Long>(numAnn);
        long firstOcc = Long.MAX_VALUE;
        for (i = 0; i < numAnn; ++i) {
            ann = (AbstractAnnotation)annotations.get(i);
            if (!annValue.equals(ann.getValue())) continue;
            ++numOcc;
            long b = ann.getBeginTimeBoundary();
            long e = ann.getEndTimeBoundary();
            long d = e - b;
            durList.add(new Long(d));
            if (b < firstOcc) {
                firstOcc = b;
            }
            if (d < minDur) {
                minDur = d;
            }
            if (d > maxDur) {
                maxDur = d;
            }
            totalDur += d;
        }
        if (numOcc == 0) {
            for (i = 1; i < this.numCols; ++i) {
                row[i] = "0";
            }
            return row;
        }
        Collections.sort(durList);
        int numDurs = durList.size();
        if (numDurs == 1) {
            medianDur = (Long)durList.get(0);
        } else if (numDurs % 2 != 0) {
            medianDur = (Long)durList.get(numDurs / 2);
        } else {
            long h = (Long)durList.get(numDurs / 2);
            long l = (Long)durList.get(numDurs / 2 - 1);
            medianDur = (h + l) / 2L;
        }
        row[1] = String.valueOf(numOcc);
        row[2] = this.format2.format((float)minDur / 1000.0f);
        row[3] = this.format2.format((float)maxDur / 1000.0f);
        row[4] = this.format.format((float)totalDur / (float)numOcc / 1000.0f);
        row[5] = this.format2.format((float)medianDur / 1000.0f);
        row[6] = this.format2.format((float)totalDur / 1000.0f);
        row[7] = this.format2.format((float)firstOcc / 1000.0f);
        if (this.numCols == 9) {
            row[7] = this.totalDuration != 0L ? this.format2.format((float)totalDur / (float)this.totalDuration * 100.0f) : "-";
            row[8] = this.format2.format((float)firstOcc / 1000.0f);
        }
        return row;
    }

    private void extractRootTiers() {
        this.tierComboBox.removeItemListener(this);
        this.tierComboBox.removeAllItems();
        if (this.transcription != null) {
            Vector tiers = this.transcription.getTiers();
            Iterator tierIt = tiers.iterator();
            TierImpl tier = null;
            while (tierIt.hasNext()) {
                tier = (TierImpl)tierIt.next();
                if (tier.getLinguisticType().getConstraints() != null) continue;
                this.tierComboBox.addItem(tier.getName());
                this.rootTiers.add(tier);
            }
            if (this.curTier != null) {
                this.tierComboBox.setSelectedItem(this.curTier);
            }
            if (this.tierComboBox.getModel().getSize() == 0) {
                this.tierComboBox.addItem("-");
            }
        } else {
            this.tierComboBox.addItem("-");
        }
        this.curTier = (String)this.tierComboBox.getSelectedItem();
        this.tierComboBox.addItemListener(this);
    }

    private void extractAllTiers() {
        this.tierComboBox.removeItemListener(this);
        this.tierComboBox.removeAllItems();
        if (this.transcription != null) {
            Vector tiers = this.transcription.getTiers();
            Iterator tierIt = tiers.iterator();
            TierImpl tier = null;
            while (tierIt.hasNext()) {
                tier = (TierImpl)tierIt.next();
                this.tierComboBox.addItem(tier.getName());
                this.rootTiers.add(tier);
            }
            if (this.curTier != null) {
                this.tierComboBox.setSelectedItem(this.curTier);
            }
            if (this.tierComboBox.getModel().getSize() == 0) {
                this.tierComboBox.addItem("-");
            }
        } else {
            this.tierComboBox.addItem("-");
        }
        this.curTier = (String)this.tierComboBox.getSelectedItem();
        this.tierComboBox.addItemListener(this);
    }

    public void itemStateChanged(ItemEvent ie) {
        if (ie.getStateChange() == 1) {
            String newSel = (String)this.tierComboBox.getSelectedItem();
            if (newSel.equals(this.curTier)) {
                return;
            }
            this.curTier = newSel;
            this.initTable();
            this.repaint();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.rootTiersOnlyCB) {
            String oldCurTier = this.curTier;
            if (this.rootTiersOnlyCB.isSelected()) {
                this.extractRootTiers();
            } else {
                this.extractAllTiers();
            }
            if (!oldCurTier.equals(this.curTier)) {
                this.tierComboBox.setSelectedItem(oldCurTier);
                this.curTier = (String)this.tierComboBox.getSelectedItem();
                this.initTable();
                this.repaint();
            }
        }
    }
}

