/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.AdvancedTierOptionsDialog;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.tier.TierTableModel;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.im.ImUtil;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class EditTierDialog2
extends ClosableDialog
implements ActionListener,
ItemListener,
ChangeListener,
ListSelectionListener {
    public static final int ADD = 0;
    public static final int CHANGE = 1;
    public static final int DELETE = 2;
    public static final int IMPORT = 3;
    private final String none = "none";
    private TranscriptionImpl transcription;
    private TierImpl tier = null;
    private TierImpl oldParentTier;
    private String oldTierName;
    private String oldParentTierName;
    private String oldParticipant;
    private String oldAnnotator;
    private LinguisticType oldLingType;
    private Locale oldLocale;
    private Locale[] langs;
    private int mode = 0;
    private boolean singleEditMode = false;
    private Vector tiers;
    private JLabel titleLabel;
    private JPanel tablePanel;
    private JTable tierTable;
    private TierTableModel model;
    private JTabbedPane tabPane;
    private JPanel editPanel;
    private JLabel selectTierLabel;
    private JLabel tierNameLabel;
    private JComboBox currentTiersComboBox;
    private JTextField tierNameTextField;
    private JLabel participantLabel;
    private JTextField participantTextField;
    private JLabel annotatorLabel;
    private JTextField annotatorTextField;
    private JLabel lingTypeLabel;
    private JComboBox lingTypeComboBox;
    private JLabel parentLabel;
    private JComboBox parentComboBox;
    private JLabel languageLabel;
    private JComboBox languageComboBox;
    private JButton advancedButton;
    private HashMap currentProps = new HashMap(5);
    private JPanel importPanel;
    private JLabel importSourceLabel;
    private JTextField importSourceTF;
    private JButton importSourceButton;
    private JButton changeButton;
    private JButton cancelButton;
    private JPanel buttonPanel;

    public EditTierDialog2(Frame parentFrame, boolean modal, Transcription theTranscription, int editMode, TierImpl tier) {
        super(parentFrame, modal);
        this.transcription = (TranscriptionImpl)theTranscription;
        if (editMode >= 0 && editMode <= 3) {
            this.mode = editMode;
        }
        this.initComponents();
        this.extractCurrentTiers();
        if (tier != null) {
            this.tier = tier;
            String name = tier.getName();
            this.singleEditMode = true;
            if (this.currentTiersComboBox != null) {
                this.currentTiersComboBox.setSelectedItem(name);
            }
        }
        this.updateLanguageComboBox();
        this.updateLocale();
        this.updateForMode();
        this.updateUIForTier((String)this.currentTiersComboBox.getSelectedItem());
        this.postInit();
        if (editMode == 0) {
            this.tierNameTextField.requestFocus();
        } else if (editMode == 3) {
            this.editPanel.setVisible(false);
            this.importSourceButton.requestFocus();
        } else {
            this.currentTiersComboBox.requestFocus();
        }
    }

    private void initComponents() {
        this.langs = ImUtil.getLanguages(this);
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new GridBagLayout());
        this.model = new TierTableModel(this.transcription.getTiers());
        this.tierTable = new JTable(this.model);
        this.tierTable.setSelectionMode(0);
        JScrollPane tableScrollPane = new JScrollPane(this.tierTable);
        Dimension size = new Dimension(300, 120);
        tableScrollPane.setMinimumSize(size);
        tableScrollPane.setPreferredSize(size);
        this.tabPane = new JTabbedPane();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.titleLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.tablePanel.add((Component)tableScrollPane, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.tablePanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(10, 6, 6, 6);
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.tabPane, gbc);
        this.editPanel = new JPanel(new GridBagLayout());
        this.selectTierLabel = new JLabel();
        this.currentTiersComboBox = new JComboBox();
        this.currentTiersComboBox.setMaximumRowCount(20);
        this.tierNameLabel = new JLabel();
        this.tierNameTextField = new JTextField();
        this.participantLabel = new JLabel();
        this.participantTextField = new JTextField();
        this.annotatorLabel = new JLabel();
        this.annotatorTextField = new JTextField();
        this.lingTypeLabel = new JLabel();
        this.lingTypeComboBox = new JComboBox();
        this.parentLabel = new JLabel();
        this.parentComboBox = new JComboBox();
        this.languageLabel = new JLabel();
        this.languageComboBox = new JComboBox();
        this.advancedButton = new JButton();
        GridBagConstraints lgbc = new GridBagConstraints();
        lgbc.anchor = 18;
        lgbc.insets = insets;
        this.editPanel.add((Component)this.selectTierLabel, lgbc);
        GridBagConstraints rgbc = new GridBagConstraints();
        rgbc.gridx = 1;
        rgbc.fill = 2;
        rgbc.anchor = 18;
        rgbc.insets = insets;
        rgbc.weightx = 1.0;
        this.editPanel.add((Component)this.currentTiersComboBox, rgbc);
        lgbc.gridy = 1;
        this.editPanel.add((Component)this.tierNameLabel, lgbc);
        rgbc.gridy = 1;
        this.editPanel.add((Component)this.tierNameTextField, rgbc);
        lgbc.gridy = 2;
        this.editPanel.add((Component)this.participantLabel, lgbc);
        rgbc.gridy = 2;
        this.editPanel.add((Component)this.participantTextField, rgbc);
        lgbc.gridy = 3;
        this.editPanel.add((Component)this.annotatorLabel, lgbc);
        rgbc.gridy = 3;
        this.editPanel.add((Component)this.annotatorTextField, rgbc);
        lgbc.gridy = 4;
        this.editPanel.add((Component)this.parentLabel, lgbc);
        rgbc.gridy = 4;
        this.editPanel.add((Component)this.parentComboBox, rgbc);
        lgbc.gridy = 5;
        this.editPanel.add((Component)this.lingTypeLabel, lgbc);
        rgbc.gridy = 5;
        this.editPanel.add((Component)this.lingTypeComboBox, rgbc);
        lgbc.gridy = 6;
        this.editPanel.add((Component)this.languageLabel, lgbc);
        rgbc.gridy = 6;
        this.editPanel.add((Component)this.languageComboBox, rgbc);
        lgbc.gridy = 7;
        this.editPanel.add((Component)this.advancedButton, lgbc);
        this.importPanel = new JPanel(new GridBagLayout());
        this.importSourceLabel = new JLabel();
        this.importSourceTF = new JTextField();
        this.importSourceTF.setEditable(false);
        this.importSourceButton = new JButton();
        this.importSourceButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        this.importPanel.add((Component)this.importSourceLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        this.importPanel.add((Component)this.importSourceTF, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.insets = insets;
        this.importPanel.add((Component)this.importSourceButton, gbc);
        this.tabPane.addTab(ElanLocale.getString("Button.Add"), null);
        this.tabPane.addTab(ElanLocale.getString("Button.Change"), null);
        this.tabPane.addTab(ElanLocale.getString("Button.Delete"), null);
        this.tabPane.addTab(ElanLocale.getString("Button.Import"), this.importPanel);
        if (this.mode < 3) {
            this.tabPane.setComponentAt(this.mode, this.editPanel);
        } else {
            this.tabPane.setComponentAt(0, this.editPanel);
        }
        this.tabPane.setSelectedIndex(this.mode);
        this.tabPane.addChangeListener(this);
        this.advancedButton.addActionListener(this);
        this.buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.changeButton = new JButton();
        this.changeButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.changeButton);
        this.buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.gridy = 3;
        gbc.anchor = 15;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
    }

    private void postInit() {
        this.pack();
        int w = 550;
        int h = 400;
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
    }

    private void updateLocale() {
        this.tablePanel.setBorder(new TitledBorder(ElanLocale.getString("EditTierDialog.Label.CurrentTiers")));
        this.tierNameLabel.setText(ElanLocale.getString("EditTierDialog.Label.TierName"));
        this.participantLabel.setText(ElanLocale.getString("EditTierDialog.Label.Participant"));
        this.annotatorLabel.setText(ElanLocale.getString("EditTierDialog.Label.Annotator"));
        this.lingTypeLabel.setText(ElanLocale.getString("EditTierDialog.Label.LinguisticType"));
        this.parentLabel.setText(ElanLocale.getString("EditTierDialog.Label.Parent"));
        this.languageLabel.setText(ElanLocale.getString("EditTierDialog.Label.Language"));
        this.cancelButton.setText(ElanLocale.getString("Button.Close"));
        this.importSourceLabel.setText("<html>" + ElanLocale.getString("EditTierDialog.Label.ImportSource") + "</html>");
        this.importSourceButton.setText(ElanLocale.getString("Button.Browse"));
        this.advancedButton.setText(ElanLocale.getString("EditTierDialog.Label.Advanced"));
    }

    private void updateForMode() {
        switch (this.mode) {
            case 0: {
                this.setTitle(ElanLocale.getString("EditTierDialog.Title.Add"));
                this.selectTierLabel.setText("");
                this.currentTiersComboBox.setEnabled(false);
                this.changeButton.setText(ElanLocale.getString("Button.Add"));
                this.parentComboBox.setEnabled(true);
                this.tierNameTextField.setEditable(true);
                this.participantTextField.setEditable(true);
                this.annotatorTextField.setEditable(true);
                this.lingTypeComboBox.setEnabled(true);
                this.languageComboBox.setEnabled(true);
                this.tierNameTextField.setText("");
                this.participantTextField.setText("");
                this.annotatorTextField.setText("");
                this.advancedButton.setEnabled(true);
                break;
            }
            case 1: {
                this.setTitle(ElanLocale.getString("EditTierDialog.Title.Change"));
                this.selectTierLabel.setText(ElanLocale.getString("EditTierDialog.Label.ChangeTier"));
                this.selectTierLabel.setVisible(true);
                this.currentTiersComboBox.setEnabled(true);
                this.currentTiersComboBox.setVisible(true);
                this.currentTiersComboBox.requestFocus();
                this.changeButton.setText(ElanLocale.getString("Button.Change"));
                this.parentComboBox.setEnabled(false);
                this.tierNameTextField.setEditable(true);
                this.participantTextField.setEditable(true);
                this.annotatorTextField.setEditable(true);
                this.lingTypeComboBox.setEnabled(true);
                this.languageComboBox.setEnabled(true);
                this.advancedButton.setEnabled(true);
                break;
            }
            case 2: {
                this.setTitle(ElanLocale.getString("EditTierDialog.Title.Delete"));
                this.selectTierLabel.setText(ElanLocale.getString("EditTierDialog.Label.DeleteTier"));
                this.changeButton.setText(ElanLocale.getString("Button.Delete"));
                this.tierNameTextField.setEditable(false);
                this.participantTextField.setEditable(false);
                this.annotatorTextField.setEditable(false);
                this.parentComboBox.setEnabled(false);
                this.lingTypeComboBox.setEnabled(false);
                this.languageComboBox.setEnabled(false);
                this.selectTierLabel.setVisible(true);
                this.currentTiersComboBox.setEnabled(true);
                this.currentTiersComboBox.setVisible(true);
                this.currentTiersComboBox.requestFocus();
                this.advancedButton.setEnabled(false);
                break;
            }
            case 3: {
                this.setTitle(ElanLocale.getString("EditTierDialog.Title.Import"));
                this.changeButton.setText(ElanLocale.getString("Button.Import"));
                this.changeButton.requestFocus();
            }
        }
        this.titleLabel.setText(this.getTitle());
    }

    private void extractCurrentTiers() {
        this.currentTiersComboBox.removeItemListener(this);
        this.currentTiersComboBox.removeAllItems();
        this.tiers = this.transcription.getTiers();
        if (this.tiers == null) {
            this.tiers = new Vector();
            return;
        }
        for (TierImpl t : this.tiers) {
            this.currentTiersComboBox.addItem(t.getName());
        }
        if (this.currentTiersComboBox.getItemCount() > 0) {
            this.currentTiersComboBox.setSelectedIndex(0);
            this.tier = (TierImpl)this.tiers.get(0);
        }
        this.currentTiersComboBox.addItemListener(this);
    }

    private void reextractTiers() {
        this.extractCurrentTiers();
        if (this.currentTiersComboBox.getItemCount() > 0) {
            this.currentTiersComboBox.setSelectedIndex(0);
        } else {
            this.tierNameTextField.setText("");
            this.participantTextField.setText("");
            this.annotatorTextField.setText("");
        }
        if (this.mode == 0) {
            this.tierNameTextField.setText("");
            this.participantTextField.setText("");
            this.annotatorTextField.setText("");
        }
        if (this.model != null) {
            this.tierTable.getSelectionModel().removeListSelectionListener(this);
            this.model.removeAllRows();
            for (TierImpl t : this.tiers) {
                this.model.addRow(t);
            }
            this.tierTable.getSelectionModel().addListSelectionListener(this);
        }
    }

    private void fillLingTypeMenu() {
        LinguisticType type;
        TierImpl t2;
        this.lingTypeComboBox.removeItemListener(this);
        this.lingTypeComboBox.removeAllItems();
        int curStereoType = -1;
        boolean onlySameStereo = false;
        boolean onlyTimeAlignable = false;
        boolean excludeTimeAlignable = false;
        if (this.mode == 1) {
            if (this.tier.getNumberOfAnnotations() > 0) {
                onlySameStereo = true;
            }
            if (this.tier.getLinguisticType().getConstraints() != null) {
                curStereoType = this.tier.getLinguisticType().getConstraints().getStereoType();
            }
            if (!onlySameStereo && curStereoType >= 0 && this.tier.getDependentTiers().size() > 0) {
                for (int i = 0; i < this.tier.getDependentTiers().size(); ++i) {
                    TierImpl ch = (TierImpl)this.tier.getDependentTiers().get(i);
                    if (!ch.isTimeAlignable()) continue;
                    onlyTimeAlignable = true;
                    break;
                }
            }
        }
        TierImpl parentTier = (TierImpl)this.transcription.getTierWithId((String)this.parentComboBox.getSelectedItem());
        Constraint parentConstraint = null;
        if (parentTier != null && (parentConstraint = parentTier.getLinguisticType().getConstraints()) != null && (parentConstraint.getStereoType() == 3 || parentConstraint.getStereoType() == 4)) {
            excludeTimeAlignable = true;
        }
        Enumeration e = this.transcription.getLinguisticTypes().elements();
        while (e.hasMoreElements()) {
            LinguisticType lt = (LinguisticType)e.nextElement();
            String ltName = lt.getLinguisticTypeName();
            if (parentTier == null && lt.getConstraints() != null || excludeTimeAlignable && lt.getConstraints() != null && (lt.getConstraints().getStereoType() == 0 || lt.getConstraints().getStereoType() == 1) || parentTier != null && lt.getConstraints() == null || onlySameStereo && lt.getConstraints() != null && lt.getConstraints().getStereoType() != curStereoType || onlyTimeAlignable && lt.getConstraints() != null && lt.getConstraints().getStereoType() != 0 && lt.getConstraints().getStereoType() != 1) continue;
            this.lingTypeComboBox.addItem(ltName);
        }
        String tierName = (String)this.currentTiersComboBox.getSelectedItem();
        if (tierName != null && (t2 = (TierImpl)this.transcription.getTierWithId(tierName)) != null && (type = t2.getLinguisticType()) != null) {
            this.lingTypeComboBox.setSelectedItem(type.getLinguisticTypeName());
        }
        this.lingTypeComboBox.addItemListener(this);
        if (this.lingTypeComboBox.getModel().getSize() <= 0) {
            this.changeButton.setEnabled(false);
        } else {
            this.changeButton.setEnabled(true);
        }
    }

    private void fillParentComboBox() {
        this.parentComboBox.removeItemListener(this);
        this.parentComboBox.removeAllItems();
        this.parentComboBox.addItem("none");
        if (this.tier != null && this.mode != 0) {
            Vector candidateParents = this.transcription.getCandidateParentTiers(this.tier);
            Iterator pIter = candidateParents.iterator();
            while (pIter.hasNext()) {
                this.parentComboBox.addItem(((Tier)pIter.next()).getName());
            }
            if (this.tier.hasParentTier()) {
                this.parentComboBox.setSelectedItem(this.tier.getParentTier().getName());
            }
        } else if (this.mode == 0) {
            for (TierImpl t : this.tiers) {
                this.parentComboBox.addItem(t.getName());
            }
            this.parentComboBox.setSelectedItem("none");
        }
        this.parentComboBox.addItemListener(this);
    }

    private void updateLanguageComboBox() {
        this.languageComboBox.removeAllItems();
        if (this.langs != null) {
            for (int i = 0; i < this.langs.length; ++i) {
                if (i == 0 && this.langs[i] == Locale.getDefault()) {
                    this.languageComboBox.addItem(this.langs[i].getDisplayName() + " (System default)");
                    continue;
                }
                this.languageComboBox.addItem(this.langs[i].getDisplayName());
            }
        }
        String none = ElanLocale.getString("EditTierDialog.Label.None");
        this.languageComboBox.insertItemAt(none, 0);
        if (this.tier != null) {
            Locale l = this.tier.getDefaultLocale();
            if (l != null) {
                if (l == Locale.getDefault() && ((String)this.languageComboBox.getItemAt(1)).startsWith(l.getDisplayName())) {
                    this.languageComboBox.setSelectedIndex(1);
                } else {
                    this.languageComboBox.setSelectedItem(l.getDisplayName());
                }
            } else {
                this.languageComboBox.setSelectedIndex(0);
            }
        }
    }

    private void updateUIForTier(String name) {
        if (name != null) {
            this.tier = (TierImpl)this.transcription.getTierWithId(name);
            if (this.tier != null) {
                if (this.currentTiersComboBox.getSelectedItem() != this.tier.getName()) {
                    this.currentTiersComboBox.setSelectedItem(name);
                }
                this.oldParentTier = (TierImpl)this.tier.getParentTier();
                this.oldParentTierName = this.oldParentTier != null ? this.tier.getParentTier().getName() : "none";
                this.oldLingType = this.tier.getLinguisticType();
                this.oldLocale = this.tier.getDefaultLocale();
                this.oldTierName = this.tier.getName();
                this.oldParticipant = this.tier.getParticipant();
                this.oldAnnotator = this.tier.getAnnotator();
                if (this.mode != 0) {
                    this.tierNameTextField.setText(this.oldTierName);
                    this.participantTextField.setText(this.oldParticipant);
                    this.annotatorTextField.setText(this.oldAnnotator);
                    if (this.mode == 1 && this.tier.getNumberOfAnnotations() == 0) {
                        this.parentComboBox.setEnabled(true);
                    }
                }
            }
            this.fillParentComboBox();
            this.fillLingTypeMenu();
            this.updateLanguageComboBox();
            if (this.model != null) {
                this.tierTable.getSelectionModel().removeListSelectionListener(this);
                int col = this.model.findColumn("TierName");
                for (int i = 0; i < this.model.getRowCount(); ++i) {
                    if (!name.equals(this.model.getValueAt(i, col))) continue;
                    this.tierTable.getSelectionModel().setLeadSelectionIndex(i);
                    break;
                }
                this.tierTable.getSelectionModel().addListSelectionListener(this);
            }
        } else {
            this.fillParentComboBox();
            this.fillLingTypeMenu();
        }
    }

    private void doAdd(String tierName, Tier parentTier, String lingType, String participant, String annotator, Locale locale) {
        Object colors;
        Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.AddNewTier");
        TranscriptionImpl receiver = this.transcription;
        Object[] args = new Object[]{tierName, parentTier, lingType, participant, annotator, locale};
        c.execute(receiver, args);
        this.reextractTiers();
        this.updateUIForTier(null);
        TierImpl tt = (TierImpl)this.transcription.getTierWithId(tierName);
        if (tt != null && tt.getLinguisticType().hasGraphicReferences()) {
            this.checkGraphics(tt);
        }
        if (this.currentProps.get("TierColor") != null && !this.currentProps.get("TierColor").equals(Color.WHITE)) {
            colors = Preferences.get("TierColors", this.transcription);
            if (colors == null) {
                colors = new HashMap();
                Preferences.set("TierColors", colors, (Transcription)this.transcription);
            }
            ((Map)colors).put(tierName, this.currentProps.get("TierColor"));
            Preferences.set("TierColors", colors, this.transcription, true);
        }
        if (this.currentProps.get("TierFont") != null) {
            HashMap fonts = Preferences.get("TierFonts", this.transcription);
            if (fonts == null) {
                fonts = new HashMap();
                Preferences.set("TierFonts", fonts, (Transcription)this.transcription);
            }
            ((Map)fonts).put(tierName, this.currentProps.get("TierFont"));
            Preferences.set("TierFonts", fonts, this.transcription, true);
        }
        if (this.currentProps.get("TierHighlightColor") != null && !this.currentProps.get("TierHighlightColor").equals(Color.WHITE)) {
            colors = Preferences.get("TierHighlightColors", this.transcription);
            if (colors == null) {
                colors = new HashMap();
                Preferences.set("TierHighlightColors", colors, (Transcription)this.transcription);
            }
            ((Map)colors).put(tierName, this.currentProps.get("TierHighlightColor"));
            Preferences.set("TierHighlightColors", colors, this.transcription, true);
        }
    }

    private void doChange(String tierName, Tier parentTier, String lingType, String participant, String annotator, Locale locale) {
        if (this.tier.getNumberOfAnnotations() > 0) {
            if (parentTier != null && this.oldParentTier == null || parentTier == null && this.oldParentTier != null || parentTier != this.oldParentTier) {
                parentTier = this.oldParentTier;
            }
            if (this.getStereoTypeForTypeName(lingType) != this.getStereoTypeForType(this.oldLingType)) {
                lingType = this.oldLingType.getLinguisticTypeName();
            }
        }
        if (!tierName.equals(this.oldTierName) || parentTier != null && this.oldParentTier != null && parentTier != this.oldParentTier || !lingType.equals(this.oldLingType.getLinguisticTypeName()) || !participant.equals(this.oldParticipant) || !annotator.equals(this.oldAnnotator) || locale == null && this.oldLocale != null || locale != null && locale != this.oldLocale) {
            Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.ChangeTier");
            TierImpl receiver = this.tier;
            Object[] args = new Object[]{tierName, parentTier, lingType, participant, annotator, locale};
            c.execute(receiver, args);
            if (this.tier.getLinguisticType().hasGraphicReferences() && !lingType.equals(this.oldLingType.getLinguisticTypeName())) {
                this.checkGraphics(this.tier);
            }
            if (this.singleEditMode) {
                this.dispose();
            } else {
                this.reextractTiers();
            }
        }
    }

    private void doDelete() {
        if (this.tier != null) {
            int option;
            Vector depTiers = this.tier.getDependentTiers();
            StringBuffer mesBuf = new StringBuffer();
            mesBuf.append(ElanLocale.getString("EditTierDialog.Message.ConfirmDelete"));
            mesBuf.append("  ");
            mesBuf.append(this.oldTierName);
            mesBuf.append(" ?\n");
            if (depTiers != null && depTiers.size() > 0) {
                mesBuf.append(ElanLocale.getString("EditTierDialog.Message.AlsoDeleted"));
                for (Tier t : depTiers) {
                    mesBuf.append("\n-   ");
                    mesBuf.append(t.getName());
                }
            }
            if ((option = JOptionPane.showConfirmDialog(this, mesBuf.toString(), ElanLocale.getString("Message.Warning"), 0)) == 0) {
                Object[] args = new Object[]{this.tier};
                Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.DeleteTier");
                c.execute(this.transcription, args);
                if (this.singleEditMode) {
                    this.dispose();
                } else {
                    this.reextractTiers();
                }
            }
        }
    }

    private void doImport() {
        String fileName = this.importSourceTF.getText();
        if (!this.isValidFile(fileName)) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("EditTierDialog.Message.SelectValid"), ElanLocale.getString("Message.Error"), 0);
            return;
        }
        Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.ImportTiers");
        c.execute(this.transcription, new Object[]{fileName});
        this.reextractTiers();
        this.updateUIForTier(null);
    }

    private void promptForImportFile() {
        String eafDir = (String)Preferences.get("LastUsedEAFDir", null);
        if (eafDir == null) {
            eafDir = System.getProperty("user.dir");
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setApproveButtonText("Select");
        chooser.setCurrentDirectory(new File(eafDir));
        chooser.setDialogTitle(ElanLocale.getString("EditTierDialog.Title.Select"));
        File eafFile = null;
        FileFilter filter = ElanFileFilter.createFileFilter(3);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(filter);
        chooser.addChoosableFileFilter(ElanFileFilter.createFileFilter(4));
        if (chooser.showOpenDialog(this) == 0) {
            String name;
            File curDir = chooser.getCurrentDirectory();
            if (curDir != null) {
                Preferences.set("LastUsedEAFDir", curDir.getAbsolutePath(), null);
            }
            if ((eafFile = chooser.getSelectedFile()) != null && this.isValidFile(name = eafFile.getAbsolutePath())) {
                this.importSourceTF.setText(name);
            }
        }
    }

    private void showAdvancedOptionsDialog() {
        String pName;
        HashMap fonts;
        HashMap highlightColors;
        this.currentProps.clear();
        HashMap colors = Preferences.get("TierColors", this.transcription);
        if (colors == null) {
            colors = new HashMap();
            Preferences.set("TierColors", colors, (Transcription)this.transcription);
        }
        if ((highlightColors = Preferences.get("TierHighlightColors", this.transcription)) == null) {
            highlightColors = new HashMap();
            Preferences.set("TierHighlightColors", highlightColors, (Transcription)this.transcription);
        }
        if ((fonts = Preferences.get("TierFonts", this.transcription)) == null) {
            fonts = new HashMap();
            Preferences.set("TierFonts", fonts, (Transcription)this.transcription);
        }
        this.currentProps.put("TierColor", Color.WHITE);
        this.currentProps.put("TierHighlightColor", Color.WHITE);
        this.currentProps.put("TierFont", null);
        if (this.mode == 0) {
            String name = this.tierNameTextField.getText();
            if (name == null || name.length() == 0) {
                this.currentProps.put("TierName", "");
            } else {
                this.currentProps.put("TierName", name);
            }
            if (this.parentComboBox.getSelectedItem() != "none") {
                Object col;
                pName = (String)this.parentComboBox.getSelectedItem();
                if (colors instanceof Map && (col = ((Map)colors).get(pName)) instanceof Color) {
                    this.currentProps.put("TierColor", col);
                }
                if (highlightColors instanceof Map && (col = ((Map)highlightColors).get(pName)) instanceof Color) {
                    this.currentProps.put("TierHighlightColor", col);
                }
            }
        } else {
            Object fo;
            Object colP;
            Object col;
            this.currentProps.put("TierName", this.currentTiersComboBox.getSelectedItem());
            if (colors instanceof Map) {
                col = ((Map)colors).get(this.currentTiersComboBox.getSelectedItem());
                if (col instanceof Color) {
                    this.currentProps.put("TierColor", col);
                } else {
                    pName = (String)this.parentComboBox.getSelectedItem();
                    colP = ((Map)colors).get(pName);
                    if (colP instanceof Color) {
                        this.currentProps.put("TierColor", colP);
                    }
                }
            }
            if (highlightColors instanceof Map) {
                col = ((Map)highlightColors).get(this.currentTiersComboBox.getSelectedItem());
                if (col instanceof Color) {
                    this.currentProps.put("TierHighlightColor", col);
                } else {
                    pName = (String)this.parentComboBox.getSelectedItem();
                    colP = ((Map)highlightColors).get(pName);
                    if (colP instanceof Color) {
                        this.currentProps.put("TierHighlightColor", colP);
                    }
                }
            }
            if (fonts instanceof Map && (fo = ((Map)fonts).get(this.currentTiersComboBox.getSelectedItem())) instanceof Font) {
                this.currentProps.put("TierFont", fo);
            }
        }
        AdvancedTierOptionsDialog dialog = new AdvancedTierOptionsDialog((Dialog)this, ElanLocale.getString("EditTierDialog.Title.Change"), true, this.currentProps);
        dialog.setVisible(true);
        if (this.mode == 1) {
            if (dialog.getTierProperties() != null) {
                this.currentProps.putAll(dialog.getTierProperties());
                Color nextColor = (Color)this.currentProps.get("TierColor");
                if (nextColor != null && !nextColor.equals(Color.WHITE)) {
                    ((Map)colors).put(this.currentTiersComboBox.getSelectedItem(), nextColor);
                } else {
                    ((Map)colors).remove(this.currentTiersComboBox.getSelectedItem());
                }
                Preferences.set("TierColors", colors, this.transcription, true);
                Color nextHighlightColor = (Color)this.currentProps.get("TierHighlightColor");
                if (nextHighlightColor != null && !nextHighlightColor.equals(Color.WHITE)) {
                    ((Map)highlightColors).put(this.currentTiersComboBox.getSelectedItem(), nextHighlightColor);
                } else {
                    ((Map)highlightColors).remove(this.currentTiersComboBox.getSelectedItem());
                }
                Preferences.set("TierHighlightColors", highlightColors, this.transcription, true);
                Font fo = (Font)this.currentProps.get("TierFont");
                if (fo != null) {
                    ((Map)fonts).put(this.currentTiersComboBox.getSelectedItem(), fo);
                } else {
                    ((Map)fonts).remove(this.currentTiersComboBox.getSelectedItem());
                }
                Preferences.set("TierFonts", fonts, this.transcription, true);
            }
        } else if (dialog.getTierProperties() != null) {
            this.currentProps.putAll(dialog.getTierProperties());
        }
    }

    private boolean isValidFile(String fileName) {
        int i;
        if (fileName == null) {
            return false;
        }
        File f = new File(fileName);
        if (!f.exists()) {
            return false;
        }
        String lowerPathName = fileName.toLowerCase();
        String[] exts = FileExtension.EAF_EXT;
        for (i = 0; i < exts.length; ++i) {
            if (!lowerPathName.endsWith("." + exts[i])) continue;
            return true;
        }
        exts = FileExtension.TEMPLATE_EXT;
        for (i = 0; i < exts.length; ++i) {
            if (!lowerPathName.endsWith("." + exts[i])) continue;
            return true;
        }
        return false;
    }

    private void checkGraphics(TierImpl ti) {
        int numGraphicTiers = 1;
        Vector tiers2 = this.transcription.getTiers();
        for (TierImpl t : tiers2) {
            if (t == ti || !t.getLinguisticType().hasGraphicReferences()) continue;
            ++numGraphicTiers;
        }
        if (numGraphicTiers == 1 && (this.transcription.getSVGFile() == null || this.transcription.getSVGFile().length() == 0)) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("EditTierDialog.Message.Graphics"), ElanLocale.getString("Message.Warning"), 2);
        }
    }

    private int getStereoTypeForTypeName(String name) {
        LinguisticType type = null;
        Vector types = this.transcription.getLinguisticTypes();
        LinguisticType tempType = null;
        for (int i = 0; i < types.size(); ++i) {
            tempType = (LinguisticType)types.get(i);
            if (!tempType.getLinguisticTypeName().equals(name)) continue;
            type = tempType;
            break;
        }
        return this.getStereoTypeForType(type);
    }

    private int getStereoTypeForType(LinguisticType type) {
        if (type == null || type.getConstraints() == null) {
            return -1;
        }
        return type.getConstraints().getStereoType();
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.changeButton) {
            if (this.mode == 2) {
                this.doDelete();
                return;
            }
            if (this.mode == 3) {
                this.doImport();
                return;
            }
            String tierName = this.tierNameTextField.getText();
            tierName.replace('\n', ' ');
            tierName.trim();
            if (tierName.length() == 0) {
                this.tierNameTextField.requestFocus();
                JOptionPane.showMessageDialog(this, ElanLocale.getString("EditTierDialog.Message.TierName"), ElanLocale.getString("Message.Error"), 0);
                return;
            }
            if (this.transcription.getTierWithId(tierName) != null && (this.mode == 0 || this.mode == 1 && !tierName.equals(this.oldTierName))) {
                this.tierNameTextField.requestFocus();
                JOptionPane.showMessageDialog(this, ElanLocale.getString("EditTierDialog.Message.Exists"), ElanLocale.getString("Message.Error"), 0);
                return;
            }
            String participant = this.participantTextField.getText();
            String annotator = this.annotatorTextField.getText();
            String lingType = (String)this.lingTypeComboBox.getSelectedItem();
            Tier parentTier = this.transcription.getTierWithId((String)this.parentComboBox.getSelectedItem());
            String localeName = (String)this.languageComboBox.getSelectedItem();
            Locale locale = null;
            if (this.languageComboBox.getSelectedIndex() != 0) {
                if (this.languageComboBox.getSelectedIndex() == 1 && localeName.indexOf("(System default)") > -1) {
                    locale = Locale.getDefault();
                } else if (this.langs != null) {
                    for (int i = 0; i < this.langs.length; ++i) {
                        if (!this.langs[i].getDisplayName().equals(localeName)) continue;
                        locale = this.langs[i];
                        break;
                    }
                }
            }
            switch (this.mode) {
                case 0: {
                    this.doAdd(tierName, parentTier, lingType, participant, annotator, locale);
                    break;
                }
                case 1: {
                    this.doChange(tierName, parentTier, lingType, participant, annotator, locale);
                }
            }
        } else if (event.getSource() == this.importSourceButton) {
            this.promptForImportFile();
        } else if (event.getSource() == this.advancedButton) {
            this.showAdvancedOptionsDialog();
        } else {
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.currentTiersComboBox) {
                String name = (String)this.currentTiersComboBox.getSelectedItem();
                this.updateUIForTier(name);
            } else if (e.getSource() == this.lingTypeComboBox && this.mode == 1) {
                if (this.tier != null && this.tier.getNumberOfAnnotations() > 0) {
                    int oldStereoType;
                    String newTypeName = (String)e.getItem();
                    boolean stereoTypeChanged = false;
                    int newStereoType = this.getStereoTypeForTypeName(newTypeName);
                    if (newStereoType != (oldStereoType = this.getStereoTypeForType(this.oldLingType))) {
                        stereoTypeChanged = true;
                    }
                    if (!this.oldLingType.getLinguisticTypeName().equals(newTypeName) && stereoTypeChanged) {
                        StringBuffer buf = new StringBuffer(ElanLocale.getString("EditTierDialog.Message.RecommendType"));
                        buf.append("\n");
                        buf.append(ElanLocale.getString("EditTierDialog.Message.Corrupt"));
                        JOptionPane.showMessageDialog(this, buf.toString(), ElanLocale.getString("Message.Warning"), 2);
                        this.lingTypeComboBox.setSelectedItem(this.oldLingType.getLinguisticTypeName());
                    }
                }
            } else if (e.getSource() == this.parentComboBox) {
                if (this.mode == 1 && this.tier != null && this.tier.getNumberOfAnnotations() > 0) {
                    if (!this.oldParentTierName.equals((String)e.getItem())) {
                        StringBuffer buf = new StringBuffer(ElanLocale.getString("EditTierDialog.Message.RecommendParent"));
                        buf.append("\n");
                        buf.append(ElanLocale.getString("EditTierDialog.Message.Corrupt"));
                        JOptionPane.showMessageDialog(this, buf.toString(), ElanLocale.getString("Message.Warning"), 2);
                        this.parentComboBox.setSelectedItem(this.oldParentTierName);
                    }
                } else {
                    TierImpl parent;
                    String partiName = this.participantTextField.getText();
                    if ((partiName == null || partiName.trim().length() == 0) && (parent = (TierImpl)this.transcription.getTierWithId((String)e.getItem())) != null) {
                        this.participantTextField.setText(parent.getParticipant());
                    }
                }
                this.fillLingTypeMenu();
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.tabPane.removeChangeListener(this);
        this.mode = this.tabPane.getSelectedIndex();
        this.tabPane.removeAll();
        this.tabPane.addTab(ElanLocale.getString("Button.Add"), null);
        this.tabPane.addTab(ElanLocale.getString("Button.Change"), null);
        this.tabPane.addTab(ElanLocale.getString("Button.Delete"), null);
        this.tabPane.addTab(ElanLocale.getString("Button.Import"), this.importPanel);
        if (this.mode < 3) {
            this.tabPane.setComponentAt(this.tabPane.getSelectedIndex(), this.editPanel);
        } else {
            this.tabPane.setComponentAt(1, this.editPanel);
        }
        this.tabPane.setSelectedIndex(this.mode);
        this.updateForMode();
        this.tabPane.revalidate();
        this.tabPane.addChangeListener(this);
        if (this.mode == 1 || this.mode == 2) {
            if (this.currentTiersComboBox.getItemCount() > 0) {
                String name = (String)this.currentTiersComboBox.getSelectedItem();
                this.updateUIForTier(name);
            }
        } else if (this.mode == 0) {
            this.updateUIForTier(null);
            if (this.parentComboBox.getItemCount() > 0) {
                this.parentComboBox.setSelectedIndex(0);
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.mode == 0) {
            return;
        }
        int row = this.tierTable.getSelectedRow();
        if (row > -1) {
            int column = this.model.findColumn("TierName");
            this.updateUIForTier((String)this.model.getValueAt(row, column));
        }
    }
}

