/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.server.corpora.clomimpl.transcriber.TranscriberDecoderInfo;

public class ImportTranscriberDialog
extends ClosableDialog
implements ActionListener {
    private Object value;
    private JPanel selectPanel;
    private JPanel optionPanel;
    private JPanel buttonPanel;
    private JButton selectButton;
    private JTextField fileField;
    private JRadioButton singleSpeakerTierRB;
    private JRadioButton tierPerSpeakerRB;
    private JButton okButton;
    private JButton cancelButton;

    public ImportTranscriberDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.selectPanel = new JPanel(new GridBagLayout());
        this.selectPanel.setBorder(new TitledBorder(ElanLocale.getString("")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = insets;
        this.selectPanel.add((Component)new JLabel(ElanLocale.getString("ImportDialog.Label.Transcriber")), gbc);
        this.fileField = new JTextField("", 20);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.selectPanel.add((Component)this.fileField, gbc);
        this.selectButton = new JButton("...");
        this.selectButton.addActionListener(this);
        gbc.gridx = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.selectPanel.add((Component)this.selectButton, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.selectPanel, gbc);
        this.optionPanel = new JPanel(new GridBagLayout());
        this.optionPanel.setBorder(new TitledBorder(ElanLocale.getString("ImportDialog.Label.Options ")));
        this.singleSpeakerTierRB = new JRadioButton(ElanLocale.getString("ImportDialog.Label.SingleSpeakerTier"));
        this.tierPerSpeakerRB = new JRadioButton(ElanLocale.getString("ImportDialog.Label.TierPerSpeaker"));
        this.tierPerSpeakerRB.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.tierPerSpeakerRB);
        group.add(this.singleSpeakerTierRB);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.optionPanel.add((Component)this.tierPerSpeakerRB, gbc);
        gbc.gridy = 1;
        this.optionPanel.add((Component)this.singleSpeakerTierRB, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.optionPanel, gbc);
        this.buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.okButton = new JButton(ElanLocale.getString("Button.OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.insets = insets;
        gbc.anchor = 15;
        gbc.fill = 0;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
    }

    public Object showDialog() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        this.dispose();
        return this.value;
    }

    private void createValueAndClose() {
        String strMessage;
        String path = this.fileField.getText();
        boolean nofile = false;
        if (path == null || path.length() == 0) {
            nofile = true;
        } else {
            File f = new File(path);
            if (!f.exists() || f.isDirectory()) {
                nofile = true;
            }
        }
        if (nofile) {
            strMessage = ElanLocale.getString("Menu.Dialog.Message1");
            strMessage = strMessage + path;
            strMessage = strMessage + ElanLocale.getString("Menu.Dialog.Message2");
            String strError = ElanLocale.getString("Message.Error");
            JOptionPane.showMessageDialog(this, strMessage, strError, 0);
            return;
        }
        if (!path.toString().toLowerCase().endsWith(".trs")) {
            strMessage = ElanLocale.getString("Menu.Dialog.Message1");
            strMessage = strMessage + path;
            strMessage = strMessage + ElanLocale.getString("Menu.Dialog.Message3");
            String strError = ElanLocale.getString("Message.Error");
            JOptionPane.showMessageDialog(this, strMessage, strError, 0);
            return;
        }
        path = path.replace('\\', '/');
        TranscriberDecoderInfo tdInfo = new TranscriberDecoderInfo(path);
        tdInfo.setSingleSpeakerTier(this.singleSpeakerTierRB.isSelected());
        this.value = tdInfo;
        this.setVisible(false);
    }

    private void selectFile() {
        File f;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(ElanFileFilter.createFileFilter(12));
        chooser.setDialogTitle(ElanLocale.getString("Button.Select"));
        chooser.setApproveButtonText(ElanLocale.getString("Button.Select"));
        String dirPath = (String)Preferences.get("LastUsedTranscriberDir", null);
        if (dirPath == null) {
            dirPath = System.getProperty("user.dir");
        }
        chooser.setCurrentDirectory(new File(dirPath));
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0 && (f = chooser.getSelectedFile()) != null) {
            Preferences.set("LastUsedTranscriberDir", f.getParent(), null);
            this.fileField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.selectButton) {
            this.selectFile();
        } else if (e.getSource() == this.okButton) {
            this.createValueAndClose();
        } else if (e.getSource() == this.cancelButton) {
            this.value = null;
            this.setVisible(false);
        }
    }
}

