/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;

public class JFontChooser
extends JPanel
implements ListSelectionListener,
ActionListener,
ChangeListener {
    public static int FONT_STYLE = 1;
    public static int FONT_SIZE = 2;
    public static int FONT_STYLE_AND_SIZE = 3;
    private JList familyList;
    private JList fontList;
    private JLabel selFontLabel;
    private JLabel fontSizeLabel;
    private JSpinner fontSizeSpinner;
    private JList fontSizeList;
    private JButton okButton;
    private JButton cancelButton;
    private GraphicsEnvironment ge;
    private String[] families;
    private Font[] allFonts;
    private Font selFont;
    private JDialog dialog;
    private int mode = FONT_STYLE;
    private int fontSize = 12;

    public JFontChooser() {
        this.ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.families = this.ge.getAvailableFontFamilyNames();
        this.allFonts = this.ge.getAllFonts();
        this.initComponents();
    }

    public JFontChooser(int selectionMode) {
        this.ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.families = this.ge.getAvailableFontFamilyNames();
        this.allFonts = this.ge.getAllFonts();
        if (selectionMode >= FONT_STYLE && selectionMode <= FONT_STYLE_AND_SIZE) {
            this.mode = selectionMode;
        }
        this.initComponents();
    }

    protected void initComponents() {
        this.familyList = new JList<String>(this.families);
        this.familyList.setSelectionMode(0);
        this.fontList = new JList(new DefaultListModel());
        this.fontList.setSelectionMode(0);
        this.selFontLabel = new JLabel("-");
        this.fontSizeLabel = new JLabel(ElanLocale.getString("Menu.View.FontSize"));
        SpinnerNumberModel model = new SpinnerNumberModel(12, 4, 60, 2);
        this.fontSizeSpinner = new JSpinner(model);
        this.fontSizeList = new JList<Object>(new Object[]{new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(14), new Integer(16), new Integer(18), new Integer(24), new Integer(28), new Integer(36), new Integer(48), new Integer(60)});
        this.fontSizeList.setSelectedValue(new Integer(this.fontSize), false);
        this.fontSizeList.setSelectionMode(0);
        this.okButton = new JButton(ElanLocale.getString("Button.Apply"));
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.setLayout(new GridBagLayout());
        JScrollPane familySP = new JScrollPane(this.familyList);
        JScrollPane fontSP = new JScrollPane(this.fontList);
        JPanel sizePanel = new JPanel(new GridBagLayout());
        Dimension dim = new Dimension(200, 160);
        familySP.setPreferredSize(dim);
        fontSP.setPreferredSize(dim);
        if (this.mode == FONT_SIZE || this.mode == FONT_STYLE_AND_SIZE) {
            sizePanel.setPreferredSize(dim);
            GridBagConstraints fgbc = new GridBagConstraints();
            fgbc.anchor = 18;
            fgbc.fill = 2;
            fgbc.weightx = 1.0;
            fgbc.insets = new Insets(0, 0, 2, 0);
            sizePanel.add((Component)this.fontSizeLabel, fgbc);
            fgbc.gridy = 1;
            fgbc.insets = new Insets(2, 0, 2, 0);
            sizePanel.add((Component)this.fontSizeSpinner, fgbc);
            fgbc.gridy = 2;
            fgbc.fill = 1;
            fgbc.weighty = 1.0;
            fgbc.insets = new Insets(2, 0, 0, 0);
            sizePanel.add((Component)new JScrollPane(this.fontSizeList), fgbc);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(10, 10, 2, 6);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)familySP, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(10, 6, 2, 10);
        this.add((Component)fontSP, gbc);
        gbc.gridx = 2;
        this.add((Component)sizePanel, gbc);
        gbc.fill = 2;
        gbc.insets = new Insets(2, 10, 2, 10);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.weighty = 0.0;
        this.add((Component)this.selFontLabel, gbc);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        gbc.insets = new Insets(10, 10, 2, 10);
        gbc.gridy = 3;
        gbc.anchor = 15;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.add((Component)buttonPanel, gbc);
        this.familyList.addListSelectionListener(this);
        this.fontList.addListSelectionListener(this);
        this.fontSizeSpinner.addChangeListener(this);
        this.fontSizeList.addListSelectionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        if (this.mode == FONT_STYLE) {
            sizePanel.setVisible(false);
        }
        if (this.mode == FONT_SIZE) {
            fontSP.setVisible(false);
        }
    }

    private void updateFontLabel() {
        String ff = "";
        if (this.familyList.getSelectedValue() != null) {
            ff = (String)this.familyList.getSelectedValue();
        }
        if (this.fontList.getSelectedValue() != null && (this.mode == FONT_STYLE || this.mode == FONT_STYLE_AND_SIZE)) {
            ff = ff + " - " + (String)this.fontList.getSelectedValue();
            this.selFontLabel.setFont(new Font((String)this.fontList.getSelectedValue(), 0, this.fontSize));
        }
        if (this.mode == FONT_SIZE || this.mode == FONT_STYLE_AND_SIZE) {
            ff = ff + " (" + this.fontSize + ")";
        }
        this.selFontLabel.setText(ff);
    }

    private void updateFontList() {
        if (this.familyList.getSelectedValue() != null) {
            String ff = (String)this.familyList.getSelectedValue();
            ((DefaultListModel)this.fontList.getModel()).clear();
            for (int i = 0; i < this.allFonts.length; ++i) {
                if (!this.allFonts[i].getFamily().equals(ff)) continue;
                ((DefaultListModel)this.fontList.getModel()).addElement(this.allFonts[i].getName());
            }
            if (((DefaultListModel)this.fontList.getModel()).getSize() > 0) {
                this.fontList.setSelectedIndex(0);
            }
            this.updateFont();
            this.updateFontLabel();
        }
    }

    private void updateFont() {
        String name = (String)this.fontList.getSelectedValue();
        if (name == null || this.mode == FONT_SIZE) {
            if (this.familyList.getSelectedValue() != null) {
                String ff = (String)this.familyList.getSelectedValue();
                for (int i = 0; i < this.allFonts.length; ++i) {
                    if (!this.allFonts[i].getFamily().equals(ff)) continue;
                    this.selFont = this.allFonts[i];
                    break;
                }
            } else {
                this.selFont = null;
            }
        } else {
            for (int i = 0; i < this.allFonts.length; ++i) {
                if (!this.allFonts[i].getName().equals(name)) continue;
                this.selFont = this.allFonts[i];
                break;
            }
        }
        if ((this.mode == FONT_SIZE || this.mode == FONT_STYLE_AND_SIZE) && this.selFont != null) {
            this.selFont = this.selFont.deriveFont((float)this.fontSize);
        }
    }

    private void doClose() {
        this.selFont = null;
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    private void doApply() {
        this.updateFont();
        if (this.dialog != null && this.dialog.isVisible()) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    public Font showDialog(JDialog parent, boolean modal, Font curFont) {
        this.dialog = new JDialog((Dialog)parent, modal);
        this.dialog.setTitle(ElanLocale.getString("FontDialog.Title"));
        if (curFont != null) {
            this.familyList.setSelectedValue(curFont.getFamily(), true);
            if (this.mode != FONT_SIZE) {
                this.fontList.setSelectedValue(curFont.getName(), true);
            }
            if (this.mode != FONT_STYLE) {
                this.fontSizeSpinner.setValue(new Integer(curFont.getSize()));
                this.fontSizeList.setSelectedValue(new Integer(curFont.getSize()), true);
            }
        }
        this.dialog.setContentPane(this);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                JFontChooser.this.doClose();
            }
        });
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parent);
        this.dialog.setVisible(true);
        return this.getValue();
    }

    public Font showDialog(JFrame parent, boolean modal, Font curFont) {
        this.dialog = new JDialog((Frame)parent, modal);
        this.dialog.setTitle(ElanLocale.getString("FontDialog.Title"));
        if (curFont != null) {
            this.familyList.setSelectedValue(curFont.getFamily(), true);
            if (this.mode != FONT_SIZE) {
                this.fontList.setSelectedValue(curFont.getName(), true);
            }
            if (this.mode != FONT_STYLE) {
                this.fontSizeSpinner.setValue(new Integer(curFont.getSize()));
                this.fontSizeList.setSelectedValue(new Integer(curFont.getSize()), true);
            }
        }
        this.dialog.setContentPane(this);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                JFontChooser.this.doClose();
            }
        });
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parent);
        this.dialog.setVisible(true);
        return this.getValue();
    }

    public Font getValue() {
        return this.selFont;
    }

    public void valueChanged(ListSelectionEvent e) {
        Integer selSize;
        if (e.getSource() == this.familyList) {
            this.updateFontList();
            this.updateFontLabel();
        } else if (e.getSource() == this.fontList) {
            this.updateFont();
            this.updateFontLabel();
        } else if (e.getSource() == this.fontSizeList && (selSize = (Integer)this.fontSizeList.getSelectedValue()) != null) {
            this.fontSize = selSize;
            this.fontSizeSpinner.setValue(selSize);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.doApply();
        } else if (e.getSource() == this.cancelButton) {
            this.doClose();
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.fontSizeSpinner) {
            this.fontSize = (Integer)this.fontSizeSpinner.getValue();
            for (int i = 0; i < this.fontSizeList.getModel().getSize(); ++i) {
                Integer value = (Integer)this.fontSizeList.getModel().getElementAt(i);
                if (value == this.fontSize) {
                    this.fontSizeList.setSelectedValue(value, true);
                    break;
                }
                if (i != this.fontSizeList.getModel().getSize() - 1) continue;
                this.fontSizeList.clearSelection();
            }
            this.updateFont();
            this.updateFontLabel();
        }
    }
}

