/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.SegmentsToTiersCommand;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.SegmentTableModel;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.data.Segment;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.client.util.TableHeaderToolTipAdapter;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class SegmentsToTiersDialog
extends ClosableDialog
implements ActionListener,
ItemListener,
ListSelectionListener,
ProgressListener {
    private TranscriptionImpl transcription;
    private List segmentations;
    private JTabbedPane tabPane;
    private JPanel simplePanel;
    private JPanel advancedPanel;
    private JLabel selectSegmentationLb;
    private JLabel selectSegmentsLb;
    private JComboBox allSegmentationsCombo;
    private JTable segmentsTable;
    private SegmentTableModel model;
    private JLabel selectSegmentationsLb;
    private JTable segmentationsTable;
    private DefaultTableModel dtModel;
    private JProgressBar progressBar;
    private SegmentsToTiersCommand com;
    private JButton okButton;
    private JButton closeButton;
    private JPanel buttonPanel;

    public SegmentsToTiersDialog(TranscriptionImpl transcription, List segmentations) throws HeadlessException {
        this.transcription = transcription;
        this.segmentations = segmentations;
        this.initComponents();
        this.postInit();
    }

    public SegmentsToTiersDialog(Frame owner, TranscriptionImpl transcription, List segmentations) throws HeadlessException {
        super(owner, true);
        this.transcription = transcription;
        this.segmentations = segmentations;
        this.initComponents();
        this.extractSegmentations();
        this.postInit();
    }

    private void initComponents() {
        this.setTitle(ElanLocale.getString("SegmentsToTierDialog.Title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.tabPane = new JTabbedPane();
        this.advancedPanel = new JPanel();
        this.tabPane.addTab(ElanLocale.getString("SegmentsToTierDialog.Tab.PerSegmentation"), this.advancedPanel);
        this.simplePanel = new JPanel();
        this.tabPane.addTab(ElanLocale.getString("SegmentsToTierDialog.Tab.All"), this.simplePanel);
        this.tabPane.setSelectedComponent(this.advancedPanel);
        Insets insets = new Insets(2, 6, 2, 6);
        this.advancedPanel.setLayout(new GridBagLayout());
        this.selectSegmentationLb = new JLabel(ElanLocale.getString("SegmentsToTierDialog.Label.SelectSegmentation"));
        this.selectSegmentsLb = new JLabel(ElanLocale.getString("SegmentsToTierDialog.Label.ConfigureSegment"));
        this.allSegmentationsCombo = new JComboBox();
        this.model = new SegmentTableModel();
        this.segmentsTable = new JTable(this.model);
        this.segmentsTable.getColumn(this.model.getColumnName(this.model.findColumn("Include"))).setPreferredWidth(50);
        this.segmentsTable.getColumn(this.model.getColumnName(this.model.findColumn("NumberSegments"))).setPreferredWidth(50);
        this.segmentsTable.getTableHeader().addMouseMotionListener(new TableHeaderToolTipAdapter(this.segmentsTable.getTableHeader()));
        this.segmentsTable.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        this.segmentsTable.setShowGrid(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.advancedPanel.add((Component)this.selectSegmentationLb, gbc);
        ++gbc.gridy;
        this.advancedPanel.add((Component)this.allSegmentationsCombo, gbc);
        ++gbc.gridy;
        this.advancedPanel.add((Component)this.selectSegmentsLb, gbc);
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        JScrollPane scPane = new JScrollPane(this.segmentsTable);
        scPane.getViewport().setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        scPane.setPreferredSize(new Dimension(300, 180));
        this.advancedPanel.add((Component)scPane, gbc);
        this.simplePanel.setLayout(new GridBagLayout());
        this.selectSegmentationsLb = new JLabel(ElanLocale.getString("SegmentsToTierDialog.Label.SelectSegmentations"));
        this.dtModel = new DefaultTableModel(){

            public boolean isCellEditable(int row, int column) {
                return column == 0;
            }
        };
        this.dtModel.setColumnIdentifiers(new String[]{"Include", "CurrentLabel"});
        this.segmentationsTable = new JTable(this.dtModel);
        this.segmentationsTable.getColumn("Include").setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.segmentationsTable.getColumn("Include").setCellRenderer(new CheckBoxTableCellRenderer());
        this.segmentationsTable.getColumn("Include").setMaxWidth(30);
        this.segmentationsTable.setShowVerticalLines(false);
        this.segmentationsTable.setTableHeader(null);
        this.segmentationsTable.setDefaultEditor(String.class, null);
        this.segmentationsTable.getSelectionModel().addListSelectionListener(this);
        gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.simplePanel.add((Component)this.selectSegmentationsLb, gbc);
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        JScrollPane listScroll = new JScrollPane(this.segmentationsTable);
        listScroll.setPreferredSize(new Dimension(300, 180));
        this.simplePanel.add((Component)listScroll, gbc);
        this.tabPane.setBorder(new EmptyBorder(4, 4, 4, 4));
        gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = insets;
        gbc.anchor = 11;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.tabPane, gbc);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setVisible(false);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.insets = new Insets(2, 10, 4, 10);
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.progressBar, gbc);
        this.okButton = new JButton(ElanLocale.getString("SegmentsToTierDialog.Button.Create"));
        this.closeButton = new JButton(ElanLocale.getString("Button.Close"));
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(1, 2, 6, 2));
        this.okButton.addActionListener(this);
        this.buttonPanel.add(this.okButton);
        this.closeButton.addActionListener(this);
        this.buttonPanel.add(this.closeButton);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.gridx = 0;
        gbc.insets = insets;
        gbc.anchor = 11;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
        this.setModal(true);
        this.allSegmentationsCombo.addItemListener(this);
    }

    private void postInit() {
        this.pack();
        int minimalWidth = 520;
        int minimalHeight = 300;
        this.setSize(this.getSize().width < minimalWidth ? minimalWidth : this.getSize().width, this.getSize().height < minimalHeight ? minimalHeight : this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(true);
    }

    private void extractSegmentations() {
        if (this.segmentations != null && this.segmentations.size() > 0) {
            Segmentation seg = null;
            String[] names = new String[this.segmentations.size()];
            for (int i = 0; i < this.segmentations.size(); ++i) {
                seg = (Segmentation)this.segmentations.get(i);
                names[i] = seg.getName();
                this.dtModel.addRow(new Object[]{Boolean.TRUE, seg.getName()});
            }
            this.allSegmentationsCombo.setModel(new DefaultComboBoxModel<String>(names));
            this.updateSegmentTable();
        }
    }

    private void updateSegmentTable() {
        if (this.allSegmentationsCombo.getSelectedIndex() > -1) {
            SegmentTableModel dtm = (SegmentTableModel)this.segmentsTable.getModel();
            dtm.removeAllRows();
            String name = (String)this.allSegmentationsCombo.getSelectedItem();
            Segmentation seg = null;
            for (int i = 0; i < this.segmentations.size(); ++i) {
                seg = (Segmentation)this.segmentations.get(i);
                if (!name.equals(seg.getName())) continue;
                ArrayList<RSelection> segments = seg.getSegments();
                Segment segment = null;
                ArrayList<String> segLabels = new ArrayList<String>();
                for (int j = 0; j < segments.size(); ++j) {
                    segment = (Segment)segments.get(j);
                    if (segment == null || segLabels.contains(segment.label)) continue;
                    this.model.addSegment(segment);
                    segLabels.add(segment.label);
                }
                break;
            }
        }
    }

    private void convertSingleSegmentation() {
        Segmentation segmentation = null;
        String segmentationName = (String)this.allSegmentationsCombo.getSelectedItem();
        for (int i = 0; i < this.segmentations.size(); ++i) {
            if (!((Segmentation)this.segmentations.get(i)).getName().equals(segmentationName)) continue;
            segmentation = (Segmentation)this.segmentations.get(i);
            break;
        }
        if (segmentation == null) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("SegmentsToTierDialog.Warning.NoSegmentation"), "", 2);
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(0);
            return;
        }
        HashMap<String, String> labelMap = new HashMap<String, String>(this.segmentsTable.getRowCount());
        if (this.segmentsTable.isEditing()) {
            int ecol = this.segmentsTable.getEditingColumn();
            int erow = this.segmentsTable.getEditingRow();
            this.segmentsTable.getCellEditor(erow, ecol).stopCellEditing();
        }
        HashMap<String, int[]> numMap = new HashMap<String, int[]>(this.segmentsTable.getRowCount());
        for (int i = 0; i < this.segmentsTable.getRowCount(); ++i) {
            Boolean sel = (Boolean)this.model.getValueAt(i, this.model.findColumn("Include"));
            if (!sel.booleanValue()) continue;
            String segLabel = (String)this.model.getValueAt(i, this.model.findColumn("CurrentLabel"));
            String newSegLabel = (String)this.model.getValueAt(i, this.model.findColumn("NewLabel"));
            Boolean indexCount = (Boolean)this.model.getValueAt(i, this.model.findColumn("NumberSegments"));
            if (newSegLabel == null || newSegLabel.equals("")) {
                newSegLabel = segLabel;
            }
            labelMap.put(segLabel, newSegLabel);
            if (!indexCount.booleanValue()) continue;
            numMap.put(segLabel, new int[]{1});
        }
        if (labelMap.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("SegmentsToTierDialog.Warning.NoSegmentsSelected"), ElanLocale.getString("Message.Warning"), 2);
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(0);
            return;
        }
        ArrayList<RSelection> segments = segmentation.getSegments();
        ArrayList<AnnotationDataRecord> records = new ArrayList<AnnotationDataRecord>(segments.size());
        Segment seg = null;
        String val = null;
        int[] curCount = null;
        for (int i = 0; i < segments.size(); ++i) {
            seg = (Segment)segments.get(i);
            val = seg.label == null ? (String)labelMap.get("<null>") : (String)labelMap.get(seg.label);
            if (val == null) continue;
            if ("<null>".equals(val)) {
                val = "";
            }
            if ((curCount = seg.label == null ? (int[])numMap.get("<null>") : (int[])numMap.get(seg.label)) != null) {
                int n = curCount[0];
                curCount[0] = n + 1;
                val = val + n;
            }
            records.add(new AnnotationDataRecord("", val, seg.beginTime, seg.endTime));
        }
        HashMap<String, ArrayList<AnnotationDataRecord>> segmentationMap = new HashMap<String, ArrayList<AnnotationDataRecord>>(1);
        segmentationMap.put(segmentation.getName(), records);
        this.com = (SegmentsToTiersCommand)ELANCommandFactory.createCommand(this.transcription, "CommandActions.SegmentsToTiers");
        this.com.addProgressListener(this);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(0);
        this.com.execute(this.transcription, new Object[]{segmentationMap});
    }

    private void convertMultiSegmentation() {
        ArrayList<Object> selSeg = new ArrayList<Object>();
        Segmentation seg = null;
        String name = null;
        for (int i = 0; i < this.segmentationsTable.getRowCount(); ++i) {
            Boolean sel = (Boolean)this.dtModel.getValueAt(i, this.dtModel.findColumn("Include"));
            if (!sel.booleanValue()) continue;
            selSeg.add(this.dtModel.getValueAt(i, this.dtModel.findColumn("CurrentLabel")));
        }
        if (selSeg.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("SegmentsToTierDialog.Warning.NoSegmentationSelected"), ElanLocale.getString("Message.Warning"), 2);
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(0);
            return;
        }
        HashMap segmentationMap = new HashMap(selSeg.size());
        ArrayList<RSelection> segments = null;
        ArrayList<AnnotationDataRecord> records = null;
        for (int i = 0; i < selSeg.size(); ++i) {
            int j;
            seg = null;
            name = (String)selSeg.get(i);
            for (j = 0; j < this.segmentations.size(); ++j) {
                if (!((Segmentation)this.segmentations.get(j)).getName().equals(name)) continue;
                seg = (Segmentation)this.segmentations.get(j);
                break;
            }
            if (seg == null) continue;
            segments = seg.getSegments();
            records = new ArrayList<AnnotationDataRecord>();
            for (j = 0; j < segments.size(); ++j) {
                Segment segment = (Segment)segments.get(j);
                records.add(new AnnotationDataRecord("", segment.label, segment.beginTime, segment.endTime));
            }
            segmentationMap.put(name, records);
        }
        this.com = (SegmentsToTiersCommand)ELANCommandFactory.createCommand(this.transcription, "CommandActions.SegmentsToTiers");
        this.com.addProgressListener(this);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(0);
        this.com.execute(this.transcription, new Object[]{segmentationMap});
    }

    private void setBusyUI(boolean busy) {
        this.progressBar.setVisible(busy);
        this.progressBar.setIndeterminate(busy);
        this.okButton.setEnabled(!busy);
        this.closeButton.setEnabled(!busy);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.setBusyUI(true);
            if (this.tabPane.getSelectedIndex() == 0) {
                this.convertSingleSegmentation();
            } else {
                this.convertMultiSegmentation();
            }
        } else if (e.getSource() == this.closeButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.updateSegmentTable();
    }

    public void valueChanged(ListSelectionEvent lse) {
        if (this.dtModel != null && lse.getValueIsAdjusting()) {
            int b = lse.getFirstIndex();
            int e = lse.getLastIndex();
            int col = this.dtModel.findColumn("Include");
            for (int i = b; i <= e; ++i) {
                if (!this.segmentationsTable.isRowSelected(i)) continue;
                this.dtModel.setValueAt(Boolean.TRUE, i, col);
            }
        }
    }

    public void progressCompleted(Object source, String message) {
        this.progressBar.setValue(this.progressBar.getMaximum());
        if (this.com != null) {
            this.com.removeProgressListener(this);
        }
        JOptionPane.showMessageDialog(this, ElanLocale.getString("Message.Complete"), "", 1);
        this.setBusyUI(false);
    }

    public void progressInterrupted(Object source, String message) {
        if (this.com != null) {
            this.com.removeProgressListener(this);
        }
        this.setBusyUI(false);
    }

    public void progressUpdated(Object source, int percent, String message) {
        if (percent < this.progressBar.getMinimum()) {
            percent = this.progressBar.getMinimum();
        } else if (percent > this.progressBar.getMaximum()) {
            this.progressCompleted(null, null);
            return;
        }
        this.progressBar.setValue(percent);
    }
}

