/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ShortcutsUtil;
import mpi.eudico.client.annotator.gui.ShortcutPanel;

public class ShortcutEditPanel
extends JPanel
implements KeyListener,
ActionListener {
    protected JTextField entryField;
    protected KeyStroke newShortcut;
    protected String newShortcutAsText;
    protected KeyStroke currentShortcut;
    protected String currentShortCutAsText;
    protected String currentAction;
    protected JButton cancelButton;
    protected JButton okButton;
    protected JButton removeButton;
    private ShortcutPanel shortcutPanel;

    public ShortcutEditPanel(ShortcutPanel shortcutPanel, String actionID, KeyStroke actionKey) {
        this.shortcutPanel = shortcutPanel;
        this.currentAction = actionID;
        this.currentShortcut = actionKey;
        this.currentShortCutAsText = ShortcutsUtil.getInstance().getDescriptionForKeyStroke(this.currentShortcut);
        this.newShortcut = this.currentShortcut;
        JLabel descField = new JLabel(ElanLocale.getString("Shortcuts.Editor.Title"));
        this.add(descField);
        this.entryField = new JTextField();
        this.entryField.setPreferredSize(new Dimension(170, 25));
        this.entryField.setFocusable(true);
        this.entryField.setFocusTraversalKeysEnabled(false);
        this.entryField.addKeyListener(this);
        this.entryField.setText(this.currentShortCutAsText);
        this.add(this.entryField);
        this.okButton = new JButton(ElanLocale.getString("Button.OK"));
        this.okButton.addActionListener(this);
        this.okButton.setVerticalTextPosition(0);
        this.okButton.setHorizontalTextPosition(10);
        this.add(this.okButton);
        this.removeButton = new JButton(ElanLocale.getString("Shortcuts.Button.Remove"));
        this.removeButton.addActionListener(this);
        this.removeButton.setVerticalTextPosition(0);
        this.removeButton.setHorizontalTextPosition(10);
        this.add(this.removeButton);
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setVerticalTextPosition(0);
        this.cancelButton.setHorizontalTextPosition(10);
        this.add(this.cancelButton);
    }

    public KeyStroke getValue() {
        return this.newShortcut;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            SwingUtilities.getWindowAncestor(this).setVisible(false);
        } else if (e.getSource() == this.removeButton) {
            this.newShortcut = null;
            this.newShortcutAsText = "";
            this.entryField.setText(this.newShortcutAsText);
            this.entryField.requestFocus();
        } else if (e.getSource() == this.okButton) {
            SwingUtilities.getWindowAncestor(this).setVisible(false);
            if (this.shortcutPanel != null) {
                this.shortcutPanel.changeShortcut(this.newShortcut);
            }
        }
    }

    public static void createAndShowGUI(ShortcutPanel caller, String actionID) {
        JDialog owner = (JDialog)SwingUtilities.getWindowAncestor(caller);
        ShortcutsUtil scu = ShortcutsUtil.getInstance();
        String actionName = scu.getDescriptionForAction(actionID);
        KeyStroke actionKeyStroke = caller.allShortCuts.get(actionID);
        JDialog frame = new JDialog(owner, ElanLocale.getString("Shortcuts.Editor.Label") + " '" + actionName + "'", true);
        ShortcutEditPanel newContentPane = new ShortcutEditPanel(caller, actionID, actionKeyStroke);
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setLocationRelativeTo(owner);
        frame.setVisible(true);
    }

    public void keyPressed(KeyEvent ke) {
        this.entryField.setText("");
        this.newShortcut = KeyStroke.getKeyStrokeForEvent(ke);
        String myKeyString = KeyEvent.getKeyText(ke.getKeyCode());
        String myModifierString = KeyEvent.getModifiersExText(ke.getModifiersEx());
        this.newShortcutAsText = ke.getModifiersEx() == 0 ? myKeyString : myModifierString + " + " + myKeyString;
    }

    public void keyReleased(KeyEvent ke) {
        this.entryField.setText(this.newShortcutAsText);
    }

    public void keyTyped(KeyEvent ke) {
    }
}

