/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui.multistep;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.multistep.MultiStepControl;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.gui.multistep.StepTitlePanel;

public class MultiStepPane
extends JComponent
implements MultiStepControl,
ActionListener {
    public static final int HELP_BUTTON = 0;
    public static final int NEXT_BUTTON = 1;
    public static final int PREVIOUS_BUTTON = 2;
    public static final int FINISH_BUTTON = 3;
    public static final int CANCEL_BUTTON = 4;
    public static final int ALL_BUTTONS = 8;
    private ResourceBundle bundle;
    private JButton helpButton;
    private JButton nextButton;
    private JButton prevButton;
    private JButton finishButton;
    private JButton cancelButton;
    private final Dimension prefSize = new Dimension(500, 400);
    private final int prefTitlePanelHeight = 70;
    private final int prefButtonPanelHeight = 60;
    private Insets insets;
    private StepTitlePanel titlePanel;
    private JPanel stepContainer;
    private CardLayout stepLayout;
    private JPanel buttonPanel;
    private JDialog dialog;
    private HashMap stepMap;
    private HashMap stepProperties;
    private int currentStepIndex = 0;
    private StepPane currentStep;

    public MultiStepPane() {
        this.initComponents();
    }

    public MultiStepPane(ResourceBundle bundle) {
        this.bundle = bundle;
        this.initComponents();
    }

    protected void initComponents() {
        this.stepMap = new HashMap();
        this.stepProperties = new HashMap();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(this.prefSize);
        this.setMinimumSize(this.prefSize);
        this.insets = new Insets(0, 0, 0, 0);
        this.titlePanel = new StepTitlePanel();
        this.titlePanel.setPreferredSize(new Dimension(this.getPreferredSize().width, 70));
        this.titlePanel.setMinimumSize(new Dimension(this.getPreferredSize().width, 70));
        this.titlePanel.setBackground(Color.white);
        this.titlePanel.setBorder(new MatteBorder(0, 0, 1, 0, Color.DARK_GRAY));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = this.insets;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.titlePanel, gridBagConstraints);
        this.stepLayout = new CardLayout();
        this.stepContainer = new JPanel(this.stepLayout);
        this.stepContainer.setPreferredSize(this.prefSize);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = this.insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.stepContainer, gridBagConstraints);
        this.buttonPanel = new JPanel(new GridBagLayout());
        this.buttonPanel.setBorder(new CompoundBorder(new MatteBorder(1, 0, 0, 0, Color.DARK_GRAY), new EmptyBorder(6, 6, 6, 6)));
        this.helpButton = new JButton();
        this.nextButton = new JButton();
        this.prevButton = new JButton();
        this.finishButton = new JButton();
        this.cancelButton = new JButton();
        this.helpButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.prevButton.addActionListener(this);
        this.finishButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        Insets buttonInsets = new Insets(4, 4, 4, 4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = buttonInsets;
        this.buttonPanel.add((Component)this.helpButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = buttonInsets;
        gridBagConstraints.weightx = 1.0;
        this.buttonPanel.add((Component)new JPanel(), gridBagConstraints);
        JPanel buttonGroupPanel = new JPanel(new GridLayout(1, 4, buttonInsets.left, buttonInsets.top));
        buttonGroupPanel.add(this.prevButton);
        buttonGroupPanel.add(this.nextButton);
        buttonGroupPanel.add(this.finishButton);
        buttonGroupPanel.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = buttonInsets;
        this.buttonPanel.add((Component)buttonGroupPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = this.insets;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.buttonPanel, gridBagConstraints);
        this.helpButton.setEnabled(false);
        this.helpButton.setVisible(false);
        this.prevButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.finishButton.setEnabled(false);
        this.updateLocale();
    }

    public void updateLocale() {
        if (this.bundle != null) {
            this.helpButton.setText(this.bundle.getString("MultiStep.Help"));
            this.prevButton.setText(this.bundle.getString("MultiStep.Previous"));
            this.nextButton.setText(this.bundle.getString("MultiStep.Next"));
            this.finishButton.setText(this.bundle.getString("MultiStep.Finish"));
            this.cancelButton.setText(this.bundle.getString("MultiStep.Cancel"));
        } else {
            this.helpButton.setText("Help");
            this.prevButton.setText("Previous");
            this.nextButton.setText("Next");
            this.finishButton.setText("Finish");
            this.cancelButton.setText("Cancel");
        }
    }

    public void addStep(StepPane step) {
        if (step == null) {
            return;
        }
        int curSize = this.stepMap.size();
        this.stepContainer.add((Component)step, "" + curSize);
        this.stepMap.put(new Integer(curSize), step);
        if (curSize == 0) {
            this.currentStepIndex = 0;
            this.currentStep = step;
            this.stepLayout.show(this.stepContainer, "" + this.currentStepIndex);
            if (this.titlePanel != null) {
                this.titlePanel.setTitleText(this.currentStep.getStepTitle());
            }
            this.currentStep.enterStepForward();
        }
    }

    public void nextStep() {
        if (this.currentStepIndex < this.stepMap.size() - 1) {
            if (this.currentStep.leaveStepForward()) {
                this.stepLayout.next(this.stepContainer);
                ++this.currentStepIndex;
                this.prevButton.setEnabled(true);
                this.nextButton.setEnabled(false);
                this.currentStep = (StepPane)this.stepMap.get(new Integer(this.currentStepIndex));
                if (this.titlePanel != null) {
                    this.titlePanel.setTitleText(this.currentStep.getStepTitle());
                }
                this.currentStep.enterStepForward();
            }
        } else if (this.currentStepIndex == this.stepMap.size()) {
            this.finish();
        }
    }

    public void previousStep() {
        if (this.currentStepIndex > 0 && this.stepMap.size() > 0 && this.currentStep.leaveStepBackward()) {
            this.stepLayout.previous(this.stepContainer);
            --this.currentStepIndex;
            if (this.currentStepIndex == 0) {
                this.prevButton.setEnabled(false);
            }
            this.nextButton.setEnabled(false);
            this.currentStep = (StepPane)this.stepMap.get(new Integer(this.currentStepIndex));
            if (this.titlePanel != null) {
                this.titlePanel.setTitleText(this.currentStep.getStepTitle());
            }
            this.currentStep.enterStepBackward();
        }
    }

    public void finish() {
        if (this.currentStep.doFinish()) {
            this.finishNotify();
            if (this.dialog != null) {
                this.dialog.setVisible(false);
            }
        }
    }

    public void cancel() {
        this.finishNotify();
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }

    public void close() {
        this.cancel();
    }

    public void showHelp() {
        this.currentStep.showHelp();
    }

    public void putStepProperty(Object key, Object value) {
        this.stepProperties.put(key, value);
    }

    public Object getStepProperty(Object key) {
        return this.stepProperties.get(key);
    }

    public Set getPropertyKeys() {
        return this.stepProperties.keySet();
    }

    public int getCurrentStepIndex() {
        return this.currentStepIndex;
    }

    public StepPane getCurrentStep() {
        return this.currentStep;
    }

    public void goToStep(int stepIndex) {
        String name;
        if (stepIndex >= 0 && stepIndex < this.stepMap.size() && (name = (String)this.stepMap.get(new Integer(stepIndex))) != null) {
            this.stepLayout.show(this.stepContainer, name);
            this.currentStepIndex = stepIndex;
        }
    }

    public void goToStep(String name) {
        if (this.stepMap.containsValue(name)) {
            Set keys = this.stepMap.keySet();
            for (Integer nextInt : keys) {
                String val = (String)this.stepMap.get(nextInt);
                if (val == null || !val.equals(name)) continue;
                this.currentStepIndex = nextInt;
                break;
            }
            this.stepLayout.show(this.stepContainer, name);
        }
    }

    private void finishNotify() {
        Set keys = this.stepMap.keySet();
        for (Integer nextInt : keys) {
            StepPane val = (StepPane)this.stepMap.get(nextInt);
            if (val == null) continue;
            val.finished();
        }
    }

    public void setButtonVisible(int buttonType, boolean visible) {
        switch (buttonType) {
            case 0: {
                this.helpButton.setVisible(visible);
                break;
            }
            case 1: {
                this.nextButton.setVisible(visible);
                break;
            }
            case 2: {
                this.prevButton.setVisible(visible);
                break;
            }
            case 3: {
                this.finishButton.setVisible(visible);
                break;
            }
            case 4: {
                this.cancelButton.setVisible(visible);
                break;
            }
            case 8: {
                this.helpButton.setVisible(visible);
                this.nextButton.setVisible(visible);
                this.prevButton.setVisible(visible);
                this.finishButton.setVisible(visible);
                this.cancelButton.setVisible(visible);
                break;
            }
        }
    }

    public boolean isButtonVisible(int buttonType) {
        switch (buttonType) {
            case 0: {
                return this.helpButton.isVisible();
            }
            case 1: {
                return this.nextButton.isVisible();
            }
            case 2: {
                return this.prevButton.isVisible();
            }
            case 3: {
                return this.finishButton.isVisible();
            }
            case 4: {
                return this.cancelButton.isVisible();
            }
            case 8: {
                return this.helpButton.isVisible() && this.nextButton.isVisible() && this.prevButton.isVisible() && this.finishButton.isVisible() && this.cancelButton.isVisible();
            }
        }
        return false;
    }

    public void setButtonEnabled(int buttonType, boolean enable) {
        switch (buttonType) {
            case 0: {
                this.helpButton.setEnabled(enable);
                break;
            }
            case 1: {
                this.nextButton.setEnabled(enable);
                break;
            }
            case 2: {
                this.prevButton.setEnabled(enable);
                break;
            }
            case 3: {
                this.finishButton.setEnabled(enable);
                break;
            }
            case 4: {
                this.cancelButton.setEnabled(enable);
                break;
            }
            case 8: {
                this.helpButton.setEnabled(enable);
                this.nextButton.setEnabled(enable);
                this.prevButton.setEnabled(enable);
                this.finishButton.setEnabled(enable);
                this.cancelButton.setEnabled(enable);
                break;
            }
        }
    }

    public boolean isButtonEnabled(int buttonType) {
        switch (buttonType) {
            case 0: {
                return this.helpButton.isEnabled();
            }
            case 1: {
                return this.nextButton.isEnabled();
            }
            case 2: {
                return this.prevButton.isEnabled();
            }
            case 3: {
                return this.finishButton.isEnabled();
            }
            case 4: {
                return this.cancelButton.isEnabled();
            }
            case 8: {
                return this.helpButton.isEnabled() && this.nextButton.isEnabled() && this.prevButton.isEnabled() && this.finishButton.isEnabled() && this.cancelButton.isEnabled();
            }
        }
        return false;
    }

    public void setButtonText(int buttonType, String text) {
        switch (buttonType) {
            case 0: {
                this.helpButton.setText(text);
                break;
            }
            case 1: {
                this.nextButton.setText(text);
                break;
            }
            case 2: {
                this.prevButton.setText(text);
                break;
            }
            case 3: {
                this.finishButton.setText(text);
                break;
            }
            case 4: {
                this.cancelButton.setText(text);
                break;
            }
        }
    }

    public void setButtonIcon(int buttonType, Icon icon) {
        switch (buttonType) {
            case 0: {
                this.helpButton.setIcon(icon);
                break;
            }
            case 1: {
                this.nextButton.setIcon(icon);
                break;
            }
            case 2: {
                this.prevButton.setIcon(icon);
                break;
            }
            case 3: {
                this.finishButton.setIcon(icon);
                break;
            }
            case 4: {
                this.cancelButton.setIcon(icon);
                break;
            }
        }
    }

    public void setTitlePanelBackground(Color background) {
        if (this.titlePanel != null) {
            this.titlePanel.setBackground(background);
        }
    }

    public void setTitlePanel(StepTitlePanel newTitlePanel) {
        GridBagConstraints c = ((GridBagLayout)this.getLayout()).getConstraints(this.titlePanel);
        this.getLayout().removeLayoutComponent(this.titlePanel);
        this.titlePanel = newTitlePanel;
        if (this.titlePanel != null) {
            this.add((Component)this.titlePanel, c);
        }
    }

    public StepTitlePanel getTitlePanel() {
        return this.titlePanel;
    }

    public void setButtonPanelBackground(Color background) {
        if (this.buttonPanel != null) {
            this.buttonPanel.setBackground(background);
        }
    }

    public JDialog createDialog(JDialog parent, String title, boolean modal) {
        this.dialog = new ClosableDialog(parent, title, modal);
        this.dialog.setContentPane(this);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parent);
        return this.dialog;
    }

    public JDialog createDialog(Frame parent, String title, boolean modal) {
        this.dialog = new ClosableDialog(parent, title, modal);
        this.dialog.setContentPane(this);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parent);
        return this.dialog;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() != this.helpButton) {
            if (e.getSource() == this.nextButton) {
                this.nextStep();
            } else if (e.getSource() == this.prevButton) {
                this.previousStep();
            } else if (e.getSource() == this.finishButton) {
                this.finish();
            } else if (e.getSource() == this.cancelButton) {
                this.cancel();
            }
        }
    }
}

