/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.ControlledVocabulary;

public class MergeUtil
implements ClientLogger {
    /*
     * Enabled aggressive block sorting
     */
    public ArrayList getAddableTiers(Transcription srcTrans, Transcription destTrans, ArrayList selTiers) {
        if (srcTrans == null || destTrans == null) {
            LOG.warning("A Transcription is null");
            return new ArrayList(0);
        }
        if (selTiers == null) {
            int size = srcTrans.getTiers().size();
            selTiers = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                TierImpl ti = (TierImpl)srcTrans.getTiers().get(i);
                selTiers.add(ti.getName());
            }
        }
        ArrayList<TierImpl> validTiers = new ArrayList<TierImpl>(selTiers.size());
        int i = 0;
        while (true) {
            TierImpl t;
            String name;
            block13: {
                TierImpl loopTier;
                String parentName;
                TierImpl parent;
                block14: {
                    block10: {
                        TierImpl t2;
                        block11: {
                            block12: {
                                if (i >= selTiers.size()) {
                                    return validTiers;
                                }
                                name = selTiers.get(i);
                                t = (TierImpl)srcTrans.getTierWithId(name);
                                if (t == null) break block10;
                                t2 = (TierImpl)destTrans.getTierWithId(name);
                                if (t2 != null) break block11;
                                if (t.getParentTier() != null) break block12;
                                validTiers.add(t);
                                break block13;
                            }
                            parent = null;
                            parentName = null;
                            loopTier = t;
                            break block14;
                        }
                        if (!this.lingTypeCompatible(t, t2)) break block13;
                        validTiers.add(t);
                        break block13;
                    }
                    LOG.warning("Tier " + name + " does not exist.");
                    break block13;
                }
                while (loopTier.getParentTier() != null) {
                    parent = (TierImpl)loopTier.getParentTier();
                    parentName = parent.getName();
                    if (selTiers.contains(parentName)) {
                        if (parent.getParentTier() == null) {
                            validTiers.add(t);
                            break;
                        }
                        if (destTrans.getTierWithId(parentName) != null) {
                            if (!this.lingTypeCompatible(parent, (TierImpl)destTrans.getTierWithId(parentName))) break;
                            validTiers.add(t);
                            break;
                        }
                        loopTier = parent;
                        continue;
                    }
                    if (destTrans.getTierWithId(parentName) == null || !this.lingTypeCompatible(parent, (TierImpl)destTrans.getTierWithId(parentName))) break;
                    validTiers.add(t);
                    break;
                }
            }
            if (!validTiers.contains(t)) {
                LOG.warning("Cannot add tier " + name);
            }
            ++i;
        }
    }

    public boolean lingTypeCompatible(TierImpl t, TierImpl t2) {
        if (t == null || t2 == null) {
            return false;
        }
        LinguisticType lt = t.getLinguisticType();
        LinguisticType lt2 = t2.getLinguisticType();
        if (lt.hasConstraints() == lt2.hasConstraints()) {
            if (lt.getConstraints() != null) {
                if (lt.getConstraints().getStereoType() == lt2.getConstraints().getStereoType()) {
                    return true;
                }
                LOG.warning("Incompatible tier types in source and destination: " + t.getName());
                return false;
            }
            return true;
        }
        return false;
    }

    public ArrayList sortTiers(ArrayList tiersToSort) {
        int i;
        if (tiersToSort == null || tiersToSort.size() == 0) {
            return null;
        }
        DefaultMutableTreeNode sortedRootNode = new DefaultMutableTreeNode("sortRoot");
        HashMap<TierImpl, DefaultMutableTreeNode> nodes = new HashMap<TierImpl, DefaultMutableTreeNode>();
        TierImpl t = null;
        for (i = 0; i < tiersToSort.size(); ++i) {
            t = (TierImpl)tiersToSort.get(i);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(t);
            nodes.put(t, node);
        }
        for (i = 0; i < tiersToSort.size(); ++i) {
            t = (TierImpl)tiersToSort.get(i);
            if (t.getParentTier() == null || !tiersToSort.contains(t.getParentTier())) {
                sortedRootNode.add((DefaultMutableTreeNode)nodes.get(t));
                continue;
            }
            ((DefaultMutableTreeNode)nodes.get(t.getParentTier())).add((DefaultMutableTreeNode)nodes.get(t));
        }
        ArrayList<Object> sorted = new ArrayList<Object>(tiersToSort.size());
        Enumeration<TreeNode> en = sortedRootNode.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            if (!(node.getUserObject() instanceof TierImpl)) continue;
            sorted.add(node.getUserObject());
        }
        return sorted;
    }

    public void addTiersTypesAndCVs(TranscriptionImpl srcTrans, TranscriptionImpl destTrans, ArrayList tiersToAdd) {
        ControlledVocabulary cv;
        int c;
        String typeName;
        LinguisticType lt;
        TierImpl t;
        int i;
        if (srcTrans == null) {
            LOG.warning("Source transcription is null.");
            return;
        }
        if (destTrans == null) {
            LOG.warning("Destination transcription is null");
            return;
        }
        if (tiersToAdd == null || tiersToAdd.size() == 0) {
            LOG.warning("No tiers to add");
            return;
        }
        Hashtable<String, ControlledVocabulary> renamedCVS = new Hashtable<String, ControlledVocabulary>(5);
        Hashtable<String, String> renamedTypes = new Hashtable<String, String>(5);
        ArrayList<LinguisticType> typesToAdd = new ArrayList<LinguisticType>(5);
        ArrayList<ControlledVocabulary> cvsToAdd = new ArrayList<ControlledVocabulary>(5);
        LinguisticType lt2 = null;
        ControlledVocabulary cv2 = null;
        for (i = 0; i < tiersToAdd.size(); ++i) {
            t = (TierImpl)tiersToAdd.get(i);
            if (t == null || destTrans.getTierWithId(t.getName()) != null || typesToAdd.contains(lt = t.getLinguisticType())) continue;
            typeName = lt.getLinguisticTypeName();
            lt2 = destTrans.getLinguisticTypeByName(typeName);
            if (lt2 != null) {
                if (lt.getConstraints() == null && lt2.getConstraints() == null || lt.getConstraints() != null && lt2.getConstraints() != null && lt.getConstraints().getStereoType() == lt.getConstraints().getStereoType()) continue;
                String nname = typeName + "-cp";
                c = 1;
                while (destTrans.getLinguisticTypeByName(nname + c) != null) {
                    ++c;
                }
                nname = nname + c;
                if (!renamedTypes.containsKey(typeName)) {
                    renamedTypes.put(typeName, nname);
                }
            }
            typesToAdd.add(lt);
            if (!lt.isUsingControlledVocabulary() || cvsToAdd.contains(cv = srcTrans.getControlledVocabulary(lt.getControlledVocabylaryName()))) continue;
            cvsToAdd.add(cv);
        }
        for (i = 0; i < cvsToAdd.size(); ++i) {
            cv = (ControlledVocabulary)cvsToAdd.get(i);
            cv2 = destTrans.getControlledVocabulary(cv.getName());
            if (cv2 == null) {
                destTrans.addControlledVocabulary(cv);
                LOG.info("Added Controlled Vocabulary: " + cv.getName());
                continue;
            }
            if (cv.equals(cv2)) continue;
            String newCVName = cv.getName() + "-cp";
            c = 1;
            while (destTrans.getControlledVocabulary(newCVName + c) != null) {
                ++c;
            }
            newCVName = newCVName + c;
            LOG.info("Renamed Controlled Vocabulary: " + cv.getName() + " to " + newCVName);
            renamedCVS.put(cv.getName(), cv);
            cv.setName(newCVName);
            destTrans.addControlledVocabulary(cv);
            LOG.info("Added Controlled Vocabulary: " + cv.getName());
        }
        for (i = 0; i < typesToAdd.size(); ++i) {
            lt = (LinguisticType)typesToAdd.get(i);
            typeName = lt.getLinguisticTypeName();
            if (lt.isUsingControlledVocabulary() && renamedCVS.containsKey(lt.getControlledVocabylaryName())) {
                cv2 = (ControlledVocabulary)renamedCVS.get(lt.getControlledVocabylaryName());
                lt.setControlledVocabularyName(cv2.getName());
            }
            if (renamedTypes.containsKey(lt.getLinguisticTypeName())) {
                String newLTName = (String)renamedTypes.get(lt.getLinguisticTypeName());
                LOG.info("Renamed Linguistic Type: " + lt.getLinguisticTypeName() + " to " + newLTName);
                lt.setLinguisticTypeName(newLTName);
            }
            destTrans.addLinguisticType(lt);
            LOG.info("Added Linguistic Type: " + lt.getLinguisticTypeName());
        }
        for (i = 0; i < tiersToAdd.size(); ++i) {
            t = (TierImpl)tiersToAdd.get(i);
            if (destTrans.getTierWithId(t.getName()) != null) continue;
            TierImpl t2 = (TierImpl)t.getParentTier();
            String parentTierName = null;
            if (t2 != null) {
                parentTierName = t2.getName();
            }
            TierImpl newTier = null;
            if (parentTierName == null) {
                newTier = new TierImpl(t.getName(), t.getParticipant(), destTrans, null);
            } else {
                t2 = (TierImpl)destTrans.getTierWithId(parentTierName);
                if (t2 != null) {
                    newTier = new TierImpl(t2, t.getName(), t.getParticipant(), destTrans, null);
                } else {
                    LOG.warning("The parent tier: " + parentTierName + " for tier: " + t.getName() + " was not found in the destination transcription");
                }
            }
            if (newTier == null) continue;
            lt = t.getLinguisticType();
            lt2 = destTrans.getLinguisticTypeByName(lt.getLinguisticTypeName());
            if (lt2 != null) {
                newTier.setLinguisticType(lt2);
                destTrans.addTier(newTier);
                LOG.info("Created and added tier to destination: " + newTier.getName());
            } else {
                LOG.warning("Could not add tier: " + newTier.getName() + " because the Linguistic Type was not found in the destination transcription.");
            }
            newTier.setDefaultLocale(t.getDefaultLocale());
            newTier.setAnnotator(t.getAnnotator());
        }
    }
}

