/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.util.TierTree;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;

public class TranscriptionCopier
implements ClientLogger {
    public void copyTranscription(TranscriptionImpl src, TranscriptionImpl dest) {
        if (src == null) {
            throw new NullPointerException("Source transcription is null");
        }
        if (dest == null) {
            throw new NullPointerException("Destination transcription is null");
        }
        this.copyHeader(src, dest);
        this.copyMediaDescriptors(src, dest);
        this.copyControlledVocabularies(src, dest);
        this.copyLinguisticTypes(src, dest);
        this.copyTiers(src, dest);
        this.copyAnnotations(src, dest);
    }

    public void copyHeader(TranscriptionImpl src, TranscriptionImpl dest) {
        if (src == null) {
            throw new NullPointerException("Source transcription is null");
        }
        if (dest == null) {
            throw new NullPointerException("Destination transcription is null");
        }
        dest.setAuthor(src.getAuthor());
    }

    public void copyMediaDescriptors(TranscriptionImpl src, TranscriptionImpl dest) {
        if (src == null) {
            throw new NullPointerException("Source transcription is null");
        }
        if (dest == null) {
            throw new NullPointerException("Destination transcription is null");
        }
        Vector mediaDescs = src.getMediaDescriptors();
        Vector<MediaDescriptor> copyDesc = new Vector<MediaDescriptor>(mediaDescs.size());
        for (int i = 0; i < mediaDescs.size(); ++i) {
            MediaDescriptor srcMd = (MediaDescriptor)mediaDescs.get(i);
            MediaDescriptor copyMd = (MediaDescriptor)srcMd.clone();
            copyDesc.add(copyMd);
        }
        dest.setMediaDescriptors(copyDesc);
    }

    public void copyControlledVocabularies(TranscriptionImpl src, TranscriptionImpl dest) {
        if (src == null) {
            throw new NullPointerException("Source transcription is null");
        }
        if (dest == null) {
            throw new NullPointerException("Destination transcription is null");
        }
        Vector srcCVS = src.getControlledVocabularies();
        Vector<ControlledVocabulary> copyCVS = new Vector<ControlledVocabulary>(srcCVS.size());
        for (int i = 0; i < srcCVS.size(); ++i) {
            ControlledVocabulary cv = (ControlledVocabulary)srcCVS.get(i);
            ControlledVocabulary cpCV = new ControlledVocabulary(cv.getName(), cv.getDescription());
            CVEntry[] srcEntries = cv.getEntries();
            for (int j = 0; j < srcEntries.length; ++j) {
                CVEntry srcEntry = srcEntries[j];
                CVEntry cpEntry = new CVEntry(srcEntry.getValue(), srcEntry.getDescription());
                cpCV.addEntry(cpEntry);
            }
            copyCVS.add(cpCV);
        }
        dest.setControlledVocabularies(copyCVS);
    }

    public void copyLinguisticTypes(TranscriptionImpl src, TranscriptionImpl dest) {
        if (src == null) {
            throw new NullPointerException("Source transcription is null");
        }
        if (dest == null) {
            throw new NullPointerException("Destination transcription is null");
        }
        Vector srcTypes = src.getLinguisticTypes();
        Vector<LinguisticType> destTypes = new Vector<LinguisticType>(srcTypes.size());
        for (int i = 0; i < srcTypes.size(); ++i) {
            LinguisticType srcLt = (LinguisticType)srcTypes.get(i);
            LinguisticType cpLt = new LinguisticType(srcLt.getLinguisticTypeName());
            cpLt.setControlledVocabularyName(srcLt.getControlledVocabylaryName());
            cpLt.setGraphicReferences(srcLt.hasGraphicReferences());
            cpLt.setTimeAlignable(srcLt.isTimeAlignable());
            cpLt.addConstraint(srcLt.getConstraints());
            destTypes.add(cpLt);
        }
        dest.setLinguisticTypes(destTypes);
    }

    public void copyTiers(TranscriptionImpl src, TranscriptionImpl dest) {
        if (src == null) {
            throw new NullPointerException("Source transcription is null");
        }
        if (dest == null) {
            throw new NullPointerException("Destination transcription is null");
        }
        String parentName = null;
        String typeName = null;
        Vector destTypes = dest.getLinguisticTypes();
        TierTree tierTree = new TierTree(src);
        DefaultMutableTreeNode root = tierTree.getTree();
        Enumeration<TreeNode> ten = root.breadthFirstEnumeration();
        ten.nextElement();
        while (ten.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)ten.nextElement();
            Object next = node.getUserObject();
            if (next instanceof String) {
                TierImpl srcTier = (TierImpl)src.getTierWithId((String)next);
                if (srcTier == null) {
                    LOG.warning("A tier could not be found in the source transcription: " + next);
                    continue;
                }
                TierImpl parTier = (TierImpl)srcTier.getParentTier();
                if (parTier != null) {
                    parentName = parTier.getName();
                }
                LinguisticType lt = srcTier.getLinguisticType();
                typeName = lt.getLinguisticTypeName();
                TierImpl cpTier = null;
                if (parTier == null) {
                    cpTier = new TierImpl(srcTier.getName(), srcTier.getParticipant(), dest, null);
                } else {
                    parTier = (TierImpl)dest.getTierWithId(parentName);
                    if (parTier != null) {
                        cpTier = new TierImpl(parTier, srcTier.getName(), srcTier.getParticipant(), dest, null);
                    } else {
                        LOG.warning("The parent tier: " + parentName + " for tier: " + cpTier.getName() + " was not found in the destination transcription");
                    }
                }
                if (cpTier == null) continue;
                LinguisticType destLt = null;
                for (int i = 0; i < destTypes.size(); ++i) {
                    lt = (LinguisticType)destTypes.get(i);
                    if (!lt.getLinguisticTypeName().equals(typeName)) continue;
                    destLt = lt;
                    break;
                }
                if (destLt != null) {
                    cpTier.setLinguisticType(destLt);
                    if (dest.getTierWithId(cpTier.getName()) == null) {
                        dest.addTier(cpTier);
                        LOG.info("Created and added tier to destination: " + cpTier.getName());
                    } else {
                        LOG.info("Could not add tier to destination: " + cpTier.getName() + " already exists in the transcription");
                    }
                } else {
                    LOG.warning("Could not add tier: " + cpTier.getName() + " because the Linguistic Type was not found in the destination transcription.");
                }
                cpTier.setDefaultLocale(srcTier.getDefaultLocale());
                cpTier.setAnnotator(srcTier.getAnnotator());
                continue;
            }
            LOG.warning("Unknown object in the tier tree.");
        }
    }

    public void copyAnnotations(TranscriptionImpl src, TranscriptionImpl dest) {
        if (src == null) {
            throw new NullPointerException("Source transcription is null");
        }
        if (dest == null) {
            throw new NullPointerException("Destination transcription is null");
        }
        Vector tiers = src.getTiers();
        for (int i = 0; i < tiers.size(); ++i) {
            TierImpl srcTier = (TierImpl)tiers.get(i);
            if (srcTier.hasParentTier()) continue;
            Vector annos = srcTier.getAnnotations();
            int size = annos.size();
            for (int j = 0; j < size; ++j) {
                AlignableAnnotation aa = (AlignableAnnotation)annos.get(j);
                DefaultMutableTreeNode annNode = AnnotationRecreator.createTreeForAnnotation(aa);
                AnnotationRecreator.createAnnotationFromTree(dest, annNode);
            }
        }
    }
}

