/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports.praat;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clomimpl.praat.PraatSpecialChars;

public class PraatTextGrid
implements ClientLogger {
    private final char brack = (char)91;
    private final String eq = "=";
    private final String item = "item";
    private final String cl = "class";
    private final String tierSpec = "IntervalTier";
    private final String textTierSpec = "TextTier";
    private final String nm = "name";
    private final String interval = "intervals";
    private final String min = "xmin";
    private final String max = "xmax";
    private final String tx = "text";
    private final String points = "points";
    private final String time = "time";
    private final String mark = "mark";
    private boolean includeTextTiers = false;
    private int pointDuration = 1;
    private String encoding;
    private File gridFile;
    private List tierNames;
    private Map annotationMap;
    private PraatSpecialChars lookUp;

    public PraatTextGrid(String fileName) throws IOException {
        this(fileName, false, 1);
    }

    public PraatTextGrid(String fileName, boolean includeTextTiers, int pointDuration) throws IOException {
        if (fileName != null) {
            this.gridFile = new File(fileName);
        }
        this.includeTextTiers = includeTextTiers;
        this.pointDuration = pointDuration;
        this.parse();
    }

    public PraatTextGrid(File gridFile) throws IOException {
        this(gridFile, false, 1);
    }

    public PraatTextGrid(File gridFile, boolean includeTextTiers, int pointDuration) throws IOException {
        this(gridFile, includeTextTiers, pointDuration, null);
    }

    public PraatTextGrid(File gridFile, boolean includeTextTiers, int pointDuration, String encoding) throws IOException {
        this.gridFile = gridFile;
        this.includeTextTiers = includeTextTiers;
        this.pointDuration = pointDuration;
        this.encoding = encoding;
        this.parse();
    }

    public List getTierNames() {
        return this.tierNames;
    }

    public List getAnnotationRecords(String tierName) {
        if (tierName == null || this.annotationMap == null) {
            return null;
        }
        Object value = this.annotationMap.get(tierName);
        if (value instanceof List) {
            return (List)value;
        }
        return null;
    }

    private void parse() throws IOException {
        if (this.gridFile == null || !this.gridFile.exists()) {
            LOG.warning("No existing file specified.");
            throw new IOException("No existing file specified.");
        }
        BufferedReader reader = null;
        try {
            String line;
            if (this.encoding == null) {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.gridFile)));
            } else {
                try {
                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.gridFile), this.encoding));
                }
                catch (UnsupportedEncodingException uee) {
                    LOG.warning("Unsupported encoding: " + uee.getMessage());
                    reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.gridFile)));
                }
            }
            System.out.println("Read encoding: " + this.encoding);
            this.tierNames = new ArrayList(4);
            this.annotationMap = new HashMap(4);
            ArrayList<AnnotationDataRecord> records = new ArrayList<AnnotationDataRecord>();
            AnnotationDataRecord record = null;
            String tierName = null;
            String annValue = "";
            long begin = -1L;
            long end = -1L;
            boolean inTier = false;
            boolean inInterval = false;
            boolean inTextTier = false;
            boolean inPoints = false;
            int eqPos = -1;
            block5: while ((line = reader.readLine()) != null) {
                int count;
                String nextName;
                if (line.indexOf("class") >= 0 && (line.indexOf("IntervalTier") > 5 || line.indexOf("TextTier") > 5)) {
                    if (line.indexOf("TextTier") > 5) {
                        if (this.includeTextTiers) {
                            inTextTier = true;
                        } else {
                            inTextTier = false;
                            inTier = false;
                            continue;
                        }
                    }
                    records = new ArrayList();
                    inTier = true;
                    continue;
                }
                if (!inTier) continue;
                eqPos = line.indexOf("=");
                if (inTextTier) {
                    if (eqPos > 0) {
                        if (!inPoints && line.indexOf("name") >= 0 && line.indexOf("name") < eqPos) {
                            tierName = this.extractTierName(line, eqPos);
                            if (!this.annotationMap.containsKey(tierName)) {
                                this.annotationMap.put(tierName, records);
                                this.tierNames.add(tierName);
                                LOG.info("Point Tier detected: " + tierName);
                                continue;
                            }
                            nextName = "";
                            for (count = 2; count < 50; ++count) {
                                nextName = tierName + "-" + count;
                                if (this.annotationMap.containsKey(nextName)) continue;
                                this.annotationMap.put(nextName, records);
                                this.tierNames.add(nextName);
                                LOG.info("Tier detected: " + tierName + " and renamed to: " + nextName);
                                continue block5;
                            }
                            continue;
                        }
                        if (!inPoints) continue;
                        if (line.indexOf("time") > -1) {
                            begin = this.extractLong(line, eqPos);
                            continue;
                        }
                        if (line.indexOf("mark") <= -1) continue;
                        annValue = this.extractTextValue(line, eqPos);
                        inPoints = false;
                        record = new AnnotationDataRecord(tierName, annValue, begin, begin + (long)this.pointDuration);
                        records.add(record);
                        annValue = "";
                        begin = -1L;
                        continue;
                    }
                    if (line.indexOf("points") >= 0 && line.indexOf(91) > "points".length()) {
                        inPoints = true;
                        continue;
                    }
                    if (line.indexOf("item") < 0 || line.indexOf(91) <= "item".length()) continue;
                    inTextTier = false;
                    inPoints = false;
                    continue;
                }
                if (eqPos > 0) {
                    if (!inInterval && line.indexOf("name") >= 0 && line.indexOf("name") < eqPos) {
                        tierName = this.extractTierName(line, eqPos);
                        if (!this.annotationMap.containsKey(tierName)) {
                            this.annotationMap.put(tierName, records);
                            this.tierNames.add(tierName);
                            LOG.info("Tier detected: " + tierName);
                            continue;
                        }
                        nextName = "";
                        for (count = 2; count < 50; ++count) {
                            nextName = tierName + "-" + count;
                            if (this.annotationMap.containsKey(nextName)) continue;
                            this.annotationMap.put(nextName, records);
                            this.tierNames.add(nextName);
                            LOG.info("Tier detected: " + tierName + " and renamed to: " + nextName);
                            continue block5;
                        }
                        continue;
                    }
                    if (!inInterval) continue;
                    if (line.indexOf("xmin") > -1) {
                        begin = this.extractLong(line, eqPos);
                        continue;
                    }
                    if (line.indexOf("xmax") > -1) {
                        end = this.extractLong(line, eqPos);
                        continue;
                    }
                    if (line.indexOf("text") <= -1) continue;
                    annValue = this.extractTextValue(line, eqPos);
                    inInterval = false;
                    record = new AnnotationDataRecord(tierName, annValue, begin, end);
                    records.add(record);
                    annValue = "";
                    begin = -1L;
                    end = -1L;
                    continue;
                }
                if (line.indexOf("intervals") >= 0 && line.indexOf(91) > "intervals".length()) {
                    inInterval = true;
                    continue;
                }
                if (line.indexOf("item") < 0 || line.indexOf(91) <= "item".length()) continue;
                inTier = false;
                inInterval = false;
            }
            reader.close();
        }
        catch (IOException ioe) {
            if (reader != null) {
                reader.close();
            }
            throw ioe;
        }
        catch (Exception fe) {
            if (reader != null) {
                reader.close();
            }
            throw new IOException("Error occurred while reading the file: " + fe.getMessage());
        }
    }

    private String extractTierName(String line, int eqPos) {
        if (line.length() > eqPos + 1) {
            String name = line.substring(eqPos + 1).trim();
            if (name.length() < 3) {
                if ("\"\"".equals(name)) {
                    return "Noname";
                }
                return name;
            }
            return this.removeQuotes(name);
        }
        return line;
    }

    private String extractTextValue(String value, int eqPos) {
        if (value.length() > eqPos + 1) {
            String rawV = this.removeQuotes(value.substring(eqPos + 1).trim());
            if (this.lookUp == null) {
                this.lookUp = new PraatSpecialChars();
            }
            if ((rawV = this.lookUp.replaceIllegalXMLChars(rawV)).indexOf(92) > -1) {
                return this.lookUp.convertSpecialChars(rawV);
            }
            return rawV;
        }
        return "";
    }

    private long extractLong(String value, int eqPos) {
        if (value.length() > eqPos + 1) {
            String v = value.substring(eqPos + 1).trim();
            long l = -1L;
            try {
                Double d = new Double(v);
                l = Math.round(d * 1000.0);
            }
            catch (NumberFormatException nfe) {
                LOG.warning("Not a valid numeric value: " + value);
            }
            return l;
        }
        return -1L;
    }

    private String removeQuotes(String value) {
        if (value.charAt(0) == '\"') {
            if (value.charAt(value.length() - 1) == '\"' && value.length() > 1) {
                return value.substring(1, value.length() - 1);
            }
            return value.substring(1);
        }
        if (value.charAt(value.length() - 1) == '\"') {
            return value.substring(0, value.length() - 1);
        }
        return value;
    }
}

