/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.integration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.integration.IMDISessionParser;
import mpi.util.LogUtil;
import org.xml.sax.SAXException;

public class ExternalLauncher {
    private static final Logger LOG = Logger.getLogger(ExternalLauncher.class.getName());
    private static String exchangeFile = "externallaunch";
    private static final String IMDI_SESSION = "IMDI_Session: ";
    private static File launchFile;
    private static FileReader reader;
    private static ExternalLauncher externalLauncher;
    private static LaunchThread launchThread;
    private static long lastModified;
    private static boolean running;

    private ExternalLauncher() {
        ExternalLauncher.init();
    }

    public static void start() {
        if (externalLauncher == null) {
            externalLauncher = new ExternalLauncher();
            LOG.info("External launch thread started...");
        }
    }

    public static void stop() {
        running = false;
        if (launchThread != null && launchThread.isAlive()) {
            try {
                launchThread.interrupt();
            }
            catch (SecurityException se) {
                LOG.warning("Could not stop the launch thread.\n" + LogUtil.formatStackTrace((Throwable)se));
            }
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException ioe) {
                LOG.warning("Could not close the file: " + launchFile.getAbsolutePath() + "\n" + LogUtil.formatStackTrace((Throwable)ioe));
            }
        }
        if (launchFile != null) {
            try {
                launchFile.delete();
            }
            catch (SecurityException se) {
                LOG.warning("Could not delete the file: " + launchFile.getAbsolutePath() + "\n" + LogUtil.formatStackTrace((Throwable)se));
            }
        }
        LOG.info("External launch thread stopped...");
    }

    public static void start(String exchangeFileName) {
        if (externalLauncher == null) {
            if (exchangeFileName != null && exchangeFileName.length() > 0) {
                exchangeFile = exchangeFileName;
            }
            externalLauncher = new ExternalLauncher();
        }
    }

    private static void init() {
        launchFile = new File(Constants.ELAN_DATA_DIR, exchangeFile);
        if (launchFile.exists()) {
            launchFile.deleteOnExit();
        }
        launchThread = new LaunchThread(1000);
        launchThread.setPriority(1);
        running = true;
        launchThread.start();
    }

    private static void checkChange() {
        if (!running) {
            return;
        }
        if (launchFile == null || !launchFile.exists()) {
            return;
        }
        if (lastModified == 0L || lastModified < launchFile.lastModified()) {
            try {
                reader = new FileReader(launchFile);
                char[] ch = new char[(int)launchFile.length()];
                reader.read(ch);
                String line = new String(ch);
                if (line != null) {
                    ExternalLauncher.openElanFrame(line);
                    lastModified = launchFile.lastModified();
                }
                reader.close();
            }
            catch (FileNotFoundException fnfe) {
                LOG.severe("Could not read file: \n" + launchFile.getAbsolutePath() + LogUtil.formatStackTrace((Throwable)fnfe));
            }
            catch (IOException ioe) {
                LOG.severe("Error reading file: \n" + launchFile.getAbsolutePath() + LogUtil.formatStackTrace((Throwable)ioe));
            }
        }
    }

    private static void openElanFrame(String line) {
        String IMDIString;
        if (line == null) {
            return;
        }
        if (line.startsWith(IMDI_SESSION) && (IMDIString = line.substring(IMDI_SESSION.length())).length() > 0) {
            IMDIString = ExternalLauncher.pathToURLString(IMDIString);
            IMDISessionParser parser = new IMDISessionParser();
            HashMap filesMap = null;
            try {
                parser.parse(IMDIString);
                filesMap = parser.getFilesMap();
            }
            catch (IOException ioe) {
                LOG.warning("Could not access the .imdi file\n" + LogUtil.formatStackTrace((Throwable)ioe));
                ExternalLauncher.showWarningDialog("Elan launcher:\nCould not access the imdi file.");
                return;
            }
            catch (SAXException sax) {
                LOG.warning("Could not parse the .imdi file\n" + LogUtil.formatStackTrace((Throwable)sax));
                ExternalLauncher.showWarningDialog("Elan launcher:\nCould not parse the imdi file.");
                return;
            }
            if (filesMap != null) {
                String eafString = (String)filesMap.get("text/x-eaf+xml");
                if (eafString == null || !eafString.toLowerCase().endsWith(".eaf")) {
                    LOG.warning("No .eaf file found");
                    ExternalLauncher.showWarningDialog("Elan launcher:\nNo eaf file found in the imdi file.");
                    return;
                }
                eafString = ExternalLauncher.absolutePath(IMDIString, eafString);
                LOG.info("Launching: " + eafString);
                String videoString = (String)filesMap.get("video");
                String audioString = (String)filesMap.get("audio");
                Vector<String> mediaFiles = new Vector<String>();
                if (videoString != null) {
                    mediaFiles.add(ExternalLauncher.absolutePath(IMDIString, videoString));
                }
                if (audioString != null) {
                    mediaFiles.add(ExternalLauncher.absolutePath(IMDIString, audioString));
                }
                FrameManager.getInstance().createFrame(eafString, mediaFiles);
            }
        }
    }

    private static String pathToURLString(String path) {
        String pathURL = path.replace('\\', '/');
        boolean isFileURL = pathURL.startsWith("file:");
        if (isFileURL) {
            pathURL = pathURL.substring(5);
            int n = 0;
            while (pathURL.charAt(0) == '/') {
                pathURL = pathURL.substring(1);
                ++n;
            }
            if (n == 2) {
                if (pathURL.charAt(1) == ':') {
                    return "file:///" + pathURL;
                }
                return "file://" + pathURL;
            }
            return "file:///" + pathURL;
        }
        return pathURL;
    }

    private static String absolutePath(String fromDoc, String fileName) {
        if (fileName == null) {
            return null;
        }
        fileName = fileName.replace('\\', '/');
        URI fileUri = null;
        fileUri = new URI(fileName);
        if (fileUri.isAbsolute()) {
            String resString = fileUri.toString();
            if (resString.startsWith("file:") || resString.startsWith("//")) {
                return fileUri.getSchemeSpecificPart();
            }
            return resString;
        }
        if (fromDoc == null) {
            return fileUri.getSchemeSpecificPart();
        }
        URI baseUri = null;
        try {
            baseUri = new URI(fromDoc);
            fileUri = new URI(ExternalLauncher.stripLeadingSlashes(fileName));
            URI resolved = baseUri.resolve(fileUri.getSchemeSpecificPart());
            String resString = resolved.toString();
            if (resString.startsWith("file:") || resString.startsWith("//")) {
                return resolved.getSchemeSpecificPart();
            }
            return resString;
        }
        catch (URISyntaxException ue) {
            try {
                LOG.warning("URI: no context for relative file path\n" + LogUtil.formatStackTrace((Throwable)ue));
                return fileUri.getSchemeSpecificPart();
            }
            catch (URISyntaxException ue2) {
                LOG.warning("URI: invalid file path\n" + LogUtil.formatStackTrace((Throwable)ue2));
                return null;
            }
        }
    }

    private static String stripLeadingSlashes(String in) {
        if (in == null) {
            return null;
        }
        String strip = in;
        while (strip.charAt(0) == '/') {
            strip = strip.substring(1);
        }
        return strip;
    }

    private static void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(null, message, "Warning", 2);
    }

    public void finalize() {
        ExternalLauncher.stop();
    }

    static {
        lastModified = 0L;
        running = false;
    }

    private static class TestLauncher
    extends Thread {
        final int num = 1;

        private TestLauncher() {
        }

        public void run() {
            for (int i = 0; i < 1; ++i) {
                try {
                    TestLauncher.sleep(5000L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                try {
                    boolean success;
                    File launchFl = new File(Constants.ELAN_DATA_DIR, exchangeFile);
                    if (!launchFl.exists() && !(success = launchFl.createNewFile())) {
                        LOG.severe("Could not create file: " + launchFl.getAbsolutePath());
                        return;
                    }
                    FileWriter writer = new FileWriter(launchFl);
                    writer.write("IMDI_Session: file:/D:/Dev_MPI/resources/testdata/elan/test.imdi");
                    writer.close();
                    continue;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static class LaunchThread
    extends Thread {
        private int delay;

        LaunchThread(int delay) {
            this.delay = delay;
        }

        public void run() {
            while (running) {
                ExternalLauncher.checkChange();
                try {
                    LaunchThread.sleep(this.delay);
                }
                catch (InterruptedException ie) {
                    LOG.info("Launch thread interrupted...");
                }
            }
        }
    }
}

