/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import mpi.eudico.client.annotator.interlinear.Interlinear;
import mpi.eudico.client.annotator.interlinear.InterlinearAnnotation;
import mpi.eudico.client.annotator.interlinear.InterlinearBlock;
import mpi.eudico.client.annotator.interlinear.InterlinearTier;
import mpi.eudico.server.corpora.clom.Tier;

public class HTMLRenderer {
    private final String NEW_LINE = "\n";
    private final String BREAK = "<br>";
    private final String NBSP = "&nbsp;";
    private Interlinear interlinear;
    private HashMap tierMap;

    public HTMLRenderer(Interlinear interlinear) {
        this.interlinear = interlinear;
        this.tierMap = new HashMap();
    }

    public void renderToFile(File outFile) throws IOException, FileNotFoundException {
        this.renderToFile(outFile, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderToFile(File outFile, String charEncoding) throws IOException, FileNotFoundException {
        if (this.interlinear == null) {
            throw new NullPointerException("Interlinear object is null");
        }
        if (outFile == null) {
            throw new NullPointerException("Export file is null");
        }
        this.tierMap.clear();
        for (int i = 0; i < this.interlinear.getVisibleTiers().size(); ++i) {
            Tier ti = (Tier)this.interlinear.getVisibleTiers().get(i);
            this.tierMap.put(ti.getName(), "ti-" + i);
        }
        BufferedWriter writer = null;
        try {
            FileOutputStream out = new FileOutputStream(outFile);
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter((OutputStream)out, charEncoding);
            }
            catch (UnsupportedCharsetException uce) {
                osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
            }
            writer = new BufferedWriter(osw);
            this.writeHTMLHeader(writer);
            this.writeBlocks(writer);
            this.writeFooter(writer);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception ee) {}
        }
    }

    public String renderToText() {
        this.tierMap.clear();
        for (int i = 0; i < this.interlinear.getVisibleTiers().size(); ++i) {
            Tier ti = (Tier)this.interlinear.getVisibleTiers().get(i);
            this.tierMap.put(ti.getName(), "ti-" + i);
        }
        StringWriter writer = new StringWriter(10000);
        try {
            this.writePreviewHTML(writer);
        }
        catch (IOException ioe) {
            return writer.toString();
        }
        return writer.toString();
    }

    private void writeHTMLHeader(Writer writer) throws IOException {
        writer.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n\"http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd\">");
        writer.write("\n");
        writer.write("<html>\n<head>\n");
        writer.write("<meta http-equiv=\"content-type\" content=\"text/html;charset=utf-8\">\n");
        writer.write("<title>" + this.interlinear.getTranscription().getName() + "</title>" + "\n");
        this.writeStyles(writer);
        writer.write("</head>\n");
        writer.write("<body>\n");
        writer.write("<h3>");
        writer.write(this.interlinear.getTranscription().getFullPath());
        writer.write("</h3>");
        writer.write("\n");
        writer.write("<p>");
        writer.write(DateFormat.getDateTimeInstance(0, 3, Locale.getDefault()).format(new Date(System.currentTimeMillis())));
        writer.write("</p>");
        writer.write("\n");
        writer.write("\n");
        writer.write("<table class=\"out\">");
        writer.write("\n");
    }

    private void writeStyles(Writer writer) throws IOException {
        writer.write("<style type=\"text/css\" media=\"screen\"><!--\n");
        writer.write("body {\n");
        writer.write("background-color: #FFFFF2;\n");
        writer.write("font-family: \"Arial Unicode MS\", Verdana, Helvetica, sans-serif;\n");
        writer.write("font-weight: normal;\n");
        writer.write("font-size: 12px;\n");
        writer.write("color: #000000;\n");
        writer.write("line-height: 15px;\n");
        writer.write("font-style: normal;\n");
        writer.write("}\n");
        writer.write("table {\n");
        writer.write("width: auto; /* change to 100% to horizontally stretch the table */\n");
        writer.write("border-collapse: collapse;\n");
        writer.write("border: 1px solid #666666;\n");
        writer.write("}\n");
        writer.write("table.out {\n");
        writer.write("border: 0px;\n");
        writer.write("width: 100%;\n");
        writer.write("}\n");
        writer.write("tr {\n");
        writer.write("border-collapse: collapse;\n");
        writer.write("border: 1px solid #dddddd;\n");
        writer.write("}\n");
        writer.write("tr.out {\n");
        writer.write("border: 0px;\n");
        writer.write("}\n");
        writer.write("td {\n");
        writer.write("padding: 2px 8px 2px 2px;\n");
        writer.write("border-collapse: collapse;\n");
        writer.write("border: 1px solid #666666;\n");
        writer.write("}\n");
        writer.write("td.out {\n");
        writer.write("border: 0px;\n");
        writer.write("}\n");
        writer.write("td.label {\n");
        writer.write("width: " + (int)(1.2 * (double)this.interlinear.getMetrics().getLeftMargin()) + ";" + "\n");
        writer.write("font-family: \"Arial Unicode MS\", Verdana, Helvetica, sans-serif;\n");
        writer.write("font-weight: bold;\n");
        writer.write("font-size: 12px;\n");
        writer.write("color: #444444;\n");
        writer.write("}\n");
        writer.write("td.tclabel {\n");
        writer.write("width: " + (int)(1.2 * (double)this.interlinear.getMetrics().getLeftMargin()) + ";" + "\n");
        writer.write("font-family: \"Arial Unicode MS\", Verdana, Helvetica, sans-serif;\n");
        writer.write("font-size: 11px;\n");
        writer.write("font-weight: bold;\n");
        writer.write("color: #9E001C;\n");
        writer.write("}\n");
        writer.write("td.tc {\n");
        writer.write("font-family: \"Arial Unicode MS\", Verdana, Helvetica, sans-serif;\n");
        writer.write("font-size: 11px;\n");
        writer.write("font-weight: bold;\n");
        writer.write("color: #9E001C;\n");
        writer.write("}\n");
        writer.write("td.hide {\n");
        writer.write("border: 0px;\n");
        writer.write("}\n");
        writer.write("/* a style class for each visible tier */\n");
        Set keys = this.tierMap.keySet();
        for (String key : keys) {
            String val = (String)this.tierMap.get(key);
            writer.write("tr." + val + " { " + "/* " + key + " */" + "\n");
            writer.write("font-family: \"" + this.interlinear.getFont(key).getName() + "\";" + "\n");
            writer.write("font-size: " + this.interlinear.getFontSize(key) + "px;" + "\n");
            writer.write("}\n");
        }
        writer.write("--></style>");
        writer.write("\n");
    }

    private void writeBlocks(Writer writer) throws IOException {
        ArrayList blocks = this.interlinear.getMetrics().getPrintBlocks();
        InterlinearBlock printBlock = null;
        for (int i = 0; i < blocks.size(); ++i) {
            printBlock = (InterlinearBlock)blocks.get(i);
            writer.write("<tr class=\"out\"><td class=\"out\">\n");
            this.writeBlock(writer, printBlock);
            writer.write("</td></tr>\n");
            writer.write("<tr class=\"out\"><td class=\"out\">&nbsp;");
            for (int j = 0; j < this.interlinear.getBlockSpacing(); ++j) {
                writer.write("<br>");
            }
            writer.write("</td></tr>\n");
        }
    }

    private void writeBlock(Writer writer, InterlinearBlock block) throws IOException {
        InterlinearTier it = null;
        InterlinearAnnotation ia = null;
        writer.write("<table>\n");
        for (int i = 0; i < block.getPrintTiers().size(); ++i) {
            it = (InterlinearTier)block.getPrintTiers().get(i);
            writer.write("<tr class=\"" + (String)this.tierMap.get(it.getTierName()) + "\">");
            if (it.isTimeCode()) {
                writer.write("<td class=\"tclabel\">");
                writer.write(this.interlinear.getMetrics().TC_TIER_NAME);
            }
            if (it.isSilDuration()) {
                writer.write("<td class=\"sdlabel\">");
                writer.write(this.interlinear.getMetrics().SD_TIER_NAME);
            } else {
                writer.write("<td class=\"label\">");
                writer.write(it.getTierName());
            }
            writer.write("</td>");
            for (int j = 0; j < it.getAnnotations().size(); ++j) {
                ia = (InterlinearAnnotation)it.getAnnotations().get(j);
                if (ia.hidden) {
                    writer.write("<td colspan=\"" + ia.colSpan + "\" class=\"hide\">" + "</td>");
                    continue;
                }
                if (it.isTimeCode()) {
                    writer.write("<td colspan=\"" + ia.colSpan + "\" class=\"tc\">" + ia.getValue() + "</td>");
                    continue;
                }
                if (it.isSilDuration()) {
                    writer.write("<td colspan=\"" + ia.colSpan + "\" class=\"sd\">" + ia.getValue() + "</td>");
                    continue;
                }
                if (ia.nrOfLines == 1) {
                    writer.write("<td colspan=\"" + ia.colSpan + "\">" + ia.getValue() + "</td>");
                    continue;
                }
                writer.write("<td colspan=\"" + ia.colSpan + "\">");
                for (int k = 0; k < ia.nrOfLines; ++k) {
                    writer.write(ia.getLines()[k]);
                    if (k >= ia.nrOfLines - 1) continue;
                    writer.write("<br>");
                }
                writer.write("</td>");
            }
            writer.write("</tr>\n");
        }
        writer.write("</table>\n");
    }

    private void writeFooter(Writer writer) throws IOException {
        writer.write("</table>\n");
        writer.write("</body>\n");
        writer.write("</html>");
    }

    private void writePreviewHTML(Writer writer) throws IOException {
        writer.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n\"http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd\">");
        writer.write("\n");
        writer.write("<html>\n<head>\n");
        writer.write("<title>" + this.interlinear.getTranscription().getName() + "</title>" + "\n");
        writer.write("</head>\n");
        writer.write("<body style=\"background-color: #FFFFF2; font-family: \"Arial Unicode MS\", Verdana, Helvetica, sans-serif;\">\n");
        writer.write("<h4 style=\"color: #ff0000\">");
        writer.write("NOTE: this preview may differ considerably from the appearance in most modern browsers!");
        writer.write("</h4>");
        writer.write("<h3>");
        writer.write(this.interlinear.getTranscription().getFullPath());
        writer.write("</h3>");
        writer.write("\n");
        writer.write("<p>");
        writer.write(DateFormat.getDateTimeInstance(0, 3, Locale.getDefault()).format(new Date(System.currentTimeMillis())));
        writer.write("</p>\n");
        writer.write("<table width=\"100%\" border=\"0px\">\n");
        ArrayList blocks = this.interlinear.getMetrics().getPrintBlocks();
        InterlinearBlock printBlock = null;
        for (int i = 0; i < blocks.size(); ++i) {
            printBlock = (InterlinearBlock)blocks.get(i);
            writer.write("<tr border=\"0px\"><td border=\"0px\">\n");
            this.writePreviewBlock(writer, printBlock);
            writer.write("</td></tr>\n");
            writer.write("<tr border=\"0px\"><td border=\"0px\">&nbsp;");
            for (int j = 0; j < this.interlinear.getBlockSpacing(); ++j) {
                writer.write("<br>");
            }
            writer.write("</td></tr>\n");
        }
        writer.write("</table>\n");
        writer.write("\n");
        writer.write("</body>\n");
        writer.write("</html>");
    }

    private void writePreviewBlock(Writer writer, InterlinearBlock block) throws IOException {
        InterlinearTier it = null;
        InterlinearAnnotation ia = null;
        writer.write("<table width=\"auto\" border=\"1px\" style=\"border-color: #666666; border-collapse: collapse; border-style: solid;\">\n");
        for (int i = 0; i < block.getPrintTiers().size(); ++i) {
            it = (InterlinearTier)block.getPrintTiers().get(i);
            writer.write("<tr border=\"1px\" style=\"font-size: " + this.interlinear.getFontSize(it.getTierName()) + "px; border-color: #dddddd; border-collapse: collapse; border-style: solid;\">");
            if (it.isTimeCode()) {
                writer.write("<td border=\"1px\" width=\"" + (int)(1.2 * (double)this.interlinear.getMetrics().getLeftMargin()) + "\"" + " style=\"font-weight: bold; border-color: #666666; border-collapse: collapse; border-style: solid; font-size: 10px; color: #9E001C;\">");
                writer.write(this.interlinear.getMetrics().TC_TIER_NAME);
            } else if (it.isSilDuration()) {
                writer.write("<td border=\"1px\" width=\"" + (int)(1.2 * (double)this.interlinear.getMetrics().getLeftMargin()) + "\"" + " style=\"font-weight: bold; border-color: #666666; border-collapse: collapse; border-style: solid; font-size: 10px; color: #9E001C;\">");
                writer.write(this.interlinear.getMetrics().SD_TIER_NAME);
            } else {
                writer.write("<td border=\"1px\" width=\"" + (int)(1.2 * (double)this.interlinear.getMetrics().getLeftMargin()) + "\"" + " style=\"font-weight: bold; border-color: #666666; border-collapse: collapse; border-style: solid; font-size: 12px; color: #444444;\">");
                writer.write(it.getTierName());
            }
            writer.write("</td>");
            for (int j = 0; j < it.getAnnotations().size(); ++j) {
                ia = (InterlinearAnnotation)it.getAnnotations().get(j);
                if (ia.hidden) {
                    writer.write("<td colspan=\"" + ia.colSpan + "\" border=\"1px\"" + " style=\"border-color: #dddddd; border-collapse: collapse; border-style: solid;\">" + "</td>");
                    continue;
                }
                if (it.isTimeCode()) {
                    writer.write("<td colspan=\"" + ia.colSpan + "\" border=\"1px\"" + " style=\"font-weight: bold; border-color: #666666; border-collapse: collapse; border-style: solid; font-size: 10px; color: #9E001C;\">" + ia.getValue() + "</td>");
                    continue;
                }
                if (it.isSilDuration()) {
                    writer.write("<td colspan=\"" + ia.colSpan + "\" border=\"1px\"" + " style=\"font-weight: bold; border-color: #666666; border-collapse: collapse; border-style: solid; font-size: 10px; color: #9E001C;\">" + ia.getValue() + "</td>");
                    continue;
                }
                if (ia.nrOfLines == 1) {
                    writer.write("<td colspan=\"" + ia.colSpan + "\" border=\"1px\"" + " style=\"border-color: #666666; border-collapse: collapse; border-style: solid;\">" + ia.getValue() + "</td>");
                    continue;
                }
                writer.write("<td colspan=\"" + ia.colSpan + "\" border=\"1px\"" + " style=\"border-color: #666666; border-collapse: collapse; border-style: solid;\">");
                for (int k = 0; k < ia.nrOfLines; ++k) {
                    writer.write(ia.getLines()[k]);
                    if (k >= ia.nrOfLines - 1) continue;
                    writer.write("<br>");
                }
                writer.write("</td>");
            }
            writer.write("</tr>\n");
        }
        writer.write("</table>\n");
    }
}

