/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.PrintCommand;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.TextExportFileChooser;
import mpi.eudico.client.annotator.interlinear.CharacterRenderer;
import mpi.eudico.client.annotator.interlinear.HTMLRenderer;
import mpi.eudico.client.annotator.interlinear.Interlinear;
import mpi.eudico.client.annotator.interlinear.PreviewPanel;
import mpi.eudico.client.annotator.interlinear.TierFontSizeDlg;
import mpi.eudico.client.annotator.tier.TierExportTableModel;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.client.util.TierSorter;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class InterlinearPreviewDlg
extends ClosableDialog
implements ActionListener,
ListSelectionListener,
ItemListener {
    private Interlinear interlinearizer;
    private int curSortMode;
    private PreviewPanel previewPanel;
    private JPanel optionsPanel;
    private JPanel whatPanel;
    private JPanel tierSelectionPanel;
    private JPanel howPanel;
    private JPanel buttonPanel;
    private JTable tierTable;
    private TierExportTableModel model;
    private JButton fontSizesButton;
    private JButton upButton;
    private JButton downButton;
    private JCheckBox selectionOnlyCheckBox;
    private JCheckBox showTierLabelCheckBox;
    private JCheckBox showTimeCodeCheckBox;
    private JComboBox timeCodeFormatComboBox;
    private JCheckBox showEmptySlotsCheckBox;
    private JRadioButton hideLinesRadioButton;
    private JRadioButton tierTemplateRadioButton;
    private JCheckBox showPageNumberCB;
    private JCheckBox silenceCB;
    private JComboBox silenceDecimalComboBox;
    private JTextField minDurSilTF;
    private JLabel minDurSilLabel;
    private JLabel silDecimalLabel;
    private JLabel widthLabel;
    private JTextField widthTextField;
    private JLabel heightLabel;
    private JTextField heightTextField;
    private JLabel blockWrapLabel;
    private JComboBox blockWrapComboBox;
    private JLabel lineWrapLabel;
    private JCheckBox lineWrapCheckBox;
    private JLabel sortingLabel;
    private JComboBox sortingComboBox;
    private JLabel lineSpacingLabel;
    private JTextField lineSpacingTextField;
    private JLabel blockSpacingLabel;
    private JTextField blockSpacingTextField;
    private JCheckBox insertTabCheckBox;
    private JButton applyChangesButton;
    private JButton printButton;
    private JButton pageSetupButton;
    private String tcStyleHhMmSsMs;
    private String tcStyleSsMs;
    private String tcStyleMs;
    private String blockWrapNone;
    private String blockWrapWithinBlock;
    private String blockWrapBlockBoundary;
    private String blockWrapEachBlock;
    private String sortingAsFile;
    private String sortingTierHierarchy;
    private String sortingLinguisticType;
    private String sortingParticipant;
    private String charEncoding = "UTF-8";
    private final String PRINT_COLUMN = "export";
    private final String TIER_NAME_COLUMN = "tier";
    private final String FONT_SIZE_COLUMN = "fontsize";

    public InterlinearPreviewDlg(Frame frame, boolean modal, Interlinear interlinearizer) {
        super(frame, modal);
        this.interlinearizer = interlinearizer;
        this.initComponents();
        this.setDefaultValues();
        this.extractTiers();
        this.doApplyChanges();
        this.postInit();
    }

    protected void initComponents() {
        this.previewPanel = new PreviewPanel(this.interlinearizer);
        this.optionsPanel = new JPanel();
        this.tierSelectionPanel = new JPanel();
        this.whatPanel = new JPanel();
        this.howPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.fontSizesButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.selectionOnlyCheckBox = new JCheckBox();
        this.showTierLabelCheckBox = new JCheckBox();
        this.showTimeCodeCheckBox = new JCheckBox();
        this.timeCodeFormatComboBox = new JComboBox();
        this.showEmptySlotsCheckBox = new JCheckBox();
        this.showEmptySlotsCheckBox.setEnabled(false);
        this.hideLinesRadioButton = new JRadioButton();
        this.tierTemplateRadioButton = new JRadioButton();
        this.showPageNumberCB = new JCheckBox();
        this.silenceCB = new JCheckBox();
        this.silenceDecimalComboBox = new JComboBox();
        this.silenceDecimalComboBox.addItem(1);
        this.silenceDecimalComboBox.addItem(2);
        this.silenceDecimalComboBox.addItem(3);
        this.minDurSilTF = new JTextField(4);
        this.minDurSilLabel = new JLabel();
        this.silDecimalLabel = new JLabel();
        this.widthLabel = new JLabel();
        this.widthTextField = new JTextField(4);
        this.heightLabel = new JLabel();
        this.heightTextField = new JTextField(4);
        this.blockWrapLabel = new JLabel();
        this.blockWrapComboBox = new JComboBox();
        this.lineWrapLabel = new JLabel();
        this.lineWrapCheckBox = new JCheckBox();
        this.sortingLabel = new JLabel();
        this.sortingComboBox = new JComboBox();
        this.lineSpacingLabel = new JLabel();
        this.lineSpacingTextField = new JTextField(2);
        this.blockSpacingLabel = new JLabel();
        this.blockSpacingTextField = new JTextField(2);
        this.applyChangesButton = new JButton();
        this.printButton = new JButton();
        if (this.interlinearizer.getOutputMode() == 100) {
            this.pageSetupButton = new JButton();
        }
        try {
            ImageIcon upIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Up16.gif"));
            ImageIcon downIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down16.gif"));
            this.upButton.setIcon(upIcon);
            this.downButton.setIcon(downIcon);
        }
        catch (Exception ex) {
            this.upButton.setText("Up");
            this.downButton.setText("Down");
        }
        this.model = new TierExportTableModel();
        this.model.setColumnIdentifiers(new String[]{"export", "tier", "fontsize"});
        this.tierTable = new JTable(this.model);
        Dimension tableDim = new Dimension(50, 100);
        this.tierTable.getColumn("export").setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.tierTable.getColumn("export").setCellRenderer(new CheckBoxTableCellRenderer());
        this.tierTable.getColumn("export").setMaxWidth(30);
        this.tierTable.getColumn("fontsize").setMaxWidth(30);
        this.tierTable.setShowVerticalLines(false);
        this.tierTable.setTableHeader(null);
        JScrollPane tierScrollPane = new JScrollPane(this.tierTable);
        tierScrollPane.setPreferredSize(tableDim);
        this.getContentPane().setLayout(new GridBagLayout());
        this.optionsPanel.setLayout(new GridBagLayout());
        this.tierSelectionPanel.setLayout(new GridBagLayout());
        this.whatPanel.setLayout(new GridBagLayout());
        this.howPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.previewPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 3;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.tierSelectionPanel.add((Component)tierScrollPane, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.anchor = 17;
        this.tierSelectionPanel.add((Component)this.upButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.anchor = 17;
        this.tierSelectionPanel.add((Component)this.downButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.anchor = 13;
        this.tierSelectionPanel.add((Component)this.fontSizesButton, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.optionsPanel.add((Component)this.tierSelectionPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 17;
        this.whatPanel.add((Component)this.selectionOnlyCheckBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.anchor = 17;
        this.whatPanel.add((Component)this.showTierLabelCheckBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = insets;
        gbc.anchor = 17;
        this.whatPanel.add((Component)this.showTimeCodeCheckBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(2, 150, 2, 2);
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.whatPanel.add((Component)this.timeCodeFormatComboBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = insets;
        gbc.anchor = 17;
        this.whatPanel.add((Component)this.showEmptySlotsCheckBox, gbc);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.hideLinesRadioButton);
        buttonGroup.add(this.tierTemplateRadioButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.insets = insets;
        gbc.anchor = 17;
        this.whatPanel.add((Component)this.hideLinesRadioButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.insets = insets;
        gbc.anchor = 17;
        this.whatPanel.add((Component)this.tierTemplateRadioButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.insets = insets;
        gbc.anchor = 17;
        this.whatPanel.add((Component)this.showPageNumberCB, gbc);
        this.silenceCB.addItemListener(this);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.insets = insets;
        gbc.anchor = 17;
        this.whatPanel.add((Component)this.silenceCB, gbc);
        this.minDurSilTF.setEnabled(false);
        this.minDurSilTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.insets = new Insets(2, 30, 2, 2);
        gbc.anchor = 17;
        this.whatPanel.add((Component)this.minDurSilTF, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.insets = new Insets(2, 100, 2, 2);
        gbc.anchor = 17;
        this.whatPanel.add((Component)this.minDurSilLabel, gbc);
        this.silenceDecimalComboBox.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 9;
        gbc.insets = new Insets(2, 30, 2, 2);
        gbc.anchor = 17;
        this.whatPanel.add((Component)this.silenceDecimalComboBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 9;
        gbc.insets = new Insets(2, 100, 2, 2);
        gbc.anchor = 17;
        this.whatPanel.add((Component)this.silDecimalLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.optionsPanel.add((Component)this.whatPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.anchor = 18;
        this.howPanel.add((Component)this.widthLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.howPanel.add((Component)this.widthTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.anchor = 18;
        this.howPanel.add((Component)this.heightLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.howPanel.add((Component)this.heightTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = insets;
        gbc.anchor = 18;
        this.howPanel.add((Component)this.blockWrapLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.howPanel.add((Component)this.blockWrapComboBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = insets;
        gbc.anchor = 18;
        this.howPanel.add((Component)this.lineWrapLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = insets;
        gbc.anchor = 18;
        this.howPanel.add((Component)this.lineWrapCheckBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.insets = insets;
        gbc.anchor = 18;
        this.howPanel.add((Component)this.sortingLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.howPanel.add((Component)this.sortingComboBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.insets = insets;
        gbc.anchor = 18;
        this.howPanel.add((Component)this.lineSpacingLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.howPanel.add((Component)this.lineSpacingTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.insets = insets;
        gbc.anchor = 18;
        this.howPanel.add((Component)this.blockSpacingLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.howPanel.add((Component)this.blockSpacingTextField, gbc);
        if (this.interlinearizer.getOutputMode() == 101) {
            this.insertTabCheckBox = new JCheckBox();
            this.insertTabCheckBox.addItemListener(this);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 7;
            gbc.gridwidth = 2;
            gbc.insets = insets;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.howPanel.add((Component)this.insertTabCheckBox, gbc);
        }
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.optionsPanel.add((Component)this.howPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        this.buttonPanel.add((Component)this.applyChangesButton, gbc);
        if (this.interlinearizer.getOutputMode() == 100) {
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.insets = insets;
            gbc.anchor = 18;
            this.buttonPanel.add((Component)this.pageSetupButton, gbc);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        this.buttonPanel.add((Component)this.printButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 3;
        gbc.insets = insets;
        gbc.anchor = 18;
        this.optionsPanel.add((Component)this.buttonPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 3;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.optionsPanel, gbc);
        this.updateForLocale();
        this.fontSizesButton.addActionListener(this);
        this.upButton.addActionListener(this);
        this.downButton.addActionListener(this);
        this.applyChangesButton.addActionListener(this);
        this.sortingComboBox.addItemListener(this);
        if (this.interlinearizer.getOutputMode() == 100) {
            this.printButton.addActionListener(this);
            this.pageSetupButton.addActionListener(this);
        } else if (this.interlinearizer.getOutputMode() == 101) {
            this.printButton.addActionListener(this);
            this.fontSizesButton.setEnabled(false);
            this.lineSpacingTextField.setEnabled(false);
        } else if (this.interlinearizer.getOutputMode() == 103) {
            this.printButton.addActionListener(this);
        }
        this.tierTable.getSelectionModel().addListSelectionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                InterlinearPreviewDlg.this.savePreferences();
                InterlinearPreviewDlg.this.interlinearizer.savePreferences();
            }
        });
    }

    protected void postInit() {
        this.pack();
        int w = 550;
        int h = 400;
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
    }

    private void setDefaultValues() {
        this.curSortMode = this.interlinearizer.getSortingStyle();
        this.selectionOnlyCheckBox.setSelected(this.interlinearizer.isSelectionOnly());
        this.showTierLabelCheckBox.setSelected(this.interlinearizer.isTierLabelsShown());
        this.showTimeCodeCheckBox.setSelected(this.interlinearizer.isTimeCodeShown());
        this.showPageNumberCB.setSelected(this.interlinearizer.isShowPageNumber());
        this.silenceCB.setSelected(this.interlinearizer.isShowSilenceDuration());
        this.silenceDecimalComboBox.setSelectedItem(this.interlinearizer.getNumOfDecimalDigits());
        this.minDurSilTF.setText(Integer.toString(this.interlinearizer.getMinSilenceDuration()));
        if (this.interlinearizer.getOutputMode() == 100) {
            this.showEmptySlotsCheckBox.setSelected(false);
            this.showEmptySlotsCheckBox.setEnabled(true);
        } else if (this.interlinearizer.getOutputMode() == 103) {
            this.showEmptySlotsCheckBox.setSelected(true);
            this.showEmptySlotsCheckBox.setEnabled(false);
            this.showPageNumberCB.setSelected(false);
            this.showPageNumberCB.setEnabled(false);
        } else {
            this.showEmptySlotsCheckBox.setSelected(false);
            this.showEmptySlotsCheckBox.setEnabled(false);
            this.showPageNumberCB.setSelected(false);
            this.showPageNumberCB.setEnabled(false);
        }
        if (this.interlinearizer.getEmptyLineStyle() == 1) {
            this.hideLinesRadioButton.setSelected(true);
        } else {
            this.tierTemplateRadioButton.setSelected(true);
        }
        if (this.interlinearizer.getBlockWrapStyle() == 1) {
            this.blockWrapComboBox.setSelectedItem(this.blockWrapBlockBoundary);
        } else if (this.interlinearizer.getBlockWrapStyle() == 0) {
            this.blockWrapComboBox.setSelectedItem(this.blockWrapEachBlock);
        } else if (this.interlinearizer.getBlockWrapStyle() == 3) {
            this.blockWrapComboBox.setSelectedItem(this.blockWrapNone);
        } else if (this.interlinearizer.getBlockWrapStyle() == 2) {
            this.blockWrapComboBox.setSelectedItem(this.blockWrapWithinBlock);
        }
        int initialWidth = this.interlinearizer.getWidth();
        int initialHeigth = this.interlinearizer.getHeight();
        if (initialWidth > 0) {
            this.widthTextField.setText("" + initialWidth);
        } else {
            this.widthTextField.setText("0");
        }
        if (initialHeigth > 0) {
            this.heightTextField.setText("" + initialHeigth);
        } else {
            this.heightTextField.setText("0");
        }
        int blockSpacing = this.interlinearizer.getBlockSpacing();
        if (blockSpacing > 0) {
            this.blockSpacingTextField.setText("" + blockSpacing);
        }
        if (this.interlinearizer.getOutputMode() == 100) {
            this.widthTextField.setEnabled(false);
            this.widthTextField.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            this.heightTextField.setEnabled(false);
            this.heightTextField.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        } else {
            this.heightTextField.setText("");
            this.heightTextField.setEnabled(false);
            this.heightTextField.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            this.lineSpacingTextField.setText("");
            this.lineSpacingTextField.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        }
        this.lineWrapCheckBox.setSelected(this.interlinearizer.getLineWrapStyle() == 4);
        if (this.interlinearizer.getOutputMode() == 101) {
            this.insertTabCheckBox.setSelected(this.interlinearizer.isInsertTabs());
        }
    }

    protected void extractTiers() {
        if (this.model != null) {
            for (int i = this.model.getRowCount() - 1; i >= 0; --i) {
                this.model.removeRow(i);
            }
            if (this.interlinearizer.getTranscription() != null) {
                TierImpl t;
                int i;
                Vector v = this.interlinearizer.getTranscription().getTiers();
                ArrayList visTiers = this.interlinearizer.getVisibleTiers();
                ArrayList sortedTiers = null;
                ArrayList<TierImpl> allTiers = new ArrayList<TierImpl>();
                Object sorted = Preferences.get(this.interlinearizer.prefTierOrder, this.interlinearizer.getTranscription());
                if (sorted instanceof ArrayList) {
                    sortedTiers = (ArrayList)sorted;
                    for (i = 0; i < sortedTiers.size(); ++i) {
                        t = (TierImpl)this.interlinearizer.getTranscription().getTierWithId((String)sortedTiers.get(i));
                        if (t == null) continue;
                        allTiers.add(t);
                    }
                }
                for (i = 0; i < v.size(); ++i) {
                    t = (TierImpl)v.get(i);
                    if (allTiers.contains(t)) continue;
                    allTiers.add(t);
                }
                for (i = 0; i < allTiers.size(); ++i) {
                    t = (TierImpl)allTiers.get(i);
                    String tierName = t.getName();
                    Integer fontSize = new Integer(this.interlinearizer.getFontSize(tierName));
                    this.model.addRow(new Object[]{new Boolean(visTiers.contains(t)), tierName, fontSize});
                }
            }
            if (this.model.getRowCount() > 1) {
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(true);
            } else {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    public void savePreferences() {
        ArrayList<String> allTiers = new ArrayList<String>();
        if (this.model != null) {
            String name = null;
            int tierCol = this.model.findColumn("tier");
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                name = (String)this.model.getValueAt(i, tierCol);
                allTiers.add(name);
            }
            Preferences.set(this.interlinearizer.prefTierOrder, allTiers, (Transcription)this.interlinearizer.getTranscription());
        }
    }

    private void updateForLocale() {
        this.setTitle(ElanLocale.getString("InterlinearizerOptionsDlg.Title"));
        this.tierSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("InterlinearizerOptionsDlg.Tiers")));
        this.whatPanel.setBorder(new TitledBorder(ElanLocale.getString("InterlinearizerOptionsDlg.What")));
        this.howPanel.setBorder(new TitledBorder(ElanLocale.getString("InterlinearizerOptionsDlg.How")));
        this.fontSizesButton.setText(ElanLocale.getString("InterlinearizerOptionsDlg.FontSizes"));
        this.selectionOnlyCheckBox.setText(ElanLocale.getString("InterlinearizerOptionsDlg.SelectionOnly"));
        this.showTierLabelCheckBox.setText(ElanLocale.getString("InterlinearizerOptionsDlg.ShowTierLabels"));
        this.showTimeCodeCheckBox.setText(ElanLocale.getString("InterlinearizerOptionsDlg.ShowTimeCode"));
        this.showEmptySlotsCheckBox.setText(ElanLocale.getString("InterlinearizerOptionsDlg.ShowEmptySlots"));
        this.tcStyleHhMmSsMs = ElanLocale.getString("TimeCodeFormat.TimeCode");
        this.tcStyleSsMs = ElanLocale.getString("TimeCodeFormat.Seconds");
        this.tcStyleMs = ElanLocale.getString("TimeCodeFormat.MilliSec");
        this.timeCodeFormatComboBox.addItem(this.tcStyleHhMmSsMs);
        this.timeCodeFormatComboBox.addItem(this.tcStyleSsMs);
        this.timeCodeFormatComboBox.addItem(this.tcStyleMs);
        this.hideLinesRadioButton.setText(ElanLocale.getString("InterlinearizerOptionsDlg.HideLines"));
        this.tierTemplateRadioButton.setText(ElanLocale.getString("InterlinearizerOptionsDlg.TierTemplate"));
        this.showPageNumberCB.setText(ElanLocale.getString("InterlinearizerOptionsDlg.ShowPageNumbers"));
        this.silenceCB.setText(ElanLocale.getString("InterlinearizerOptionsDlg.IncludeSilence"));
        this.minDurSilLabel.setText(ElanLocale.getString("InterlinearizerOptionsDlg.MinSilenceDuration"));
        this.silDecimalLabel.setText(ElanLocale.getString("InterlinearizerOptionsDlg.NumberofDigits"));
        this.widthLabel.setText(ElanLocale.getString("InterlinearizerOptionsDlg.Width"));
        this.heightLabel.setText(ElanLocale.getString("InterlinearizerOptionsDlg.Height"));
        this.blockWrapLabel.setText(ElanLocale.getString("InterlinearizerOptionsDlg.BlockWrap"));
        this.blockWrapNone = ElanLocale.getString("InterlinearizerOptionsDlg.BlockWrap.None");
        this.blockWrapWithinBlock = ElanLocale.getString("InterlinearizerOptionsDlg.BlockWrap.WithinBlock");
        this.blockWrapBlockBoundary = ElanLocale.getString("InterlinearizerOptionsDlg.BlockWrap.BlockBoundary");
        this.blockWrapEachBlock = ElanLocale.getString("InterlinearizerOptionsDlg.BlockWrap.EachBlock");
        this.blockWrapComboBox.addItem(this.blockWrapNone);
        this.blockWrapComboBox.addItem(this.blockWrapWithinBlock);
        this.blockWrapComboBox.addItem(this.blockWrapBlockBoundary);
        this.blockWrapComboBox.addItem(this.blockWrapEachBlock);
        this.lineWrapLabel.setText(ElanLocale.getString("InterlinearizerOptionsDlg.LineWrap"));
        this.sortingLabel.setText(ElanLocale.getString("InterlinearizerOptionsDlg.Sorting"));
        this.sortingAsFile = ElanLocale.getString("InterlinearizerOptionsDlg.Sorting.AsFile");
        this.sortingComboBox.addItem(this.sortingAsFile);
        this.sortingTierHierarchy = ElanLocale.getString("InterlinearizerOptionsDlg.Sorting.TierHierarchy");
        this.sortingComboBox.addItem(this.sortingTierHierarchy);
        this.sortingLinguisticType = ElanLocale.getString("InterlinearizerOptionsDlg.Sorting.ByType");
        this.sortingComboBox.addItem(this.sortingLinguisticType);
        this.sortingParticipant = ElanLocale.getString("InterlinearizerOptionsDlg.Sorting.ByParticipant");
        this.sortingComboBox.addItem(this.sortingParticipant);
        this.lineSpacingLabel.setText(ElanLocale.getString("InterlinearizerOptionsDlg.LineSpacing"));
        this.blockSpacingLabel.setText(ElanLocale.getString("InterlinearizerOptionsDlg.BlockSpacing"));
        if (this.insertTabCheckBox != null) {
            this.insertTabCheckBox.setText(ElanLocale.getString("InterlinearizerOptionsDlg.InsertTab"));
        }
        this.applyChangesButton.setText(ElanLocale.getString("InterlinearizerOptionsDlg.ApplyChanges"));
        if (this.interlinearizer.getOutputMode() == 100) {
            this.pageSetupButton.setText(ElanLocale.getString("Menu.File.PageSetup"));
            this.printButton.setText(ElanLocale.getString("Menu.File.Print"));
        } else {
            this.printButton.setText(ElanLocale.getString("Menu.File.SaveAs"));
        }
    }

    private void moveUp() {
        if (this.tierTable == null || this.model == null || this.model.getRowCount() < 2) {
            return;
        }
        int[] selected = this.tierTable.getSelectedRows();
        for (int i = 0; i < selected.length; ++i) {
            int row = selected[i];
            if (row <= 0 || this.tierTable.isRowSelected(row - 1)) continue;
            this.model.moveRow(row, row, row - 1);
            this.tierTable.changeSelection(row, 0, true, false);
            this.tierTable.changeSelection(row - 1, 0, true, false);
        }
    }

    private void moveDown() {
        if (this.tierTable == null || this.model == null || this.model.getRowCount() < 2) {
            return;
        }
        int[] selected = this.tierTable.getSelectedRows();
        for (int i = selected.length - 1; i >= 0; --i) {
            int row = selected[i];
            if (row >= this.model.getRowCount() - 1 || this.tierTable.isRowSelected(row + 1)) continue;
            this.model.moveRow(row, row, row + 1);
            this.tierTable.changeSelection(row, 0, true, false);
            this.tierTable.changeSelection(row + 1, 0, true, false);
        }
    }

    private void sortTiersTable() {
        if (this.tierTable == null || this.model == null || this.model.getRowCount() < 2) {
            return;
        }
        ArrayList<TierImpl> curOrder = new ArrayList<TierImpl>();
        String name = null;
        TierImpl t = null;
        int col = this.model.findColumn("tier");
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            name = (String)this.model.getValueAt(i, col);
            t = (TierImpl)this.interlinearizer.getTranscription().getTierWithId(name);
            curOrder.add(t);
        }
        TierSorter sorter = new TierSorter(this.interlinearizer.getTranscription());
        ArrayList newSort = null;
        switch (this.curSortMode) {
            case 0: {
                newSort = sorter.sortTiers(sorter.UNSORTED);
                break;
            }
            case 1: {
                newSort = sorter.sortTiers(sorter.BY_HIERARCHY, curOrder);
                break;
            }
            case 2: {
                newSort = sorter.sortTiers(sorter.BY_LINGUISTIC_TYPE, curOrder);
                break;
            }
            case 3: {
                newSort = sorter.sortTiers(sorter.BY_PARTICIPANT, curOrder);
                break;
            }
        }
        block7: for (int i = 0; i < newSort.size(); ++i) {
            t = (TierImpl)newSort.get(i);
            name = t.getName();
            for (int j = 0; j < this.model.getRowCount(); ++j) {
                String cellName = (String)this.model.getValueAt(j, col);
                if (cellName == null || !cellName.equals(name)) continue;
                this.model.moveRow(j, j, i);
                continue block7;
            }
        }
        this.tierTable.clearSelection();
    }

    private ArrayList getVisibleTierList() {
        ArrayList<TierImpl> vt = new ArrayList<TierImpl>();
        if (this.model != null) {
            String name = null;
            Boolean vis = null;
            TierImpl t = null;
            int tierCol = this.model.findColumn("tier");
            int visCol = this.model.findColumn("export");
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                vis = (Boolean)this.model.getValueAt(i, visCol);
                if (!vis.booleanValue()) continue;
                name = (String)this.model.getValueAt(i, tierCol);
                t = (TierImpl)this.interlinearizer.getTranscription().getTierWithId(name);
                vt.add(t);
            }
        }
        return vt;
    }

    private void applyFontSizes() {
        if (this.model != null) {
            String name = null;
            Integer size = null;
            int tierCol = this.model.findColumn("tier");
            int sizeCol = this.model.findColumn("fontsize");
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                name = (String)this.model.getValueAt(i, tierCol);
                size = (Integer)this.model.getValueAt(i, sizeCol);
                if (name == null || size == null || size.intValue() == this.interlinearizer.getFontSize(name)) continue;
                this.interlinearizer.setFontSize(name, size);
            }
        }
    }

    private void doSetFontSizes() {
        ArrayList<String> fontNames = new ArrayList<String>();
        HashMap<String, Integer> fontMap = new HashMap<String, Integer>();
        if (this.model != null) {
            int tierCol = this.model.findColumn("tier");
            int fontCol = this.model.findColumn("fontsize");
            String name = null;
            Integer size = null;
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                name = (String)this.model.getValueAt(i, tierCol);
                size = (Integer)this.model.getValueAt(i, fontCol);
                fontNames.add(name);
                fontMap.put(name, size);
            }
            TierFontSizeDlg dlg = new TierFontSizeDlg((Dialog)this, true, fontMap, fontNames);
            dlg.setLocationRelativeTo(this.tierTable);
            dlg.setVisible(true);
            Iterator tierIt = fontMap.keySet().iterator();
            name = null;
            size = null;
            block1: while (tierIt.hasNext()) {
                name = (String)tierIt.next();
                if (name == null || (size = (Integer)fontMap.get(name)) == null) continue;
                for (int i = 0; i < this.model.getRowCount(); ++i) {
                    Object ttName = this.model.getValueAt(i, tierCol);
                    if (!name.equals(ttName)) continue;
                    this.model.setValueAt(size, i, fontCol);
                    continue block1;
                }
            }
        }
    }

    private void doApplyChanges() {
        String tcStyleString;
        this.interlinearizer.setSelectionOnly(this.selectionOnlyCheckBox.isSelected());
        this.interlinearizer.setTierLabelsShown(this.showTierLabelCheckBox.isSelected());
        this.interlinearizer.setTimeCodeShown(this.showTimeCodeCheckBox.isSelected());
        this.interlinearizer.setShowPageNumber(this.showPageNumberCB.isSelected());
        this.interlinearizer.setShowSilenceDuration(this.silenceCB.isSelected());
        int minSilence = 20;
        if (this.silenceCB.isSelected()) {
            String textValue = this.minDurSilTF.getText().trim();
            try {
                minSilence = Integer.parseInt(textValue);
                int numOfDigits = Integer.parseInt(this.silenceDecimalComboBox.getSelectedItem().toString());
                this.interlinearizer.setMinSilenceDuration(minSilence);
                this.interlinearizer.setNumOfDecimalDigits(numOfDigits);
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("InterlinearizerOptionsDlg.Message.InvalidNumber"), ElanLocale.getString("Message.Warning"), 2);
                this.minDurSilTF.selectAll();
                this.minDurSilTF.requestFocus();
                return;
            }
        }
        if ((tcStyleString = (String)this.timeCodeFormatComboBox.getSelectedItem()).equals(this.tcStyleHhMmSsMs)) {
            this.interlinearizer.setTimeCodeType(0);
        } else if (tcStyleString.equals(this.tcStyleSsMs)) {
            this.interlinearizer.setTimeCodeType(1);
        } else if (tcStyleString.equals(this.tcStyleMs)) {
            this.interlinearizer.setTimeCodeType(2);
        }
        this.interlinearizer.setEmptySlotsShown(this.showEmptySlotsCheckBox.isSelected());
        if (this.hideLinesRadioButton.isSelected()) {
            this.interlinearizer.setEmptyLineStyle(1);
        } else {
            this.interlinearizer.setEmptyLineStyle(0);
        }
        int imageWidth = 0;
        if (this.interlinearizer.getOutputMode() == 100) {
            int pageWidth = new Double(PrintCommand.pageFormat.getImageableWidth()).intValue();
            this.widthTextField.setText(new Integer(pageWidth).toString());
            this.interlinearizer.setWidth(pageWidth);
            int pageHeight = new Double(PrintCommand.pageFormat.getImageableHeight()).intValue();
            this.heightTextField.setText("" + pageHeight);
            this.interlinearizer.setPageHeight(pageHeight);
        } else {
            String widthText = this.widthTextField.getText();
            try {
                imageWidth = Integer.parseInt(widthText);
                this.interlinearizer.setWidth(imageWidth);
            }
            catch (NumberFormatException nfe) {
                imageWidth = this.interlinearizer.getWidth();
                this.widthTextField.setText("" + imageWidth);
            }
        }
        if (this.lineWrapCheckBox.isSelected()) {
            this.interlinearizer.setLineWrapStyle(4);
        } else {
            this.interlinearizer.setLineWrapStyle(3);
        }
        String blockWrapString = (String)this.blockWrapComboBox.getSelectedItem();
        if (blockWrapString.equals(this.blockWrapNone)) {
            this.interlinearizer.setBlockWrapStyle(3);
        } else if (blockWrapString.equals(this.blockWrapWithinBlock)) {
            this.interlinearizer.setBlockWrapStyle(2);
        } else if (blockWrapString.equals(this.blockWrapBlockBoundary)) {
            this.interlinearizer.setBlockWrapStyle(1);
        } else if (blockWrapString.equals(this.blockWrapEachBlock)) {
            this.interlinearizer.setBlockWrapStyle(0);
        }
        String sortingString = (String)this.sortingComboBox.getSelectedItem();
        if (sortingString.equals(this.sortingAsFile)) {
            this.interlinearizer.setSortingStyle(0);
        } else if (sortingString.equals(this.sortingTierHierarchy)) {
            this.interlinearizer.setSortingStyle(1);
        } else if (sortingString.equals(this.sortingLinguisticType)) {
            this.interlinearizer.setSortingStyle(2);
        } else if (sortingString.equals(this.sortingParticipant)) {
            this.interlinearizer.setSortingStyle(3);
        }
        if (this.interlinearizer.getOutputMode() == 100) {
            int lineSpacing = 0;
            try {
                lineSpacing = Integer.parseInt(this.lineSpacingTextField.getText());
            }
            catch (NumberFormatException nfe) {
                this.lineSpacingTextField.setText("" + lineSpacing);
            }
            this.interlinearizer.setLineSpacing(lineSpacing);
        } else {
            this.lineSpacingTextField.setText("");
        }
        int blockSpacing = -1;
        try {
            blockSpacing = Integer.parseInt(this.blockSpacingTextField.getText());
        }
        catch (NumberFormatException nfe) {
            this.blockSpacingTextField.setText("" + this.interlinearizer.getBlockSpacing());
        }
        this.interlinearizer.setBlockSpacing(blockSpacing);
        this.interlinearizer.setVisibleTiers(this.getVisibleTierList());
        this.applyFontSizes();
        if (this.interlinearizer.getOutputMode() == 100) {
            this.interlinearizer.renderView(this.previewPanel.getBufferedImage());
            this.previewPanel.updateView();
        } else if (this.interlinearizer.getOutputMode() == 103) {
            this.interlinearizer.renderView(this.previewPanel.getBufferedImage());
            this.previewPanel.updateView();
        } else {
            this.interlinearizer.renderView();
            int pageWidth = 600;
            FontMetrics metrics = this.previewPanel.getBufferedImage().getGraphics().getFontMetrics(Interlinear.MONOSPACED_FONT);
            if (metrics != null) {
                int cw = metrics.charWidth('w');
                pageWidth = cw * this.interlinearizer.getWidth();
            }
            this.previewPanel.setImageableSize(new Dimension(pageWidth, this.interlinearizer.getHeight()));
            this.interlinearizer.drawViewOnImage(this.previewPanel.getBufferedImage(), this.previewPanel.getOffset());
            this.previewPanel.repaint();
        }
    }

    private void doPrint() {
        Command c = ELANCommandFactory.createCommand(null, "Menu.File.Print");
        c.execute(this.interlinearizer.getTranscription(), new Object[]{this.interlinearizer});
    }

    private void doSaveText() {
        String fileName = this.promptForFileName();
        if (fileName != null) {
            try {
                File exportFile = new File(fileName);
                CharacterRenderer render = new CharacterRenderer(this.interlinearizer, exportFile, this.charEncoding);
                render.renderText();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("InterlinearizerOptionsDlg.Error.TextOut") + " \n" + "(" + e.getMessage() + ")", ElanLocale.getString("Message.Error"), 2);
            }
        }
    }

    private void doSaveHTML() {
        String fileName = this.promptForHTMLFileName();
        if (fileName != null) {
            try {
                File exportFile = new File(fileName);
                HTMLRenderer render = new HTMLRenderer(this.interlinearizer);
                render.renderToFile(exportFile);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("InterlinearizerOptionsDlg.Error.TextOut") + " \n" + "(" + e.getMessage() + ")", ElanLocale.getString("Message.Error"), 2);
            }
        }
    }

    private void doPageSetup() {
        Command c = ELANCommandFactory.createCommand(null, "Menu.File.PageSetup");
        c.execute(this.interlinearizer.getTranscription(), null);
        this.doApplyChanges();
    }

    private String promptForFileName() {
        String exportDir = (String)Preferences.get("LastUsedExportDir", null);
        if (exportDir == null) {
            exportDir = System.getProperty("user.dir");
        }
        TextExportFileChooser chooser = new TextExportFileChooser();
        chooser.setCurrentDirectory(new File(exportDir));
        chooser.setDialogTitle(ElanLocale.getString("ExportDialog.ExportToFile"));
        File exportFile = null;
        FileFilter filter = ElanFileFilter.createFileFilter(11);
        chooser.setFileFilter(filter);
        if (chooser.showSaveDialog(null, null) == 0) {
            File curDir = chooser.getCurrentDirectory();
            if (curDir != null) {
                Preferences.set("LastUsedExportDir", curDir.getAbsolutePath(), null);
            }
            if ((exportFile = chooser.getSelectedFile()) != null) {
                this.charEncoding = chooser.getSelectedEncoding();
                String name = exportFile.getAbsolutePath();
                String lowerPathName = name.toLowerCase();
                String[] exts = FileExtension.TEXT_EXT;
                boolean validExt = false;
                for (int i = 0; i < exts.length; ++i) {
                    if (!lowerPathName.endsWith("." + exts[i])) continue;
                    validExt = true;
                    break;
                }
                if (!validExt) {
                    name = name + "." + exts[0];
                    exportFile = new File(name);
                }
                if (exportFile.exists()) {
                    int answer = JOptionPane.showConfirmDialog(null, ElanLocale.getString("Message.Overwrite"), ElanLocale.getString("SaveDialog.Message.Title"), 0);
                    if (answer == 1) {
                        return this.promptForFileName();
                    }
                    return name;
                }
                return name;
            }
            return null;
        }
        return null;
    }

    private String promptForHTMLFileName() {
        String exportDir = (String)Preferences.get("LastUsedExportDir", null);
        if (exportDir == null) {
            exportDir = System.getProperty("user.dir");
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(exportDir));
        chooser.setDialogTitle(ElanLocale.getString("ExportDialog.ExportToFile"));
        File exportFile = null;
        FileFilter filter = ElanFileFilter.createFileFilter(15);
        chooser.setFileFilter(filter);
        if (chooser.showSaveDialog(this.getParent()) == 0) {
            File curDir = chooser.getCurrentDirectory();
            if (curDir != null) {
                Preferences.set("LastUsedExportDir", curDir.getAbsolutePath(), null);
            }
            if ((exportFile = chooser.getSelectedFile()) != null) {
                String name = exportFile.getAbsolutePath();
                String lowerPathName = name.toLowerCase();
                String[] exts = FileExtension.HTML_EXT;
                boolean validExt = false;
                for (int i = 0; i < exts.length; ++i) {
                    if (!lowerPathName.endsWith("." + exts[i])) continue;
                    validExt = true;
                    break;
                }
                if (!validExt) {
                    name = name + "." + exts[0];
                    exportFile = new File(name);
                }
                if (exportFile.exists()) {
                    int answer = JOptionPane.showConfirmDialog(this.getParent(), ElanLocale.getString("Message.Overwrite"), ElanLocale.getString("SaveDialog.Message.Title"), 0);
                    if (answer == 1) {
                        return this.promptForFileName();
                    }
                    return name;
                }
                return name;
            }
            return null;
        }
        return null;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.applyChangesButton) {
            this.doApplyChanges();
        } else if (event.getSource() == this.printButton) {
            if (this.interlinearizer.getOutputMode() == 100) {
                this.doPrint();
            } else if (this.interlinearizer.getOutputMode() == 103) {
                this.doSaveHTML();
            } else {
                this.doSaveText();
            }
        } else if (event.getSource() == this.pageSetupButton) {
            this.doPageSetup();
        } else if (event.getSource() == this.fontSizesButton) {
            this.doSetFontSizes();
        } else if (event.getSource() == this.upButton) {
            this.moveUp();
        } else if (event.getSource() == this.downButton) {
            this.moveDown();
        }
    }

    public void valueChanged(ListSelectionEvent lse) {
        if (this.model != null && lse.getValueIsAdjusting()) {
            int b = lse.getFirstIndex();
            int e = lse.getLastIndex();
            int col = this.model.findColumn("export");
            for (int i = b; i <= e; ++i) {
                if (!this.tierTable.isRowSelected(i)) continue;
                this.model.setValueAt(Boolean.TRUE, i, col);
            }
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        if (ie.getSource() == this.sortingComboBox) {
            if (ie.getStateChange() == 1) {
                int nextSort = this.curSortMode;
                String sortMode = (String)this.sortingComboBox.getSelectedItem();
                nextSort = sortMode == this.sortingAsFile ? 0 : (sortMode == this.sortingTierHierarchy ? 1 : (sortMode == this.sortingParticipant ? 3 : 2));
                this.curSortMode = nextSort;
                this.sortTiersTable();
            }
        } else if (ie.getSource() == this.insertTabCheckBox) {
            this.interlinearizer.setInsertTabs(this.insertTabCheckBox.isSelected());
        } else if (ie.getSource() == this.silenceCB) {
            if (this.silenceCB.isSelected()) {
                this.minDurSilTF.setEnabled(true);
                this.minDurSilTF.setBackground(Constants.SHAREDCOLOR4);
                if (this.minDurSilTF.getText() == null || this.minDurSilTF.getText().length() == 0) {
                    this.minDurSilTF.setText("" + 20);
                }
                this.silenceDecimalComboBox.setEnabled(true);
                this.silenceDecimalComboBox.setSelectedItem(2);
                this.minDurSilTF.requestFocus();
            } else {
                this.minDurSilTF.setEnabled(false);
                this.minDurSilTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
                this.silenceDecimalComboBox.setEnabled(false);
            }
        }
    }
}

