/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear;

import java.util.ArrayList;
import mpi.eudico.client.annotator.interlinear.InterlinearAnnotation;

public class InterlinearTier {
    private String tierName;
    private ArrayList annotations;
    private int numLines = 1;
    private int printHeight = 0;
    private int printWidth = 0;
    private int marginWidth = 0;
    private boolean isTimeCode;
    private boolean isSilDuration;

    public InterlinearTier(String tierName) {
        this.tierName = tierName;
        this.annotations = new ArrayList();
        this.isTimeCode = false;
    }

    public void addAnnotation(InterlinearAnnotation ann) {
        if (ann != null) {
            this.annotations.add(ann);
        }
    }

    public ArrayList getAnnotations() {
        return this.annotations;
    }

    public String getTierName() {
        return this.tierName;
    }

    public int getMarginWidth() {
        return this.marginWidth;
    }

    public void setMarginWidth(int marginWidth) {
        this.marginWidth = marginWidth;
    }

    public int getPrintHeight() {
        return this.printHeight;
    }

    public void setPrintHeight(int printHeight) {
        this.printHeight = printHeight;
    }

    public int getPrintWidth() {
        return this.printWidth;
    }

    public void setPrintWidth(int printWidth) {
        this.printWidth = printWidth;
    }

    public int getPrintAdvance() {
        if (this.annotations.size() == 0) {
            return this.printWidth;
        }
        InterlinearAnnotation last = (InterlinearAnnotation)this.annotations.get(this.annotations.size() - 1);
        return Math.max(last.x + last.calcWidth, this.printWidth);
    }

    public void setTimeCode(boolean isTimeCode) {
        this.isTimeCode = isTimeCode;
    }

    public boolean isSilDuration() {
        return this.isSilDuration;
    }

    public void setSilDuration(boolean silDur) {
        this.isSilDuration = silDur;
    }

    public boolean isTimeCode() {
        return this.isTimeCode;
    }

    public int getNumLines() {
        return this.numLines;
    }

    public void setNumLines(int newNumLines) {
        this.numLines = newNumLines;
    }
}

