/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import mpi.eudico.client.annotator.interlinear.Interlinear;
import mpi.eudico.client.annotator.interlinear.InterlinearAnnotation;
import mpi.eudico.client.annotator.interlinear.InterlinearBlock;
import mpi.eudico.client.annotator.interlinear.InterlinearTier;

public class PixelRenderer {
    public static void render(Interlinear interlinear, BufferedImage bi, int[] offset) {
        Graphics2D g2d = (Graphics2D)bi.getGraphics();
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        int[] visibleRect = new int[]{bi.getWidth(), bi.getHeight()};
        PixelRenderer.render(interlinear, g2d, offset, visibleRect);
    }

    public static void render(Interlinear interlinear, Graphics g, int pageIndex) {
        if (pageIndex < 0 || pageIndex >= interlinear.getMetrics().getPageBreaks().size()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        int[] pageBreak = (int[])interlinear.getMetrics().getPageBreaks().get(pageIndex);
        g2d.setColor(Color.LIGHT_GRAY);
        if (interlinear.isTierLabelsShown()) {
            int h = interlinear.getPageHeight();
            if (interlinear.isShowPageNumber()) {
                h -= interlinear.pageNumberAreaHeight;
            }
            g2d.drawLine(interlinear.getMetrics().getLeftMargin() - 2, 0, interlinear.getMetrics().getLeftMargin() - 2, h);
        }
        int[] offset = new int[]{0, 0};
        int[] visRect = new int[]{interlinear.getWidth(), interlinear.getHeight()};
        PixelRenderer.renderPage(g2d, interlinear, pageBreak, offset, visRect, 0);
        if (interlinear.isShowPageNumber()) {
            g2d.setFont(Interlinear.DEFAULTFONT.deriveFont(10.0f));
            int w = g2d.getFontMetrics().stringWidth("" + (pageIndex + 1));
            g2d.drawString("" + (pageIndex + 1), interlinear.getWidth() / 2 - w / 2, interlinear.getPageHeight() - 2);
            g2d.setColor(Color.LIGHT_GRAY);
            g2d.drawLine(0, interlinear.getPageHeight() - interlinear.pageNumberAreaHeight + 2, interlinear.getWidth(), interlinear.getPageHeight() - interlinear.pageNumberAreaHeight + 2);
        }
    }

    public static void renderCharacterPreview(Interlinear interlinear, BufferedImage bi, int[] offset) {
        Graphics2D g2d = (Graphics2D)bi.getGraphics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        g2d.setColor(Color.BLACK);
        g2d.setFont(Interlinear.MONOSPACED_FONT);
        g2d.translate((double)(-offset[0]), 0.0);
        int[] visibleRect = new int[]{bi.getWidth(), bi.getHeight()};
        PixelRenderer.renderCharacterPreview(interlinear, g2d, offset, visibleRect);
    }

    private static void render(Interlinear interlinear, Graphics2D g2d, int[] offset, int[] visibleRect) {
        int vertOffset = offset[1];
        int firstVisPage = vertOffset / interlinear.getPageHeight();
        g2d.setColor(Color.WHITE);
        g2d.translate(-offset[0], 0);
        g2d.fillRect(0, 0, interlinear.getWidth(), visibleRect[1]);
        g2d.setColor(Color.LIGHT_GRAY);
        if (interlinear.isTierLabelsShown()) {
            g2d.drawLine(interlinear.getMetrics().getLeftMargin() - 2, 0, interlinear.getMetrics().getLeftMargin() - 2, visibleRect[1]);
        }
        g2d.translate(0.0, (double)(-vertOffset));
        ArrayList breaks = interlinear.getMetrics().getPageBreaks();
        g2d.setColor(Color.GRAY);
        for (int i = firstVisPage; i < breaks.size(); ++i) {
            g2d.drawLine(0, i * interlinear.getPageHeight(), visibleRect[0], i * interlinear.getPageHeight());
            if (i * interlinear.getPageHeight() > offset[1] + visibleRect[1]) break;
        }
        ArrayList blocks = interlinear.getMetrics().getPrintBlocks();
        Object printBlock = null;
        Object pt = null;
        int y = 0;
        for (int i = firstVisPage; i < breaks.size(); ++i) {
            int[] br = (int[])breaks.get(i);
            y = i * interlinear.getPageHeight();
            if (y < offset[1] + visibleRect[1]) {
                PixelRenderer.renderPage(g2d, interlinear, br, offset, visibleRect, y);
                if (!interlinear.isShowPageNumber()) continue;
                g2d.setColor(Color.BLACK);
                g2d.setFont(Interlinear.DEFAULTFONT.deriveFont(10.0f));
                int w = g2d.getFontMetrics().stringWidth("" + (firstVisPage + 1));
                g2d.drawString("" + (firstVisPage + 1), interlinear.getWidth() / 2 - w / 2, i * interlinear.getPageHeight() - 2);
                g2d.setColor(Color.LIGHT_GRAY);
                g2d.drawLine(0, i * interlinear.getPageHeight() - interlinear.pageNumberAreaHeight + 2, visibleRect[0], i * interlinear.getPageHeight() - interlinear.pageNumberAreaHeight + 2);
                continue;
            }
            return;
        }
    }

    private static void renderPage(Graphics2D g2d, Interlinear interlinear, int[] br, int[] offset, int[] visibleRect, int startYShift) {
        ArrayList blocks = interlinear.getMetrics().getPrintBlocks();
        InterlinearBlock printBlock = null;
        InterlinearTier pt = null;
        int y = startYShift;
        for (int j = br[0]; j <= br[2]; ++j) {
            printBlock = (InterlinearBlock)blocks.get(j);
            ArrayList tiers = printBlock.getPrintTiers();
            int lineNum = 0;
            int k = 0;
            int maxK = printBlock.getNumberOfLines();
            if (j == br[0]) {
                k = br[1];
            }
            if (j == br[2]) {
                maxK = br[3];
            }
            for (int tierCount = 0; tierCount < tiers.size(); ++tierCount) {
                pt = (InterlinearTier)tiers.get(tierCount);
                for (int tierLine = 0; tierLine < pt.getNumLines(); ++tierLine) {
                    if (lineNum < k) {
                        ++lineNum;
                        continue;
                    }
                    if (lineNum > maxK) {
                        return;
                    }
                    if (y >= offset[1]) {
                        PixelRenderer.renderTier(g2d, interlinear, pt, 0, y, tierLine);
                    }
                    if ((y += pt.getPrintHeight()) > offset[1] + visibleRect[1]) {
                        return;
                    }
                    if (tierLine != pt.getNumLines() - 1) {
                        y += interlinear.getLineSpacing();
                    }
                    ++lineNum;
                }
                if (tierCount == tiers.size() - 1) continue;
                y += interlinear.getLineSpacing();
            }
            y += interlinear.getBlockSpacing();
        }
    }

    private static void renderTier(Graphics2D g2d, Interlinear interlinear, InterlinearTier pt, int xShift, int yShift, int line) {
        yShift += pt.getPrintHeight();
        g2d.setFont(interlinear.getFont(pt.getTierName()));
        if (interlinear.isTierLabelsShown() && line == 0) {
            if (!g2d.getFont().getName().equals(Interlinear.DEFAULTFONT.getName())) {
                g2d.setFont(Interlinear.DEFAULTFONT.deriveFont((float)interlinear.getFontSize(pt.getTierName())));
            }
            g2d.setColor(Color.LIGHT_GRAY);
            if (pt.isTimeCode()) {
                g2d.drawString(interlinear.getMetrics().TC_TIER_NAME, xShift, yShift - g2d.getFontMetrics().getDescent());
            } else if (pt.isSilDuration()) {
                g2d.drawString(interlinear.getMetrics().SD_TIER_NAME, xShift, yShift - g2d.getFontMetrics().getDescent());
            } else {
                g2d.drawString(pt.getTierName(), xShift, yShift - g2d.getFontMetrics().getDescent());
            }
            g2d.setFont(interlinear.getFont(pt.getTierName()));
        }
        if (pt.isTimeCode()) {
            g2d.setColor(Color.RED);
        } else {
            g2d.setColor(Color.BLACK);
        }
        xShift += interlinear.getMetrics().getLeftMargin();
        ArrayList annos = pt.getAnnotations();
        InterlinearAnnotation pa = null;
        for (int i = 0; i < annos.size(); ++i) {
            pa = (InterlinearAnnotation)annos.get(i);
            if (pa.nrOfLines == 1) {
                g2d.drawString(pa.getValue(), xShift + pa.x, yShift - g2d.getFontMetrics().getDescent());
                if (!interlinear.isEmptySlotsShown() || !pa.getValue().equals("")) continue;
                g2d.setColor(Color.GRAY);
                g2d.drawRect(xShift + pa.x, yShift - pt.getPrintHeight() + 1, pa.calcWidth, pt.getPrintHeight() - 2);
                g2d.setColor(Color.BLACK);
                continue;
            }
            int y = yShift - g2d.getFontMetrics().getDescent();
            if (line >= pa.getLines().length) continue;
            g2d.drawString(pa.getLines()[line], xShift + pa.x, y);
        }
    }

    private static void renderCharacterPreview(Interlinear interlinear, Graphics2D g2d, int[] offset, int[] visibleRect) {
        int charWidth = g2d.getFontMetrics().charWidth('w');
        int vertOffset = offset[1];
        g2d.translate(0.0, (double)(-vertOffset));
        ArrayList blocks = interlinear.getMetrics().getPrintBlocks();
        InterlinearBlock printBlock = null;
        ArrayList tiers = null;
        InterlinearTier pt = null;
        int y = 0;
        for (int i = 0; i < blocks.size(); ++i) {
            printBlock = (InterlinearBlock)blocks.get(i);
            tiers = printBlock.getPrintTiers();
            if (y + printBlock.getNumberOfLines() * 12 > vertOffset) {
                for (int j = 0; j < tiers.size(); ++j) {
                    pt = (InterlinearTier)tiers.get(j);
                    PixelRenderer.renderCharTier(g2d, interlinear, pt, charWidth, y);
                    y += pt.getNumLines() * 12;
                }
            } else {
                y += printBlock.getNumberOfLines() * 12;
            }
            if ((y += interlinear.getBlockSpacing() * 12) <= vertOffset + visibleRect[1]) continue;
            return;
        }
    }

    private static void renderCharTier(Graphics2D g2d, Interlinear interlinear, InterlinearTier pt, int charWidth, int yShift) {
        yShift += 12;
        int xShift = 0;
        if (pt.isTimeCode()) {
            g2d.drawString(interlinear.getMetrics().TC_TIER_NAME, xShift, yShift - g2d.getFontMetrics().getDescent());
        } else if (pt.isSilDuration()) {
            g2d.drawString(interlinear.getMetrics().SD_TIER_NAME, xShift, yShift - g2d.getFontMetrics().getDescent());
        } else {
            g2d.drawString(pt.getTierName(), xShift, yShift - g2d.getFontMetrics().getDescent());
        }
        xShift = interlinear.getMetrics().getLeftMargin() * charWidth;
        ArrayList annos = pt.getAnnotations();
        InterlinearAnnotation pa = null;
        for (int i = 0; i < annos.size(); ++i) {
            pa = (InterlinearAnnotation)annos.get(i);
            if (pa.nrOfLines == 1) {
                g2d.drawString(pa.getValue(), xShift + pa.x * charWidth, yShift - g2d.getFontMetrics().getDescent());
                continue;
            }
            int y = yShift - g2d.getFontMetrics().getDescent();
            for (int line = 0; line < pa.getLines().length; ++line) {
                g2d.drawString(pa.getLines()[line], xShift + pa.x * charWidth, y);
                y += 12;
            }
        }
    }
}

