/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.lexicon;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mpi.eudico.client.annotator.lexicon.api.LexSrvcAvailabilityDetector;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.lexicon.LexiconLink;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClient;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClientFactory;

public class LexiconClientFactoryLoader {
    public void loadLexiconClientFactories(TranscriptionImpl transcription) {
        LexiconServiceClientFactory factory;
        if (transcription == null) {
            return;
        }
        if (transcription.isLexcionServicesLoaded()) {
            return;
        }
        HashMap<String, LexiconServiceClientFactory> factories = LexSrvcAvailabilityDetector.getLexiconServiceClientFactories();
        if (factories.size() == 0) {
            transcription.setLexcionServicesLoaded(true);
            return;
        }
        HashMap<String, LexiconLink> lexLinks = transcription.getLexiconLinks();
        for (String name : factories.keySet()) {
            factory = (LexiconServiceClientFactory)factories.get(name);
            transcription.addLexiconServiceClientFactory(name, factory);
            if (lexLinks.size() <= 0) continue;
            Iterator linkIt = lexLinks.keySet().iterator();
            while (linkIt.hasNext()) {
                LexiconLink link = (LexiconLink)lexLinks.get(linkIt.next());
                if (!name.equals(link.getLexSrvcClntType())) continue;
                LexiconServiceClient client = factory.createClient(link.getUrl());
                link.setSrvcClient(client);
            }
        }
        Vector linTypes = transcription.getLinguisticTypes();
        for (int i = 0; i < linTypes.size(); ++i) {
            LinguisticType lt = (LinguisticType)linTypes.get(i);
            if (!lt.isUsingLexiconQueryBundle() || lt.getLexiconQueryBundle().getLink().getSrvcClient() != null || (factory = (LexiconServiceClientFactory)factories.get(lt.getLexiconQueryBundle().getLink().getLexSrvcClntType())) == null) continue;
            LexiconServiceClient client = factory.createClient(lt.getLexiconQueryBundle().getLink().getUrl());
            lt.getLexiconQueryBundle().getLink().setSrvcClient(client);
        }
        transcription.setLexcionServicesLoaded(true);
    }
}

