/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.lexicon;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.server.corpora.lexicon.LexiconLink;

public class LexiconLoginDialog
extends ClosableDialog
implements ActionListener {
    private JTextField usernameFld;
    private JPasswordField passwordFld;
    private JButton okBtn;
    private JButton cancelBtn;
    private LexiconLink link;
    private boolean canceled;
    private Component parent;

    public LexiconLoginDialog(Frame parent, LexiconLink link) {
        super(parent, ElanLocale.getString("EditLexSrvcDialog.Label.NameAndPassword"), true);
        this.link = link;
        this.canceled = true;
        this.parent = parent;
        this.initComponents(link);
        this.postInit();
    }

    public LexiconLoginDialog(Dialog parent, LexiconLink link) {
        super(parent, ElanLocale.getString("EditLexSrvcDialog.Label.NameAndPassword"), true);
        this.link = link;
        this.canceled = true;
        this.parent = parent;
        this.initComponents(link);
        this.postInit();
    }

    private void initComponents(LexiconLink link) {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LexiconLoginDialog.this.closeDialog();
            }
        });
        String intro = "<html>" + ElanLocale.getString("LexiconLoginDialog.Label") + " '" + link.getName() + "' (" + link.getUrl() + ").";
        JLabel introLbl = new JLabel(intro);
        JLabel usernameLbl = new JLabel(ElanLocale.getString("EditLexSrvcDialog.Label.Username"));
        this.usernameFld = new JTextField();
        JLabel passwordLbl = new JLabel(ElanLocale.getString("EditLexSrvcDialog.Label.Password"));
        this.passwordFld = new JPasswordField();
        this.okBtn = new JButton(ElanLocale.getString("Button.OK"));
        this.okBtn.addActionListener(this);
        this.cancelBtn = new JButton(ElanLocale.getString("Button.Cancel"));
        this.cancelBtn.addActionListener(this);
        JPanel mainPnl = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 5, 0, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        mainPnl.add((Component)introLbl, c);
        c.insets = new Insets(15, 5, 0, 0);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        mainPnl.add((Component)usernameLbl, c);
        c.insets = new Insets(15, 5, 0, 5);
        c.gridx = 1;
        c.gridy = 1;
        mainPnl.add((Component)this.usernameFld, c);
        c.insets = new Insets(5, 5, 0, 0);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        mainPnl.add((Component)passwordLbl, c);
        c.insets = new Insets(5, 5, 0, 5);
        c.gridx = 1;
        c.gridy = 2;
        mainPnl.add((Component)this.passwordFld, c);
        JPanel buttonPnl = new JPanel();
        buttonPnl.setLayout(new BoxLayout(buttonPnl, 2));
        buttonPnl.add(Box.createHorizontalGlue());
        buttonPnl.add(this.okBtn);
        buttonPnl.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPnl.add(this.cancelBtn);
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        mainPnl.add((Component)buttonPnl, c);
        mainPnl.setPreferredSize(new Dimension(460, 160));
        this.setContentPane(mainPnl);
        this.getRootPane().setDefaultButton(this.okBtn);
    }

    private void postInit() {
        this.pack();
        int w = 450;
        int h = 200;
        this.setSize(this.getSize().width > w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
        this.setLocationRelativeTo(this.parent);
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.okBtn) {
            this.setVisible(false);
            this.link.getSrvcClient().setUsername(this.usernameFld.getText());
            this.link.getSrvcClient().setPassword(new String(this.passwordFld.getPassword()));
            this.canceled = false;
            this.closeDialog();
        } else if (ae.getSource() == this.cancelBtn) {
            this.closeDialog();
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void closeDialog() {
        this.dispose();
    }
}

