/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.lexicon;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.server.corpora.lexicon.LexiconIdentification;
import mpi.eudico.server.corpora.lexicon.LexiconLink;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClient;

public class LexiconServiceStep2
extends StepPane
implements ListSelectionListener {
    private JLabel questionLabel;
    private JList lexiconList;
    private JScrollPane lexiconListScroller;
    private DefaultListModel lexiconListModel;
    private JTextArea lexiconDescArea;
    private JScrollPane lexiconDescScroller;

    public LexiconServiceStep2(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.questionLabel = new JLabel(ElanLocale.getString("EditLexSrvcDialog.Label.SelectLexicon"));
        this.lexiconListModel = new DefaultListModel();
        this.lexiconList = new JList(this.lexiconListModel);
        this.lexiconList.setSelectionMode(0);
        this.lexiconList.addListSelectionListener(this);
        this.lexiconListScroller = new JScrollPane(this.lexiconList);
        this.lexiconDescArea = new JTextArea("");
        this.lexiconDescArea.setEditable(false);
        this.lexiconDescArea.setLineWrap(true);
        this.lexiconDescScroller = new JScrollPane(this.lexiconDescArea);
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c.anchor = 21;
        c.insets = new Insets(5, 0, 5, 0);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.questionLabel, c);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.lexiconListScroller, c);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.lexiconDescScroller, c);
    }

    public String getStepTitle() {
        return ElanLocale.getString("EditLexSrvcDialog.Title.Step2");
    }

    public void enterStepForward() {
        this.multiPane.setButtonEnabled(1, false);
        this.multiPane.setButtonEnabled(2, true);
        this.fillLexiconList();
    }

    public void enterStepBackward() {
        this.multiPane.setButtonEnabled(1, false);
        this.multiPane.setButtonEnabled(2, true);
        this.fillLexiconList();
    }

    public boolean leaveStepForward() {
        return false;
    }

    public boolean leaveStepBackward() {
        this.lexiconListModel.clear();
        return true;
    }

    public boolean doFinish() {
        if (this.lexiconList.getSelectedIndex() >= 0) {
            LexiconServiceClient client = (LexiconServiceClient)this.multiPane.getStepProperty("serviceClient");
            LexiconLink link = new LexiconLink((String)this.multiPane.getStepProperty("linkName"), client.getType(), client.getUrl(), client, (LexiconIdentification)this.lexiconList.getSelectedValue());
            this.multiPane.putStepProperty("newLink", link);
        }
        return true;
    }

    private void fillLexiconList() {
        Object lexica = this.multiPane.getStepProperty("lexicaIds");
        if (lexica instanceof ArrayList) {
            for (Object lexicon : (ArrayList)lexica) {
                if (!(lexicon instanceof LexiconIdentification)) continue;
                this.lexiconListModel.addElement(lexicon);
            }
        }
    }

    public void valueChanged(ListSelectionEvent ae) {
        if (ae.getSource() == this.lexiconList) {
            if (this.lexiconList.getSelectedIndex() != -1) {
                this.lexiconDescArea.setText(((LexiconIdentification)this.lexiconList.getSelectedValue()).getDescription());
                this.multiPane.setButtonEnabled(3, true);
            } else {
                this.lexiconDescArea.setText("");
                this.multiPane.setButtonEnabled(3, false);
            }
        }
    }
}

