/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.lexicon.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import mpi.eudico.client.annotator.lexicon.api.LexSrvcClntBundle;
import mpi.eudico.client.annotator.lexicon.api.LexSrvcClntLoader;
import mpi.eudico.client.annotator.lexicon.api.LexSrvcClntParser;
import mpi.eudico.client.annotator.lexicon.api.Param;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClientFactory;
import mpi.eudico.util.ExtClassLoader;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexSrvcAvailabilityDetector {
    private static Map<String, LexSrvcClntBundle> lexSrvcClntBundles = new HashMap<String, LexSrvcClntBundle>();
    private static LexSrvcClntLoader lexSrvcClntLoader;

    private LexSrvcAvailabilityDetector() {
    }

    private static void init() {
        File[] files;
        File extFile = new File(ExtClassLoader.EXTENSIONS_DIR);
        if (!extFile.exists()) {
            ClientLogger.LOG.warning("The extension folder could not be found (" + ExtClassLoader.EXTENSIONS_DIR + ").");
            return;
        }
        if (!extFile.isDirectory()) {
            ClientLogger.LOG.warning("The extension 'folder' is not a folder (" + ExtClassLoader.EXTENSIONS_DIR + ").");
            return;
        }
        if (!extFile.canRead()) {
            ClientLogger.LOG.warning("The extension folder is not accessible (" + ExtClassLoader.EXTENSIONS_DIR + ").");
            return;
        }
        for (File f : files = extFile.listFiles()) {
            if (f.isDirectory()) {
                LexSrvcAvailabilityDetector.detectLexSrvcClnt(f);
                continue;
            }
            String name = f.getName().toLowerCase();
            if (!name.endsWith("jar")) continue;
            LexSrvcAvailabilityDetector.detectLexSrvcClntFromJar(f);
        }
    }

    public static HashMap<String, LexiconServiceClientFactory> getLexiconServiceClientFactories() {
        HashMap<String, LexiconServiceClientFactory> lexSrvcClnts = new HashMap<String, LexiconServiceClientFactory>(6);
        for (String key : lexSrvcClntBundles.keySet()) {
            LexSrvcClntBundle bundle = lexSrvcClntBundles.get(key);
            if (bundle.getJavaLibs() != null) {
                if (lexSrvcClntLoader == null) {
                    lexSrvcClntLoader = new LexSrvcClntLoader(bundle.getJavaLibs(), bundle.getNativeLibs());
                } else {
                    lexSrvcClntLoader.addLibs(bundle.getJavaLibs());
                    lexSrvcClntLoader.addNativeLibs(bundle.getNativeLibs());
                }
                try {
                    LexiconServiceClientFactory clientFactory = (LexiconServiceClientFactory)Class.forName(bundle.getLexSrvcClntClass(), true, lexSrvcClntLoader).newInstance();
                    clientFactory.setType(bundle.getName());
                    clientFactory.setDescription(bundle.getDescription());
                    for (Param p : bundle.getParamList()) {
                        if (p.getType().equals("defaultUrl")) {
                            clientFactory.setDefaultUrl(p.getContent());
                            continue;
                        }
                        if (!p.getType().equals("searchConstraint")) continue;
                        clientFactory.addSearchConstraint(p.getContent());
                    }
                    lexSrvcClnts.put(key, clientFactory);
                }
                catch (ClassNotFoundException cnfe) {
                    ClientLogger.LOG.severe("Cannot load the lexicon service client class: " + bundle.getLexSrvcClntClass() + " - Class not found");
                }
                catch (InstantiationException ie) {
                    ClientLogger.LOG.severe("Cannot instantiate the lexicon service client class: " + bundle.getLexSrvcClntClass());
                }
                catch (IllegalAccessException iae) {
                    ClientLogger.LOG.severe("Cannot access the lexicon service client class: " + bundle.getLexSrvcClntClass());
                }
                catch (Exception ex) {
                    ClientLogger.LOG.severe("Cannot load the lexicon service client: " + bundle.getLexSrvcClntClass() + " - " + ex.getMessage());
                    ex.printStackTrace();
                }
                continue;
            }
            ClientLogger.LOG.severe("Cannot load the lexicon service client: no Java library has been found ");
        }
        return lexSrvcClnts;
    }

    public static int getNumberOfFactories() {
        return lexSrvcClntBundles.size();
    }

    public static List<String> getFactoryNames() {
        if (lexSrvcClntBundles.size() > 0) {
            ArrayList<String> names = new ArrayList<String>(lexSrvcClntBundles.size());
            names.addAll(lexSrvcClntBundles.keySet());
            return names;
        }
        return null;
    }

    public static LexiconServiceClientFactory getFactoryByName(String name) {
        LexSrvcClntBundle bundle = lexSrvcClntBundles.get(name);
        if (bundle == null) {
            return null;
        }
        if (bundle.getJavaLibs() != null) {
            if (lexSrvcClntLoader == null) {
                lexSrvcClntLoader = new LexSrvcClntLoader(bundle.getJavaLibs(), bundle.getNativeLibs());
            } else {
                lexSrvcClntLoader.addLibs(bundle.getJavaLibs());
                lexSrvcClntLoader.addNativeLibs(bundle.getNativeLibs());
            }
            try {
                LexiconServiceClientFactory clientFactory = (LexiconServiceClientFactory)Class.forName(bundle.getLexSrvcClntClass(), true, lexSrvcClntLoader).newInstance();
                clientFactory.setType(bundle.getName());
                clientFactory.setDescription(bundle.getDescription());
                for (Param p : bundle.getParamList()) {
                    if (p.getType().equals("defaultUrl")) {
                        clientFactory.setDefaultUrl(p.getContent());
                        continue;
                    }
                    if (!p.getType().equals("searchConstraint")) continue;
                    clientFactory.addSearchConstraint(p.getContent());
                }
                return clientFactory;
            }
            catch (ClassNotFoundException cnfe) {
                ClientLogger.LOG.severe("Cannot load the lexicon service client class: " + bundle.getLexSrvcClntClass() + " - Class not found");
            }
            catch (InstantiationException ie) {
                ClientLogger.LOG.severe("Cannot instantiate the lexicon service client class: " + bundle.getLexSrvcClntClass());
            }
            catch (IllegalAccessException iae) {
                ClientLogger.LOG.severe("Cannot access the lexicon service client class: " + bundle.getLexSrvcClntClass());
            }
            catch (Exception ex) {
                ClientLogger.LOG.severe("Cannot load the lexicon service client: " + bundle.getLexSrvcClntClass() + " - " + ex.getMessage());
                ex.printStackTrace();
            }
        } else {
            ClientLogger.LOG.severe("Cannot load the lexicon service client: no Java library has been found ");
        }
        return null;
    }

    private static void detectLexSrvcClntFromJar(File file) {
        try {
            JarFile jFile = new JarFile(file);
            JarEntry je = jFile.getJarEntry("lexiconServiceClient.cmdi");
            if (je == null) {
                ClientLogger.LOG.warning("No plug-in metadata file (lexiconServiceClient.cmdi) found in " + file.getName());
                return;
            }
            try {
                URL jarUrl = file.toURI().toURL();
                URL[] libUrls = new URL[]{jarUrl};
                InputStream mdStream = jFile.getInputStream(je);
                LexSrvcAvailabilityDetector.createBundle(mdStream, libUrls, null, file.getParentFile());
            }
            catch (MalformedURLException mue) {
                ClientLogger.LOG.severe("Cannot create URL for file: " + file.getName());
            }
            catch (IOException ioe) {
                ClientLogger.LOG.warning("Cannot read the cmdi file from the jar file: " + file.getName());
            }
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("Cannot read the jar file: " + file.getName());
        }
    }

    private static void detectLexSrvcClnt(File file) {
        File[] files = file.listFiles();
        File mdFile = null;
        for (File f : files) {
            if (!f.getName().toLowerCase().equals("lexiconserviceclient.cmdi")) continue;
            mdFile = f;
            break;
        }
        if (mdFile != null) {
            ArrayList<URL> libs = new ArrayList<URL>();
            ArrayList<URL> natLibs = new ArrayList<URL>();
            LexSrvcAvailabilityDetector.addLibs(file, libs, natLibs);
            try {
                FileInputStream mdStream = new FileInputStream(mdFile);
                URL[] libUrls = null;
                if (libs.size() > 0) {
                    libUrls = libs.toArray(new URL[0]);
                }
                URL[] natLibUrls = null;
                if (natLibs.size() > 0) {
                    natLibUrls = natLibs.toArray(new URL[0]);
                }
                LexSrvcAvailabilityDetector.createBundle(mdStream, libUrls, natLibUrls, file);
            }
            catch (FileNotFoundException fnfe) {
                ClientLogger.LOG.severe("Cannot parse metadata file: " + fnfe.getMessage());
            }
        } else {
            ClientLogger.LOG.info("No lexiconServiceClient.cmdi metadata file found in: " + file.getName());
        }
    }

    private static void createBundle(InputStream lexStream, URL[] libs, URL[] natLibs, File baseDir) {
        boolean isLexClient = false;
        String binaryName = null;
        LexSrvcClntBundle bundle = null;
        LexSrvcClntParser parser = null;
        try {
            parser = new LexSrvcClntParser(lexStream);
            parser.parse();
            if (!parser.curOsSupported) {
                ClientLogger.LOG.warning("Lexicon service client does not support this Operating System: " + parser.name);
                return;
            }
            if (parser.implementor == null) {
                ClientLogger.LOG.warning("The implementing class name has not been specified.");
                return;
            }
            isLexClient = true;
            binaryName = parser.implementor;
        }
        catch (SAXException sax) {
            ClientLogger.LOG.severe("Cannot parse metadata file: " + sax.getMessage());
        }
        if (isLexClient) {
            LexSrvcClntLoader loader = new LexSrvcClntLoader(libs, natLibs);
            if (binaryName != null) {
                try {
                    Class<?> c = loader.loadClass(binaryName);
                    bundle = new LexSrvcClntBundle();
                    bundle.setName(parser.name);
                    bundle.setDescription(parser.description);
                    bundle.setParamList(parser.paramList);
                    bundle.setLexSrvcClntClass(binaryName);
                    bundle.setJavaLibs(libs);
                    bundle.setNativeLibs(natLibs);
                    bundle.setBaseDir(baseDir);
                    lexSrvcClntBundles.put(bundle.getName(), bundle);
                }
                catch (ClassNotFoundException cne) {
                    ClientLogger.LOG.severe("Cannot load the lexicon service client class: " + binaryName + " - Class not found");
                }
            } else {
                ClientLogger.LOG.warning("Cannot load the lexicon service client class: Class not found");
            }
        }
    }

    private static void addLibs(File file, List<URL> libs, List<URL> natLibs) {
        File[] files;
        for (File f : files = file.listFiles()) {
            try {
                if (f.isDirectory()) {
                    LexSrvcAvailabilityDetector.addLibs(f, libs, natLibs);
                    continue;
                }
                String name = f.getName().toLowerCase();
                if (!name.endsWith("jar") && !name.endsWith("zip")) continue;
                try {
                    libs.add(f.toURI().toURL());
                }
                catch (MalformedURLException mue) {
                    ClientLogger.LOG.severe("Cannot create URL for file: " + f.getName());
                }
            }
            catch (SecurityException se) {
                ClientLogger.LOG.warning("Cannot read file: " + f.getName());
            }
        }
    }

    static {
        LexSrvcAvailabilityDetector.init();
    }
}

