/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.linkedmedia;

import java.util.ArrayList;
import java.util.Vector;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.linkedmedia.LinkedFilesTableModel;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;

public class MediaDescriptorTableModel
extends LinkedFilesTableModel {
    private Vector descriptors;

    public MediaDescriptorTableModel() {
        this(new Vector(0));
    }

    public MediaDescriptorTableModel(Vector descriptors) {
        this.descriptors = descriptors != null ? descriptors : new Vector();
        this.columnIds = new ArrayList();
        this.columnIds.add(ElanLocale.getString("LinkedFilesDialog.Label.MediaName"));
        this.columnIds.add(ElanLocale.getString("LinkedFilesDialog.Label.MediaURL"));
        this.columnIds.add(ElanLocale.getString("LinkedFilesDialog.Label.MimeType"));
        this.columnIds.add(ElanLocale.getString("LinkedFilesDialog.Label.ExtractedFrom"));
        this.columnIds.add(ElanLocale.getString("LinkedFilesDialog.Label.MediaOffset"));
        this.columnIds.add(ElanLocale.getString("LinkedFilesDialog.Label.MasterMedia"));
        this.columnIds.add(ElanLocale.getString("LinkedFilesDialog.Label.LinkStatus"));
        this.types = new ArrayList(this.columnIds.size());
        this.types.add(String.class);
        this.types.add(String.class);
        this.types.add(String.class);
        this.types.add(String.class);
        this.types.add(Integer.class);
        this.types.add(Boolean.class);
        this.types.add(Boolean.class);
        this.initData();
    }

    private void initData() {
        this.data = new ArrayList(this.descriptors.size());
        for (int i = 0; i < this.descriptors.size(); ++i) {
            MediaDescriptor desc = (MediaDescriptor)this.descriptors.get(i);
            ArrayList<Object> rowData = new ArrayList<Object>(this.getColumnCount());
            String url = desc.mediaURL;
            String name = FileUtility.fileNameFromPath(url);
            rowData.add(name);
            rowData.add(url);
            rowData.add(desc.mimeType);
            rowData.add(desc.extractedFrom != null ? desc.extractedFrom : "-");
            if (desc.extractedFrom != null && i > 0) {
                rowData.add(new Integer((int)this.getInheritedOffset(desc)));
            } else {
                rowData.add(new Integer((int)desc.timeOrigin));
            }
            rowData.add(i == 0 ? Boolean.TRUE : Boolean.FALSE);
            boolean linked = MediaDescriptorUtil.checkLinkStatus(desc);
            rowData.add(new Boolean(linked));
            this.data.add(rowData);
        }
    }

    private long getInheritedOffset(MediaDescriptor desc) {
        if (desc == null) {
            return 0L;
        }
        if (desc.extractedFrom == null) {
            return desc.timeOrigin;
        }
        if (this.descriptors.size() > 0) {
            MediaDescriptor md = (MediaDescriptor)this.descriptors.get(0);
            if (desc.extractedFrom.equals(md.mediaURL)) {
                return md.timeOrigin;
            }
        }
        return desc.timeOrigin;
    }

    public void removeRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.data.size()) {
            this.data.remove(rowIndex);
            this.descriptors.remove(rowIndex);
            this.fireTableDataChanged();
        }
    }

    public void addRow(MediaDescriptor desc) {
        if (desc == null) {
            return;
        }
        this.descriptors.add(desc);
        ArrayList<Object> rowData = new ArrayList<Object>(this.getColumnCount());
        int i = this.data.size();
        String url = desc.mediaURL;
        String name = FileUtility.fileNameFromPath(url);
        rowData.add(name);
        rowData.add(url);
        rowData.add(desc.mimeType);
        rowData.add(desc.extractedFrom != null ? desc.extractedFrom : "-");
        rowData.add(new Integer((int)desc.timeOrigin));
        rowData.add(i == 0 ? Boolean.TRUE : Boolean.FALSE);
        boolean linked = MediaDescriptorUtil.checkLinkStatus(desc);
        rowData.add(new Boolean(linked));
        this.data.add(rowData);
        this.fireTableDataChanged();
    }

    public void addMediaDescriptor(MediaDescriptor md) {
        this.addRow(md);
    }

    public void rowDataChanged() {
        this.initData();
        this.fireTableDataChanged();
    }
}

