/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.md.imdi;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.util.MutableInt;
import mpi.eudico.util.DocumentNotLoadedException;
import mpi.util.OurURL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImdiDoc {
    private Document doc;
    private List<String> allKeys = new ArrayList<String>();
    private Map<String, String> mdValuesMap = new LinkedHashMap<String, String>();
    private final String KEYS_KEY = "Keys.Key";
    private final String HTML_B = "<html>";
    private final String HTML_E = "</html>";
    private final String B_B = "<b>";
    private final String B_E = "</b>";

    public ImdiDoc(String filePath) throws DocumentNotLoadedException {
        OurURL ourl = null;
        try {
            File file = new File(filePath);
            ourl = new OurURL(file.toURL());
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            String fileName = ourl.toString();
            String uri = fileName.substring(0, fileName.lastIndexOf(47) + 1);
            InputSource fileSource = new InputSource(ourl.openStream());
            fileSource.setSystemId(uri);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            factory.setValidating(true);
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", this.getClass().getResource("/mpi/eudico/resources/IMDI_3.0.xsd").openStream());
            docBuilder = factory.newDocumentBuilder();
            this.doc = docBuilder.parse(fileSource);
        }
        catch (SAXParseException spe) {
            ClientLogger.LOG.warning("Cannot parse file: " + spe.getMessage());
            throw new DocumentNotLoadedException("Could not construct Imdi DOM: ", spe);
        }
        catch (SAXException sxe) {
            ClientLogger.LOG.warning("Cannot parse file: " + sxe.getMessage());
            throw new DocumentNotLoadedException("Could not construct Imdi DOM: ", sxe);
        }
        catch (IllegalArgumentException iae) {
            ClientLogger.LOG.warning("Cannot set attributes for document builder: " + iae.getMessage());
            throw new DocumentNotLoadedException("Could not construct Imdi DOM: ", iae);
        }
        catch (ParserConfigurationException pce) {
            ClientLogger.LOG.warning("Cannot set configure the parser: " + pce.getMessage());
            throw new DocumentNotLoadedException("Could not construct Imdi DOM: ", pce);
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("Cannot read the Imdi file: " + ioe.getMessage());
            throw new DocumentNotLoadedException("Could not construct Imdi DOM: ", ioe);
        }
        this.createIds(this.doc, this.doc.getDocumentElement(), null);
    }

    public ImdiDoc(InputSource inputSource) throws DocumentNotLoadedException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            factory.setValidating(true);
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", this.getClass().getResource("/mpi/eudico/resources/IMDI_3.0.xsd").openStream());
            docBuilder = factory.newDocumentBuilder();
            this.doc = docBuilder.parse(inputSource);
        }
        catch (SAXParseException spe) {
            ClientLogger.LOG.warning("Cannot parse file: " + spe.getMessage());
            throw new DocumentNotLoadedException("Could not construct Imdi DOM: ", spe);
        }
        catch (SAXException sxe) {
            ClientLogger.LOG.warning("Cannot parse file: " + sxe.getMessage());
            throw new DocumentNotLoadedException("Could not construct Imdi DOM: ", sxe);
        }
        catch (IllegalArgumentException iae) {
            ClientLogger.LOG.warning("Cannot set attributes for document builder: " + iae.getMessage());
            throw new DocumentNotLoadedException("Could not construct Imdi DOM: ", iae);
        }
        catch (ParserConfigurationException pce) {
            ClientLogger.LOG.warning("Cannot set configure the parser: " + pce.getMessage());
            throw new DocumentNotLoadedException("Could not construct Imdi DOM: ", pce);
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("Cannot read the Imdi file: " + ioe.getMessage());
            throw new DocumentNotLoadedException("Could not construct Imdi DOM: ", ioe);
        }
        this.createIds(this.doc, this.doc.getDocumentElement(), null);
    }

    private void createIds(Document doc, Element elm, String parentId) {
        if (parentId != null) {
            elm.setAttribute("id", parentId + "." + elm.getNodeName());
        } else {
            elm.setAttribute("id", elm.getNodeName());
        }
        String nextId = elm.getAttribute("id");
        if (!this.allKeys.contains(nextId)) {
            this.allKeys.add(nextId);
        }
        this.allKeys.remove("METATRANSCRIPT");
        NodeList childList = elm.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node nd = childList.item(i);
            if (!(nd instanceof Element)) continue;
            this.createIds(doc, (Element)nd, nextId);
        }
    }

    public List getKeys() {
        return this.allKeys;
    }

    public List getValues(String key) {
        if (key == null) {
            return null;
        }
        List<Element> elems = this.getElementsById(key);
        if (elems.size() > 0) {
            ArrayList<String> vals = new ArrayList<String>(elems.size());
            for (int i = 0; i < elems.size(); ++i) {
                Element elem = elems.get(i);
                if (elem.getFirstChild() != null && elem.getFirstChild().getNodeType() == 3) {
                    vals.add(elem.getFirstChild().getNodeValue());
                    continue;
                }
                vals.add("");
            }
            return vals;
        }
        return null;
    }

    public String getValue(String key) {
        if (this.mdValuesMap != null) {
            return this.mdValuesMap.get(key);
        }
        return null;
    }

    public Map<String, String> getValuesForKeys(List<String> keys, boolean includeChildren) {
        if (keys == null || keys.size() == 0) {
            return null;
        }
        LinkedHashMap<String, String> mdValues = new LinkedHashMap<String, String>();
        this.addKeyAndValue(keys, this.doc, mdValues, new MutableInt(0), includeChildren);
        return mdValues;
    }

    public DefaultMutableTreeNode getTreeForKeys(List<String> keys, boolean includeChildren) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("METATRANSCRIPT");
        this.addKeyAndValue(keys, this.doc, root, includeChildren);
        if (root.getChildCount() == 1) {
            if ((root = (DefaultMutableTreeNode)root.getChildAt(0)).getChildCount() == 1 && ((String)root.getUserObject()).indexOf("METATRANSCRIPT") > -1) {
                root = (DefaultMutableTreeNode)root.getChildAt(0);
            }
            int ch = root.getChildCount();
            block0: for (int i = 0; i < ch; ++i) {
                DefaultMutableTreeNode nd = (DefaultMutableTreeNode)root.getChildAt(i);
                Enumeration<TreeNode> nodeEnum = nd.depthFirstEnumeration();
                while (nodeEnum.hasMoreElements()) {
                    DefaultMutableTreeNode nd2 = (DefaultMutableTreeNode)nodeEnum.nextElement();
                    if (((String)nd2.getUserObject()).indexOf("MDGroup") <= -1) continue;
                    nodeEnum = null;
                    nd = (DefaultMutableTreeNode)nd2.getParent();
                    for (int j = nd2.getChildCount() - 1; j >= 0; --j) {
                        nd.add((DefaultMutableTreeNode)nd2.getChildAt(j));
                    }
                    nd.remove(nd2);
                    continue block0;
                }
            }
        }
        return root;
    }

    private List<Element> getElementsById(String key) {
        if (key != null) {
            ArrayList<Element> elems = new ArrayList<Element>(5);
            this.addChildElementsById(key, this.doc, elems);
            return elems;
        }
        return null;
    }

    private void addChildElementsById(String key, Node node, List<Element> elemList) {
        if (node != null) {
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element el;
                Node nd = nodes.item(i);
                if (nd instanceof Element && key.equals((el = (Element)nd).getAttribute("id"))) {
                    elemList.add(el);
                }
                this.addChildElementsById(key, nd, elemList);
            }
        }
    }

    private void addKeyAndValue(List<String> keys, Node node, Map<String, String> mdValues, MutableInt index, boolean includeChildren) {
        if (node == null) {
            return;
        }
        NodeList nodes = node.getChildNodes();
        String key = null;
        String val = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element elem;
            Node nd = nodes.item(i);
            if (nd instanceof Element && keys.contains(key = (elem = (Element)nd).getAttribute("id"))) {
                String name;
                val = elem.getFirstChild() != null && elem.getFirstChild().getNodeType() == 3 ? elem.getFirstChild().getNodeValue() : "";
                if (key.endsWith("Keys.Key") && (name = elem.getAttribute("Name")) != null) {
                    key = key + "[" + name + "]";
                }
                mdValues.put("(" + index.intValue + ")" + key, val);
                if (includeChildren) {
                    Node n2 = null;
                    NodeList childEl = elem.getElementsByTagName("*");
                    if (childEl.getLength() > 0) {
                        for (int j = 0; j < childEl.getLength(); ++j) {
                            n2 = childEl.item(j);
                            if (!(n2 instanceof Element)) continue;
                            ++index.intValue;
                            this.addChildKeyAndValue(n2, mdValues, index, includeChildren);
                        }
                    }
                }
            }
            ++index.intValue;
            this.addKeyAndValue(keys, nd, mdValues, index, includeChildren);
        }
    }

    private void addChildKeyAndValue(Node node, Map<String, String> mdValues, MutableInt index, boolean includeChildren) {
        if (node == null) {
            return;
        }
        String key = null;
        String val = null;
        if (node instanceof Element) {
            String name;
            Element elem = (Element)node;
            key = elem.getAttribute("id");
            val = elem.getFirstChild() != null && elem.getFirstChild().getNodeType() == 3 ? elem.getFirstChild().getNodeValue() : "";
            if (key.endsWith("Keys.Key") && (name = elem.getAttribute("Name")) != null) {
                key = key + "[" + name + "]";
            }
            mdValues.put("(" + index.intValue + ")" + key, val);
            if (includeChildren) {
                Node n2 = null;
                NodeList childEl = elem.getElementsByTagName("*");
                if (childEl.getLength() > 0) {
                    for (int j = 0; j < childEl.getLength(); ++j) {
                        n2 = childEl.item(j);
                        if (!(n2 instanceof Element)) continue;
                        ++index.intValue;
                        this.addChildKeyAndValue(childEl.item(j), mdValues, index, includeChildren);
                    }
                }
            }
        }
    }

    private void addKeyAndValue(List<String> keys, Node node, DefaultMutableTreeNode treeNode, boolean includeChildren) {
        if (node == null) {
            return;
        }
        NodeList nodes = node.getChildNodes();
        Element elem = null;
        String elId = null;
        String key = null;
        DefaultMutableTreeNode childNode = null;
        String val = null;
        boolean hasText = false;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node nd = nodes.item(i);
            childNode = null;
            hasText = false;
            if (nd instanceof Element) {
                elem = (Element)nd;
                elId = elem.getAttribute("id");
                key = elem.getNodeName();
                if (keys.contains(elId)) {
                    String name;
                    if (elem.getFirstChild() != null && elem.getFirstChild().getNodeType() == 3) {
                        val = elem.getFirstChild().getNodeValue();
                        hasText = true;
                    } else {
                        val = "-";
                    }
                    if (key.equals("Key")) {
                        name = elem.getAttribute("Name");
                        if (name == null || !hasText) continue;
                        key = name.replace(' ', '_');
                        childNode = new DefaultMutableTreeNode(this.getHtmlString(key, val));
                        treeNode.insert(childNode, 0);
                        continue;
                    }
                    if (hasText) {
                        childNode = new DefaultMutableTreeNode(this.getHtmlString(key, val));
                    } else if (key.equals("Actor") || key.equals("Session") || key.equals("Project")) {
                        name = this.getNameChildElement(elem);
                        childNode = new DefaultMutableTreeNode(this.getHtmlString(key, name));
                    } else {
                        childNode = new DefaultMutableTreeNode(this.getHtmlString(key, null));
                    }
                    treeNode.insert(childNode, 0);
                    if (includeChildren) {
                        Node n2 = null;
                        NodeList childEl = elem.getElementsByTagName("*");
                        if (childEl.getLength() > 0) {
                            for (int j = 0; j < childEl.getLength(); ++j) {
                                n2 = childEl.item(j);
                                if (!(n2 instanceof Element)) continue;
                                this.addChildKeyAndValue(n2, childNode, includeChildren);
                            }
                        }
                    }
                } else {
                    boolean mustAddEmptyTreeNode = false;
                    for (int j = 0; j < keys.size(); ++j) {
                        String next = keys.get(j);
                        if (next == null || !next.startsWith(elId)) continue;
                        mustAddEmptyTreeNode = true;
                        break;
                    }
                    if (mustAddEmptyTreeNode) {
                        if (key.equals("Actor") || key.equals("Session") || key.equals("Project")) {
                            String name = this.getNameChildElement(elem);
                            childNode = new DefaultMutableTreeNode(this.getHtmlString(key, name));
                        } else {
                            childNode = new DefaultMutableTreeNode(this.getHtmlString(key, null));
                        }
                        treeNode.insert(childNode, 0);
                    }
                }
            }
            if (childNode != null) {
                this.addKeyAndValue(keys, nd, childNode, includeChildren);
                continue;
            }
            this.addKeyAndValue(keys, nd, treeNode, includeChildren);
        }
    }

    private void addChildKeyAndValue(Node node, DefaultMutableTreeNode treeNode, boolean includeChildren) {
        if (node == null) {
            return;
        }
        Element elem = null;
        String key = null;
        DefaultMutableTreeNode childNode = null;
        String val = null;
        boolean hasText = false;
        if (node instanceof Element) {
            elem = (Element)node;
            key = elem.getNodeName();
            if (elem.getFirstChild() != null && elem.getFirstChild().getNodeType() == 3) {
                val = elem.getFirstChild().getNodeValue();
                hasText = true;
            } else {
                val = "-";
            }
            if (key.equals("Key")) {
                String name = elem.getAttribute("Name");
                if (name != null && hasText) {
                    key = name.replace(' ', '_');
                    childNode = new DefaultMutableTreeNode(this.getHtmlString(key, val));
                    treeNode.add(childNode);
                }
                return;
            }
            if (hasText) {
                childNode = new DefaultMutableTreeNode(this.getHtmlString(key, val));
            } else if (key.equals("Actor") || key.equals("Session") || key.equals("Project")) {
                String name = this.getNameChildElement(elem);
                childNode = new DefaultMutableTreeNode(this.getHtmlString(key, name));
            } else {
                childNode = new DefaultMutableTreeNode(this.getHtmlString(key, null));
            }
            if (childNode != null) {
                treeNode.add(childNode);
            }
            if (includeChildren) {
                Node n2 = null;
                NodeList childEl = elem.getElementsByTagName("*");
                if (childEl.getLength() > 0) {
                    for (int j = 0; j < childEl.getLength(); ++j) {
                        n2 = childEl.item(j);
                        if (!(n2 instanceof Element)) continue;
                        this.addChildKeyAndValue(n2, childNode, includeChildren);
                    }
                }
            }
        }
    }

    private String getNameChildElement(Element elem) {
        Node n;
        NodeList list;
        if (elem != null && (list = elem.getElementsByTagName("Name")).getLength() > 0 && (n = list.item(0)).getFirstChild() != null && n.getFirstChild().getNodeType() == 3) {
            return n.getFirstChild().getNodeValue();
        }
        return null;
    }

    private String getHtmlString(String key, String val) {
        if (key == null) {
            return null;
        }
        StringBuilder b = new StringBuilder("<html>");
        b.append("<b>");
        b.append(key);
        b.append("</b>");
        if (val != null) {
            b.append(" ");
            b.append(val);
        }
        b.append("</html>");
        return b.toString();
    }

    private void printChildren(Node node) {
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node nd = nodes.item(i);
            System.out.println("N: " + nd.getNodeName() + " V: " + nd.getNodeValue());
            if (nd instanceof Element) {
                Element el = (Element)nd;
                System.out.println("Id: " + el.getAttribute("id"));
                if (el.getFirstChild() != null && el.getFirstChild().getNodeType() == 3) {
                    System.out.println("Text: " + el.getFirstChild().getNodeValue());
                }
                System.out.println("Num Ch.: " + el.getChildNodes().getLength());
            }
            if (!nd.hasChildNodes()) continue;
            this.printChildren(nd);
        }
    }
}

