/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.md.spi;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.md.imdi.ImdiFileServiceProvider;
import mpi.eudico.client.annotator.md.spi.MDServiceProvider;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.util.ExtClassLoader;

public class MDServiceRegistry {
    private static MDServiceRegistry registry;
    private final String spiClassName = "mpi.eudico.client.annotator.md.spi.MDServiceProvider";
    private Class prefProviderClass;
    private List<Class> providers = new ArrayList<Class>();

    private MDServiceRegistry() {
        this.registerPropertySpi();
        this.registerStandardSpis();
        this.registerClasspathSpis();
    }

    public static MDServiceRegistry getInstance() {
        if (registry == null) {
            registry = new MDServiceRegistry();
        }
        return registry;
    }

    public MDServiceProvider getProviderByClassName(String className) {
        if (className == null) {
            return null;
        }
        if (this.prefProviderClass != null && this.prefProviderClass.getName().equals(className)) {
            return this.createProviderInstance(this.prefProviderClass);
        }
        for (int i = 0; i < this.providers.size(); ++i) {
            Class provClass = this.providers.get(i);
            if (!provClass.getName().equals(className)) continue;
            return this.createProviderInstance(provClass);
        }
        return null;
    }

    public MDServiceProvider getProviderForMDFile(String filePath) {
        if (filePath == null) {
            ClientLogger.LOG.warning("No file specified for TSServiceProvider");
            return null;
        }
        File f = new File(filePath);
        if (!f.exists()) {
            ClientLogger.LOG.warning("The metadata file does not exist: " + filePath);
            return null;
        }
        if (!f.canRead()) {
            ClientLogger.LOG.warning("The metadata file cannot be read: " + filePath);
            return null;
        }
        if (f.length() == 0L) {
            ClientLogger.LOG.warning("The metadata file has zero length: " + filePath);
            return null;
        }
        MDServiceProvider provider = null;
        if (this.prefProviderClass != null && (provider = this.createProviderInstance(this.prefProviderClass)) != null && provider.setMetadataFile(filePath)) {
            provider.initialize();
            return provider;
        }
        for (int i = 0; i < this.providers.size(); ++i) {
            Class cl = this.providers.get(i);
            provider = this.createProviderInstance(cl);
            if (provider == null || !provider.setMetadataFile(filePath)) continue;
            provider.initialize();
            return provider;
        }
        return null;
    }

    private void registerPropertySpi() {
        String name = System.getProperty("mpi.eudico.client.annotator.md.spi.MDServiceProvider");
        if (name == null) {
            return;
        }
        try {
            Class<?> c;
            this.prefProviderClass = c = Class.forName(name, true, ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException cnfe) {
            ClientLogger.LOG.warning(cnfe.getMessage());
        }
        catch (SecurityException se) {
            ClientLogger.LOG.warning(se.getMessage());
        }
        if (this.prefProviderClass == null) {
            try {
                Class<?> propImpl = ExtClassLoader.getInstance().loadClass(name);
                if (propImpl != null) {
                    try {
                        this.prefProviderClass = propImpl;
                    }
                    catch (SecurityException se) {
                        ClientLogger.LOG.warning(se.getMessage());
                    }
                }
            }
            catch (ClassNotFoundException cne) {
                ClientLogger.LOG.warning(cne.getMessage());
            }
        }
    }

    private void registerStandardSpis() {
        this.providers.add(ImdiFileServiceProvider.class);
    }

    private void registerClasspathSpis() {
        Class[] implementors = ExtClassLoader.getInstance().getImplementingClasses(MDServiceProvider.class);
        if (implementors != null && implementors.length > 0) {
            for (int i = 0; i < implementors.length; ++i) {
                Class cl = implementors[i];
                if (this.providers.contains(cl)) continue;
                this.providers.add(cl);
            }
        }
    }

    private MDServiceProvider createProviderInstance(Class cl) {
        if (cl == null) {
            ClientLogger.LOG.warning("Cannot create a new instance: the class is null");
            return null;
        }
        try {
            return (MDServiceProvider)cl.newInstance();
        }
        catch (IllegalAccessException iae) {
            ClientLogger.LOG.warning("Cannot create new instance of: " + cl);
            ClientLogger.LOG.warning(iae.getMessage());
        }
        catch (InstantiationException ia) {
            ClientLogger.LOG.warning("Cannot create new instance of: " + cl);
            ClientLogger.LOG.warning(ia.getMessage());
        }
        catch (SecurityException se) {
            ClientLogger.LOG.warning("Cannot create new instance of: " + cl);
            ClientLogger.LOG.warning(se.getMessage());
        }
        catch (Exception exc) {
            ClientLogger.LOG.warning("Cannot create new instance of: " + cl);
            ClientLogger.LOG.warning(exc.getMessage());
        }
        return null;
    }
}

