/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.awt.Component;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.ControllerListener;
import mpi.eudico.client.mediacontrol.ControllerManager;
import mpi.eudico.client.mediacontrol.PeriodicUpdateController;
import mpi.eudico.client.mediacontrol.TimeEvent;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;

public class EmptyMediaPlayer
extends ControllerManager
implements ElanMediaPlayer,
ControllerListener {
    private long mediaTime;
    private long offset;
    private float rate;
    private float volume;
    private boolean playing;
    private long milliSecondsPerSample;
    private long duration;
    private long startTimeMillis;
    private boolean playingInterval;
    private PeriodicUpdateController periodicController;
    private long intervalStopTime;
    private boolean frameStepsToFrameBegin = false;

    public EmptyMediaPlayer(long duration) {
        this.duration = duration;
        this.offset = 0L;
        this.volume = 1.0f;
        this.rate = 1.0f;
        this.milliSecondsPerSample = 40L;
    }

    public MediaDescriptor getMediaDescriptor() {
        return null;
    }

    public String getFrameworkDescription() {
        return "Empty Media Player";
    }

    public synchronized void controllerUpdate(ControllerEvent event) {
        if (event instanceof TimeEvent && this.periodicController != null && this.getMediaTime() >= this.intervalStopTime) {
            this.stop();
        }
    }

    public synchronized void playInterval(long startTime, long stopTime) {
        if (this.playingInterval || stopTime <= startTime) {
            return;
        }
        this.periodicController = new PeriodicUpdateController(25L);
        this.periodicController.addControllerListener(this);
        this.addController(this.periodicController);
        this.intervalStopTime = stopTime;
        this.setMediaTime(startTime);
        this.playingInterval = true;
        this.start();
    }

    public void setStopTime(long stopTime) {
    }

    private void stopPlayingInterval() {
        if (this.periodicController != null) {
            this.periodicController.removeControllerListener(this);
            this.removeController(this.periodicController);
            this.periodicController = null;
        }
        this.playingInterval = false;
    }

    public Component getVisualComponent() {
        return null;
    }

    public int getSourceHeight() {
        return 0;
    }

    public int getSourceWidth() {
        return 0;
    }

    public float getAspectRatio() {
        return 1.0f;
    }

    public void setAspectRatio(float aspectRatio) {
    }

    public synchronized void start() {
        this.playing = true;
        this.startTimeMillis = System.currentTimeMillis();
        this.startControllers();
    }

    public synchronized void stop() {
        if (this.playing) {
            this.mediaTime += System.currentTimeMillis() - this.startTimeMillis;
        }
        this.playing = false;
        this.stopControllers();
        if (this.playingInterval) {
            this.stopPlayingInterval();
        }
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public long getMilliSecondsPerSample() {
        return this.milliSecondsPerSample;
    }

    public void setMilliSecondsPerSample(long milliSeconds) {
        this.milliSecondsPerSample = milliSeconds;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getMediaTime() {
        if (this.playing) {
            return this.mediaTime + System.currentTimeMillis() - this.startTimeMillis;
        }
        return this.mediaTime - this.offset;
    }

    public void setMediaTime(long time) {
        this.mediaTime = time + this.offset;
        this.setControllersMediaTime(time);
    }

    public void nextFrame() {
        if (this.frameStepsToFrameBegin) {
            long curFrame = this.getMediaTime() / this.milliSecondsPerSample;
            this.setMediaTime((curFrame + 1L) * this.milliSecondsPerSample);
        } else {
            this.setMediaTime(this.getMediaTime() + this.getMilliSecondsPerSample());
        }
    }

    public void previousFrame() {
        if (this.frameStepsToFrameBegin) {
            long curFrame = this.getMediaTime() / this.milliSecondsPerSample;
            if (curFrame > 0L) {
                this.setMediaTime((curFrame - 1L) * this.milliSecondsPerSample);
            } else {
                this.setMediaTime(0L);
            }
        } else {
            this.setMediaTime(this.getMediaTime() - this.getMilliSecondsPerSample());
        }
    }

    public void setFrameStepsToFrameBegin(boolean stepsToFrameBegin) {
        this.frameStepsToFrameBegin = stepsToFrameBegin;
    }

    public float getRate() {
        return this.rate;
    }

    public synchronized void setRate(float rate) {
        this.rate = rate;
    }

    public boolean isFrameRateAutoDetected() {
        return false;
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float level) {
        this.volume = level;
    }

    public void setLayoutManager(ElanLayoutManager layoutManager) {
    }

    public void updateLocale() {
    }

    public long getMediaDuration() {
        return this.duration;
    }

    public void cleanUpOnClose() {
    }
}

