/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.FormattedMessageDlg;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.ImagePanel;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.ControllerListener;
import mpi.eudico.client.mediacontrol.ControllerManager;
import mpi.eudico.client.mediacontrol.PeriodicUpdateController;
import mpi.eudico.client.mediacontrol.TimeEvent;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.util.TimeFormatter;

public class ImagePlayer
extends ControllerManager
implements ElanMediaPlayer,
ControllerListener,
MouseListener,
ActionListener {
    private MediaDescriptor mediaDescriptor;
    protected BufferedImage image;
    protected ImagePanel visComponent;
    protected boolean attached = true;
    protected boolean cursorVisible = false;
    private ElanLayoutManager layoutManager;
    private long mediaTime;
    private long offset;
    private float rate;
    private boolean playing;
    private long milliSecondsPerSample;
    protected long duration = 10000L;
    protected int[] cursorGrid = new int[]{1, 1};
    private boolean frameStepsToFrameBegin = false;
    private long startTimeMillis;
    private boolean playingInterval;
    private PeriodicUpdateController periodicController;
    private PeriodicUpdateController playerController;
    private long intervalStopTime;
    private JPopupMenu popup;
    private JMenuItem detachMI;
    private JMenuItem durationItem;
    private JCheckBoxMenuItem cursorVisItem;
    private final DecimalFormat format = new DecimalFormat("#.###");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImagePlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        this.mediaDescriptor = mediaDescriptor;
        this.offset = 0L;
        this.rate = 1.0f;
        this.milliSecondsPerSample = 40L;
        if (mediaDescriptor != null) {
            this.offset = mediaDescriptor.timeOrigin;
            if (mediaDescriptor.mediaURL == null) throw new NoPlayerException("Cannot create player: no media descriptor");
            try {
                URL url = new URL(mediaDescriptor.mediaURL);
                try {
                    this.image = ImageIO.read(url);
                }
                catch (IOException ioe) {
                    throw new NoPlayerException("Cannot create player: " + ioe.getMessage());
                }
            }
            catch (MalformedURLException mue) {
                if (mediaDescriptor.mediaURL.startsWith("file:")) {
                    String path = mediaDescriptor.mediaURL.substring(5);
                    File f = new File(path);
                    if (!f.exists() || !f.canRead()) {
                        throw new NoPlayerException("Cannot create player: file does not exist or cannot be read - " + mediaDescriptor.mediaURL);
                    }
                    try {
                        this.image = ImageIO.read(f);
                    }
                    catch (IOException ioe) {
                        throw new NoPlayerException("Cannot create player: " + ioe.getMessage());
                    }
                }
                File f = new File(mediaDescriptor.mediaURL);
                if (f.exists() && f.canRead()) throw new NoPlayerException("Cannot create player for: " + mediaDescriptor.mediaURL);
                throw new NoPlayerException("Cannot create player: file does not exist or cannot be read - " + mediaDescriptor.mediaURL);
            }
            if (this.image == null) throw new NoPlayerException("Cannot create player for: " + mediaDescriptor.mediaURL);
            this.duration = 600000L - this.offset;
        }
        this.playerController = new PeriodicUpdateController(40L);
        this.playerController.addControllerListener(this);
        this.addController(this.playerController);
    }

    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof TimeEvent) {
            if (this.periodicController != null) {
                if (this.getMediaTime() >= this.intervalStopTime) {
                    this.stop();
                }
            } else if (this.getMediaTime() >= this.duration) {
                this.stop();
                this.playerController.setMediaTime(this.duration);
            }
        }
        if (this.visComponent != null && this.visComponent.isCursorVisible()) {
            long mt = this.getMediaTime();
            if (this.duration - this.offset > 0L) {
                this.visComponent.setCursorProgress((float)(mt + this.offset) / (float)this.duration);
            } else {
                this.visComponent.setCursorProgress(0.0f);
            }
        }
    }

    public void cleanUpOnClose() {
        if (this.visComponent != null) {
            this.visComponent.flush();
        }
    }

    public float getAspectRatio() {
        if (this.image != null && this.image.getHeight() != 0) {
            return (float)this.image.getWidth() / (float)this.image.getHeight();
        }
        return 1.0f;
    }

    public String getFrameworkDescription() {
        return "MPI_PL Image Player";
    }

    public MediaDescriptor getMediaDescriptor() {
        return this.mediaDescriptor;
    }

    public long getMediaDuration() {
        return this.duration - this.offset;
    }

    public long getMediaTime() {
        if (this.playing) {
            return this.mediaTime + System.currentTimeMillis() - this.startTimeMillis - this.offset;
        }
        return this.mediaTime - this.offset;
    }

    public long getMilliSecondsPerSample() {
        return this.milliSecondsPerSample;
    }

    public long getOffset() {
        return this.offset;
    }

    public float getRate() {
        return this.rate;
    }

    public int getSourceHeight() {
        if (this.image != null) {
            return this.image.getHeight();
        }
        return 0;
    }

    public int getSourceWidth() {
        if (this.image != null) {
            return this.image.getWidth();
        }
        return 0;
    }

    public Component getVisualComponent() {
        if (this.visComponent == null) {
            this.visComponent = new ImagePanel(this.image);
            this.visComponent.setCursorVisible(this.cursorVisible);
            this.visComponent.setCursorGrid(this.cursorGrid[0], this.cursorGrid[1]);
            this.visComponent.addMouseListener(this);
        }
        return this.visComponent;
    }

    public float getVolume() {
        return 0.0f;
    }

    public boolean isFrameRateAutoDetected() {
        return true;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void nextFrame() {
        if (this.frameStepsToFrameBegin) {
            long curFrame = this.getMediaTime() / this.milliSecondsPerSample;
            this.setMediaTime((curFrame + 1L) * this.milliSecondsPerSample);
        } else {
            this.setMediaTime(this.getMediaTime() + this.getMilliSecondsPerSample());
        }
    }

    public void playInterval(long startTime, long stopTime) {
        if (this.playingInterval || stopTime <= startTime) {
            return;
        }
        this.periodicController = new PeriodicUpdateController(25L);
        this.periodicController.addControllerListener(this);
        this.addController(this.periodicController);
        this.intervalStopTime = stopTime;
        this.setMediaTime(startTime);
        this.playingInterval = true;
        this.start();
    }

    public void previousFrame() {
        if (this.frameStepsToFrameBegin) {
            long curFrame = this.getMediaTime() / this.milliSecondsPerSample;
            if (curFrame > 0L) {
                this.setMediaTime((curFrame - 1L) * this.milliSecondsPerSample);
            } else {
                this.setMediaTime(0L);
            }
        } else {
            this.setMediaTime(this.getMediaTime() - this.getMilliSecondsPerSample());
        }
    }

    public void setAspectRatio(float aspectRatio) {
    }

    public void setFrameStepsToFrameBegin(boolean stepsToFrameBegin) {
        this.frameStepsToFrameBegin = stepsToFrameBegin;
    }

    public void setLayoutManager(ElanLayoutManager layoutManager) {
        this.layoutManager = layoutManager;
        if (layoutManager != null) {
            Object val = Preferences.get("ImagePlayer.Duration", layoutManager.getViewerManager().getTranscription());
            if (val instanceof Long) {
                this.duration = (Long)val;
            }
            if ((val = Preferences.get("ImagePlayer.CursorVisible", layoutManager.getViewerManager().getTranscription())) instanceof Boolean) {
                this.cursorVisible = (Boolean)val;
                if (this.visComponent != null) {
                    this.visComponent.setCursorVisible(this.cursorVisible);
                }
            }
            if ((val = Preferences.get("ImagePlayer.CursorGrid.Columns", layoutManager.getViewerManager().getTranscription())) instanceof Integer) {
                this.cursorGrid[0] = (Integer)val;
            }
            if ((val = Preferences.get("ImagePlayer.CursorGrid.Rows", layoutManager.getViewerManager().getTranscription())) instanceof Integer) {
                this.cursorGrid[1] = (Integer)val;
            }
            if (this.visComponent != null) {
                this.visComponent.setCursorGrid(this.cursorGrid[0], this.cursorGrid[1]);
            }
        }
    }

    public void setMediaTime(long time) {
        this.mediaTime = time + this.offset;
        if (this.mediaTime > this.duration) {
            this.mediaTime = this.duration;
        }
        this.setControllersMediaTime(time);
    }

    public void setMilliSecondsPerSample(long milliSeconds) {
        this.milliSecondsPerSample = milliSeconds;
    }

    public void setOffset(long offset) {
        this.offset = offset;
        this.mediaDescriptor.timeOrigin = offset;
    }

    public void setRate(float rate) {
        this.rate = rate;
    }

    public void setStopTime(long stopTime) {
    }

    public void setVolume(float level) {
    }

    public void start() {
        this.playing = true;
        this.startTimeMillis = System.currentTimeMillis();
        this.startControllers();
    }

    public void stop() {
        if (this.playing) {
            this.mediaTime += System.currentTimeMillis() - this.startTimeMillis;
        }
        this.playing = false;
        this.stopControllers();
        if (this.playingInterval) {
            this.stopPlayingInterval();
        }
    }

    private void copyToClipboard(String text) {
        if (text == null) {
            return;
        }
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkSystemClipboardAccess();
                StringSelection ssVal = new StringSelection(text);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssVal, null);
            }
            catch (SecurityException se) {
            }
            catch (IllegalStateException ise) {}
        } else {
            try {
                StringSelection ssVal = new StringSelection(text);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssVal, null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private void stopPlayingInterval() {
        if (this.periodicController != null) {
            this.periodicController.removeControllerListener(this);
            this.removeController(this.periodicController);
            this.periodicController = null;
        }
        this.playingInterval = false;
    }

    public void updateLocale() {
        if (this.popup != null) {
            this.popup = null;
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.image == null) {
            return;
        }
        try {
            if (e.isAltDown()) {
                this.copyToClipboard(this.format.format((float)e.getX() / (float)this.visComponent.getWidth()) + "," + this.format.format((float)e.getY() / (float)this.visComponent.getHeight()));
            } else if (e.isShiftDown()) {
                this.copyToClipboard("" + (int)((float)this.image.getWidth() / (float)this.visComponent.getWidth() * (float)e.getX()) + "," + (int)((float)this.image.getHeight() / (float)this.visComponent.getHeight() * (float)e.getY()));
            } else {
                this.copyToClipboard("" + (int)((float)this.image.getWidth() / (float)this.visComponent.getWidth() * (float)e.getX()) + "," + (int)((float)this.image.getHeight() / (float)this.visComponent.getHeight() * (float)e.getY()) + " [" + this.image.getWidth() + "," + this.image.getHeight() + "]");
            }
        }
        catch (Exception exep) {
            exep.printStackTrace();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) && e.getButton() == 1 ^ e.isMetaDown() || e.isPopupTrigger()) {
            if (this.popup == null) {
                this.popup = new JPopupMenu("Popup");
                this.detachMI = new JMenuItem();
                this.detachMI.setActionCommand("detach");
                if (this.attached) {
                    this.detachMI.setText(ElanLocale.getString("Detachable.detach"));
                } else {
                    this.detachMI.setText(ElanLocale.getString("Detachable.attach"));
                }
                this.detachMI.addActionListener(this);
                this.popup.add(this.detachMI);
                JMenuItem infoItem = new JMenuItem(ElanLocale.getString("Player.Info"));
                infoItem.setActionCommand("info");
                infoItem.addActionListener(this);
                this.popup.add(infoItem);
                JMenuItem setDurationItem = new JMenuItem(ElanLocale.getString("Player.SetDuration"));
                setDurationItem.setActionCommand("duration");
                setDurationItem.addActionListener(this);
                this.popup.add(setDurationItem);
                this.durationItem = new JMenuItem(ElanLocale.getString("Player.duration") + ":  " + TimeFormatter.toString(this.getMediaDuration()));
                this.durationItem.setEnabled(false);
                this.popup.add(this.durationItem);
                this.popup.addSeparator();
                this.cursorVisItem = new JCheckBoxMenuItem(ElanLocale.getString("ImagePlayer.CursorVisible"));
                this.cursorVisItem.setActionCommand("curvis");
                this.cursorVisItem.setSelected(this.cursorVisible);
                this.cursorVisItem.addActionListener(this);
                this.popup.add(this.cursorVisItem);
                JMenuItem setCursorGridItem = new JMenuItem(ElanLocale.getString("ImagePlayer.CursorGrid"));
                setCursorGridItem.setActionCommand("setgrid");
                setCursorGridItem.addActionListener(this);
                this.popup.add(setCursorGridItem);
            }
            this.popup.show((Component)e.getSource(), e.getPoint().x, e.getPoint().y);
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("detach")) {
            if (this.attached) {
                if (this.layoutManager != null && this.visComponent != null) {
                    this.layoutManager.detach(this.visComponent);
                    this.attached = !this.attached;
                    this.detachMI.setText(ElanLocale.getString("Detachable.attach"));
                }
            } else if (this.layoutManager != null && this.visComponent != null) {
                this.layoutManager.attach(this.visComponent);
                this.attached = !this.attached;
                this.detachMI.setText(ElanLocale.getString("Detachable.detach"));
            }
        } else if (e.getActionCommand().equals("info")) {
            new FormattedMessageDlg(this);
        } else if (e.getActionCommand().equals("duration")) {
            String dur = null;
            Container parent = this.visComponent;
            if (this.layoutManager != null) {
                parent = this.layoutManager.getElanFrame();
            }
            if ((dur = JOptionPane.showInputDialog(parent, ElanLocale.getString("Player.SetDurationMessage"), ElanLocale.getString("Player.SetDuration"), -1)) != null && dur.length() > 0) {
                long ms = TimeFormatter.toMilliSeconds(dur);
                if (ms > this.offset && ms > this.milliSecondsPerSample) {
                    this.duration = ms;
                    if (this.durationItem != null) {
                        this.durationItem.setText(ElanLocale.getString("Player.duration") + ":  " + TimeFormatter.toString(this.getMediaDuration()));
                    }
                    if (this.getMediaTime() > this.getMediaDuration()) {
                        this.setMediaTime(this.getMediaDuration());
                    }
                }
                if (this.visComponent.isCursorVisible()) {
                    long mt = this.getMediaTime();
                    if (this.duration - this.offset > 0L) {
                        this.visComponent.setCursorProgress((float)(mt + this.offset) / (float)this.duration);
                    } else {
                        this.visComponent.setCursorProgress(0.0f);
                    }
                }
                this.layoutManager.setPreference("ImagePlayer.Duration", new Long(this.duration), this.layoutManager.getViewerManager().getTranscription());
            }
        } else if (e.getActionCommand().equals("curvis")) {
            if (this.visComponent != null && this.cursorVisItem != null) {
                this.visComponent.setCursorVisible(this.cursorVisItem.isSelected());
                if (this.visComponent.isCursorVisible()) {
                    long mt = this.getMediaTime();
                    if (this.duration > 0L) {
                        this.visComponent.setCursorProgress((float)mt / (float)this.duration);
                    } else {
                        this.visComponent.setCursorProgress(0.0f);
                    }
                }
                this.layoutManager.setPreference("ImagePlayer.CursorVisible", new Boolean(this.visComponent.isCursorVisible()), this.layoutManager.getViewerManager().getTranscription());
            }
        } else if (e.getActionCommand().equals("setgrid")) {
            int option;
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.gridwidth = 2;
            panel.add((Component)new JLabel(ElanLocale.getString("ImagePlayer.CursorGridLabel")), gbc);
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 17;
            panel.add((Component)new JLabel(ElanLocale.getString("ImagePlayer.CursorGridColumns")), gbc);
            JTextField colField = new JTextField(8);
            colField.setText(String.valueOf(this.cursorGrid[0]));
            gbc.gridx = 1;
            panel.add((Component)colField, gbc);
            JTextField rowField = new JTextField(8);
            rowField.setText(String.valueOf(this.cursorGrid[1]));
            gbc.gridy = 2;
            panel.add((Component)rowField, gbc);
            gbc.gridx = 0;
            panel.add((Component)new JLabel(ElanLocale.getString("ImagePlayer.CursorGridRows")), gbc);
            Container parent = this.visComponent;
            if (this.layoutManager != null) {
                parent = this.layoutManager.getElanFrame();
            }
            if ((option = JOptionPane.showConfirmDialog(parent, panel, ElanLocale.getString("ImagePlayer.CursorGrid"), 2, -1, null)) == 0) {
                try {
                    this.cursorGrid[0] = Integer.parseInt(colField.getText());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                try {
                    this.cursorGrid[1] = Integer.parseInt(rowField.getText());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                this.visComponent.setCursorGrid(this.cursorGrid[0], this.cursorGrid[1]);
                this.layoutManager.setPreference("ImagePlayer.CursorGrid.Columns", new Integer(this.cursorGrid[0]), this.layoutManager.getViewerManager().getTranscription());
                this.layoutManager.setPreference("ImagePlayer.CursorGrid.Rows", new Integer(this.cursorGrid[1]), this.layoutManager.getViewerManager().getTranscription());
            }
        }
    }
}

