/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.export.ImageExporter;
import mpi.eudico.client.annotator.gui.FormattedMessageDlg;
import mpi.eudico.client.annotator.gui.TextAreaMessageDlg;
import mpi.eudico.client.annotator.player.DIBToImage;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.annotator.player.VideoFrameGrabber;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.ControllerListener;
import mpi.eudico.client.mediacontrol.ControllerManager;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.util.TimeFormatter;
import nl.mpi.jds.JDSException;
import nl.mpi.jds.JDSPanel;
import nl.mpi.jds.JDSPlayer;

public class JDSMediaPlayer
extends ControllerManager
implements ElanMediaPlayer,
ControllerListener,
VideoFrameGrabber,
ActionListener {
    private static boolean regFiltersPrinted = false;
    private JDSPlayer jdsPlayer;
    private JDSPanel jdsPanel;
    private MediaDescriptor mediaDescriptor;
    private long offset = 0L;
    private long stopTime;
    private long duration;
    private float origAspectRatio;
    private float aspectRatio;
    private double millisPerSample;
    private boolean playing;
    private PlayerStateWatcher stopThread = null;
    private PlayerEndWatcher endThread = null;
    private boolean frameRateAutoDetected = true;
    private boolean frameStepsToFrameBegin = false;
    private ElanLayoutManager layoutManager;
    private JPopupMenu popup;
    private JMenuItem durationItem;
    protected JMenuItem detachItem;
    private JMenuItem infoItem;
    private JMenuItem saveItem;
    private JRadioButtonMenuItem origRatioItem;
    private JRadioButtonMenuItem ratio_4_3_Item;
    private JRadioButtonMenuItem ratio_3_2_Item;
    private JRadioButtonMenuItem ratio_16_9_Item;
    private JRadioButtonMenuItem ratio_185_1_Item;
    private JRadioButtonMenuItem ratio_235_1_Item;
    private JMenuItem graphItem;
    private JMenuItem allFiltersItem;
    private boolean detached;
    private JMenu arMenu;
    private JMenu zoomMenu;
    private JRadioButtonMenuItem zoom100;
    private JRadioButtonMenuItem zoom150;
    private JRadioButtonMenuItem zoom200;
    private JRadioButtonMenuItem zoom300;
    private JRadioButtonMenuItem zoom400;
    private float videoScaleFactor = 1.0f;
    private int vx = 0;
    private int vy = 0;
    private int vw = 0;
    private int vh = 0;
    private int dragX = 0;
    private int dragY = 0;
    private static int java_version = 15;

    public JDSMediaPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        this.mediaDescriptor = mediaDescriptor;
        this.offset = mediaDescriptor.timeOrigin;
        String URLString = mediaDescriptor.mediaURL;
        if (URLString.startsWith("file:") && !URLString.startsWith("file:///")) {
            URLString = URLString.substring(5);
        }
        String prefSplitter = System.getProperty("JDSPreferredSplitter");
        try {
            this.jdsPlayer = prefSplitter == null || prefSplitter.length() == 0 ? new JDSPlayer(URLString) : new JDSPlayer(URLString, prefSplitter);
            this.duration = this.jdsPlayer.getDuration();
            this.jdsPlayer.setStopTime(this.duration);
            this.duration -= this.offset;
            this.aspectRatio = this.origAspectRatio = this.jdsPlayer.getAspectRatio();
            this.millisPerSample = this.jdsPlayer.getTimePerFrame();
            if (this.millisPerSample == 0.0) {
                this.millisPerSample = 40.0;
                this.frameRateAutoDetected = false;
            }
            if (this.jdsPlayer.isVisualMedia()) {
                this.jdsPanel = new JDSPanel(this.jdsPlayer);
                this.initPopupMenu();
                MouseHandler mh = new MouseHandler();
                this.jdsPanel.addMouseListener(mh);
                this.jdsPanel.addMouseMotionListener(mh);
            } else {
                this.millisPerSample = 40.0;
                this.frameRateAutoDetected = false;
                this.aspectRatio = 0.0f;
            }
            if (!regFiltersPrinted) {
                this.printRegisteredFilters();
            }
            this.printFiltersInChain();
        }
        catch (JDSException jdse) {
            throw new NoPlayerException(jdse.getMessage());
        }
    }

    private void printRegisteredFilters() {
        if (this.jdsPlayer != null) {
            String[] allFilters = this.jdsPlayer.getRegisteredFilters();
            System.out.println("Registered Filters:");
            for (int i = 0; i < allFilters.length; ++i) {
                System.out.println(i + ": " + allFilters[i]);
            }
            regFiltersPrinted = true;
            System.out.println();
        }
    }

    private void printFiltersInChain() {
        if (this.jdsPlayer != null) {
            String[] filters = this.jdsPlayer.getFiltersInGraph();
            System.out.println("Filters in the filter chain: " + this.mediaDescriptor.mediaURL);
            for (int i = 0; i < filters.length; ++i) {
                System.out.println(filters[i]);
            }
        }
    }

    public void cleanUpOnClose() {
        if (this.jdsPlayer != null) {
            this.jdsPlayer.cleanUpOnClose();
            this.jdsPlayer = null;
        }
    }

    public float getAspectRatio() {
        return this.aspectRatio;
    }

    public String getFrameworkDescription() {
        return "JDS - Java DirectShow Player";
    }

    public MediaDescriptor getMediaDescriptor() {
        return this.mediaDescriptor;
    }

    public long getMediaDuration() {
        return this.duration;
    }

    public long getMediaTime() {
        if (this.jdsPlayer != null) {
            return this.jdsPlayer.getMediaTime() - this.offset;
        }
        return 0L;
    }

    public long getMilliSecondsPerSample() {
        return (long)this.millisPerSample;
    }

    public long getOffset() {
        return this.offset;
    }

    public float getRate() {
        if (this.jdsPlayer != null) {
            return this.jdsPlayer.getRate();
        }
        return 0.0f;
    }

    public int getSourceHeight() {
        if (this.jdsPlayer != null) {
            return this.jdsPlayer.getSourceHeight();
        }
        return 0;
    }

    public int getSourceWidth() {
        if (this.jdsPlayer != null) {
            return this.jdsPlayer.getSourceWidth();
        }
        return 0;
    }

    public Component getVisualComponent() {
        return this.jdsPanel;
    }

    public float getVolume() {
        if (this.jdsPlayer != null) {
            return this.jdsPlayer.getVolume();
        }
        return 0.0f;
    }

    public boolean isFrameRateAutoDetected() {
        return this.frameRateAutoDetected;
    }

    public boolean isPlaying() {
        if (this.jdsPlayer != null) {
            return this.jdsPlayer.isPlaying();
        }
        return false;
    }

    public void nextFrame() {
        if (this.jdsPlayer != null) {
            if (this.jdsPlayer.isPlaying()) {
                this.stop();
            }
            if (this.frameStepsToFrameBegin) {
                long curFrame = (long)((double)this.getMediaTime() / this.millisPerSample);
                this.setMediaTime((long)((double)(curFrame + 1L) * this.millisPerSample));
            } else {
                long curTime = this.jdsPlayer.getMediaTime();
                curTime = (long)((double)curTime + this.millisPerSample);
                this.jdsPlayer.setMediaTime(curTime);
                this.setControllersMediaTime(curTime - this.offset);
            }
        }
    }

    public void playInterval(long startTime, long stopTime) {
        if (this.jdsPlayer != null) {
            if (this.jdsPlayer.isPlaying()) {
                this.stop();
            }
            this.setStopTime(stopTime);
            this.setMediaTime(startTime);
            this.startInterval();
        }
    }

    public void setStopTime(long stopTime) {
        this.stopTime = stopTime;
        long nFrames = (stopTime + this.offset) / this.getMilliSecondsPerSample();
        if (nFrames * this.getMilliSecondsPerSample() == stopTime + this.offset) {
            ++this.stopTime;
        }
        this.jdsPlayer.setStopTime(this.stopTime + this.offset);
        this.setControllersStopTime(this.stopTime);
    }

    public void previousFrame() {
        if (this.jdsPlayer != null) {
            if (this.jdsPlayer.isPlaying()) {
                this.stop();
            }
            if (this.frameStepsToFrameBegin) {
                long curFrame = (long)((double)this.getMediaTime() / this.millisPerSample);
                if (curFrame > 0L) {
                    this.setMediaTime((long)((double)(curFrame - 1L) * this.millisPerSample));
                } else {
                    this.setMediaTime(0L);
                }
            } else {
                long curTime = this.jdsPlayer.getMediaTime();
                if ((curTime = (long)((double)curTime - this.millisPerSample)) < 0L) {
                    curTime = 0L;
                }
                this.jdsPlayer.setMediaTime(curTime);
                this.setControllersMediaTime(curTime - this.offset);
            }
        }
    }

    public void setAspectRatio(float aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    public void setFrameStepsToFrameBegin(boolean stepsToFrameBegin) {
        this.frameStepsToFrameBegin = stepsToFrameBegin;
    }

    public void setZoomFactor(float zoom) {
        this.videoScaleFactor = zoom;
        if (this.videoScaleFactor == 1.0f) {
            this.vx = 0;
            this.vy = 0;
        }
        this.vw = (int)(this.videoScaleFactor * (float)this.jdsPanel.getWidth());
        this.vh = (int)(this.videoScaleFactor * (float)this.jdsPanel.getHeight());
        this.jdsPlayer.setVideoScaleFactor(this.videoScaleFactor);
        if (this.popup != null) {
            int zf = (int)(100.0f * this.videoScaleFactor);
            switch (zf) {
                case 100: {
                    this.zoom100.setSelected(true);
                    break;
                }
                case 150: {
                    this.zoom150.setSelected(true);
                    break;
                }
                case 200: {
                    this.zoom200.setSelected(true);
                    break;
                }
                case 300: {
                    this.zoom300.setSelected(true);
                    break;
                }
                case 400: {
                    this.zoom400.setSelected(true);
                }
            }
        }
    }

    public void setLayoutManager(ElanLayoutManager layoutManager) {
        if (this.layoutManager == null) {
            // empty if block
        }
        this.layoutManager = layoutManager;
    }

    public void setMediaTime(long time) {
        if (this.jdsPlayer != null) {
            if (this.jdsPlayer.isPlaying()) {
                this.stop();
            }
            if (time < 0L) {
                time = 0L;
            }
            if (time > this.duration) {
                time = this.duration;
            }
            if (this.jdsPlayer.getState() != 1) {
                this.jdsPlayer.pause();
            }
            this.jdsPlayer.setMediaTime(time + this.offset);
            this.setControllersMediaTime(time);
        }
    }

    public void setMilliSecondsPerSample(long milliSeconds) {
        if (!this.frameRateAutoDetected) {
            this.millisPerSample = milliSeconds;
        }
    }

    public void setOffset(long offset) {
        long diff = this.offset - offset;
        this.offset = offset;
        this.mediaDescriptor.timeOrigin = offset;
        if (this.jdsPlayer != null) {
            this.duration = this.jdsPlayer.getDuration() - offset;
        }
        this.stopTime += diff;
        this.setStopTime(this.stopTime);
    }

    public void setRate(float rate) {
        if (this.jdsPlayer != null) {
            this.jdsPlayer.setRate(rate);
        }
        this.setControllersRate(rate);
    }

    public void setVolume(float level) {
        if (this.jdsPlayer != null) {
            this.jdsPlayer.setVolume(level);
        }
    }

    void startInterval() {
        if (this.jdsPlayer != null) {
            if (this.playing) {
                return;
            }
            this.playing = true;
            this.jdsPlayer.start();
            this.startControllers();
            if (this.stopThread != null && this.stopThread.isAlive()) {
                this.stopThread.setStopped();
            }
            this.stopThread = new PlayerStateWatcher();
            this.stopThread.start();
        }
    }

    public void start() {
        if (this.jdsPlayer != null) {
            if (this.playing) {
                return;
            }
            if (this.getMediaDuration() - this.getMediaTime() < 40L) {
                this.setMediaTime(0L);
            }
            this.playing = true;
            this.jdsPlayer.start();
            this.startControllers();
            if (this.endThread != null && this.endThread.isAlive()) {
                this.endThread.setStopped();
            }
            this.endThread = new PlayerEndWatcher();
            this.endThread.start();
        }
    }

    public void stop() {
        if (this.jdsPlayer != null) {
            if (!this.playing) {
                return;
            }
            if (this.stopThread != null) {
                this.stopThread.setStopped();
            }
            this.jdsPlayer.pause();
            this.stopControllers();
            this.setControllersMediaTime(this.getMediaTime());
            this.playing = false;
            if (this.jdsPlayer.getStopTime() != this.duration) {
                this.setStopTime(this.duration);
            }
        }
    }

    public void updateLocale() {
        if (this.popup != null) {
            if (this.detached) {
                this.detachItem.setText(ElanLocale.getString("Detachable.attach"));
            } else {
                this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
            }
            this.infoItem.setText(ElanLocale.getString("Player.Info"));
            this.durationItem.setText(ElanLocale.getString("Player.duration") + ":  " + TimeFormatter.toString(this.getMediaDuration()));
            this.saveItem.setText(ElanLocale.getString("Player.SaveFrame"));
            this.origRatioItem.setText(ElanLocale.getString("Player.ResetAspectRatio"));
            this.arMenu.setText(ElanLocale.getString("Player.ForceAspectRatio"));
            this.zoomMenu.setText(ElanLocale.getString("Menu.Zoom"));
            this.graphItem.setText(ElanLocale.getString("Player.FilterGraph"));
            this.allFiltersItem.setText(ElanLocale.getString("Player.AllFilters"));
        }
    }

    public void controllerUpdate(ControllerEvent event) {
    }

    public Image getCurrentFrameImage() {
        return this.getFrameImageForTime(this.getMediaTime());
    }

    public Image getFrameImageForTime(long time) {
        if (this.jdsPlayer == null) {
            return null;
        }
        if (this.jdsPlayer.isPlaying()) {
            this.stop();
        }
        if (time != this.getMediaTime()) {
            this.setMediaTime(time);
        }
        BufferedImage image = null;
        byte[] data = this.jdsPlayer.getCurrentImageData();
        image = DIBToImage.DIBDataToBufferedImage(data);
        return image;
    }

    public static final byte[] getBytes(int i) {
        return new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
    }

    private void initPopupMenu() {
        if (this.jdsPanel == null) {
            return;
        }
        this.popup = new JPopupMenu();
        this.detachItem = new JMenuItem(ElanLocale.getString("Detachable.detach"));
        this.detachItem.addActionListener(this);
        this.infoItem = new JMenuItem(ElanLocale.getString("Player.Info"));
        this.infoItem.addActionListener(this);
        this.durationItem = new JMenuItem(ElanLocale.getString("Player.duration") + ":  " + TimeFormatter.toString(this.getMediaDuration()));
        this.durationItem.setEnabled(false);
        this.saveItem = new JMenuItem(ElanLocale.getString("Player.SaveFrame"));
        this.saveItem.addActionListener(this);
        this.origRatioItem = new JRadioButtonMenuItem(ElanLocale.getString("Player.ResetAspectRatio"), true);
        this.origRatioItem.setActionCommand("ratio_orig");
        this.origRatioItem.addActionListener(this);
        this.ratio_4_3_Item = new JRadioButtonMenuItem("4:3");
        this.ratio_4_3_Item.setActionCommand("ratio_4_3");
        this.ratio_4_3_Item.addActionListener(this);
        this.ratio_3_2_Item = new JRadioButtonMenuItem("3:2");
        this.ratio_3_2_Item.setActionCommand("ratio_3_2");
        this.ratio_3_2_Item.addActionListener(this);
        this.ratio_16_9_Item = new JRadioButtonMenuItem("16:9");
        this.ratio_16_9_Item.setActionCommand("ratio_16_9");
        this.ratio_16_9_Item.addActionListener(this);
        this.ratio_185_1_Item = new JRadioButtonMenuItem("1.85:1");
        this.ratio_185_1_Item.setActionCommand("ratio_185_1");
        this.ratio_185_1_Item.addActionListener(this);
        this.ratio_235_1_Item = new JRadioButtonMenuItem("2.35:1");
        this.ratio_235_1_Item.setActionCommand("ratio_235_1");
        this.ratio_235_1_Item.addActionListener(this);
        this.arMenu = new JMenu(ElanLocale.getString("Player.ForceAspectRatio"));
        ButtonGroup arbg = new ButtonGroup();
        arbg.add(this.origRatioItem);
        arbg.add(this.ratio_4_3_Item);
        arbg.add(this.ratio_3_2_Item);
        arbg.add(this.ratio_16_9_Item);
        arbg.add(this.ratio_185_1_Item);
        arbg.add(this.ratio_235_1_Item);
        this.arMenu.add(this.origRatioItem);
        this.arMenu.addSeparator();
        this.arMenu.add(this.ratio_4_3_Item);
        this.arMenu.add(this.ratio_3_2_Item);
        this.arMenu.add(this.ratio_16_9_Item);
        this.arMenu.add(this.ratio_185_1_Item);
        this.arMenu.add(this.ratio_235_1_Item);
        this.zoomMenu = new JMenu(ElanLocale.getString("Menu.Zoom"));
        this.zoom100 = new JRadioButtonMenuItem("100%", this.videoScaleFactor == 1.0f);
        this.zoom100.setActionCommand("zoom100");
        this.zoom100.addActionListener(this);
        this.zoom150 = new JRadioButtonMenuItem("150%", (double)this.videoScaleFactor == 1.5);
        this.zoom150.setActionCommand("zoom150");
        this.zoom150.addActionListener(this);
        this.zoom200 = new JRadioButtonMenuItem("200%", this.videoScaleFactor == 2.0f);
        this.zoom200.setActionCommand("zoom200");
        this.zoom200.addActionListener(this);
        this.zoom300 = new JRadioButtonMenuItem("300%", this.videoScaleFactor == 3.0f);
        this.zoom300.setActionCommand("zoom300");
        this.zoom300.addActionListener(this);
        this.zoom400 = new JRadioButtonMenuItem("400%", this.videoScaleFactor == 4.0f);
        this.zoom400.setActionCommand("zoom400");
        this.zoom400.addActionListener(this);
        ButtonGroup zbg = new ButtonGroup();
        zbg.add(this.zoom100);
        zbg.add(this.zoom150);
        zbg.add(this.zoom200);
        zbg.add(this.zoom300);
        zbg.add(this.zoom400);
        this.zoomMenu.add(this.zoom100);
        this.zoomMenu.add(this.zoom150);
        this.zoomMenu.add(this.zoom200);
        this.zoomMenu.add(this.zoom300);
        this.zoomMenu.add(this.zoom400);
        this.graphItem = new JMenuItem(ElanLocale.getString("Player.FilterGraph"));
        this.graphItem.addActionListener(this);
        this.allFiltersItem = new JMenuItem(ElanLocale.getString("Player.AllFilters"));
        this.allFiltersItem.addActionListener(this);
        this.popup.add(this.detachItem);
        this.popup.addSeparator();
        this.popup.add(this.saveItem);
        this.popup.add(this.infoItem);
        this.popup.add(this.graphItem);
        this.popup.add(this.allFiltersItem);
        this.popup.add(this.arMenu);
        this.popup.add(this.zoomMenu);
        this.popup.add(this.durationItem);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.detachItem) && this.layoutManager != null) {
            if (this.detached) {
                this.layoutManager.attach(this.getVisualComponent());
                this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
                this.detached = false;
            } else {
                this.layoutManager.detach(this.getVisualComponent());
                this.detachItem.setText(ElanLocale.getString("Detachable.attach"));
                this.detached = true;
            }
            this.getVisualComponent().addNotify();
        } else if (e.getSource() == this.infoItem) {
            new FormattedMessageDlg(this);
        } else if (e.getSource() == this.graphItem) {
            String[] graphText = this.jdsPlayer.getFiltersInGraph();
            if (graphText != null) {
                new TextAreaMessageDlg((Component)this.jdsPanel, graphText, ElanLocale.getString("Player.FilterGraph.Title"));
            } else {
                new TextAreaMessageDlg((Component)this.jdsPanel, ElanLocale.getString("Player.Message.NoGraph"), ElanLocale.getString("Player.FilterGraph.Title"));
            }
        } else if (e.getSource() == this.allFiltersItem) {
            String[] graphText = this.jdsPlayer.getRegisteredFilters();
            if (graphText != null) {
                new TextAreaMessageDlg((Component)this.jdsPanel, graphText, ElanLocale.getString("Player.AllFilters.Title"));
            } else {
                new TextAreaMessageDlg((Component)this.jdsPanel, ElanLocale.getString("Player.Message.NoFilters"), ElanLocale.getString("Player.AllFilters.Title"));
            }
        } else if (e.getSource() == this.saveItem) {
            ImageExporter export = new ImageExporter();
            export.exportImage((BufferedImage)this.getCurrentFrameImage());
        } else if (e.getActionCommand().startsWith("ratio")) {
            if (e.getSource() == this.origRatioItem) {
                this.aspectRatio = this.origAspectRatio;
            } else if (e.getSource() == this.ratio_4_3_Item) {
                this.aspectRatio = 1.33f;
            } else if (e.getSource() == this.ratio_3_2_Item) {
                this.aspectRatio = 1.66f;
            } else if (e.getSource() == this.ratio_16_9_Item) {
                this.aspectRatio = 1.78f;
            } else if (e.getSource() == this.ratio_185_1_Item) {
                this.aspectRatio = 1.85f;
            } else if (e.getSource() == this.ratio_235_1_Item) {
                this.aspectRatio = 2.35f;
            }
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getActionCommand().startsWith("zoom")) {
            if (e.getSource() == this.zoom100) {
                this.videoScaleFactor = 1.0f;
            } else if (e.getSource() == this.zoom150) {
                this.videoScaleFactor = 1.5f;
            } else if (e.getSource() == this.zoom200) {
                this.videoScaleFactor = 2.0f;
            } else if (e.getSource() == this.zoom300) {
                this.videoScaleFactor = 3.0f;
            } else if (e.getSource() == this.zoom400) {
                this.videoScaleFactor = 4.0f;
            }
            this.jdsPlayer.setVideoScaleFactor(this.videoScaleFactor);
            this.layoutManager.setPreference("VideoZoom(" + this.mediaDescriptor.mediaURL + ")", new Float(this.videoScaleFactor), this.layoutManager.getViewerManager().getTranscription());
        }
    }

    private void copyToClipboard(String text) {
        if (text == null) {
            return;
        }
        System.out.println(text);
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkSystemClipboardAccess();
                StringSelection ssVal = new StringSelection(text);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssVal, null);
            }
            catch (SecurityException se) {
            }
            catch (IllegalStateException ise) {}
        } else {
            try {
                StringSelection ssVal = new StringSelection(text);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssVal, null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    static {
        String version = System.getProperty("java.version");
        if (version.length() >= 3 && version.charAt(1) == '.') {
            char[] ch = new char[]{version.charAt(0), version.charAt(2)};
            try {
                java_version = Integer.parseInt(new String(ch));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private class PlayerEndWatcher
    extends Thread {
        private boolean stopped = false;

        private PlayerEndWatcher() {
        }

        public void setStopped() {
            this.stopped = true;
        }

        public void run() {
            while (JDSMediaPlayer.this.playing && !this.stopped && JDSMediaPlayer.this.getMediaTime() < JDSMediaPlayer.this.duration) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                    return;
                }
                catch (Exception exception) {
                }
            }
            if (this.stopped) {
                return;
            }
            if (JDSMediaPlayer.this.playing) {
                JDSMediaPlayer.this.jdsPlayer.stopWhenReady();
                JDSMediaPlayer.this.stopControllers();
                JDSMediaPlayer.this.setControllersMediaTime(JDSMediaPlayer.this.getMediaTime());
                JDSMediaPlayer.this.jdsPlayer.pause();
                JDSMediaPlayer.this.playing = false;
            }
        }
    }

    private class PlayerStateWatcher
    extends Thread {
        private boolean stopped = false;

        private PlayerStateWatcher() {
        }

        public void setStopped() {
            this.stopped = true;
        }

        public void run() {
            while (JDSMediaPlayer.this.playing && !this.stopped && JDSMediaPlayer.this.getMediaTime() < JDSMediaPlayer.this.stopTime + JDSMediaPlayer.this.offset) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                    return;
                }
                catch (Exception exception) {
                }
            }
            if (this.stopped) {
                return;
            }
            if (JDSMediaPlayer.this.playing) {
                JDSMediaPlayer.this.jdsPlayer.stopWhenReady();
                JDSMediaPlayer.this.stopControllers();
                JDSMediaPlayer.this.setControllersMediaTime(JDSMediaPlayer.this.getMediaTime());
                JDSMediaPlayer.this.jdsPlayer.pause();
                JDSMediaPlayer.this.setStopTime(JDSMediaPlayer.this.duration);
                JDSMediaPlayer.this.playing = false;
            }
        }
    }

    private class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        private final DecimalFormat format = new DecimalFormat("#.###");

        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2) {
                if (JDSMediaPlayer.this.layoutManager != null) {
                    JDSMediaPlayer.this.layoutManager.setFirstPlayer(JDSMediaPlayer.this);
                }
                return;
            }
            if (SwingUtilities.isRightMouseButton(e)) {
                return;
            }
            try {
                int[] vidDest = JDSMediaPlayer.this.jdsPlayer.getVideoDestinationPos();
                if (vidDest != null) {
                    if (e.isAltDown()) {
                        JDSMediaPlayer.this.copyToClipboard(this.format.format((float)(e.getX() - vidDest[0]) / (float)vidDest[2]) + "," + this.format.format((float)(e.getY() - vidDest[1]) / (float)vidDest[3]));
                    } else if (e.isShiftDown()) {
                        JDSMediaPlayer.this.copyToClipboard("" + (int)((float)JDSMediaPlayer.this.jdsPlayer.getSourceWidth() / (float)vidDest[2] * (float)(e.getX() - vidDest[0])) + "," + (int)((float)JDSMediaPlayer.this.jdsPlayer.getSourceHeight() / (float)vidDest[3] * (float)(e.getY() - vidDest[1])));
                    } else {
                        JDSMediaPlayer.this.copyToClipboard("" + (int)((float)JDSMediaPlayer.this.jdsPlayer.getSourceWidth() / (float)vidDest[2] * (float)(e.getX() - vidDest[0])) + "," + (int)((float)JDSMediaPlayer.this.jdsPlayer.getSourceHeight() / (float)vidDest[3] * (float)(e.getY() - vidDest[1])) + " [" + JDSMediaPlayer.this.jdsPlayer.getSourceWidth() + "," + JDSMediaPlayer.this.jdsPlayer.getSourceHeight() + "]");
                    }
                }
            }
            catch (Exception exep) {
                exep.printStackTrace();
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            Point cl = e.getPoint();
            if (java_version >= 16) {
                cl = this.adjustCoords(e.getComponent(), cl);
            }
            if (SwingUtilities.isRightMouseButton(e)) {
                JDSMediaPlayer.this.popup.show(JDSMediaPlayer.this.getVisualComponent(), (int)cl.getX(), (int)cl.getY());
                return;
            }
            JDSMediaPlayer.this.dragX = (int)cl.getX();
            JDSMediaPlayer.this.dragY = (int)cl.getY();
            JDSMediaPlayer.this.vw = (int)((float)JDSMediaPlayer.this.jdsPanel.getWidth() * JDSMediaPlayer.this.videoScaleFactor);
            JDSMediaPlayer.this.vh = (int)((float)JDSMediaPlayer.this.jdsPanel.getHeight() * JDSMediaPlayer.this.videoScaleFactor);
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            int dx = JDSMediaPlayer.this.dragX - e.getX();
            int dy = JDSMediaPlayer.this.dragY - e.getY();
            JDSMediaPlayer.this.vx -= dx;
            JDSMediaPlayer.this.vy -= dy;
            JDSMediaPlayer.this.dragX = e.getX();
            JDSMediaPlayer.this.dragY = e.getY();
            if (JDSMediaPlayer.this.vx + JDSMediaPlayer.this.vw < JDSMediaPlayer.this.jdsPanel.getWidth()) {
                JDSMediaPlayer.this.vx = JDSMediaPlayer.this.jdsPanel.getWidth() - JDSMediaPlayer.this.vw;
            }
            if (JDSMediaPlayer.this.vx > 0) {
                JDSMediaPlayer.this.vx = 0;
            }
            if (JDSMediaPlayer.this.vy + JDSMediaPlayer.this.vh < JDSMediaPlayer.this.jdsPanel.getHeight()) {
                JDSMediaPlayer.this.vy = JDSMediaPlayer.this.jdsPanel.getHeight() - JDSMediaPlayer.this.vh;
            }
            if (JDSMediaPlayer.this.vy > 0) {
                JDSMediaPlayer.this.vy = 0;
            }
            JDSMediaPlayer.this.jdsPlayer.setVideoDestinationPos(JDSMediaPlayer.this.vx, JDSMediaPlayer.this.vy, JDSMediaPlayer.this.vw, JDSMediaPlayer.this.vh);
        }

        public void mouseMoved(MouseEvent e) {
        }

        private Point adjustCoords(Component comp, Point org) {
            try {
                Point p = comp.getLocationOnScreen();
                return new Point((int)(p.getX() + org.getX()), (int)(p.getY() + org.getY()));
            }
            catch (Exception exception) {
                return org;
            }
        }
    }
}

