/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Logger;
import mpi.util.LogUtil;

public class MPEGVideoHeader {
    private static final Logger LOG = Logger.getLogger(MPEGVideoHeader.class.getName());
    private static final int PACK_START_CODE = 442;
    private static final int VIDEO_HEADER_START_CODE = 435;
    private static final int MPEG4_VIDEO_HEADER_START_CODE = 432;
    private static final int MAX_FORWARD_READ_LENGTH = 500000;
    private static final float[] pelAspectRatioTable = new float[]{0.0f, 1.0f, 0.6735f, 0.7031f, 0.7615f, 0.8055f, 0.8437f, 0.8935f, 0.9375f, 0.9815f, 1.0255f, 1.0695f, 1.125f, 1.1575f, 1.2015f, 1.0f};
    private static final float[] pictureRateTable = new float[]{0.0f, 23.976f, 24.0f, 25.0f, 29.97f, 30.0f, 50.0f, 59.94f, 60.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f};
    private static final int UNKNOWN_INT = -1;
    private static final float UNKNOWN_FLOAT = -1.0f;
    private int width = -1;
    private int height = -1;
    private float fps = -1.0f;
    private float pelAspectRatio = -1.0f;
    private boolean firstPackFound = false;
    private int mpegType = -1;
    private double initialSCR = -1.0;
    private RandomAccessFile raf;

    public MPEGVideoHeader(String path) {
        this.readHeader(path);
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0 || args[0].length() == 0) {
            MPEGVideoHeader.usage();
            return;
        }
        new MPEGVideoHeader(args[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeader(String path) {
        File mpegFile = new File(path);
        if (!mpegFile.exists()) {
            LOG.warning("Mpeg file not found: " + path);
            return;
        }
        try {
            this.raf = new RandomAccessFile(mpegFile, "r");
            this.readStart();
        }
        catch (FileNotFoundException fnfe) {
            LOG.warning("Mpeg file not found.");
        }
        catch (IOException ioe) {
            LOG.warning("Error reading Mpeg file.\n" + LogUtil.formatStackTrace((Throwable)ioe));
        }
        catch (Exception e) {
            LOG.warning("Unknown error reading Mpeg file.");
        }
        finally {
            try {
                this.raf.close();
            }
            catch (IOException ioee) {}
        }
    }

    protected double getMPEGSCR(byte[] b) {
        long low4Bytes = ((b[0] & 0xFF) >> 1 & 3) << 30 | (b[1] & 0xFF) << 22 | (b[2] & 0xFF) >> 1 << 15 | (b[3] & 0xFF) << 7 | (b[4] & 0xFF) >> 1;
        double scr = (double)low4Bytes / 90000.0;
        return scr;
    }

    protected double getMPEG2SCR(byte[] b) {
        long low4Bytes = (b[0] & 0x18) >> 3 << 30 | (b[0] & 3) << 28 | (b[1] & 0xFF) << 20 | (b[2] & 0xF8) >> 1 << 15 | (b[2] & 3) << 13 | (b[3] & 0xFF) << 5 | (b[4] & 0xFF) >> 3;
        int sys_clock_extension = (b[4] & 3) << 7 | (b[5] & 0xFF) >> 1;
        if (sys_clock_extension == 0) {
            double scr = (double)low4Bytes / 90000.0;
            return scr;
        }
        return 0.0;
    }

    private static void usage() {
        System.out.println("Enter a path to a MPEG file!");
    }

    private void readStart() throws IOException {
        int available;
        int forward = 1024;
        byte[] b = new byte[forward];
        long curPointer = 0L;
        for (int i = 0; i < 500000; i += available - 2) {
            available = this.raf.read(b);
            curPointer = this.raf.getFilePointer();
            if (available <= 0) continue;
            for (int offset = 0; offset < available - 2; ++offset) {
                if (b[offset] != 0 || b[offset + 1] != 0 || b[offset + 2] != 1) continue;
                this.raf.seek(curPointer - (long)(available - offset));
                this.checkHeaderCode();
                if (this.mpegType == -1 || this.width == -1) continue;
                return;
            }
        }
    }

    private void checkHeaderCode() throws IOException {
        int code = this.raf.readInt();
        switch (code) {
            case 442: {
                if (this.firstPackFound) break;
                this.readPackHeader();
                break;
            }
            case 435: {
                if (this.width != -1 && this.height != -1) break;
                this.readVideoHeader();
                break;
            }
            case 432: {
                this.mpegType = 4;
            }
        }
    }

    private void readPackHeader() throws IOException {
        if (this.initialSCR != -1.0) {
            return;
        }
        byte[] b = new byte[6];
        this.raf.readFully(b);
        if ((b[0] & 0xF0) == 32) {
            this.mpegType = 1;
            this.initialSCR = this.getMPEGSCR(b);
        } else if ((b[0] & 0xC0) == 64) {
            this.mpegType = 2;
            this.initialSCR = this.getMPEG2SCR(b);
        }
    }

    private void readVideoHeader() throws IOException {
        int framerateIndex;
        if (this.width != -1 && this.height != -1) {
            return;
        }
        byte[] b = new byte[3];
        this.raf.readFully(b);
        this.width = (b[0] & 0xFF) << 4 | b[1] & 0xF0;
        this.height = (b[1] & 0xF) << 8 | b[2] & 0xFF;
        byte nb = this.raf.readByte();
        int ratioIndex = (nb & 0xFF) >> 4;
        if (ratioIndex > 0 && ratioIndex < pelAspectRatioTable.length) {
            this.pelAspectRatio = pelAspectRatioTable[ratioIndex];
        }
        if ((framerateIndex = nb & 0xF) > 0 && framerateIndex < pictureRateTable.length) {
            this.fps = pictureRateTable[framerateIndex];
        }
    }

    public float getFps() {
        return this.fps;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void printResults() {
        boolean isPal = this.fps == pictureRateTable[3];
        boolean isNTSC = this.fps == pictureRateTable[4];
        String results = "MPEG Header Info:\nMPEG type: " + this.mpegType + "\nWidth: " + this.width + "\nHeight: " + this.height + "\nAspect Ratio: " + this.pelAspectRatio + "\nFrame Rate: " + this.fps + "\nIs PAL: " + isPal + "\nIs NTSC: " + isNTSC;
        System.out.println(results);
    }
}

