/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.io.File;
import mpi.eudico.client.annotator.player.CocoaQTMediaPlayer;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.ImagePlayer;
import mpi.eudico.client.annotator.player.JDSMediaPlayer;
import mpi.eudico.client.annotator.player.JMFGraphicMediaPlayer;
import mpi.eudico.client.annotator.player.JMFMediaPlayer;
import mpi.eudico.client.annotator.player.NativeMediaPlayerWindowsDS;
import mpi.eudico.client.annotator.player.NativeMediaPlayerWindowsQT;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.annotator.player.QTMediaPlayer;
import mpi.eudico.client.annotator.player.QTStreamingPlayer;
import mpi.eudico.client.annotator.svg.SVGPrefs;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;

public class PlayerFactory {
    public static final String JMF_MEDIA_FRAMEWORK = "JMF";
    public static final String QT_MEDIA_FRAMEWORK = "QT";
    public static final String NATIVE_WINDOWS_MEDIA_FRAMEWORK = "NativeWindows";
    public static final String COCOA_QT = "CocoaQT";
    public static final String JDS = "JDS";

    public static ElanMediaPlayer createElanMediaPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        String mediaURL = mediaDescriptor.mediaURL;
        if (mediaURL.startsWith("file")) {
            if (!new File(mediaURL.substring(5)).exists()) {
                throw new NoPlayerException("Media File not found: " + mediaURL);
            }
        } else if (mediaURL.startsWith("rtsp")) {
            if (System.getProperty("os.name").toLowerCase().indexOf("os x") >= 0) {
                return PlayerFactory.createQTStreamingPlayer(mediaDescriptor);
            }
            return PlayerFactory.createQTStreamingPlayer(mediaDescriptor);
        }
        if (mediaDescriptor.mimeType != null && mediaDescriptor.mimeType.startsWith("image")) {
            return new ImagePlayer(mediaDescriptor);
        }
        String preferredMF = System.getProperty("PreferredMediaFramework");
        try {
            if (preferredMF != null) {
                if (preferredMF.equals(JMF_MEDIA_FRAMEWORK)) {
                    return PlayerFactory.createJMFMediaPlayer(mediaDescriptor);
                }
                if (preferredMF.equals(QT_MEDIA_FRAMEWORK)) {
                    return PlayerFactory.createQTMediaPlayer(mediaDescriptor);
                }
                if (preferredMF.equals(NATIVE_WINDOWS_MEDIA_FRAMEWORK)) {
                    return PlayerFactory.createNativeMediaPlayerDS(mediaDescriptor);
                }
                if (preferredMF.equals(COCOA_QT)) {
                    try {
                        return PlayerFactory.createCocoaQTMediaPlayer(mediaDescriptor);
                    }
                    catch (NoPlayerException npe) {
                        System.out.println("Could not create a Cocoa based player...");
                        return PlayerFactory.createQTMediaPlayer(mediaDescriptor);
                    }
                }
                if (preferredMF.equals(JDS)) {
                    return PlayerFactory.createJDSPlayer(mediaDescriptor);
                }
            }
        }
        catch (NoPlayerException npe) {
            System.out.println("Preferred media framework '" + preferredMF + "' can not handle: " + mediaDescriptor.mediaURL);
        }
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0) {
            ElanMediaPlayer player = null;
            if (!JDS.equals(preferredMF)) {
                try {
                    player = PlayerFactory.createJDSPlayer(mediaDescriptor);
                }
                catch (NoPlayerException npe) {
                    System.out.println(npe.getMessage());
                }
            }
            if (player == null && !NATIVE_WINDOWS_MEDIA_FRAMEWORK.equals(preferredMF)) {
                try {
                    player = PlayerFactory.createNativeMediaPlayerDS(mediaDescriptor);
                }
                catch (NoPlayerException npe) {
                    System.out.println(npe.getMessage());
                }
            }
            if (player == null && !QT_MEDIA_FRAMEWORK.equals(preferredMF)) {
                try {
                    player = PlayerFactory.createQTMediaPlayer(mediaDescriptor);
                }
                catch (NoPlayerException npe) {
                    System.out.println("No QT: " + npe.getMessage());
                }
            }
            if (player == null && !JMF_MEDIA_FRAMEWORK.equals(preferredMF)) {
                try {
                    player = PlayerFactory.createJMFMediaPlayer(mediaDescriptor);
                }
                catch (NoPlayerException npe) {
                    System.out.println("No JMF: " + npe.getMessage());
                }
            }
            if (player != null) {
                return player;
            }
            throw new NoPlayerException("Could not create any media player for: " + mediaDescriptor.mediaURL);
        }
        if (System.getProperty("os.name").toLowerCase().indexOf("os x") >= 0) {
            try {
                return PlayerFactory.createCocoaQTMediaPlayer(mediaDescriptor);
            }
            catch (NoPlayerException npe) {
                System.out.println("Could not create a Cocoa based player... " + npe.getMessage());
                return PlayerFactory.createQTMediaPlayer(mediaDescriptor);
            }
        }
        return PlayerFactory.createJMFMediaPlayer(mediaDescriptor);
    }

    public static ElanMediaPlayer createNativeMediaPlayerDS(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0) {
            System.out.println("Using Windows Native Media Player DS");
            return new NativeMediaPlayerWindowsDS(mediaDescriptor);
        }
        return PlayerFactory.createJMFMediaPlayer(mediaDescriptor);
    }

    public static ElanMediaPlayer createNativeMediaPlayerQT(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0) {
            System.out.println("Using Windows Native Media Player QT");
            return new NativeMediaPlayerWindowsQT(mediaDescriptor);
        }
        throw new NoPlayerException("No Native Media Framework Available for " + System.getProperty("os.name"));
    }

    public static ElanMediaPlayer createJMFMediaPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        System.out.println("Using JMF Media Player");
        if (SVGPrefs.getUseSVG()) {
            return new JMFGraphicMediaPlayer(mediaDescriptor);
        }
        return new JMFMediaPlayer(mediaDescriptor);
    }

    public static ElanMediaPlayer createQTMediaPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        System.out.println("Using QT Media Player");
        return new QTMediaPlayer(mediaDescriptor);
    }

    public static ElanMediaPlayer createCocoaQTMediaPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        System.out.println("Using Cocoa QT Media Player");
        return new CocoaQTMediaPlayer(mediaDescriptor);
    }

    public static ElanMediaPlayer createQTStreamingPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        System.out.println("Using QT Streaming Player");
        return new QTStreamingPlayer(mediaDescriptor);
    }

    public static ElanMediaPlayer createJDSPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        return new JDSMediaPlayer(mediaDescriptor);
    }
}

