/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.text.DecimalFormat;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.export.ImageExporter;
import mpi.eudico.client.annotator.gui.FormattedMessageDlg;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.MPEGVideoHeader;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.annotator.player.VideoFrameGrabber;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.ControllerListener;
import mpi.eudico.client.mediacontrol.ControllerManager;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.util.TimeFormatter;
import quicktime.QTException;
import quicktime.QTSession;
import quicktime.app.display.QTCanvas;
import quicktime.app.time.TaskAllMovies;
import quicktime.app.time.Tasking;
import quicktime.app.view.MoviePlayer;
import quicktime.app.view.QTComponent;
import quicktime.app.view.QTFactory;
import quicktime.app.view.QTImageProducer;
import quicktime.io.OpenMovieFile;
import quicktime.io.QTFile;
import quicktime.qd.Pict;
import quicktime.qd.PixMap;
import quicktime.qd.QDDimension;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.std.clocks.ExtremesCallBack;
import quicktime.std.clocks.TimeBase;
import quicktime.std.clocks.TimeRecord;
import quicktime.std.image.Matrix;
import quicktime.std.movies.Movie;
import quicktime.std.movies.MovieController;
import quicktime.std.movies.TimeInfo;
import quicktime.std.movies.Track;
import quicktime.std.movies.media.DataRef;
import quicktime.std.movies.media.GenericMedia;
import quicktime.std.movies.media.MPEGMedia;
import quicktime.std.movies.media.Media;
import quicktime.std.movies.media.MovieMedia;
import quicktime.std.movies.media.StreamMedia;
import quicktime.std.movies.media.VideoMedia;
import quicktime.util.QTUtils;
import quicktime.util.RawEncodedImage;

public class QTMediaPlayer
extends ControllerManager
implements ElanMediaPlayer,
ControllerListener,
VideoFrameGrabber,
ActionListener {
    public static final int STOP_WITH_STOP_TIME = 0;
    public static final int STOP_WITH_PREVIEW = 1;
    private QTComponent canvas;
    private float aspectRatio;
    protected long offset;
    private long milliSecondsPerSample;
    boolean playingInterval;
    boolean streaming;
    ExtremesCallBack endOfMediaCallback;
    private JPopupMenu popup;
    private boolean isWavPlayer;
    private MediaDescriptor mediaDescriptor;
    private ElanLayoutManager layoutManager;
    private boolean detached;
    private JMenuItem durationItem;
    private JMenuItem detachItem;
    private JMenuItem infoItem;
    private JMenuItem saveItem;
    private JMenuItem ratio_4_3_Item;
    private JMenuItem ratio_3_2_Item;
    private JMenuItem ratio_16_9_Item;
    private JMenuItem ratio_185_1_Item;
    private JMenuItem ratio_235_1_Item;
    private Component visualComponent;
    int stopMode;
    TimeBase timeBase;
    long exactStopTime;
    protected Movie movie;
    private MovieController controller;
    private QTFile scratchFile;
    private String scratchName = "tmpMedia";
    static int scratchCount = 0;
    private boolean isEditSave = false;
    private int mpegImageWidth = 0;
    private int mpegImageHeight = 0;
    private boolean frameRateAutoDetected = false;
    private boolean rateDetectionAttempted = false;
    private boolean frameStepsToFrameBegin = false;

    public QTMediaPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        this.mediaDescriptor = mediaDescriptor;
        this.initQTJNI();
        try {
            QTSession.open();
            System.out.println("QuickTime version: " + QTSession.getQTMajorVersion() + "." + QTSession.getMinorVersion() + "." + QTSession.getBugFixVersion());
            String URLString = mediaDescriptor.mediaURL;
            System.out.println("mediaURL = " + URLString);
            String qtNoSleep = System.getProperty("QTNoSleepTime");
            if (qtNoSleep != null && qtNoSleep.toLowerCase().equals("true")) {
                try {
                    Tasking.tasker.setSleepTime(1);
                    System.out.println("QT setting sleep time off...");
                }
                catch (Exception exc) {
                    // empty catch block
                }
            }
            String fileString = URLString;
            if (URLString.startsWith("file:")) {
                this.streaming = false;
                fileString = URLString.substring(5);
                QTFile qtFile = new QTFile(fileString);
                this.movie = Movie.fromFile((OpenMovieFile)OpenMovieFile.asRead((QTFile)qtFile));
                this.movie.setTimeScale(1000);
                this.movie.update();
                Movie editMovie = this.createScratchMovie();
                if (editMovie != null) {
                    this.movie = editMovie;
                    this.isEditSave = true;
                }
            } else {
                this.streaming = true;
                DataRef dataRef = new DataRef(URLString);
                this.movie = Movie.fromDataRef((DataRef)dataRef, (int)1);
            }
            MoviePlayer player = new MoviePlayer(this.movie);
            this.controller = new MovieController(this.movie);
            this.controller.activate();
            this.controller.setAttached(true);
            Matrix matrix = new Matrix();
            matrix.scale(1.1f, 1.1f, 0.0f, 0.0f);
            this.movie.setMatrix(matrix);
            if (URLString.endsWith("wav") || mediaDescriptor.mimeType.equals("audio/*")) {
                this.isWavPlayer = true;
                this.canvas = null;
                this.visualComponent = null;
            } else {
                if (URLString.startsWith("file") && (URLString.endsWith("mpg") || URLString.endsWith("mpeg"))) {
                    MPEGVideoHeader mpegHeader = new MPEGVideoHeader(fileString);
                    this.mpegImageWidth = mpegHeader.getWidth();
                    this.mpegImageHeight = mpegHeader.getHeight();
                }
                this.canvas = QTFactory.makeQTComponent((Movie)this.movie);
                this.visualComponent = this.canvas.asComponent();
                this.visualComponent.addMouseListener(new MouseHandler());
                this.popup = new JPopupMenu();
                this.durationItem = new JMenuItem(ElanLocale.getString("Player.duration") + ":  " + TimeFormatter.toString(this.getMediaDuration()));
                this.durationItem.setEnabled(false);
                this.infoItem = new JMenuItem(ElanLocale.getString("Player.Info"));
                this.infoItem.addActionListener(this);
                this.saveItem = new JMenuItem(ElanLocale.getString("Player.SaveFrame"));
                this.saveItem.addActionListener(this);
                this.ratio_4_3_Item = new JMenuItem("4:3");
                this.ratio_4_3_Item.addActionListener(this);
                this.ratio_3_2_Item = new JMenuItem("3:2");
                this.ratio_3_2_Item.addActionListener(this);
                this.ratio_16_9_Item = new JMenuItem("16:9");
                this.ratio_16_9_Item.addActionListener(this);
                this.ratio_185_1_Item = new JMenuItem("1.85:1");
                this.ratio_185_1_Item.addActionListener(this);
                this.ratio_235_1_Item = new JMenuItem("2.35:1");
                this.ratio_235_1_Item.addActionListener(this);
                JMenu arMenu = new JMenu(ElanLocale.getString("Player.ForceAspectRatio"));
                arMenu.add(this.ratio_4_3_Item);
                arMenu.add(this.ratio_3_2_Item);
                arMenu.add(this.ratio_16_9_Item);
                arMenu.add(this.ratio_185_1_Item);
                arMenu.add(this.ratio_235_1_Item);
                this.popup.addSeparator();
                this.popup.add(this.saveItem);
                this.popup.add(this.infoItem);
                this.popup.add(arMenu);
                this.popup.add(this.durationItem);
                JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            }
            float boundsW = player.getOriginalSize().getWidth();
            float boundsH = player.getOriginalSize().getHeight();
            this.aspectRatio = boundsW / boundsH;
            System.out.println("Aspect ratio: " + this.aspectRatio);
            this.offset = mediaDescriptor.timeOrigin;
            this.milliSecondsPerSample = 40L;
            this.timeBase = this.movie.getTimeBase();
            this.endOfMediaCallback = new TimeBaseExtremesCallBack(this.timeBase, 2);
            this.endOfMediaCallback.callMeWhen();
            this.stopMode = 0;
            this.movie.goToBeginning();
            if (this.isWavPlayer) {
                TaskAllMovies.addMovieAndStart();
            }
        }
        catch (QTException e) {
            System.out.println("QTException while creating QT player ");
            e.printStackTrace();
            QTSession.close();
            throw new NoPlayerException("QTException while creating QT player.");
        }
    }

    private void detectFrameRate() {
        try {
            int numframes;
            this.rateDetectionAttempted = true;
            int scale = this.movie.getTimeScale();
            boolean isVisual = false;
            Track track = null;
            for (int i = 0; i < this.movie.getTrackCount(); ++i) {
                track = this.movie.getTrack(i + 1);
                System.out.println("Media: " + track.getMedia().getClass().getName());
                if (!(track.getMedia() instanceof MovieMedia) && !(track.getMedia() instanceof MPEGMedia) && !(track.getMedia() instanceof VideoMedia) && !(track.getMedia() instanceof StreamMedia) && !(track.getMedia() instanceof GenericMedia)) continue;
                isVisual = true;
                break;
            }
            if (!isVisual) {
                System.out.println("Media: non-video...");
                return;
            }
            int numTestFrames = 30;
            System.out.println("duration=" + this.movie.getDuration() + " timescale=" + this.movie.getTimeScale());
            this.movie.task(0);
            int flags = 16;
            int[] modes = new int[]{1702454643};
            TimeInfo info = this.movie.getNextInterestingTime(flags, modes, 0, 1.0f);
            System.out.println(info);
            int lastTime = info.time;
            int numDuplicateTimes = 0;
            for (numframes = 0; info.time >= 0 && numframes <= numTestFrames; ++numframes) {
                info = this.movie.getNextInterestingTime(flags, modes, info.time, 1.0f);
                if (info.time == lastTime) {
                    System.out.println("T: same time...");
                    if (++numDuplicateTimes != 3) continue;
                    break;
                }
                lastTime = info.time;
            }
            System.out.println("frames = " + numframes + " cur time: " + info.time);
            float frameRate = 0.0f;
            if (numframes > numTestFrames) {
                frameRate = (float)((numframes + 1) * scale) / (float)info.time;
            } else if (numframes > 0) {
                frameRate = (float)(numframes * scale) / (float)info.time;
            } else {
                System.out.println("framerate could not be calculated");
                return;
            }
            System.out.println("framerate: " + frameRate);
            System.out.println("Ms per frame: " + Math.round(1000.0f / frameRate));
            if (frameRate > 0.0f) {
                this.frameRateAutoDetected = true;
                this.milliSecondsPerSample = Math.round(1000.0f / frameRate);
            }
        }
        catch (QTException qte) {
            qte.printStackTrace();
        }
    }

    public MediaDescriptor getMediaDescriptor() {
        return this.mediaDescriptor;
    }

    public Movie getMovie() {
        if (this.isEditSave) {
            return this.movie;
        }
        return null;
    }

    public Dimension getMediaFileDimension() {
        if (this.mpegImageWidth > 0 && this.mpegImageHeight > 0) {
            return new Dimension(this.mpegImageWidth, this.mpegImageHeight);
        }
        return null;
    }

    public String getFrameworkDescription() {
        return "Quicktime For Java Media Player";
    }

    public synchronized void controllerUpdate(ControllerEvent event) {
    }

    public void playInterval(long startTime, long stopTime) {
        if (this.movie == null || this.playingInterval || stopTime <= startTime) {
            return;
        }
        long startOff = startTime + this.offset;
        long stopOff = stopTime + this.offset;
        try {
            if (stopTime - startTime < 5000L) {
                int loadBeginTime = startOff - 5000L > 0L ? (int)(startOff - 5000L) : 0;
                int loadDuration = (int)(stopOff - (long)loadBeginTime + 1000L);
                this.movie.loadIntoRam(loadBeginTime, loadDuration, 2);
            }
            this.setMediaTime(startTime);
            Thread.sleep(100L);
            if (this.stopMode == 0) {
                this.setStopTime(stopOff);
            } else {
                this.movie.setPreviewTime((int)startOff, (int)(stopTime - startTime));
                this.movie.setPreviewMode(true);
            }
            this.exactStopTime = stopTime;
            this.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setStopTime(long stopTime) {
        try {
            this.timeBase.setStopTime(new TimeRecord(this.movie.getTimeScale(), stopTime));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Component getVisualComponent() {
        return this.visualComponent;
    }

    public Component createNewVisualComponent() {
        if (this.isWavPlayer) {
            return null;
        }
        try {
            this.canvas = QTFactory.makeQTComponent((Movie)this.movie);
            this.visualComponent = this.canvas.asComponent();
            this.visualComponent.addMouseListener(new MouseHandler());
        }
        catch (QTException qte) {
            System.out.println("Could not create a new visual component. ");
            qte.printStackTrace();
        }
        return this.visualComponent;
    }

    public int getSourceHeight() {
        if (this.movie != null) {
            try {
                return this.movie.getNaturalBoundsRect().getHeight();
            }
            catch (QTException qte) {
                return 0;
            }
        }
        return 0;
    }

    public int getSourceWidth() {
        if (this.movie != null) {
            try {
                return this.movie.getNaturalBoundsRect().getWidth();
            }
            catch (QTException qte) {
                return 0;
            }
        }
        return 0;
    }

    public float getAspectRatio() {
        if (this.movie == null) {
            return 0.0f;
        }
        return this.aspectRatio;
    }

    public void setAspectRatio(float aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    public synchronized void start() {
        if (this.movie == null) {
            return;
        }
        if (this.getMediaDuration() - this.getMediaTime() < 40L) {
            this.setMediaTime(0L);
        }
        try {
            this.startControllers();
            this.movie.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void stop() {
        if (this.movie == null) {
            return;
        }
        try {
            this.movie.stop();
            this.stopControllers();
            this.setControllersMediaTime(this.getMediaTime());
        }
        catch (QTException qt) {
            qt.printStackTrace();
        }
    }

    public boolean isPlaying() {
        if (this.movie == null) {
            return false;
        }
        float rate = 0.0f;
        try {
            rate = this.movie.getRate();
        }
        catch (Exception qt) {
            qt.printStackTrace();
        }
        return rate != 0.0f;
    }

    public void setOffset(long offset) {
        this.offset = offset;
        this.mediaDescriptor.timeOrigin = offset;
    }

    public long getOffset() {
        return this.offset;
    }

    public synchronized void setMediaTime(long time) {
        if (this.movie == null) {
            return;
        }
        if (this.isPlaying()) {
            this.stop();
        }
        try {
            this.movie.setTime(new TimeRecord(this.movie.getTimeScale(), time + this.offset));
            this.setControllersMediaTime(time);
        }
        catch (Exception qt) {
            qt.printStackTrace();
        }
    }

    public void nextFrame() {
        if (this.frameStepsToFrameBegin) {
            long curFrame = this.getMediaTime() / this.milliSecondsPerSample;
            this.setMediaTime((curFrame + 1L) * this.milliSecondsPerSample);
        } else {
            this.setMediaTime(this.getMediaTime() + this.getMilliSecondsPerSample());
        }
    }

    public void previousFrame() {
        if (this.frameStepsToFrameBegin) {
            long curFrame = this.getMediaTime() / this.milliSecondsPerSample;
            if (curFrame > 0L) {
                this.setMediaTime((curFrame - 1L) * this.milliSecondsPerSample);
            } else {
                this.setMediaTime(0L);
            }
        } else {
            this.setMediaTime(this.getMediaTime() - this.getMilliSecondsPerSample());
        }
    }

    public void setFrameStepsToFrameBegin(boolean stepsToFrameBegin) {
        this.frameStepsToFrameBegin = stepsToFrameBegin;
    }

    public long getMediaTime() {
        if (this.movie == null) {
            return 0L;
        }
        long time = 0L;
        try {
            time = this.movie.getTime();
        }
        catch (Exception qt) {
            qt.printStackTrace();
        }
        return time - this.offset;
    }

    public long getMilliSecondsPerSample() {
        if (!this.rateDetectionAttempted) {
            this.detectFrameRate();
        }
        return this.milliSecondsPerSample;
    }

    public void setMilliSecondsPerSample(long milliSeconds) {
        if (!this.frameRateAutoDetected) {
            this.milliSecondsPerSample = milliSeconds;
        }
    }

    public synchronized void setRate(float rate) {
        if (this.movie == null) {
            return;
        }
        if (this.isPlaying()) {
            this.stop();
        }
        try {
            this.movie.setPreferredRate(rate);
            this.setControllersRate(rate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public float getRate() {
        if (this.movie == null) {
            return 0.0f;
        }
        float rate = 0.0f;
        try {
            rate = this.movie.getPreferredRate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rate;
    }

    public boolean isFrameRateAutoDetected() {
        if (!this.rateDetectionAttempted) {
            this.detectFrameRate();
        }
        return this.frameRateAutoDetected;
    }

    public long getMediaDuration() {
        if (this.movie == null) {
            return 0L;
        }
        long duration = 0L;
        try {
            duration = this.movie.getDuration();
        }
        catch (Exception qt) {
            qt.printStackTrace();
        }
        return duration - this.offset;
    }

    public void setVolume(float volume) {
        if (this.movie == null) {
            return;
        }
        try {
            this.movie.setVolume(volume);
        }
        catch (Exception qt) {
            qt.printStackTrace();
        }
    }

    public float getVolume() {
        if (this.movie == null) {
            return 0.0f;
        }
        float volume = 0.0f;
        try {
            volume = this.movie.getVolume();
        }
        catch (Exception qt) {
            qt.printStackTrace();
        }
        return volume;
    }

    public void setStopMode(int mode) {
        if (mode == 1 || mode == 0) {
            this.stopMode = mode;
        }
    }

    private Movie createScratchMovie() {
        if (this.movie == null) {
            return null;
        }
        try {
            Track origTrack;
            Media media = null;
            if (this.movie.getTrackCount() >= 1 && (media = (origTrack = this.movie.getTrack(1)).getMedia()) instanceof MPEGMedia) {
                this.isWavPlayer = false;
                File tempFile = new File(Constants.ELAN_DATA_DIR, this.scratchName + scratchCount++);
                if (tempFile.exists()) {
                    long modified = tempFile.lastModified();
                    long age = System.currentTimeMillis() - modified;
                    if (age >= 86400000L) {
                        tempFile.delete();
                    }
                }
                this.scratchFile = new QTFile(tempFile);
                this.scratchFile.createMovieFile(QTUtils.toOSType((String)"TOVD"), -2147483647);
                this.scratchFile.deleteOnExit();
                File resourceFile = new File(this.scratchFile.getAbsolutePath() + ".#res");
                if (resourceFile.exists()) {
                    resourceFile.deleteOnExit();
                }
                Movie editMovie = new Movie();
                int dataRefCount = media.getDataRefCount();
                DataRef mediaDataRef = media.getDataRef(dataRefCount);
                QDDimension origSize = origTrack.getSize();
                Track editTrack = editMovie.newTrack(origSize.getWidthF(), origSize.getHeightF(), origTrack.getVolume());
                int ts = this.movie.getTimeScale();
                Media.newFromType((int)1297106247, (Track)editTrack, (int)ts, (DataRef)mediaDataRef);
                int duration = origTrack.getDuration();
                origTrack.insertSegment(editTrack, 0, duration, 0);
                origTrack.copySettings(editTrack);
                OpenMovieFile omf = OpenMovieFile.asWrite((QTFile)this.scratchFile);
                editMovie.addResource(omf, 0, this.scratchFile.getName());
                omf.close();
                Movie nextMovie = Movie.fromFile((OpenMovieFile)OpenMovieFile.asRead((QTFile)this.scratchFile));
                if (nextMovie != null) {
                    nextMovie.setTimeScale(ts);
                    nextMovie.update();
                    QTUtils.reclaimMemory();
                    return nextMovie;
                }
            }
        }
        catch (QTException qte) {
            qte.printStackTrace();
        }
        return null;
    }

    public Image getCurrentFrameImage() {
        return this.getFrameImageForTime(this.getMediaTime());
    }

    public Image getFrameImageForTime(long time) {
        try {
            int w = 352;
            int h = 288;
            if (this.mpegImageWidth > 0 && this.mpegImageHeight > 0) {
                w = this.mpegImageWidth;
                h = this.mpegImageHeight;
            } else {
                w = this.movie.getNaturalBoundsRect().getWidth();
                h = this.movie.getNaturalBoundsRect().getHeight();
            }
            Pict pict = this.movie.getTrack(1).getPict((int)time);
            QDGraphics offScr = new QDGraphics(QDGraphics.kDefaultPixelFormat, new QDRect(0, 0, w, h));
            pict.draw(offScr, offScr.getBounds());
            PixMap pixmap = offScr.getPixMap();
            RawEncodedImage raw = RawEncodedImage.fromPixMap((PixMap)pixmap);
            int intsPerRow = pixmap.getRowBytes() / 4;
            int[] pixels = new int[intsPerRow * h];
            raw.copyToArray(0, pixels, 0, pixels.length);
            DirectColorModel model = new DirectColorModel(32, 0xFF0000, 65280, 255, 0);
            Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(w, h, (ColorModel)model, pixels, 0, intsPerRow));
            return image;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Image getFrameImageForTime2(long time) {
        try {
            int w = 352;
            int h = 288;
            if (this.mpegImageWidth > 0 && this.mpegImageHeight > 0) {
                w = this.mpegImageWidth;
                h = this.mpegImageHeight;
            } else {
                w = this.movie.getNaturalBoundsRect().getWidth();
                h = this.movie.getNaturalBoundsRect().getHeight();
            }
            MoviePlayer pl = new MoviePlayer(this.movie);
            pl.setTime((int)time);
            QTImageProducer ip = new QTImageProducer(pl, new Dimension(w, h));
            Image img = Toolkit.getDefaultToolkit().createImage((ImageProducer)ip);
            return img;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void finalize() throws Throwable {
        System.out.println("Finalize QT player...");
        if (this.scratchFile.exists()) {
            File resourceFile = new File(this.scratchFile.getAbsolutePath() + ".#res");
            if (resourceFile.exists()) {
                resourceFile.delete();
            }
            this.scratchFile.delete();
        }
        if (this.isWavPlayer) {
            TaskAllMovies.removeMovie();
        }
        QTSession.close();
        QTUtils.reclaimMemory();
        super.finalize();
    }

    private void initQTJNI() {
        if (System.getProperty("os.name").regionMatches(false, 0, "Win", 0, 3)) {
            try {
                System.loadLibrary("QTJava");
            }
            catch (UnsatisfiedLinkError ule) {
                System.out.println(ule.getMessage());
            }
            try {
                System.loadLibrary("QTJavaNative");
            }
            catch (UnsatisfiedLinkError ule) {
                System.out.println(ule.getMessage());
            }
            try {
                System.loadLibrary("QTJNative");
            }
            catch (UnsatisfiedLinkError ule) {
                System.out.println(ule.getMessage());
            }
        }
    }

    public void setLayoutManager(ElanLayoutManager layoutManager) {
        if (this.layoutManager == null && !this.isWavPlayer) {
            this.detachItem = new JMenuItem(ElanLocale.getString("Detachable.detach"));
            this.detachItem.addActionListener(this);
            this.popup.insert(this.detachItem, 0);
        }
        this.layoutManager = layoutManager;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.detachItem) && this.layoutManager != null) {
            if (this.detached) {
                this.layoutManager.attach(this.getVisualComponent());
                this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
                this.detached = false;
            } else {
                this.layoutManager.detach(this.getVisualComponent());
                this.detachItem.setText(ElanLocale.getString("Detachable.attach"));
                this.detached = true;
            }
        } else if (e.getSource() == this.infoItem) {
            new FormattedMessageDlg(this);
        } else if (e.getSource() == this.saveItem) {
            ImageExporter export = new ImageExporter(this.layoutManager.getElanFrame());
            export.exportImage(this.getCurrentFrameImage());
        } else if (e.getSource() == this.ratio_4_3_Item) {
            this.aspectRatio = 1.33f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.ratio_3_2_Item) {
            this.aspectRatio = 1.66f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.ratio_16_9_Item) {
            this.aspectRatio = 1.78f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.ratio_185_1_Item) {
            this.aspectRatio = 1.85f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.ratio_235_1_Item) {
            this.aspectRatio = 2.35f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        }
    }

    public void updateLocale() {
        if (this.infoItem != null) {
            this.infoItem.setText(ElanLocale.getString("Player.Info"));
        }
        if (this.durationItem != null) {
            this.durationItem.setText(ElanLocale.getString("Player.duration") + ":  " + TimeFormatter.toString(this.getMediaDuration()));
        }
        if (this.saveItem != null) {
            this.saveItem.setText(ElanLocale.getString("Player.SaveFrame"));
        }
        if (this.detachItem != null) {
            if (this.detached) {
                this.detachItem.setText(ElanLocale.getString("Detachable.attach"));
            } else {
                this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
            }
        }
    }

    private void copyToClipboard(String text) {
        if (text == null) {
            return;
        }
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkSystemClipboardAccess();
                StringSelection ssVal = new StringSelection(text);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssVal, null);
            }
            catch (SecurityException se) {
            }
            catch (IllegalStateException ise) {}
        } else {
            try {
                StringSelection ssVal = new StringSelection(text);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssVal, null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void cleanUpOnClose() {
        System.out.println("Clean up QT media player...");
        this.visualComponent = null;
        this.layoutManager = null;
        this.mediaDescriptor = null;
        try {
            this.timeBase.disposeQTObject();
            this.endOfMediaCallback.cancelAndCleanup();
            this.controller.deactivate();
            this.controller.disposeQTObject();
            this.canvas = null;
            this.movie = null;
            this.controller = null;
        }
        catch (QTException qte) {
            qte.printStackTrace();
        }
    }

    private class TimeBaseExtremesCallBack
    extends ExtremesCallBack {
        public TimeBaseExtremesCallBack(TimeBase tb, int flag) throws QTException {
            super(tb, flag);
        }

        public void execute() {
            try {
                QTMediaPlayer.this.movie.stop();
                QTMediaPlayer.this.stopControllers();
                QTMediaPlayer.this.setMediaTime(QTMediaPlayer.this.exactStopTime);
                if (QTMediaPlayer.this.stopMode == 0) {
                    QTMediaPlayer.this.setStopTime(QTMediaPlayer.this.movie.getDuration());
                } else {
                    QTMediaPlayer.this.movie.setPreviewMode(false);
                }
                QTMediaPlayer.this.exactStopTime = QTMediaPlayer.this.movie.getDuration();
                QTMediaPlayer.this.endOfMediaCallback.callMeWhen();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected class MouseHandler
    extends MouseAdapter {
        private final DecimalFormat format = new DecimalFormat("#.###");

        protected MouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                JPopupMenu.setDefaultLightWeightPopupEnabled(false);
                QTMediaPlayer.this.popup.show(QTMediaPlayer.this.getVisualComponent(), e.getPoint().x, e.getPoint().y);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2) {
                if (QTMediaPlayer.this.layoutManager != null) {
                    QTMediaPlayer.this.layoutManager.setFirstPlayer(QTMediaPlayer.this);
                }
                return;
            }
            if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                JPopupMenu.setDefaultLightWeightPopupEnabled(false);
                QTMediaPlayer.this.popup.show(QTMediaPlayer.this.getVisualComponent(), e.getPoint().x, e.getPoint().y);
                return;
            }
            try {
                if (e.isAltDown()) {
                    QTMediaPlayer.this.copyToClipboard(this.format.format((float)e.getX() / (float)QTMediaPlayer.this.visualComponent.getWidth()) + "," + this.format.format((float)e.getY() / (float)QTMediaPlayer.this.visualComponent.getHeight()));
                } else if (e.isShiftDown()) {
                    QTMediaPlayer.this.copyToClipboard("" + (int)((float)QTMediaPlayer.this.movie.getNaturalBoundsRect().getWidth() / (float)QTMediaPlayer.this.visualComponent.getWidth() * (float)e.getX()) + "," + (int)((float)QTMediaPlayer.this.movie.getNaturalBoundsRect().getHeight() / (float)QTMediaPlayer.this.visualComponent.getHeight() * (float)e.getY()));
                } else {
                    QTMediaPlayer.this.copyToClipboard("" + (int)((float)QTMediaPlayer.this.movie.getNaturalBoundsRect().getWidth() / (float)QTMediaPlayer.this.visualComponent.getWidth() * (float)e.getX()) + "," + (int)((float)QTMediaPlayer.this.movie.getNaturalBoundsRect().getHeight() / (float)QTMediaPlayer.this.visualComponent.getHeight() * (float)e.getY()) + " [" + QTMediaPlayer.this.movie.getNaturalBoundsRect().getWidth() + "," + QTMediaPlayer.this.movie.getNaturalBoundsRect().getHeight() + "]");
                }
            }
            catch (Exception exep) {
                exep.printStackTrace();
            }
        }
    }

    private class QTCanvasNoMouse
    extends QTCanvas {
        private QTCanvasNoMouse() {
        }

        public void addMouseListener(MouseListener ml) {
            if (ml instanceof MouseHandler) {
                super.addMouseListener(ml);
            }
        }
    }

    private class VisualComponent
    extends Panel
    implements ComponentListener,
    HierarchyListener {
        boolean doNotify = true;

        public VisualComponent(Component component) {
            this.add(component);
            this.addComponentListener(this);
            this.addHierarchyListener(this);
        }

        public void componentResized(ComponentEvent e) {
            System.out.println("resized");
        }

        public void hierarchyChanged(HierarchyEvent e) {
            System.out.println("hier");
        }

        public void addNotify() {
            System.out.println("addNotify");
            if (this.doNotify) {
                super.addNotify();
                this.doNotify = false;
            }
        }

        public void removeNotify() {
            System.out.println("removeNotify");
            super.removeNotify();
        }

        public void componentShown(ComponentEvent e) {
            System.out.println("show");
        }

        public void componentHidden(ComponentEvent e) {
            System.out.println("hide");
        }

        public void componentMoved(ComponentEvent e) {
            System.out.println("move");
        }

        protected void finalize() throws Throwable {
            System.out.println("Finalize visual component");
            super.finalize();
        }
    }
}

