/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.prefs.PreferenceEditor;

public class EditingPanel
extends JPanel
implements PreferenceEditor {
    private JCheckBox deselectCB;
    private JCheckBox enterCommitsCB;
    private JCheckBox clearSelectionCB;
    private JCheckBox createDependAnnCB;
    private boolean origDeselectFlag = false;
    private boolean origEnterFlag = false;
    private boolean origClearSelFlag = false;
    private boolean oriCreateDependAnnFlag = false;

    public EditingPanel() {
        this.readPrefs();
        this.initComponents();
    }

    private void readPrefs() {
        Object val = Preferences.get("InlineEdit.DeselectCommits", null);
        if (val instanceof Boolean) {
            this.origDeselectFlag = (Boolean)val;
        }
        if ((val = Preferences.get("InlineEdit.EnterCommits", null)) instanceof Boolean) {
            this.origEnterFlag = (Boolean)val;
        }
        if ((val = Preferences.get("ClearSelectionAfterCreation", null)) instanceof Boolean) {
            this.origClearSelFlag = (Boolean)val;
        }
        if ((val = Preferences.get("CreateDependingAnnotations", null)) instanceof Boolean) {
            this.oriCreateDependAnnFlag = (Boolean)val;
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 0, 2, 0);
        this.deselectCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.Deselect"), this.origDeselectFlag);
        this.enterCommitsCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.EnterCommits"), this.origEnterFlag);
        this.clearSelectionCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.ClearSelection"), this.origClearSelFlag);
        this.createDependAnnCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.CreateDependAnn"), this.oriCreateDependAnnFlag);
        this.deselectCB.setFont(this.deselectCB.getFont().deriveFont(0));
        this.enterCommitsCB.setFont(this.deselectCB.getFont());
        this.clearSelectionCB.setFont(this.deselectCB.getFont());
        this.createDependAnnCB.setFont(this.deselectCB.getFont());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        this.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Category.Edit")), gbc);
        gbc.gridy = 1;
        this.add((Component)this.deselectCB, gbc);
        gbc.gridy = 2;
        this.add((Component)this.enterCommitsCB, gbc);
        gbc.gridy = 3;
        this.add((Component)this.clearSelectionCB, gbc);
        gbc.gridy = 4;
        this.add((Component)this.createDependAnnCB, gbc);
        gbc.gridy = 5;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)new JPanel(), gbc);
    }

    public Map getChangedPreferences() {
        if (this.isChanged()) {
            HashMap<String, Boolean> chMap = new HashMap<String, Boolean>(3);
            if (this.deselectCB.isSelected() != this.origDeselectFlag) {
                chMap.put("InlineEdit.DeselectCommits", new Boolean(this.deselectCB.isSelected()));
            }
            if (this.enterCommitsCB.isSelected() != this.origEnterFlag) {
                chMap.put("InlineEdit.EnterCommits", new Boolean(this.enterCommitsCB.isSelected()));
            }
            if (this.clearSelectionCB.isSelected() != this.origClearSelFlag) {
                chMap.put("ClearSelectionAfterCreation", new Boolean(this.clearSelectionCB.isSelected()));
            }
            if (this.createDependAnnCB.isSelected() != this.oriCreateDependAnnFlag) {
                chMap.put("CreateDependingAnnotations", new Boolean(this.createDependAnnCB.isSelected()));
            }
            return chMap;
        }
        return null;
    }

    public boolean isChanged() {
        return this.deselectCB.isSelected() != this.origDeselectFlag || this.enterCommitsCB.isSelected() != this.origEnterFlag || this.clearSelectionCB.isSelected() != this.origClearSelFlag || this.createDependAnnCB.isSelected() != this.oriCreateDependAnnFlag;
    }
}

