/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.prefs.PreferenceEditor;
import mpi.eudico.client.annotator.util.FileUtility;

public class MediaNavPanel
extends JPanel
implements PreferenceEditor,
ChangeListener,
ActionListener {
    private boolean origFrameStepToFrameBegin = false;
    private String curMediaLocation = "-";
    private boolean origVideoSameSize = false;
    private boolean videoInCentre = false;
    private boolean origAltMediaLocSetsDirty = true;
    private String origTimeFormat = MS;
    private JCheckBox frameStepCB;
    private JCheckBox videosSameSizeCB;
    private JCheckBox videosInCentreCB;
    private JLabel setDirLabel;
    private JLabel curDirLabel;
    private JButton defaultDirButton;
    private JButton resetDirButton;
    private JCheckBox changedMediaLocCB;
    private JLabel timeFormatLabel;
    private JComboBox timeFormatComboBox;
    private static String HH_MM_SS_MS = ElanLocale.getString("TimeCodeFormat.Hours");
    private static String SS_MS = ElanLocale.getString("TimeCodeFormat.Seconds");
    private static String MS = ElanLocale.getString("TimeCodeFormat.MilliSec");
    private static String NTSC = ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.NTSC");
    private static String PAL = ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL");

    public MediaNavPanel() {
        this.readPrefs();
        this.initComponents();
    }

    private void readPrefs() {
        Object val = Preferences.get("MediaNavigation.FrameStepToFrameBegin", null);
        if (val instanceof Boolean) {
            this.origFrameStepToFrameBegin = (Boolean)val;
        }
        if ((val = Preferences.get("DefaultMediaLocation", null)) instanceof String) {
            this.curMediaLocation = (String)val;
        }
        if ((val = Preferences.get("Media.VideosSameSize", null)) instanceof Boolean) {
            this.origVideoSameSize = (Boolean)val;
        }
        if ((val = Preferences.get("Media.VideosCentre", null)) instanceof Boolean) {
            this.videoInCentre = (Boolean)val;
        }
        if ((val = Preferences.get("MediaLocation.AltLocationSetsChanged", null)) instanceof Boolean) {
            this.origAltMediaLocSetsDirty = (Boolean)val;
        }
        if ((val = Preferences.get("CurrentTime.Copy.TimeFormat", null)) instanceof String) {
            this.origTimeFormat = ((String)val).toString();
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 0, 2, 0);
        this.frameStepCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.MediaNav.FrameBegin"), this.origFrameStepToFrameBegin);
        this.frameStepCB.setFont(this.frameStepCB.getFont().deriveFont(0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        gbc.gridwidth = 3;
        this.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Category.MediaNav")), gbc);
        gbc.gridy = 1;
        this.add((Component)this.frameStepCB, gbc);
        gbc.gridy = 2;
        gbc.insets = new Insets(12, 0, 2, 0);
        this.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Media.VideoDisplay")), gbc);
        this.videosSameSizeCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.VideoSize"), this.origVideoSameSize);
        gbc.gridy = 3;
        gbc.insets = insets;
        this.videosSameSizeCB.setFont(this.videosSameSizeCB.getFont().deriveFont(0));
        this.add((Component)this.videosSameSizeCB, gbc);
        this.videosInCentreCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.VideoCentre"), this.videoInCentre);
        this.videosInCentreCB.addActionListener(this);
        gbc.gridy = 4;
        gbc.insets = insets;
        this.videosInCentreCB.setFont(this.videosInCentreCB.getFont().deriveFont(0));
        this.add((Component)this.videosInCentreCB, gbc);
        gbc.gridy = 5;
        gbc.insets = new Insets(12, 0, 2, 0);
        this.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Media.Location")), gbc);
        this.setDirLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Media.DefaultLoc"));
        this.setDirLabel.setFont(this.setDirLabel.getFont().deriveFont(0));
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.weightx = 0.5;
        gbc.insets = insets;
        this.add((Component)this.setDirLabel, gbc);
        this.curDirLabel = new JLabel(this.curMediaLocation);
        this.curDirLabel.setFont(this.curDirLabel.getFont().deriveFont(0));
        gbc.gridy = 7;
        this.add((Component)this.curDirLabel, gbc);
        this.defaultDirButton = new JButton(ElanLocale.getString("Button.Browse"));
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridheight = 2;
        gbc.anchor = 12;
        this.add((Component)this.defaultDirButton, gbc);
        this.defaultDirButton.addActionListener(this);
        this.resetDirButton = new JButton();
        ImageIcon resetIcon = null;
        try {
            resetIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Remove.gif"));
            this.resetDirButton.setIcon(resetIcon);
        }
        catch (Exception ex) {
            this.resetDirButton.setText("X");
        }
        this.resetDirButton.setToolTipText(ElanLocale.getString("PreferencesDialog.Reset"));
        this.resetDirButton.setPreferredSize(new Dimension(this.resetDirButton.getPreferredSize().width, this.defaultDirButton.getPreferredSize().height));
        gbc.gridx = 2;
        gbc.gridy = 6;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridheight = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 10, 2, 0);
        this.add((Component)this.resetDirButton, gbc);
        this.resetDirButton.addActionListener(this);
        this.changedMediaLocCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.SaveAltLocation"));
        this.changedMediaLocCB.setFont(this.changedMediaLocCB.getFont().deriveFont(0));
        this.changedMediaLocCB.setSelected(this.origAltMediaLocSetsDirty);
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        this.add((Component)this.changedMediaLocCB, gbc);
        this.timeFormatLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Media.TimeFormat"));
        gbc.gridy = 10;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(12, 0, 2, 0);
        this.add((Component)this.timeFormatLabel, gbc);
        this.timeFormatComboBox = new JComboBox();
        this.timeFormatComboBox.addItem(HH_MM_SS_MS);
        this.timeFormatComboBox.addItem(SS_MS);
        this.timeFormatComboBox.addItem(MS);
        this.timeFormatComboBox.addItem(NTSC);
        this.timeFormatComboBox.addItem(PAL);
        this.timeFormatComboBox.setSelectedItem(this.origTimeFormat);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        this.add((Component)this.timeFormatComboBox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 11;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.add((Component)new JPanel(), gbc);
    }

    public Map getChangedPreferences() {
        if (this.isChanged()) {
            HashMap<String, Object> chMap = new HashMap<String, Object>(4);
            if (this.frameStepCB.isSelected() != this.origFrameStepToFrameBegin) {
                chMap.put("MediaNavigation.FrameStepToFrameBegin", new Boolean(this.frameStepCB.isSelected()));
            }
            if (this.videosSameSizeCB.isSelected() != this.origVideoSameSize) {
                chMap.put("Media.VideosSameSize", new Boolean(this.videosSameSizeCB.isSelected()));
            }
            if (this.videosInCentreCB.isSelected() != this.videoInCentre) {
                chMap.put("Media.VideosCentre", new Boolean(this.videosInCentreCB.isSelected()));
            }
            if (this.curDirLabel.getText() != null && !this.curDirLabel.getText().equals("-")) {
                chMap.put("DefaultMediaLocation", this.curDirLabel.getText());
            } else {
                chMap.put("DefaultMediaLocation", null);
            }
            if (this.changedMediaLocCB.isSelected() != this.origAltMediaLocSetsDirty) {
                chMap.put("MediaLocation.AltLocationSetsChanged", new Boolean(this.changedMediaLocCB.isSelected()));
            }
            if (!this.timeFormatComboBox.getSelectedItem().toString().equals(this.origTimeFormat)) {
                chMap.put("CurrentTime.Copy.TimeFormat", new String(this.timeFormatComboBox.getSelectedItem().toString()));
            }
            return chMap;
        }
        return null;
    }

    public boolean isChanged() {
        return this.frameStepCB.isSelected() != this.origFrameStepToFrameBegin || !this.curMediaLocation.equals(this.curDirLabel.getText()) || this.videosSameSizeCB.isSelected() != this.origVideoSameSize || this.videosInCentreCB.isSelected() != this.videoInCentre || this.changedMediaLocCB.isSelected() != this.origAltMediaLocSetsDirty || !this.origTimeFormat.equals(this.timeFormatComboBox.getSelectedItem().toString());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.defaultDirButton) {
            File selFile;
            File dir;
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(ElanLocale.getString("PreferencesDialog.Media.DefaultLoc"));
            File startDir = new File(System.getProperty("user.home"));
            if (this.curMediaLocation.length() > 1 && (dir = new File(FileUtility.urlToAbsPath(this.curMediaLocation))).exists() && dir.isDirectory()) {
                startDir = dir;
            }
            chooser.setCurrentDirectory(startDir);
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileSelectionMode(1);
            int option = chooser.showDialog(this, ElanLocale.getString("Button.Select"));
            if (option == 0 && (selFile = chooser.getSelectedFile()) != null) {
                this.curDirLabel.setText(selFile.getAbsolutePath());
                this.curDirLabel.setText(FileUtility.pathToURLString(selFile.getAbsolutePath()));
            }
        } else if (e.getSource() == this.resetDirButton) {
            this.curDirLabel.setText("-");
        } else if (e.getSource() == this.videosInCentreCB) {
            Preferences.set("Media.VideosCentre.Temporary", this.videosInCentreCB.isSelected(), null);
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.videosInCentreCB) {
            Preferences.set("Media.VideosCentre.Temporary", this.videosInCentreCB.isSelected(), null);
        }
    }
}

