/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.prefs.PreferenceEditor;
import mpi.eudico.client.annotator.util.SystemReporting;

public class PlatformPanel
extends JPanel
implements PreferenceEditor {
    private JCheckBox macScreenBarCB;
    private boolean origMacUseScreenBar = false;
    private JCheckBox macLAndFCB;
    private boolean origMacLF = false;
    private JRadioButton cocoaQTB;
    private JRadioButton qtB;
    private String origMacPrefFramework = "CocoaQT";
    private boolean origPermDetached = false;
    private JCheckBox permDetachedCB;
    private JRadioButton jdsRB;
    private JRadioButton dsShowRB;
    private JRadioButton winQTRB;
    private JRadioButton jmfRB;
    private String origWinPrefFramework = "JDS";

    public PlatformPanel() {
        this.readPrefs();
        this.initComponents();
    }

    private void readPrefs() {
        Object val = null;
        if (SystemReporting.isMacOS()) {
            val = Preferences.get("OS.Mac.useScreenMenuBar", null);
            if (val instanceof Boolean) {
                this.origMacUseScreenBar = (Boolean)val;
            }
            if ((val = Preferences.get("UseMacLF", null)) instanceof Boolean) {
                this.origMacLF = (Boolean)val;
            }
            if ((val = Preferences.get("Mac.PrefMediaFramework", null)) instanceof String) {
                this.origMacPrefFramework = (String)val;
            }
            if ((val = Preferences.get("PreferredMediaWindow", null)) instanceof Boolean) {
                this.origPermDetached = (Boolean)val;
            }
        } else if (SystemReporting.isWindows() && (val = Preferences.get("Windows.PrefMediaFramework", null)) instanceof String) {
            this.origWinPrefFramework = (String)val;
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 0, 2, 0);
        GridBagConstraints gbc = new GridBagConstraints();
        Font plainFont = null;
        int gy = 0;
        if (SystemReporting.isMacOS()) {
            this.macScreenBarCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.OS.Mac.ScreenMenuBar"));
            this.macScreenBarCB.setSelected(this.origMacUseScreenBar);
            plainFont = this.macScreenBarCB.getFont().deriveFont(0);
            this.macScreenBarCB.setFont(plainFont);
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.gridwidth = 2;
            gbc.gridy = gy++;
            gbc.insets = insets;
            this.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.OS.Mac")), gbc);
            gbc.gridy = gy++;
            gbc.gridwidth = 1;
            this.add((Component)this.macScreenBarCB, gbc);
            JLabel relaunchLabel = new JLabel();
            ImageIcon relaunchIcon = null;
            try {
                relaunchIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Refresh16.gif"));
                relaunchLabel.setIcon(relaunchIcon);
            }
            catch (Exception ex) {
                relaunchLabel.setText(ElanLocale.getString("PreferencesDialog.Relaunch"));
            }
            relaunchLabel.setToolTipText(ElanLocale.getString("PreferencesDialog.Relaunch.Tooltip"));
            this.macScreenBarCB.setToolTipText(ElanLocale.getString("PreferencesDialog.Relaunch.Tooltip"));
            gbc.gridx = 1;
            gbc.gridwidth = 1;
            gbc.fill = 0;
            gbc.anchor = 13;
            gbc.weightx = 0.0;
            this.add((Component)relaunchLabel, gbc);
            this.macLAndFCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.OS.Mac.LF"));
            this.macLAndFCB.setSelected(this.origMacLF);
            this.macLAndFCB.setFont(plainFont);
            gbc.gridy = gy++;
            gbc.gridx = 0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.macLAndFCB, gbc);
            JLabel relaunchLabel2 = new JLabel();
            if (relaunchIcon != null) {
                relaunchLabel2.setIcon(relaunchIcon);
            } else {
                relaunchLabel2.setText(ElanLocale.getString("PreferencesDialog.Relaunch"));
            }
            relaunchLabel2.setToolTipText(ElanLocale.getString("PreferencesDialog.Relaunch.Tooltip"));
            this.macLAndFCB.setToolTipText(ElanLocale.getString("PreferencesDialog.Relaunch.Tooltip"));
            gbc.gridx = 1;
            gbc.gridwidth = 1;
            gbc.fill = 0;
            gbc.anchor = 13;
            gbc.weightx = 0.0;
            this.add((Component)relaunchLabel2, gbc);
            JLabel frameworkLabel = new JLabel(ElanLocale.getString("Player.Framework"));
            frameworkLabel.setFont(plainFont);
            this.cocoaQTB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.Cocoa"));
            this.cocoaQTB.setFont(plainFont);
            this.qtB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.QTJ"));
            this.qtB.setFont(plainFont);
            if (this.origMacPrefFramework.equals("CocoaQT")) {
                this.cocoaQTB.setSelected(true);
            } else {
                this.qtB.setSelected(true);
            }
            ButtonGroup gr = new ButtonGroup();
            gr.add(this.cocoaQTB);
            gr.add(this.qtB);
            gbc.gridx = 0;
            gbc.gridy = gy++;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.anchor = 18;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(12, 0, 2, 0);
            this.add((Component)frameworkLabel, gbc);
            gbc.gridy = gy++;
            gbc.insets = insets;
            this.add((Component)this.cocoaQTB, gbc);
            gbc.gridy = gy++;
            this.add((Component)this.qtB, gbc);
            this.permDetachedCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.OS.Mac.DetachedMedia"), this.origPermDetached);
            this.permDetachedCB.setFont(plainFont);
            gbc.gridy = gy++;
            this.add((Component)this.permDetachedCB, gbc);
            gbc.gridy = gy++;
            gbc.gridx = 0;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.add((Component)new JPanel(), gbc);
        } else if (SystemReporting.isWindows()) {
            gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.gridwidth = 2;
            gbc.gridy = gy++;
            gbc.insets = new Insets(12, 0, 2, 0);
            this.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.OS.Windows")), gbc);
            gbc.insets = insets;
            ButtonGroup winBG = new ButtonGroup();
            this.jdsRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.JDS"), true);
            this.dsShowRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.WMP"));
            this.winQTRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.QTJ"));
            this.jmfRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.JMF"));
            winBG.add(this.jdsRB);
            winBG.add(this.dsShowRB);
            winBG.add(this.winQTRB);
            winBG.add(this.jmfRB);
            plainFont = this.dsShowRB.getFont().deriveFont(0);
            JLabel winMedia = new JLabel(ElanLocale.getString("Player.Framework"));
            winMedia.setFont(plainFont);
            gbc.gridy = gy++;
            this.add((Component)winMedia, gbc);
            if (this.origWinPrefFramework.equals("NativeWindows")) {
                this.dsShowRB.setSelected(true);
            } else if (this.origWinPrefFramework.equals("QT")) {
                this.winQTRB.setSelected(true);
            } else if (this.origWinPrefFramework.equals("JMF")) {
                this.jmfRB.setSelected(true);
            }
            this.jdsRB.setFont(plainFont);
            this.dsShowRB.setFont(plainFont);
            this.winQTRB.setFont(plainFont);
            this.jmfRB.setFont(plainFont);
            gbc.insets = insets;
            gbc.gridy = gy++;
            this.add((Component)this.jdsRB, gbc);
            gbc.gridy = gy++;
            this.add((Component)this.dsShowRB, gbc);
            gbc.gridy = gy++;
            this.add((Component)this.winQTRB, gbc);
            gbc.gridy = gy++;
            this.add((Component)this.jmfRB, gbc);
            gbc.gridy = gy++;
            gbc.gridx = 0;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.add((Component)new JPanel(), gbc);
        }
    }

    public Map getChangedPreferences() {
        if (this.isChanged()) {
            HashMap<String, Object> chMap = new HashMap<String, Object>(4);
            if (SystemReporting.isMacOS()) {
                if (this.macScreenBarCB.isSelected() != this.origMacUseScreenBar) {
                    chMap.put("OS.Mac.useScreenMenuBar", new Boolean(this.macScreenBarCB.isSelected()));
                }
                if (this.macLAndFCB.isSelected() != this.origMacLF) {
                    chMap.put("UseMacLF", new Boolean(this.macLAndFCB.isSelected()));
                }
                String tmp = "CocoaQT";
                if (this.qtB.isSelected()) {
                    tmp = "QT";
                }
                if (!this.origMacPrefFramework.equals(tmp)) {
                    chMap.put("Mac.PrefMediaFramework", tmp);
                    System.setProperty("PreferredMediaFramework", tmp);
                }
                if (this.origPermDetached != this.permDetachedCB.isSelected()) {
                    chMap.put("PreferredMediaWindow", new Boolean(this.permDetachedCB.isSelected()));
                }
            } else if (SystemReporting.isWindows()) {
                String winTmp = "JDS";
                if (this.dsShowRB.isSelected()) {
                    winTmp = "NativeWindows";
                } else if (this.winQTRB.isSelected()) {
                    winTmp = "QT";
                } else if (this.jmfRB.isSelected()) {
                    winTmp = "JMF";
                }
                if (!this.origWinPrefFramework.equals(winTmp)) {
                    chMap.put("Windows.PrefMediaFramework", winTmp);
                    System.setProperty("PreferredMediaFramework", winTmp);
                }
            }
            return chMap;
        }
        return null;
    }

    public boolean isChanged() {
        if (SystemReporting.isMacOS()) {
            if (this.macScreenBarCB.isSelected() != this.origMacUseScreenBar || this.macLAndFCB.isSelected() != this.origMacLF || this.permDetachedCB.isSelected() != this.origPermDetached) {
                return true;
            }
            String tmp = "CocoaQT";
            if (this.qtB.isSelected()) {
                tmp = "QT";
            }
            if (!this.origMacPrefFramework.equals(tmp)) {
                return true;
            }
        } else if (SystemReporting.isWindows()) {
            String winTmp = "JDS";
            if (this.dsShowRB.isSelected()) {
                winTmp = "NativeWindows";
            } else if (this.winQTRB.isSelected()) {
                winTmp = "QT";
            } else if (this.jmfRB.isSelected()) {
                winTmp = "JMF";
            }
            if (!this.origWinPrefFramework.equals(winTmp)) {
                return true;
            }
        }
        return false;
    }
}

