/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.prefs.PreferenceEditor;

public class UIPrefsPanel
extends JPanel
implements PreferenceEditor {
    private JComboBox nrOfRecentItemsCBox;
    private Integer origNrRecentItems = 5;
    private JCheckBox tooltipCB;
    private boolean origToolTipEnabled = true;

    public UIPrefsPanel() {
        this.readPrefs();
        this.initComponents();
    }

    private void readPrefs() {
        Object val = Preferences.get("UI.RecentItems", null);
        if (val instanceof Integer) {
            this.origNrRecentItems = (Integer)val;
        }
        if ((val = Preferences.get("UI.ToolTips.Enabled", null)) instanceof Boolean) {
            this.origToolTipEnabled = (Boolean)val;
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 0, 2, 0);
        Integer[] nrOfRecentItemsList = new Integer[]{5, 10, 15, 20, 25, 30};
        this.nrOfRecentItemsCBox = new JComboBox<Integer>(nrOfRecentItemsList);
        this.nrOfRecentItemsCBox.setSelectedItem(this.origNrRecentItems);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.insets = insets;
        this.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.UI.RecentItems")), gbc);
        gbc.gridy = 1;
        this.add((Component)this.nrOfRecentItemsCBox, gbc);
        gbc.gridy = 2;
        gbc.insets = new Insets(12, 0, 2, 0);
        this.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.UI.ToolTip")), gbc);
        this.tooltipCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.UI.ToolTip.Enabled"));
        this.tooltipCB.setSelected(this.origToolTipEnabled);
        this.tooltipCB.setFont(this.tooltipCB.getFont().deriveFont(0));
        gbc.gridy = 3;
        gbc.insets = insets;
        this.add((Component)this.tooltipCB, gbc);
        gbc.gridy = 4;
        gbc.gridx = 0;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)new JPanel(), gbc);
    }

    public Map getChangedPreferences() {
        if (this.isChanged()) {
            HashMap<String, Object> chMap = new HashMap<String, Object>(2);
            if (this.nrOfRecentItemsCBox.getSelectedItem() != this.origNrRecentItems) {
                chMap.put("UI.RecentItems", this.nrOfRecentItemsCBox.getSelectedItem());
            }
            if (this.tooltipCB.isSelected() != this.origToolTipEnabled) {
                chMap.put("UI.ToolTips.Enabled", new Boolean(this.tooltipCB.isSelected()));
            }
            return chMap;
        }
        return null;
    }

    public boolean isChanged() {
        return this.nrOfRecentItemsCBox.getSelectedItem() != this.origNrRecentItems || this.tooltipCB.isSelected() != this.origToolTipEnabled;
    }
}

