/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.prefs.PreferenceEditor;
import mpi.eudico.client.util.ButtonCellEditor;
import mpi.eudico.client.util.ButtonTableCellRenderer;
import mpi.eudico.client.util.RadioButtonCellEditor;
import mpi.eudico.client.util.RadioButtonTableCellRenderer;
import mpi.eudico.client.util.SelectEnableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewerPanel
extends JPanel
implements PreferenceEditor,
MouseListener {
    private int origNumSubtitles = 4;
    private boolean origActiveAnnBold = false;
    private boolean origReducedTierHeight = false;
    private boolean videoInCentre = false;
    private JComboBox numSubCB;
    private JCheckBox aaBoldCB;
    private JCheckBox redTierHeightCB;
    private JButton downButton;
    private JButton upButton;
    private JTable viewerTable;
    private boolean sortOrderChanged = false;
    private final String GRID_VIEWER = ElanLocale.getString("Menu.View.Viewers.Grid");
    private final String TEXT_VIEWER = ElanLocale.getString("Menu.View.Viewers.Text");
    private final String SUBTITLE_VIEWER = ElanLocale.getString("Menu.View.Viewers.Subtitles");
    private final String LEXICON_VIEWER = ElanLocale.getString("LexiconEntryViewer.Lexicon");
    private final String AUDIO_RECOGNIZER = ElanLocale.getString("Menu.View.Viewers.Audio");
    private final String VIDEO_RECOGNIZER = ElanLocale.getString("Menu.View.Viewers.Video");
    private final String METADATA_VIEWER = ElanLocale.getString("Menu.View.Viewers.MetaData");
    private final List<String> viewersList = new ArrayList<String>(Arrays.asList(this.GRID_VIEWER, this.TEXT_VIEWER, this.SUBTITLE_VIEWER, this.LEXICON_VIEWER, this.AUDIO_RECOGNIZER, this.VIDEO_RECOGNIZER, this.METADATA_VIEWER));
    private List<String> viewerSortOrder;

    public ViewerPanel() {
        this.readPrefs();
        this.initComponents();
    }

    private void readPrefs() {
        Object val = Preferences.get("Media.VideosCentre", null);
        if (val instanceof Boolean) {
            this.videoInCentre = (Boolean)val;
        }
        if ((val = Preferences.get("NumberOfSubtitleViewers", null)) instanceof Integer) {
            this.origNumSubtitles = (Integer)val;
        }
        if ((val = Preferences.get("TimeLineViewer.ActiveAnnotationBold", null)) instanceof Boolean) {
            this.origActiveAnnBold = (Boolean)val;
        }
        if ((val = Preferences.get("TimeLineViewer.ReducedTierHeight", null)) instanceof Boolean) {
            this.origReducedTierHeight = (Boolean)val;
        }
        this.viewerSortOrder = (val = Preferences.get("PreferencesDialog.Viewer.SortOrder", null)) instanceof List ? (List<Object>)val : this.viewersList;
    }

    private void readViewerPref() {
        for (int x = 0; x < this.viewerTable.getRowCount(); ++x) {
            if (!(this.viewerTable.getModel().getValueAt(x, 0) instanceof SelectEnableObject)) continue;
            SelectEnableObject seo = (SelectEnableObject)this.viewerTable.getModel().getValueAt(x, 1);
            boolean bool = this.getPrefValue((String)seo.getValue());
            seo.setSelected(bool);
            ((SelectEnableObject)this.viewerTable.getModel().getValueAt(x, 0)).setSelected(!bool);
        }
    }

    private String getRefValue(String viewer) {
        String val = null;
        if (viewer.equals(this.GRID_VIEWER)) {
            val = "PreferencesDialog.Viewer.Grid.Right";
        } else if (viewer.equals(this.TEXT_VIEWER)) {
            val = "PreferencesDialog.Viewer.Text.Right";
        } else if (viewer.equals(this.SUBTITLE_VIEWER)) {
            val = "PreferencesDialog.Viewer.Subtitle.Right";
        } else if (viewer.equals(this.LEXICON_VIEWER)) {
            val = "PreferencesDialog.Viewer.Lexicon.Right";
        } else if (viewer.equals(this.AUDIO_RECOGNIZER)) {
            val = "PreferencesDialog.Viewer.Audio.Right";
        } else if (viewer.equals(this.VIDEO_RECOGNIZER)) {
            val = "PreferencesDialog.Viewer.Video.Right";
        } else if (viewer.equals(this.METADATA_VIEWER)) {
            val = "PreferencesDialog.Viewer.MetaData.Right";
        }
        return val;
    }

    private boolean getPrefValue(String viewer) {
        boolean bool = true;
        Object val = null;
        val = Preferences.get(this.getRefValue(viewer), null);
        if (val instanceof Boolean) {
            bool = (Boolean)val;
        }
        return bool;
    }

    private void initComponents() {
        String coulmnHeader1 = ElanLocale.getString("PreferencesDialog.Viewer.ColumnHeader.LeftofVideo");
        String coulmnHeader2 = ElanLocale.getString("PreferencesDialog.Viewer.ColumnHeader.RightofVideo");
        String coulmnHeader3 = ElanLocale.getString("PreferencesDialog.Viewer.ColumnHeader.MoveUp");
        String coulmnHeader4 = ElanLocale.getString("PreferencesDialog.Viewer.ColumnHeader.MoveDown");
        DefaultTableModel dm = new DefaultTableModel();
        dm.setColumnIdentifiers(new String[]{coulmnHeader1, coulmnHeader2, coulmnHeader3, coulmnHeader4});
        this.viewerTable = new JTable(dm);
        this.viewerTable.getColumn(coulmnHeader1).setCellEditor(new RadioButtonCellEditor(new JCheckBox()));
        this.viewerTable.getColumn(coulmnHeader1).setCellRenderer(new RadioButtonTableCellRenderer());
        this.viewerTable.getColumn(coulmnHeader2).setCellEditor(new RadioButtonCellEditor(new JCheckBox()));
        this.viewerTable.getColumn(coulmnHeader2).setCellRenderer(new RadioButtonTableCellRenderer());
        this.viewerTable.getColumn(coulmnHeader3).setCellRenderer(new ButtonTableCellRenderer());
        this.viewerTable.getColumn(coulmnHeader3).setCellEditor(new ButtonCellEditor(new JCheckBox()));
        this.viewerTable.getColumn(coulmnHeader3).setMaxWidth(70);
        this.viewerTable.getColumn(coulmnHeader4).setCellRenderer(new ButtonTableCellRenderer());
        this.viewerTable.getColumn(coulmnHeader4).setCellEditor(new ButtonCellEditor(new JCheckBox()));
        this.viewerTable.getColumn(coulmnHeader4).setMaxWidth(70);
        this.viewerTable.setGridColor(Color.BLACK);
        this.viewerTable.setRowHeight(20);
        this.viewerTable.addMouseListener(this);
        ImageIcon upIcon = null;
        ImageIcon downIcon = null;
        String upButtonLabel = null;
        String downButtonLabel = null;
        try {
            upIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Up16.gif"));
            downIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down16.gif"));
        }
        catch (Exception ex) {
            upButtonLabel = "Up";
            downButtonLabel = "Down";
        }
        for (int i = 0; i < this.viewerSortOrder.size(); ++i) {
            SelectEnableObject leftObj = new SelectEnableObject(this.viewerSortOrder.get(i), false, false);
            SelectEnableObject rightObj = new SelectEnableObject(this.viewerSortOrder.get(i), true, true);
            this.upButton = new JButton();
            this.downButton = new JButton();
            this.upButton.setToolTipText(ElanLocale.getString("PreferencesDialog.Viewer.SortButtonToolTip"));
            this.downButton.setToolTipText(ElanLocale.getString("PreferencesDialog.Viewer.SortButtonToolTip"));
            if (upIcon != null && downIcon != null) {
                this.upButton.setIcon(upIcon);
                this.downButton.setIcon(downIcon);
            } else {
                this.upButton.setText(upButtonLabel);
                this.downButton.setText(downButtonLabel);
            }
            dm.addRow(new Object[]{leftObj, rightObj, this.upButton, this.downButton});
        }
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 0, 2, 0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.insets = insets;
        this.add((Component)new JLabel(ElanLocale.getString("Tab.Subtitles")), gbc);
        JLabel numLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Viewer.NumSubtitles"));
        numLabel.setFont(numLabel.getFont().deriveFont(0));
        gbc.insets = new Insets(2, 22, 2, 0);
        gbc.gridy = 1;
        this.add((Component)numLabel, gbc);
        this.numSubCB = new JComboBox<Integer>(new Integer[]{1, 2, 3, 4, 5, 6, 7, 8});
        this.numSubCB.setSelectedItem(this.origNumSubtitles);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(2, 225, 2, 0);
        this.add((Component)this.numSubCB, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.insets = insets;
        gbc.gridy = 2;
        this.add((Component)new JLabel(ElanLocale.getString("TimeLineViewer.Name")), gbc);
        this.aaBoldCB = new JCheckBox(ElanLocale.getString("TimeLineViewer.ActiveAnnotationBold"));
        this.aaBoldCB.setFont(this.aaBoldCB.getFont().deriveFont(0));
        this.aaBoldCB.setSelected(this.origActiveAnnBold);
        gbc.gridy = 3;
        gbc.insets = insets;
        this.add((Component)this.aaBoldCB, gbc);
        this.redTierHeightCB = new JCheckBox(ElanLocale.getString("TimeLineViewer.ReducedTierHeight"));
        this.redTierHeightCB.setFont(this.redTierHeightCB.getFont().deriveFont(0));
        this.redTierHeightCB.setSelected(this.origReducedTierHeight);
        gbc.gridy = 4;
        this.add((Component)this.redTierHeightCB, gbc);
        gbc.gridy = 6;
        gbc.insets = new Insets(10, 0, 2, 0);
        JLabel videoLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Viewer.Label.Video"));
        videoLabel.setFont(videoLabel.getFont().deriveFont(0));
        this.add((Component)videoLabel, gbc);
        JScrollPane scrollPane = new JScrollPane(this.viewerTable);
        gbc.gridy = 7;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(6, 10, 2, 0);
        this.add((Component)scrollPane, gbc);
        this.updateViewerSelectionInTable();
    }

    @Override
    public Map getChangedPreferences() {
        if (this.isChanged()) {
            HashMap<String, Object> chMap = new HashMap<String, Object>(1);
            if (this.origNumSubtitles != (Integer)this.numSubCB.getSelectedItem()) {
                chMap.put("NumberOfSubtitleViewers", (Integer)this.numSubCB.getSelectedItem());
            }
            if (this.origActiveAnnBold != this.aaBoldCB.isSelected()) {
                chMap.put("TimeLineViewer.ActiveAnnotationBold", new Boolean(this.aaBoldCB.isSelected()));
            }
            if (this.origReducedTierHeight != this.redTierHeightCB.isSelected()) {
                chMap.put("TimeLineViewer.ReducedTierHeight", new Boolean(this.redTierHeightCB.isSelected()));
            }
            if (this.videoInCentre) {
                for (int x = 0; x < this.viewerTable.getRowCount(); ++x) {
                    if (!(this.viewerTable.getModel().getValueAt(x, 0) instanceof SelectEnableObject)) continue;
                    SelectEnableObject seo = (SelectEnableObject)this.viewerTable.getModel().getValueAt(x, 1);
                    String refValue = this.getRefValue((String)seo.getValue());
                    chMap.put(refValue, new Boolean(seo.isSelected()));
                }
            }
            if (this.sortOrderChanged) {
                chMap.put("PreferencesDialog.Viewer.SortOrder", this.getNewViewerSortOrder());
            }
            return chMap;
        }
        return null;
    }

    @Override
    public boolean isChanged() {
        int count = (Integer)this.numSubCB.getSelectedItem();
        List<String> newSortOrder = this.getNewViewerSortOrder();
        for (int i = 0; i < this.viewerSortOrder.size(); ++i) {
            if (this.viewerSortOrder.get(i).equals(newSortOrder.get(i))) continue;
            this.sortOrderChanged = true;
            return true;
        }
        if (count != this.origNumSubtitles) {
            return true;
        }
        if (this.origActiveAnnBold != this.aaBoldCB.isSelected()) {
            return true;
        }
        if (this.origReducedTierHeight != this.redTierHeightCB.isSelected()) {
            return true;
        }
        return this.videoInCentre;
    }

    private List<String> getNewViewerSortOrder() {
        ArrayList<String> newSortOrder = new ArrayList<String>();
        for (int row = 0; row < this.viewerTable.getRowCount(); ++row) {
            newSortOrder.add((String)((SelectEnableObject)this.viewerTable.getModel().getValueAt(row, 0)).getValue());
        }
        return newSortOrder;
    }

    public void updateVideoInCentre(Boolean val) {
        if (val != this.videoInCentre) {
            this.videoInCentre = val;
            this.updateViewerSelectionInTable();
        }
    }

    private void updateViewerSelectionInTable() {
        if (!this.videoInCentre) {
            for (int x = 0; x < this.viewerTable.getRowCount(); ++x) {
                if (!(this.viewerTable.getModel().getValueAt(x, 0) instanceof SelectEnableObject)) continue;
                SelectEnableObject leftRB = (SelectEnableObject)this.viewerTable.getModel().getValueAt(x, 0);
                SelectEnableObject rightRB = (SelectEnableObject)this.viewerTable.getModel().getValueAt(x, 1);
                leftRB.setEnabled(false);
                leftRB.setSelected(false);
                rightRB.setEnabled(true);
                rightRB.setSelected(true);
            }
        } else {
            this.readViewerPref();
            for (int x = 0; x < this.viewerTable.getRowCount(); ++x) {
                if (!(this.viewerTable.getModel().getValueAt(x, 0) instanceof SelectEnableObject)) continue;
                SelectEnableObject rb = (SelectEnableObject)this.viewerTable.getModel().getValueAt(x, 0);
                rb.setEnabled(true);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int selectedColumnIndex;
        int selectedRowIndex = this.viewerTable.getSelectedRow();
        if (this.viewerTable.getValueAt(selectedRowIndex, selectedColumnIndex = this.viewerTable.getSelectedColumn()) instanceof JButton) {
            if (selectedColumnIndex == 2) {
                Object row1 = this.viewerTable.getModel().getValueAt(selectedRowIndex, 0);
                Object row11 = this.viewerTable.getModel().getValueAt(selectedRowIndex, 1);
                if (selectedRowIndex > 0) {
                    Object row2 = this.viewerTable.getModel().getValueAt(selectedRowIndex - 1, 0);
                    Object row21 = this.viewerTable.getModel().getValueAt(selectedRowIndex - 1, 1);
                    this.viewerTable.getModel().setValueAt(row1, selectedRowIndex - 1, 0);
                    this.viewerTable.getModel().setValueAt(row11, selectedRowIndex - 1, 1);
                    this.viewerTable.getModel().setValueAt(row2, selectedRowIndex, 0);
                    this.viewerTable.getModel().setValueAt(row21, selectedRowIndex, 1);
                }
            } else if (selectedColumnIndex == 3) {
                Object row1 = this.viewerTable.getModel().getValueAt(selectedRowIndex, 0);
                Object row11 = this.viewerTable.getModel().getValueAt(selectedRowIndex, 1);
                if (selectedRowIndex < this.viewerTable.getRowCount() - 1) {
                    Object row2 = this.viewerTable.getModel().getValueAt(selectedRowIndex + 1, 0);
                    Object row21 = this.viewerTable.getModel().getValueAt(selectedRowIndex + 1, 1);
                    this.viewerTable.getModel().setValueAt(row1, selectedRowIndex + 1, 0);
                    this.viewerTable.getModel().setValueAt(row11, selectedRowIndex + 1, 1);
                    this.viewerTable.getModel().setValueAt(row2, selectedRowIndex, 0);
                    this.viewerTable.getModel().setValueAt(row21, selectedRowIndex, 1);
                }
            }
        }
        this.viewerTable.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int selectedColumnIndex;
        int selectedRowIndex = this.viewerTable.getSelectedRow();
        if (this.viewerTable.getValueAt(selectedRowIndex, selectedColumnIndex = this.viewerTable.getSelectedColumn()) instanceof SelectEnableObject) {
            SelectEnableObject seo1 = (SelectEnableObject)this.viewerTable.getValueAt(selectedRowIndex, selectedColumnIndex);
            if (seo1.isSelected()) {
                SelectEnableObject seo2 = null;
                if (selectedColumnIndex == 0) {
                    seo2 = (SelectEnableObject)this.viewerTable.getValueAt(selectedRowIndex, 1);
                } else if (selectedColumnIndex == 1) {
                    seo2 = (SelectEnableObject)this.viewerTable.getValueAt(selectedRowIndex, 0);
                }
                if (seo2 != null && seo2.isEnabled()) {
                    seo2.setSelected(false);
                }
            } else {
                seo1.setSelected(true);
            }
        }
        this.viewerTable.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

