/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.recognizer.api.AvailabilityDetector;
import mpi.eudico.client.annotator.recognizer.api.Recognizer;
import mpi.eudico.client.annotator.recognizer.api.RecognizerHost;
import mpi.eudico.client.annotator.recognizer.data.BoundarySegmentation;
import mpi.eudico.client.annotator.recognizer.data.MediaDescriptor;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.recognizer.gui.AbstractRecognizerPanel;
import mpi.eudico.client.util.WAVHeader;
import mpi.eudico.client.util.WAVSampler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioRecognizerPanel
extends AbstractRecognizerPanel
implements ActionListener,
Runnable,
RecognizerHost,
ElanLocaleListener {
    private String visibleAudioFilePath;

    public AudioRecognizerPanel(ViewerManager2 viewerManager, ArrayList<String> audioFilePaths) {
        super(viewerManager, audioFilePaths);
    }

    @Override
    protected void initComponents() {
        this.mode = 0;
        if (this.viewerManager.getSignalViewer() != null) {
            this.visibleAudioFilePath = this.viewerManager.getSignalViewer().getMediaPath();
            try {
                WAVSampler wavSampler = new WAVSampler(this.visibleAudioFilePath);
                WAVHeader wavHeader = wavSampler.getWavHeader();
                this.notMono = wavHeader.getNumberOfChannels() > 1;
            }
            catch (Exception e) {
                System.out.println("Cannot handle file: " + e.getMessage());
            }
        }
        super.initComponents();
    }

    @Override
    protected HashMap<String, Recognizer> getAvailableRecognizers() {
        return AvailabilityDetector.getAudioRecognizers(this.mediaFilePaths);
    }

    @Override
    protected void setRecognizer(String name) {
        super.setRecognizer(name);
        if (this.selectionPanel.isEnabled()) {
            this.selectionPanel.setStereoMode(this.notMono);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.startStopButton) && this.currentRecognizer != null && !this.isRunning && (this.currentRecognizer.getExamplesSupport() != 1 || this.getSelections().size() >= 1) && this.viewerManager.getSignalViewer() != null) {
            this.viewerManager.getSignalViewer().setSegmentationChannel1(null);
            this.viewerManager.getSignalViewer().setSegmentationChannel2(null);
        }
        super.actionPerformed(e);
    }

    public ArrayList<String> getAudioFilePaths() {
        return this.mediaFilePaths;
    }

    public void setAudioFilePaths(ArrayList<String> audioFilePaths) {
        this.mediaFilePaths.clear();
        for (int i = 0; i < audioFilePaths.size(); ++i) {
            String path = audioFilePaths.get(i);
            if (path.startsWith("file:")) {
                path = path.substring(5);
            }
            if (this.mediaFilePaths.contains(path)) continue;
            this.mediaFilePaths.add(path);
        }
        if (this.mediaFilePaths.size() > 0) {
            this.visibleAudioFilePath = (String)this.mediaFilePaths.get(0);
        }
        try {
            WAVSampler wavSampler = new WAVSampler(this.visibleAudioFilePath);
            WAVHeader wavHeader = wavSampler.getWavHeader();
            this.notMono = wavHeader.getNumberOfChannels() > 1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.segmentations = new HashMap();
        this.updateFileList();
    }

    @Override
    public void addSegmentation(Segmentation segmentation) {
        super.addSegmentation(segmentation);
        if (this.viewerManager.getSignalViewer() != null) {
            int channel = 0;
            ArrayList<MediaDescriptor> mediaDescriptors = segmentation.getMediaDescriptors();
            for (int i = 0; i < mediaDescriptors.size(); ++i) {
                MediaDescriptor descriptor = mediaDescriptors.get(i);
                channel += descriptor.channel;
            }
            if (channel == 1) {
                if (this.notMono) {
                    this.viewerManager.getSignalViewer().setSegmentationChannel1(new BoundarySegmentation(segmentation));
                } else {
                    this.viewerManager.getSignalViewer().setSegmentation(new BoundarySegmentation(segmentation));
                }
            } else if (channel == 2) {
                this.viewerManager.getSignalViewer().setSegmentationChannel2(new BoundarySegmentation(segmentation));
            } else if (channel == 3) {
                // empty if block
            }
        }
    }
}

