/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.recognizer.data.NumParam;
import mpi.eudico.client.annotator.recognizer.gui.AbstractParamPanel;

public class NumParamPanel
extends AbstractParamPanel
implements ChangeListener,
ActionListener,
FocusListener {
    private float min;
    private float max;
    private float initial;
    private int decPrecision = 1;
    private JSlider slider;
    private JTextField valueField;
    private int scale = 100000;
    private DecimalFormat decFormat;

    public NumParamPanel(String paramName, String description, float min, float max, float initial, int precision) {
        super(paramName, description);
        this.min = min;
        this.max = max;
        if (this.min > this.max) {
            float tmp = this.max;
            this.max = this.min;
            this.min = tmp;
        }
        this.initial = initial;
        this.decPrecision = precision;
        this.initComponents();
    }

    public NumParamPanel(NumParam param) {
        super(param);
        if (param != null) {
            this.min = param.min;
            this.max = param.max;
            if (this.min > this.max) {
                float tmp = this.max;
                this.max = this.min;
                this.min = tmp;
            }
            this.initial = param.def;
            this.decPrecision = param.precision;
            this.initComponents();
        }
    }

    protected void initComponents() {
        super.initComponents();
        StringBuilder sb = new StringBuilder("#0.");
        for (int i = 0; i < this.decPrecision; ++i) {
            sb.append("0");
        }
        this.decFormat = new DecimalFormat(sb.toString(), new DecimalFormatSymbols(Locale.US));
        StringBuilder builder = new StringBuilder("<html><p>");
        builder.append(this.description);
        builder.append(" <i><small>");
        builder.append(" (" + this.min + " - " + this.max + ")");
        builder.append("</small></i></p></html>");
        this.descLabel.setText(builder.toString());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 2;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(1, 1, 4, 1);
        this.slider = new JSlider((int)(this.min * (float)this.scale), (int)(this.max * (float)this.scale), (int)(this.initial * (float)this.scale));
        this.add((Component)this.slider, gbc);
        this.slider.addChangeListener(this);
        this.valueField = new JTextField(8);
        this.valueField.setText(String.valueOf(this.initial));
        this.valueField.addActionListener(this);
        this.valueField.addFocusListener(this);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.insets = new Insets(1, 1, 1, 5);
        this.add((Component)this.valueField, gbc);
    }

    protected Object getParamValue() {
        if (this.slider != null) {
            return new Float((float)this.slider.getValue() / (float)this.scale);
        }
        return null;
    }

    protected void setParamValue(Object value) {
        if (value instanceof Float) {
            float nv = ((Float)value).floatValue();
            if (nv >= this.min && nv <= this.max) {
                this.initial = nv;
                if (this.slider != null) {
                    this.slider.setValue((int)(this.initial * (float)this.scale));
                }
            }
        } else if (value instanceof String) {
            try {
                float nv = Float.parseFloat((String)value);
                if (nv >= this.min && nv <= this.max) {
                    this.initial = nv;
                    if (this.slider != null) {
                        this.slider.setValue((int)(this.initial * (float)this.scale));
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.slider) {
            this.valueField.setText(this.decFormat.format((float)this.slider.getValue() / (float)this.scale));
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.valueField) {
            String v = this.valueField.getText();
            try {
                float fv = Float.parseFloat(v);
                if (fv < this.min) {
                    fv = this.min;
                }
                if (fv > this.max) {
                    fv = this.max;
                }
                this.slider.setValue((int)(fv * (float)this.scale));
            }
            catch (NumberFormatException nfe) {
                this.valueField.setText(this.decFormat.format((float)this.slider.getValue() / (float)this.scale));
            }
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.valueField) {
            String v = this.valueField.getText();
            try {
                float fv = Float.parseFloat(v);
                if (fv < this.min) {
                    fv = this.min;
                }
                if (fv > this.max) {
                    fv = this.max;
                }
                this.slider.setValue((int)(fv * (float)this.scale));
            }
            catch (NumberFormatException nfe) {
                this.valueField.setText(this.decFormat.format((float)this.slider.getValue() / (float)this.scale));
            }
        }
    }
}

