/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.gui;

import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import mpi.eudico.client.annotator.recognizer.api.ParamPreferences;
import mpi.eudico.client.annotator.recognizer.data.FileParam;
import mpi.eudico.client.annotator.recognizer.data.NumParam;
import mpi.eudico.client.annotator.recognizer.data.Param;
import mpi.eudico.client.annotator.recognizer.data.TextParam;
import mpi.eudico.client.annotator.recognizer.gui.AbstractParamPanel;
import mpi.eudico.client.annotator.recognizer.gui.FileParamPanel;
import mpi.eudico.client.annotator.recognizer.gui.NumParamPanel;
import mpi.eudico.client.annotator.recognizer.gui.TextParamPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParamPanelContainer
extends JPanel
implements ParamPreferences {
    private String recogizerName;
    private GridLayout gLayout;
    private List<AbstractParamPanel> panels;

    public ParamPanelContainer(String recogizerName) {
        this.recogizerName = recogizerName;
        this.gLayout = new GridLayout(0, 1, 2, 2);
        this.setLayout(this.gLayout);
        this.setBorder(new EmptyBorder(2, 2, 2, 0));
        this.panels = new ArrayList<AbstractParamPanel>(10);
    }

    public ParamPanelContainer(String recogizerName, List<Param> params) {
        this.recogizerName = recogizerName;
        this.gLayout = new GridLayout(0, 1, 2, 2);
        this.setLayout(this.gLayout);
        this.setBorder(new EmptyBorder(2, 2, 2, 0));
        if (params != null) {
            this.panels = new ArrayList<AbstractParamPanel>(params.size());
            for (Param p : params) {
                if (p instanceof NumParam) {
                    this.addParamPanel(new NumParamPanel((NumParam)p));
                    continue;
                }
                if (p instanceof TextParam) {
                    this.addParamPanel(new TextParamPanel((TextParam)p));
                    continue;
                }
                if (!(p instanceof FileParam)) continue;
                FileParamPanel fpp = new FileParamPanel((FileParam)p);
                if (((FileParam)p).ioType == 'i' && (((FileParam)p).contentType == 0 || ((FileParam)p).contentType == 1)) {
                    fpp.setEnabled(false);
                    continue;
                }
                this.addParamPanel(fpp);
            }
        } else {
            this.panels = new ArrayList<AbstractParamPanel>(10);
        }
    }

    public String getRecognizerName() {
        return this.recogizerName;
    }

    @Override
    public Map<String, Object> getParamPreferences() {
        HashMap<String, Object> storedPrefs = new HashMap<String, Object>(this.panels.size());
        for (AbstractParamPanel p : this.panels) {
            storedPrefs.put(p.getParamName(), p.getParamValue());
        }
        return storedPrefs;
    }

    @Override
    public void setParamPreferences(Map<String, Object> storedPrefs) {
        block0: for (String key : storedPrefs.keySet()) {
            for (AbstractParamPanel p : this.panels) {
                if (p.getParamName() == null || !p.getParamName().equals(key)) continue;
                p.setParamValue(storedPrefs.get(key));
                continue block0;
            }
        }
    }

    public int getNumPanels() {
        return this.panels.size();
    }

    public AbstractParamPanel getParamPanel(int index) {
        if (index >= 0 && index < this.panels.size()) {
            return this.panels.get(index);
        }
        return null;
    }

    public void addParamPanel(AbstractParamPanel app) {
        this.gLayout.setRows(this.gLayout.getRows() + 1);
        this.add(app);
        this.panels.add(app);
    }
}

