/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.gui;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.recognizer.api.RecognizerHost;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;

public class SegmentationPanel
extends JPanel
implements ActionListener {
    private RecognizerHost host;
    private ViewerManager2 viewerManager;
    private TitledBorder border;
    private JButton makeSegmentationTier;

    public SegmentationPanel(RecognizerHost host, ViewerManager2 viewerManager) {
        this.host = host;
        this.viewerManager = viewerManager;
        this.setLayout(new FlowLayout(1, 0, 0));
        this.border = new TitledBorder(ElanLocale.getString("Recognizer.SegmentationsPanel.Title"));
        this.setBorder(this.border);
        this.makeSegmentationTier = new JButton(ElanLocale.getString("Recognizer.SegmentationsPanel.Make.Tier"));
        this.makeSegmentationTier.addActionListener(this);
        this.add(this.makeSegmentationTier);
    }

    public void updateLocale() {
        this.border.setTitle(ElanLocale.getString("Recognizer.SegmentationsPanel.Title"));
        this.makeSegmentationTier.setText(ElanLocale.getString("Recognizer.SegmentationsPanel.Make.Tier"));
    }

    public void setEnabled(boolean enabled) {
        this.makeSegmentationTier.setEnabled(enabled);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.makeSegmentationTier)) {
            if (this.host.isBusy()) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("SegmentsToTierDialog.Warning.Busy"), ElanLocale.getString("Message.Warning"), 2);
                return;
            }
            ArrayList<Segmentation> segments = this.host.getSegmentations();
            if (segments == null || segments.size() == 0) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("SegmentsToTierDialog.Warning.NoSegmentation"), ElanLocale.getString("Message.Warning"), 2);
                return;
            }
            Command cc = ELANCommandFactory.createCommand(this.viewerManager.getTranscription(), "Seg2TierDlg");
            cc.execute(this.viewerManager.getTranscription(), new Object[]{segments});
        }
    }
}

