/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.recognizer.api.Recognizer;
import mpi.eudico.client.annotator.recognizer.api.RecognizerHost;
import mpi.eudico.client.annotator.recognizer.data.MediaDescriptor;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.data.Segment;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.recognizer.impl.DemoRecognizerPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DemoRecognizer
implements Recognizer {
    private static String EVEN_LABEL = "E";
    private static String UNEVEN_LABEL = "U";
    private RecognizerHost host;
    private DemoRecognizerPanel controlPanel;
    private boolean keepRunning;
    private String currentMediaFilePath;
    float duration = 12000.0f;
    private String name = "Demo Recognizer";
    private StringBuilder reportBuilder;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JPanel getControlPanel() {
        if (this.controlPanel == null) {
            this.controlPanel = new DemoRecognizerPanel();
        }
        return this.controlPanel;
    }

    @Override
    public boolean setMedia(List<String> mediaFilePaths) {
        if (mediaFilePaths == null) {
            return false;
        }
        this.currentMediaFilePath = mediaFilePaths.get(0);
        return true;
    }

    @Override
    public void setRecognizerHost(RecognizerHost host) {
        this.host = host;
    }

    @Override
    public void start() {
        this.keepRunning = true;
        this.getReportBuilder().delete(0, this.getReportBuilder().length());
        this.getReportBuilder().append("Recognizer: " + this.name + " starting...\n");
        this.recog();
    }

    @Override
    public void stop() {
        this.keepRunning = false;
        this.getReportBuilder().append("Recognizer: " + this.name + " stopped...\n");
    }

    protected void recog() {
        long start = -1L;
        long end = -1L;
        ArrayList<RSelection> selections = this.host.getSelections();
        if (selections != null) {
            for (int i = 0; i < selections.size(); ++i) {
                RSelection selection = selections.get(i);
                if (start == -1L) {
                    start = selection.beginTime;
                } else if (selection.beginTime < start) {
                    start = selection.beginTime;
                }
                if (selection.endTime <= end) continue;
                end = selection.endTime;
            }
        }
        start = start < 0L ? 0L : start;
        end = end < start + 12000L ? start + 12000L : end;
        this.getReportBuilder().append("Creating segments in interval: " + start + " - " + end + "\n");
        this.duration = end - start;
        ArrayList<RSelection> segments = new ArrayList<RSelection>();
        int stepDuration = 1000 * this.controlPanel.getStepDuration();
        this.getReportBuilder().append("Segment size in ms.: " + stepDuration + "\n");
        int nSteps = (int)(this.duration / (float)stepDuration);
        if (nSteps < 0) {
            nSteps = 1;
        }
        float perStep = 1.0f / (float)nSteps;
        for (int step = 0; step < nSteps; ++step) {
            long time = start + (long)(step * stepDuration);
            this.host.setProgress((float)time / this.duration);
            Segment segment = new Segment();
            segment.beginTime = time;
            segment.endTime = time + (long)stepDuration;
            segment.label = step % 2 == 0 ? EVEN_LABEL : UNEVEN_LABEL;
            segments.add(segment);
            try {
                Thread.currentThread();
                Thread.sleep(50L);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.host.setProgress((float)step * perStep);
            if (!this.keepRunning) break;
        }
        this.getReportBuilder().append("Number of segments created: " + segments.size() + "\n");
        if (this.keepRunning) {
            this.host.setProgress(1.0f);
        }
        MediaDescriptor descriptor = new MediaDescriptor(this.currentMediaFilePath, 1);
        Segmentation seg = new Segmentation("DEMO", segments, descriptor);
        this.host.addSegmentation(seg);
    }

    @Override
    public void updateLocale(Locale locale) {
    }

    @Override
    public boolean canCombineMultipleFiles() {
        return false;
    }

    @Override
    public boolean canHandleMedia(String mediaFilePath) {
        return true;
    }

    @Override
    public void dispose() {
        if (this.reportBuilder != null) {
            this.reportBuilder.delete(0, this.reportBuilder.length());
            this.reportBuilder = null;
        }
        this.controlPanel = null;
    }

    @Override
    public int getExamplesSupport() {
        return 0;
    }

    @Override
    public Object getParameterValue(String param) {
        if ("StepDuration".equals(param) && this.controlPanel != null) {
            return new Integer(this.controlPanel.getStepDuration());
        }
        return null;
    }

    @Override
    public int getRecognizerType() {
        return 2;
    }

    @Override
    public String getReport() {
        if (this.reportBuilder != null) {
            return this.reportBuilder.toString();
        }
        return null;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setParameterValue(String param, String value) {
    }

    @Override
    public void setParameterValue(String param, float value) {
        if ("StepDuration".equals(param) && this.controlPanel != null) {
            this.controlPanel.setStepDuration((int)value);
        }
    }

    private StringBuilder getReportBuilder() {
        if (this.reportBuilder == null) {
            this.reportBuilder = new StringBuilder();
        }
        return this.reportBuilder;
    }
}

