/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.recognizer.data.FileParam;
import mpi.eudico.client.annotator.recognizer.data.NumParam;
import mpi.eudico.client.annotator.recognizer.data.Param;
import mpi.eudico.client.annotator.recognizer.data.TextParam;
import mpi.eudico.client.annotator.util.ClientLogger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParamIO {
    public Map<String, Object> read(File f) throws IOException {
        if (f == null) {
            new IOException("Cannot read from file: file is null");
        }
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            ParamHandler ph = new ParamHandler();
            reader.setContentHandler(ph);
            reader.parse(f.getAbsolutePath());
            return ph.getParamMap();
        }
        catch (SAXException sax) {
            ClientLogger.LOG.warning("Parsing failed: " + sax.getMessage());
            throw new IOException(sax.getMessage());
        }
    }

    public void write(List<Param> paramList, File f) throws IOException {
        if (f == null) {
            new IOException("Cannot write to file: file is null");
        }
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8")));
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<PARAM xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"file:avatech-call.xsd\">");
        if (paramList != null && paramList.size() > 0) {
            for (Param p : paramList) {
                writer.print("<param name=\"" + p.id + "\">");
                if (p instanceof NumParam) {
                    writer.print(((NumParam)p).current);
                } else if (p instanceof TextParam) {
                    writer.print(((TextParam)p).curValue);
                } else if (p instanceof FileParam) {
                    String path = ((FileParam)p).filePath;
                    if (path.startsWith("file:")) {
                        path = path.substring(5);
                    }
                    writer.print(path);
                }
                writer.println("</param>");
            }
        }
        writer.println("</PARAM>");
        writer.close();
    }

    public void write(Map<String, Object> paramMap, File f) throws IOException {
        if (f == null) {
            new IOException("Cannot write to file: file is null");
        }
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8")));
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<PARAM xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"file:avatech-call.xsd\">");
        if (paramMap != null && paramMap.size() > 0) {
            String key2 = null;
            Object val = null;
            for (String key2 : paramMap.keySet()) {
                val = paramMap.get(key2);
                writer.print("<param name=\"" + key2 + "\">");
                if (val instanceof String) {
                    writer.print((String)val);
                } else if (val instanceof Float) {
                    writer.print((Float)val);
                } else if (val instanceof Double) {
                    writer.print((Double)val);
                }
                writer.println("</param>");
            }
        }
        writer.println("</PARAM>");
        writer.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ParamHandler
    implements ContentHandler {
        private String curContent = "";
        private String curName = null;
        private final String PARAM = "param";
        private final String NAME = "name";
        private Map<String, Object> params = new HashMap<String, Object>();

        public Map<String, Object> getParamMap() {
            return this.params;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.curContent = this.curContent + new String(ch, start, length);
        }

        @Override
        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
            if (name.equals("param")) {
                this.curName = attributes.getValue("name");
            }
        }

        @Override
        public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
            if (name.equals("param")) {
                this.curContent = this.curContent.trim();
                if (this.curName != null) {
                    this.params.put(this.curName, this.curContent);
                }
                this.curContent = "";
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endPrefixMapping(String arg0) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void processingInstruction(String arg0, String arg1) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator arg0) {
        }

        @Override
        public void skippedEntity(String arg0) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        }
    }
}

