/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mpi.eudico.client.annotator.search.model.EAFType;
import mpi.eudico.client.annotator.search.result.model.EAFMultipleFileMatch;
import mpi.search.content.model.CorpusType;
import mpi.search.content.query.model.Constraint;
import mpi.search.content.query.model.ContentQuery;
import mpi.search.content.query.model.Utilities;
import mpi.search.content.result.model.ContentResult;
import mpi.search.result.model.Match;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class EAFMultipleFileSearchHandler
extends DefaultHandler {
    private static final String NULL = "iuhfiahfafb29384hc";
    private final ContentResult result;
    private final Pattern pattern;
    private final Hashtable timeSlots;
    private final Hashtable timeUnsolvedMatches;
    private final Hashtable ref1;
    private final Hashtable ref2;
    private final List tierNames;
    private boolean doAppend;
    private boolean processAfter;
    private StringBuffer textBuffer;
    private EAFMultipleFileMatch lastMatch;
    private String annotationBefore;
    private String tierName;
    private String timeSlotRef1;
    private String timeSlotRef2;
    private String annotationRef;
    private int indexInTier;
    private File file;
    private List unalignedAlignablesIds;
    private List unalignedAlignableMatches;
    private String lastAlignedBTS;
    private String id;

    public EAFMultipleFileSearchHandler(ContentQuery query) {
        this.result = (ContentResult)query.getResult();
        this.pattern = Utilities.getPattern((Constraint)query.getAnchorConstraint(), (CorpusType)new EAFType());
        this.tierNames = new ArrayList();
        this.timeSlots = new Hashtable();
        this.ref1 = new Hashtable();
        this.ref2 = new Hashtable();
        this.timeUnsolvedMatches = new Hashtable();
        this.unalignedAlignablesIds = new ArrayList();
        this.unalignedAlignableMatches = new ArrayList();
    }

    public void newFile(File file) {
        this.file = file;
        this.timeSlots.clear();
        this.ref1.clear();
        this.ref2.clear();
        this.timeUnsolvedMatches.clear();
        this.unalignedAlignablesIds.clear();
        this.unalignedAlignableMatches.clear();
    }

    public ContentResult getResult() {
        return this.result;
    }

    public List getTierNames() {
        return this.tierNames;
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        this.doAppend = false;
        if (qName.equals("TIER")) {
            this.tierName = attrs.getValue("TIER_ID");
            if (!this.tierNames.contains(this.tierName)) {
                this.tierNames.add(this.tierName);
            }
            this.annotationBefore = null;
            this.processAfter = false;
            this.indexInTier = -1;
        } else if (qName.equals("ANNOTATION_VALUE")) {
            this.doAppend = true;
            this.textBuffer = new StringBuffer();
            ++this.indexInTier;
        } else if (qName.equals("ALIGNABLE_ANNOTATION")) {
            this.id = attrs.getValue("ANNOTATION_ID");
            this.timeSlotRef1 = attrs.getValue("TIME_SLOT_REF1");
            this.timeSlotRef2 = attrs.getValue("TIME_SLOT_REF2");
            this.annotationRef = null;
            this.ref1.put(this.id, this.timeSlotRef1);
            this.ref2.put(this.id, this.timeSlotRef2);
            if (this.lastAlignedBTS == null && this.timeSlots.containsKey(this.timeSlotRef1) && !this.timeSlots.containsKey(this.timeSlotRef2)) {
                this.lastAlignedBTS = this.timeSlotRef1;
            }
        } else if (qName.equals("REF_ANNOTATION")) {
            this.id = attrs.getValue("ANNOTATION_ID");
            this.annotationRef = attrs.getValue("ANNOTATION_REF");
            this.timeSlotRef1 = null;
            this.timeSlotRef2 = null;
            this.ref1.put(this.id, NULL);
            this.ref2.put(this.id, this.annotationRef);
        } else if (qName.equals("TIME_SLOT")) {
            this.id = attrs.getValue("TIME_SLOT_ID");
            String value = attrs.getValue("TIME_VALUE");
            if (this.id != null && value != null) {
                this.timeSlots.put(this.id, value);
            }
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if (qName.equals("ANNOTATION_VALUE")) {
            Matcher matcher;
            if (this.processAfter) {
                this.lastMatch.setRightContext(this.textBuffer.toString());
                this.processAfter = false;
            }
            if ((matcher = this.pattern.matcher(this.textBuffer)).find()) {
                EAFMultipleFileMatch match = new EAFMultipleFileMatch(this.textBuffer.toString());
                ArrayList<int[]> substringIndices = new ArrayList<int[]>();
                do {
                    substringIndices.add(new int[]{matcher.start(0), matcher.end(0)});
                } while (matcher.find());
                match.setMatchedSubstringIndices((int[][])substringIndices.toArray((T[])new int[0][0]));
                match.setIndex(this.indexInTier);
                match.setId(this.id);
                if (this.annotationBefore != null) {
                    match.setLeftContext(this.annotationBefore);
                }
                match.setTierName(this.tierName);
                match.setFileName(this.file.getAbsolutePath());
                match.setBeginTimeBoundary(-1L);
                match.setEndTimeBoundary(-1L);
                if (this.annotationRef == null) {
                    if (!this.timeSlots.containsKey(this.timeSlotRef1) || !this.timeSlots.containsKey(this.timeSlotRef2)) {
                        this.unalignedAlignableMatches.add(match);
                    }
                    this.setTimeForMatch(match, this.timeSlotRef1, this.timeSlotRef2);
                } else {
                    String alignedAnnID = this.annotationRef;
                    while (this.ref1.get(alignedAnnID) == NULL) {
                        alignedAnnID = (String)this.ref2.get(alignedAnnID);
                    }
                    Object timeSlotRef = this.ref1.get(alignedAnnID);
                    if (timeSlotRef != null) {
                        this.setTimeForMatch(match, this.ref1.get(alignedAnnID), this.ref2.get(alignedAnnID));
                    } else {
                        this.timeUnsolvedMatches.put(match, this.annotationRef);
                    }
                }
                this.lastMatch = match;
                this.processAfter = true;
            }
            this.annotationBefore = this.textBuffer.toString();
        } else if (qName.equals("ALIGNABLE_ANNOTATION") && this.lastAlignedBTS != null) {
            if (this.timeSlots.containsKey(this.timeSlotRef2)) {
                this.unalignedAlignablesIds.add(this.id);
                this.calculateUnalignedAlignedMatches();
            } else {
                this.unalignedAlignablesIds.add(this.id);
            }
        }
    }

    public void endDocument() {
        try {
            Enumeration e = this.timeUnsolvedMatches.keys();
            while (e.hasMoreElements()) {
                EAFMultipleFileMatch match = (EAFMultipleFileMatch)((Object)e.nextElement());
                String alignedAnnID = (String)this.timeUnsolvedMatches.get((Object)match);
                while (this.ref1.get(alignedAnnID) == NULL) {
                    alignedAnnID = (String)this.ref2.get(alignedAnnID);
                }
                Object timeSlotRef = this.ref1.get(alignedAnnID);
                if (timeSlotRef == null) continue;
                this.setTimeForMatch(match, this.ref1.get(alignedAnnID), this.ref2.get(alignedAnnID));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setTimeForMatch(EAFMultipleFileMatch match, Object timeSlotRef1, Object timeSlotRef2) {
        String value;
        if (timeSlotRef1 != null && (value = (String)this.timeSlots.get(timeSlotRef1)) != null) {
            match.setBeginTimeBoundary(Long.valueOf(value));
        }
        if (timeSlotRef2 != null) {
            value = (String)this.timeSlots.get(timeSlotRef2);
            if (value != null) {
                match.setEndTimeBoundary(Long.valueOf(value));
            }
            if (match.getEndTimeBoundary() < match.getBeginTimeBoundary()) {
                // empty if block
            }
        }
        this.result.addMatch((Match)match);
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (this.doAppend) {
            this.textBuffer.append(buf, offset, len);
        }
    }

    private void calculateUnalignedAlignedMatches() {
        if (this.unalignedAlignablesIds.size() != 0) {
            int i;
            long refBT = 0L;
            long refET = 0L;
            try {
                refBT = Long.valueOf((String)this.timeSlots.get(this.lastAlignedBTS));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            try {
                refET = Long.valueOf((String)this.timeSlots.get(this.timeSlotRef2));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            long span = refET - refBT;
            if (span < 0L) {
                span = 0L;
            }
            int step = (int)(span / (long)this.unalignedAlignablesIds.size());
            for (i = 0; i < this.unalignedAlignablesIds.size(); ++i) {
                String id = (String)this.unalignedAlignablesIds.get(i);
                String tsRef2 = (String)this.ref2.get(id);
                if (this.timeSlots.containsKey(tsRef2)) continue;
                this.timeSlots.put(tsRef2, String.valueOf(refBT + (long)((i + 1) * step)));
            }
            for (i = 0; i < this.unalignedAlignableMatches.size(); ++i) {
                String tsRef2;
                String tsRef1;
                String value;
                EAFMultipleFileMatch match = (EAFMultipleFileMatch)((Object)this.unalignedAlignableMatches.get(i));
                String id = match.getId();
                if (match.getBeginTimeBoundary() == -1L && (value = (String)this.timeSlots.get(tsRef1 = (String)this.ref1.get(id))) != null) {
                    match.setBeginTimeBoundary(Long.valueOf(value));
                }
                if (match.getEndTimeBoundary() != -1L || (value = (String)this.timeSlots.get(tsRef2 = (String)this.ref2.get(id))) == null) continue;
                match.setEndTimeBoundary(Long.valueOf(value));
            }
        }
        this.unalignedAlignablesIds.clear();
        this.unalignedAlignableMatches.clear();
        this.lastAlignedBTS = null;
    }
}

